/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.util;

import javajs.util.AU;
import javajs.util.M4;
import javajs.util.P3;
import javajs.util.P3i;
import javajs.util.P4;
import javajs.util.PT;
import javajs.util.T3;
import javajs.util.T4;
import javajs.util.V3;
import org.jmol.util.Escape;
import org.jmol.viewer.Viewer;

public class SimpleUnitCell {
    public static final int PARAM_STD = 6;
    public static final int PARAM_VAX = 6;
    public static final int PARAM_VBX = 9;
    public static final int PARAM_VCX = 12;
    public static final int PARAM_VCZ = 14;
    public static final int PARAM_OXYZ = 15;
    public static final int PARAM_M4 = 6;
    public static final int PARAM_M33 = 21;
    public static final int PARAM_SUPERCELL = 22;
    public static final int PARAM_SCALE = 25;
    public static final int PARAM_SLOP = 26;
    public static final int PARAM_COUNT = 27;
    public static final int INFO_IS_RHOMBOHEDRAL = 8;
    public static final int INFO_IS_HEXAGONAL = 7;
    public static final int INFO_DIMENSIONS = 6;
    public static final int INFO_GAMMA = 5;
    public static final int INFO_BETA = 4;
    public static final int INFO_ALPHA = 3;
    public static final int INFO_C = 2;
    public static final int INFO_B = 1;
    public static final int INFO_A = 0;
    public static final String HEX_TO_RHOMB = "2/3a+1/3b+1/3c,-1/3a+1/3b+1/3c,-1/3a-2/3b+1/3c";
    public static final String RHOMB_TO_HEX = "a-b,b-c,a+b+c";
    protected static final double toRadians = Math.PI / 180;
    public static final float SLOPSP = 1.0E-4f;
    public static final float SLOPDP = 1.0E-12f;
    public static final float SLOP_PARAMS = 0.001f;
    protected float[] unitCellParams;
    protected float slop = Viewer.isHighPrecision ? 1.0E-12f : 1.0E-4f;
    public M4 matrixCartesianToFractional;
    public M4 matrixFractionalToCartesian;
    protected M4 matrixCtoFNoOffset;
    protected M4 matrixFtoCNoOffset;
    public double volume;
    protected int dimension = 3;
    private P3 fractionalOrigin = new P3();
    private int na;
    private int nb;
    private int nc;
    protected float a;
    protected float b;
    protected float c;
    protected float alpha;
    protected float beta;
    protected float gamma;
    protected double cosAlpha;
    protected double sinAlpha;
    protected double cosBeta;
    protected double sinBeta;
    protected double cosGamma;
    protected double sinGamma;
    protected double cA_;
    protected double cB_;
    protected double a_;
    protected double b_;
    protected double c_;

    public float getPrecision() {
        return this.slop;
    }

    public void setPrecision(float slop) {
        this.slop = !Float.isNaN(slop) ? slop : (!Float.isNaN(this.unitCellParams[26]) ? this.unitCellParams[26] : (Viewer.isHighPrecision ? 1.0E-12f : 1.0E-4f));
        this.unitCellParams[26] = this.slop;
    }

    public boolean isSupercell() {
        return this.na > 1 || this.nb > 1 || this.nc > 1;
    }

    public static boolean isValid(float[] parameters) {
        return parameters != null && (parameters[0] > 0.0f || parameters.length > 14 && !Float.isNaN(parameters[14]));
    }

    protected SimpleUnitCell() {
    }

    public static SimpleUnitCell newA(float[] params) {
        SimpleUnitCell c = new SimpleUnitCell();
        c.init(params);
        return c;
    }

    public static int getDimensionFromParams(float[] params) {
        return params[0] <= 0.0f ? 3 : (params[1] < 0.0f ? 1 : (params[2] < 0.0f ? 2 : 3));
    }

    protected void init(float[] params) {
        if (params == null) {
            params = new float[]{1.0f, 1.0f, 1.0f, 90.0f, 90.0f, 90.0f};
        }
        if (!SimpleUnitCell.isValid(params)) {
            return;
        }
        this.unitCellParams = SimpleUnitCell.newParams(params, Float.NaN);
        boolean rotateHex = false;
        this.dimension = SimpleUnitCell.getDimensionFromParams(params);
        this.a = params[0];
        this.b = params[1];
        this.c = params[2];
        this.alpha = params[3];
        this.beta = params[4];
        this.gamma = params[5];
        if (this.gamma == -1.0f && this.c > 0.0f) {
            rotateHex = true;
            this.gamma = 120.0f;
        }
        if (params.length > 26) {
            if (Float.isNaN(params[26])) {
                params[26] = this.slop;
            } else {
                this.slop = params[26];
            }
        }
        this.na = Math.max(1, params.length > 24 && !Float.isNaN(params[22]) ? (int)params[22] : 1);
        float fa = this.na;
        this.nb = Math.max(1, params.length > 24 && !Float.isNaN(params[23]) ? (int)params[23] : 1);
        float fb = this.nb;
        this.nc = Math.max(1, params.length > 24 && !Float.isNaN(params[24]) ? (int)params[24] : 1);
        float fc = this.nc;
        if (params.length > 25 && !Float.isNaN(params[25])) {
            float fScale = params[25];
            if (fScale > 0.0f) {
                fa *= fScale;
                fb *= fScale;
                fc *= fScale;
            }
        } else {
            fc = 1.0f;
            fb = 1.0f;
            fa = 1.0f;
        }
        if (this.a <= 0.0f && this.c <= 0.0f) {
            V3 va = SimpleUnitCell.newV(params, 6);
            V3 vb = SimpleUnitCell.newV(params, 9);
            V3 vc = SimpleUnitCell.newV(params, 12);
            this.setABC(va, vb, vc);
            if (this.c < 0.0f) {
                float[] n = AU.arrayCopyF(params, -1);
                if (this.b < 0.0f) {
                    vb.set(0.0f, 0.0f, 1.0f);
                    vb.cross(vb, va);
                    if (vb.length() < 0.001f) {
                        vb.set(0.0f, 1.0f, 0.0f);
                    }
                    vb.normalize();
                    n[9] = vb.x;
                    n[10] = vb.y;
                    n[11] = vb.z;
                }
                if (this.c < 0.0f) {
                    vc.cross(va, vb);
                    vc.normalize();
                    n[12] = vc.x;
                    n[13] = vc.y;
                    n[14] = vc.z;
                }
                params = n;
            }
        }
        this.a *= fa;
        if (this.b <= 0.0f) {
            this.c = 1.0f;
            this.b = 1.0f;
        } else if (this.c <= 0.0f) {
            this.c = 1.0f;
            this.b *= fb;
        } else {
            this.b *= fb;
            this.c *= fc;
        }
        this.setCellParams();
        if (params.length > 21 && !Float.isNaN(params[21])) {
            float[] scaleMatrix = new float[16];
            for (int i = 0; i < 16; ++i) {
                float f;
                switch (i % 4) {
                    case 0: {
                        f = fa;
                        break;
                    }
                    case 1: {
                        f = fb;
                        break;
                    }
                    case 2: {
                        f = fc;
                        break;
                    }
                    default: {
                        f = 1.0f;
                    }
                }
                scaleMatrix[i] = params[6 + i] * f;
            }
            this.matrixCartesianToFractional = M4.newA16(scaleMatrix);
            this.matrixCartesianToFractional.getTranslation(this.fractionalOrigin);
            this.matrixFractionalToCartesian = M4.newM4(this.matrixCartesianToFractional).invert();
            if (params[0] == 1.0f) {
                this.setParamsFromMatrix();
            }
        } else if (params.length > 14 && !Float.isNaN(params[14])) {
            M4 m = this.matrixFractionalToCartesian = new M4();
            m.setColumn4(0, params[6] * fa, params[7] * fa, params[8] * fa, 0.0f);
            m.setColumn4(1, params[9] * fb, params[10] * fb, params[11] * fb, 0.0f);
            m.setColumn4(2, params[12] * fc, params[13] * fc, params[14] * fc, 0.0f);
            if (params.length > 17 && !Float.isNaN(params[17])) {
                m.setColumn4(3, params[15], params[16], params[17], 1.0f);
            } else {
                m.setColumn4(3, 0.0f, 0.0f, 0.0f, 1.0f);
            }
            this.matrixCartesianToFractional = M4.newM4(this.matrixFractionalToCartesian).invert();
        } else {
            M4 m = this.matrixFractionalToCartesian = new M4();
            if (rotateHex) {
                m.setColumn4(0, (float)((double)(-this.b) * this.cosGamma), (float)((double)(-this.b) * this.sinGamma), 0.0f, 0.0f);
                m.setColumn4(1, (float)((double)(-this.b) * this.cosGamma), (float)((double)this.b * this.sinGamma), 0.0f, 0.0f);
            } else {
                m.setColumn4(0, this.a, 0.0f, 0.0f, 0.0f);
                m.setColumn4(1, (float)((double)this.b * this.cosGamma), (float)((double)this.b * this.sinGamma), 0.0f, 0.0f);
            }
            m.setColumn4(2, (float)((double)this.c * this.cosBeta), (float)((double)this.c * (this.cosAlpha - this.cosBeta * this.cosGamma) / this.sinGamma), (float)(this.volume / ((double)(this.a * this.b) * this.sinGamma)), 0.0f);
            m.setColumn4(3, 0.0f, 0.0f, 0.0f, 1.0f);
            this.matrixCartesianToFractional = M4.newM4(this.matrixFractionalToCartesian).invert();
        }
        this.matrixCtoFNoOffset = this.matrixCartesianToFractional;
        this.matrixFtoCNoOffset = this.matrixFractionalToCartesian;
    }

    private static V3 newV(float[] p, int i) {
        return V3.new3(p[i++], p[i++], p[i]);
    }

    public static float[] newParams(float[] params, float slop) {
        float[] p = new float[27];
        int n = params.length;
        for (int i = 0; i < 27; ++i) {
            p[i] = i < n ? params[i] : Float.NaN;
        }
        if (n < 27) {
            p[26] = slop;
        }
        return p;
    }

    public static void addVectors(float[] params) {
        SimpleUnitCell c = SimpleUnitCell.newA(params);
        M4 m = c.matrixFractionalToCartesian;
        for (int i = 0; i < 9; ++i) {
            params[6 + i] = m.getElement(i % 3, i / 3);
        }
    }

    private void setParamsFromMatrix() {
        V3 va = V3.new3(1.0f, 0.0f, 0.0f);
        V3 vb = V3.new3(0.0f, 1.0f, 0.0f);
        V3 vc = V3.new3(0.0f, 0.0f, 1.0f);
        this.matrixFractionalToCartesian.rotate(va);
        this.matrixFractionalToCartesian.rotate(vb);
        this.matrixFractionalToCartesian.rotate(vc);
        this.setABC(va, vb, vc);
        this.setCellParams();
    }

    private void setABC(V3 va, V3 vb, V3 vc) {
        SimpleUnitCell.fillParams(va, vb, vc, this.unitCellParams);
        float[] p = this.unitCellParams;
        this.a = p[0];
        this.b = p[1];
        this.c = p[2];
        this.alpha = p[3];
        this.beta = p[4];
        this.gamma = p[5];
    }

    public static void fillParams(V3 va, V3 vb, V3 vc, float[] p) {
        if (va == null) {
            va = SimpleUnitCell.newV(p, 6);
            vb = SimpleUnitCell.newV(p, 9);
            vc = SimpleUnitCell.newV(p, 12);
        }
        float a = va.length();
        float b = vb.length();
        float c = vc.length();
        if (a == 0.0f) {
            return;
        }
        if (b == 0.0f) {
            c = -1.0f;
            b = -1.0f;
        } else if (c == 0.0f) {
            c = -1.0f;
        }
        p[0] = a;
        p[1] = b;
        p[2] = c;
        p[3] = (float)(b < 0.0f || c < 0.0f ? 90.0 : (double)vb.angle(vc) / (Math.PI / 180));
        p[4] = (float)(c < 0.0f ? 90.0 : (double)va.angle(vc) / (Math.PI / 180));
        p[5] = (float)(b < 0.0f ? 90.0 : (double)va.angle(vb) / (Math.PI / 180));
    }

    private void setCellParams() {
        this.cosAlpha = Math.cos(Math.PI / 180 * (double)this.alpha);
        this.sinAlpha = Math.sin(Math.PI / 180 * (double)this.alpha);
        this.cosBeta = Math.cos(Math.PI / 180 * (double)this.beta);
        this.sinBeta = Math.sin(Math.PI / 180 * (double)this.beta);
        this.cosGamma = Math.cos(Math.PI / 180 * (double)this.gamma);
        this.sinGamma = Math.sin(Math.PI / 180 * (double)this.gamma);
        double unitVolume = Math.sqrt(this.sinAlpha * this.sinAlpha + this.sinBeta * this.sinBeta + this.sinGamma * this.sinGamma + 2.0 * this.cosAlpha * this.cosBeta * this.cosGamma - 2.0);
        this.volume = (double)(this.a * this.b * this.c) * unitVolume;
        this.cA_ = (this.cosAlpha - this.cosBeta * this.cosGamma) / this.sinGamma;
        this.cB_ = unitVolume / this.sinGamma;
        this.a_ = (double)(this.b * this.c) * this.sinAlpha / this.volume;
        this.b_ = (double)(this.a * this.c) * this.sinBeta / this.volume;
        this.c_ = (double)(this.a * this.b) * this.sinGamma / this.volume;
    }

    public P3 getFractionalOrigin() {
        return this.fractionalOrigin;
    }

    public P3 toSupercell(P3 fpt) {
        fpt.x /= (float)this.na;
        fpt.y /= (float)this.nb;
        fpt.z /= (float)this.nc;
        return fpt;
    }

    public final void toCartesian(T3 pt, boolean ignoreOffset) {
        if (this.matrixFractionalToCartesian != null) {
            (ignoreOffset ? this.matrixFtoCNoOffset : this.matrixFractionalToCartesian).rotTrans(pt);
        }
    }

    public void toFractionalM(M4 m) {
        if (this.matrixCartesianToFractional == null) {
            return;
        }
        m.mul(this.matrixFractionalToCartesian);
        m.mul2(this.matrixCartesianToFractional, m);
    }

    public final void toFractional(T3 pt, boolean ignoreOffset) {
        if (this.matrixCartesianToFractional == null) {
            return;
        }
        (ignoreOffset ? this.matrixCtoFNoOffset : this.matrixCartesianToFractional).rotTrans(pt);
    }

    public boolean isPolymer() {
        return this.dimension == 1;
    }

    public boolean isSlab() {
        return this.dimension == 2;
    }

    public final float[] getUnitCellParams() {
        return this.unitCellParams;
    }

    public final float[] getUnitCellAsArray(boolean vectorsOnly) {
        float[] fArray;
        M4 m = this.matrixFractionalToCartesian;
        if (vectorsOnly) {
            float[] fArray2 = new float[9];
            fArray2[0] = m.m00;
            fArray2[1] = m.m10;
            fArray2[2] = m.m20;
            fArray2[3] = m.m01;
            fArray2[4] = m.m11;
            fArray2[5] = m.m21;
            fArray2[6] = m.m02;
            fArray2[7] = m.m12;
            fArray = fArray2;
            fArray2[8] = m.m22;
        } else {
            float[] fArray3 = new float[17];
            fArray3[0] = this.a;
            fArray3[1] = this.b;
            fArray3[2] = this.c;
            fArray3[3] = this.alpha;
            fArray3[4] = this.beta;
            fArray3[5] = this.gamma;
            fArray3[6] = m.m00;
            fArray3[7] = m.m10;
            fArray3[8] = m.m20;
            fArray3[9] = m.m01;
            fArray3[10] = m.m11;
            fArray3[11] = m.m21;
            fArray3[12] = m.m02;
            fArray3[13] = m.m12;
            fArray3[14] = m.m22;
            fArray3[15] = this.dimension;
            fArray = fArray3;
            fArray3[16] = (float)this.volume;
        }
        return fArray;
    }

    public final float getInfo(int infoType) {
        switch (infoType) {
            case 0: {
                return this.a;
            }
            case 1: {
                return this.b;
            }
            case 2: {
                return this.c;
            }
            case 3: {
                return this.alpha;
            }
            case 4: {
                return this.beta;
            }
            case 5: {
                return this.gamma;
            }
            case 6: {
                return this.dimension;
            }
            case 7: {
                return SimpleUnitCell.isHexagonal(this.unitCellParams) ? 1 : 0;
            }
            case 8: {
                return SimpleUnitCell.isRhombohedral(this.unitCellParams) ? 1 : 0;
            }
        }
        return Float.NaN;
    }

    public static T3[] getReciprocal(T3[] abc, T3[] ret, float scale) {
        int i;
        int off = abc.length == 4 ? 1 : 0;
        T3[] rabc = new P3[4];
        P3 p3 = rabc[0] = off == 1 ? P3.newP(abc[0]) : new P3();
        if (scale == 0.0f) {
            scale = (float)Math.PI * 2;
        }
        for (i = 0; i < 3; ++i) {
            P3 p32 = new P3();
            rabc[i + 1] = p32;
            P3 v = p32;
            v.cross(abc[(i + 1) % 3 + off], abc[(i + 2) % 3 + off]);
            float vol = abc[i + off].dot(v);
            if (scale == -1.0f) {
                scale = (float)Math.sqrt(vol);
            }
            v.scale(scale / vol);
        }
        if (ret == null) {
            return rabc;
        }
        for (i = 0; i < 4; ++i) {
            ret[i] = rabc[i];
        }
        return ret;
    }

    public static T3[] setAbc(String abcabg, float[] params, T3[] ucnew) {
        if (abcabg != null) {
            String[] tokens;
            if (params == null) {
                params = new float[6];
            }
            if ((tokens = PT.split(abcabg.replace(',', '='), "=")).length >= 12) {
                for (int i = 0; i < 6; ++i) {
                    params[i] = PT.parseFloat(tokens[i * 2 + 1]);
                }
            }
        }
        if (ucnew == null) {
            return null;
        }
        return SimpleUnitCell.setAbcFromParams(params, ucnew);
    }

    public static T3[] setAbcFromParams(float[] params, T3[] ucnew) {
        float[] f = SimpleUnitCell.newA(params).getUnitCellAsArray(true);
        ucnew[1].set(f[0], f[1], f[2]);
        ucnew[2].set(f[3], f[4], f[5]);
        ucnew[3].set(f[6], f[7], f[8]);
        return ucnew;
    }

    public void unitizeDim(int dimension, T3 pt) {
        switch (dimension) {
            case 3: {
                pt.z = SimpleUnitCell.unitizeX(pt.z, this.slop);
            }
            case 2: {
                pt.y = SimpleUnitCell.unitizeX(pt.y, this.slop);
            }
            case 1: {
                pt.x = SimpleUnitCell.unitizeX(pt.x, this.slop);
            }
        }
    }

    public static void unitizeDimRnd(int dimension, T3 pt, float slop) {
        switch (dimension) {
            case 3: {
                pt.z = SimpleUnitCell.unitizeXRnd(pt.z, slop);
            }
            case 2: {
                pt.y = SimpleUnitCell.unitizeXRnd(pt.y, slop);
            }
            case 1: {
                pt.x = SimpleUnitCell.unitizeXRnd(pt.x, slop);
            }
        }
    }

    public static float unitizeX(float x, float slop) {
        if ((x = (float)((double)x - Math.floor(x))) > 1.0f - slop || x < slop) {
            x = 0.0f;
        }
        return x;
    }

    public static float unitizeXRnd(float x, float slop) {
        if ((x -= (float)Math.floor(x)) > 1.0f - slop || x < slop) {
            x = 0.0f;
        }
        return x;
    }

    public int twelfthsOf(float f) {
        if (f == 0.0f) {
            return 0;
        }
        int i = Math.round(f = Math.abs(f * 12.0f));
        return i <= 12 && Math.abs(f - (float)i) < this.slop * 12.0f ? i : -1;
    }

    public void twelfthify(P3 pt) {
        switch (this.dimension) {
            case 3: {
                pt.z = this.setTwelfths(pt.z);
            }
            case 2: {
                pt.y = this.setTwelfths(pt.y);
            }
            case 1: {
                pt.x = this.setTwelfths(pt.x);
            }
        }
    }

    private float setTwelfths(float x) {
        int i = this.twelfthsOf(x);
        return i >= 0 ? (float)i / 12.0f * (float)(x < 0.0f ? -1 : 1) : x;
    }

    public static void ijkToPoint3f(int nnn, P3 cell, int offset, int kcode) {
        int f = nnn > 1000000000 ? 1000 : (nnn > 1000000 ? 100 : 10);
        int f2 = f * f;
        cell.x = nnn / f2 % f + (offset -= offset >= 0 ? 5 * f / 10 : offset);
        cell.y = nnn % f2 / f + offset;
        cell.z = (kcode == 0 ? nnn % f : (offset == -500 ? kcode / f : kcode) % f) + offset;
    }

    public static P4 ptToIJK(T3 pt, int scale) {
        if (pt.x <= 5.0f && pt.y <= 5.0f && pt.z <= 5.0f) {
            return P4.new4(555.0f, (pt.x + 4.0f) * 100.0f + (pt.y + 4.0f) * 10.0f + pt.z + 4.0f, scale, 0.0f);
        }
        int i555 = 1500500500;
        return P4.new4(i555, (float)i555 + pt.x * 1000000.0f + pt.y * 1000.0f + pt.z, scale, 1500500.0f + pt.z);
    }

    public static String escapeMultiplier(T3 pt) {
        if (pt instanceof P4) {
            P4 pt4 = (P4)pt;
            int x = (int)Math.floor(pt4.x / 1000.0f) * 1000 + (int)Math.floor(pt4.w / 1000.0f) - 1000;
            int y = (int)Math.floor(pt4.y / 1000.0f) * 1000 + (int)Math.floor(pt4.w) % 1000;
            return "{" + x + " " + y + " " + pt.z + "}";
        }
        return Escape.eP(pt);
    }

    public static void setMinMaxLatticeParameters(int dimension, P3i minXYZ, P3i maxXYZ, int kcode) {
        if (maxXYZ.x <= maxXYZ.y && maxXYZ.y >= 555) {
            P3 pt = new P3();
            SimpleUnitCell.ijkToPoint3f(maxXYZ.x, pt, 0, kcode);
            minXYZ.x = (int)pt.x;
            minXYZ.y = (int)pt.y;
            minXYZ.z = (int)pt.z;
            SimpleUnitCell.ijkToPoint3f(maxXYZ.y, pt, 1, kcode);
            maxXYZ.x = (int)pt.x;
            maxXYZ.y = (int)pt.y;
            maxXYZ.z = (int)pt.z;
        }
        switch (dimension) {
            case 1: {
                minXYZ.y = 0;
                maxXYZ.y = 1;
            }
            case 2: {
                minXYZ.z = 0;
                maxXYZ.z = 1;
            }
        }
    }

    public static boolean isHexagonal(float[] params) {
        return SimpleUnitCell.approx0(params[0] - params[1]) && SimpleUnitCell.approx0(params[3] - 90.0f) && SimpleUnitCell.approx0(params[4] - 90.0f) && (SimpleUnitCell.approx0(params[5] - 120.0f) || params[5] == -1.0f);
    }

    public static boolean isRhombohedral(float[] params) {
        return SimpleUnitCell.approx0(params[0] - params[1]) && SimpleUnitCell.approx0(params[1] - params[2]) && !SimpleUnitCell.approx0(params[3] - 90.0f) && SimpleUnitCell.approx0(params[3] - params[4]) && SimpleUnitCell.approx0(params[4] - params[5]);
    }

    protected static boolean approx0(float f) {
        return Math.abs(f) < 0.001f;
    }

    public static int getCellRange(T3 fset, P3[] cellRange) {
        int t3w = fset instanceof T4 ? (int)((T4)fset).w : 0;
        SimpleUnitCell.ijkToPoint3f((int)fset.x, cellRange[0], 0, t3w);
        SimpleUnitCell.ijkToPoint3f((int)fset.y, cellRange[1], 1, t3w);
        if (fset.z < 0.0f) {
            cellRange[0].scale(-1.0f / fset.z);
            cellRange[1].scale(-1.0f / fset.z);
        }
        return t3w;
    }

    public String toString() {
        return "[" + this.a + " " + this.b + " " + this.c + " " + this.alpha + " " + this.beta + " " + this.gamma + "]";
    }

    public static float parseCalc(Viewer vwr, String[] functions, String s) {
        String p;
        int i;
        String[] parts;
        float d = PT.parseFloatStrict(s);
        if (!Double.isNaN(d)) {
            return d;
        }
        s = s.toLowerCase();
        if (functions != null && s.indexOf(40) >= 0) {
            parts = PT.split(s, "(");
            i = parts.length - 1;
            while (--i >= 0) {
                p = parts[i];
                String f = null;
                int j = functions.length;
                while (--j >= 0) {
                    if (!p.endsWith(functions[j])) continue;
                    f = functions[j];
                    break;
                }
                if (f != null) continue;
                System.err.println("Unrecognized function " + s);
                int n = i;
                parts[n] = parts[n] + "?";
            }
            s = PT.join(parts, '(', 0);
        }
        if (s.indexOf(47) >= 0) {
            parts = PT.split(s, "/");
            i = parts.length - 1;
            while (--i >= 0) {
                p = parts[i];
                boolean haveDecimal = false;
                boolean haveDigit = false;
                int j = p.length();
                while (--j >= 0) {
                    char c = p.charAt(j);
                    if (c == '.') {
                        haveDecimal = true;
                        break;
                    }
                    if (c == ')') {
                        if (haveDigit) {
                            return Float.NaN;
                        }
                        int n = i;
                        parts[n] = parts[n] + "*1.0";
                        break;
                    }
                    if (!PT.isDigit(c)) break;
                    haveDigit = true;
                }
                if (!haveDigit || haveDecimal) continue;
                int n = i;
                parts[n] = parts[n] + ".";
            }
            s = PT.join(parts, '/', 0);
        }
        return vwr.evaluateExpressionAsVariable(s).asFloat();
    }
}

