# distutils: libraries = gmp pari
"""
Declarations for non-inline functions from PARI.

This file contains all declarations from headers/paridecl.h from
the PARI distribution, except the inline functions which are in
declinl.pxi (that file is automatically included by this file).


AUTHORS:

 - (unknown authors before 2010)

 - Robert Bradshaw, Jeroen Demeyer, William Stein (2010-08-15):
   Upgrade to PARI 2.4.3 (:trac:`9343`)

 - Jeroen Demeyer (2010-08-15): big clean up (:trac:`9898`)

 - Jeroen Demeyer (2014-02-09): upgrade to PARI 2.7 (:trac:`15767`)

 - Jeroen Demeyer (2014-09-19): upgrade to PARI 2.8 (:trac:`16997`)
"""

# ****************************************************************************
#  Distributed under the terms of the GNU General Public License (GPL)
#  as published by the Free Software Foundation; either version 2 of
#  the License, or (at your option) any later version.
#                  https://www.gnu.org/licenses/
# ****************************************************************************

from __future__ import print_function

from libc.stdio cimport FILE
from cpython.getargs cimport va_list

from .types cimport *


cdef extern from *:     # PARI headers already included by types.pxd
    char* PARIVERSION

    # parierr.h
    enum err_list:
        e_SYNTAX, e_BUG
        e_ALARM, e_FILE
        e_MISC, e_FLAG, e_IMPL, e_ARCH, e_PACKAGE, e_NOTFUNC
        e_PREC, e_TYPE, e_DIM, e_VAR, e_PRIORITY, e_USER
        e_STACK, e_OVERFLOW, e_DOMAIN, e_COMPONENT
        e_MAXPRIME
        e_CONSTPOL, e_IRREDPOL, e_COPRIME, e_PRIME, e_MODULUS, e_ROOTS0
        e_OP, e_TYPE2, e_INV
        e_MEM
        e_SQRTN
        e_NONE

    int warner, warnprec, warnfile, warnmem, warnuser

    # paricast.h

    long    mael2(GEN, long, long)
    long    mael3(GEN, long, long, long)
    long    mael4(GEN, long, long, long, long)
    long    mael5(GEN, long, long, long, long, long)
    long    mael(GEN, long, long)
    GEN     gmael1(GEN, long)
    GEN     gmael2(GEN, long, long)
    GEN     gmael3(GEN, long, long, long)
    GEN     gmael4(GEN, long, long, long, long)
    GEN     gmael5(GEN, long, long, long, long, long)
    GEN     gmael(GEN, long, long)
    GEN     gel(GEN, long)
    GEN     gcoeff(GEN, long, long)
    long    coeff(GEN, long, long)
    char*   GSTR(GEN)

    # paricom.h

    GEN     gen_1
    GEN     gen_m1
    GEN     gen_2
    GEN     gen_m2
    GEN     ghalf
    GEN     gen_0
    GEN     gnil
    GEN     err_e_STACK
    int     PARI_SIGINT_block, PARI_SIGINT_pending
    void    NEXT_PRIME_VIADIFF(long, byteptr)
    void    PREC_PRIME_VIADIFF(long, byteptr)
    int     INIT_JMPm, INIT_SIGm, INIT_DFTm, INIT_noPRIMEm, INIT_noIMTm
    int     new_galois_format, factor_add_primes, factor_proven
    int     precdl
    # The "except 0" here is to ensure compatibility with
    # _pari_err_handle() in handle_error.pyx
    int     (*cb_pari_err_handle)(GEN) except 0
    int     (*cb_pari_handle_exception)(long) except 0
    void    (*cb_pari_err_recover)(long)

    # kernel/gmp/int.h

    GEN     int_MSW(GEN z)
    GEN     int_LSW(GEN z)
    GEN     int_W(GEN z, long i)
    GEN     int_W_lg(GEN z, long i, long lz)
    GEN     int_precW(GEN z)
    GEN     int_nextW(GEN z)

    # paristio.h

    extern pari_sp avma
    struct _pari_mainstack "pari_mainstack":
        pari_sp top, bot, vbot
        size_t size, rsize, vsize, memused
    extern _pari_mainstack* pari_mainstack
    struct PariOUT:
        void (*putch)(char)
        void (*puts)(char*)
        void (*flush)()
    extern PariOUT* pariOut
    extern PariOUT* pariErr
    extern byteptr diffptr
    extern pari_prime* pari_PRIMES

    ###############################################
    #                                             #
    # All declarations below come from paridecl.h #
    #                                             #
    ###############################################

    # OBSOLETE
    GEN     buchimag(GEN D, GEN c1, GEN c2, GEN gCO)
    GEN     buchreal(GEN D, GEN gsens, GEN c1, GEN c2, GEN gRELSUP, long prec)
    GEN     zidealstar(GEN nf, GEN x)
    GEN     zidealstarinit(GEN nf, GEN x)
    GEN     zidealstarinitgen(GEN nf, GEN x)
    GEN     factmod(GEN f, GEN p)
    void    mpbern(long n, long prec)
    GEN     simplefactmod(GEN f, GEN p)
    void    listkill(GEN l)
    GEN     isprincipalforce(GEN bnf, GEN x)
    GEN     isprincipalgen(GEN bnf, GEN x)
    GEN     isprincipalgenforce(GEN bnf, GEN x)

    # F2v.c

    GEN     F2Ms_ker(GEN M, long nrows)
    GEN     F2Ms_to_F2m(GEN M, long nrows)
    GEN     F2c_to_ZC(GEN x)
    GEN     F2c_to_mod(GEN x)
    GEN     F2m_F2c_gauss(GEN a, GEN b)
    GEN     F2m_F2c_invimage(GEN A, GEN y)
    GEN     F2m_F2c_mul(GEN x, GEN y)
    GEN     F2m_deplin(GEN x)
    ulong   F2m_det(GEN x)
    ulong   F2m_det_sp(GEN x)
    GEN     F2m_gauss(GEN a, GEN b)
    GEN     F2m_inv(GEN x)
    GEN     F2m_invimage(GEN A, GEN B)
    GEN     F2m_ker(GEN x)
    GEN     F2m_ker_sp(GEN x, long deplin)
    GEN     F2m_mul(GEN x, GEN y)
    GEN     F2m_powu(GEN x, ulong n)
    long    F2m_rank(GEN x)
    GEN     F2m_row(GEN x, long j)
    GEN     F2m_rowslice(GEN x, long a, long b)
    GEN     F2m_to_F2Ms(GEN M)
    GEN     F2m_to_Flm(GEN z)
    GEN     F2m_to_ZM(GEN z)
    GEN     F2m_to_mod(GEN z)
    GEN     F2m_transpose(GEN x)
    void    F2v_add_inplace(GEN x, GEN y)
    void    F2v_and_inplace(GEN x, GEN y)
    ulong   F2v_dotproduct(GEN x, GEN y)
    int     F2v_equal0(GEN a)
    ulong   F2v_hamming(GEN H)
    void    F2v_negimply_inplace(GEN x, GEN y)
    void    F2v_or_inplace(GEN x, GEN y)
    GEN     F2v_slice(GEN x, long a, long b)
    GEN     F2v_to_Flv(GEN x)
    GEN     matid_F2m(long n)

    # F2x.c

    GEN     F2x_F2xq_eval(GEN Q, GEN x, GEN T)
    GEN     F2x_F2xqV_eval(GEN P, GEN V, GEN T)
    GEN     F2x_Frobenius(GEN T)
    GEN     F2x_1_add(GEN y)
    GEN     F2x_add(GEN x, GEN y)
    GEN     F2x_deflate(GEN x0, long d)
    GEN     F2x_degfact(GEN f)
    long    F2x_degree(GEN x)
    GEN     F2x_deriv(GEN x)
    GEN     F2x_divrem(GEN x, GEN y, GEN *pr)
    ulong   F2x_eval(GEN P, ulong x)
    void    F2x_even_odd(GEN p, GEN *pe, GEN *po)
    GEN     F2x_extgcd(GEN a, GEN b, GEN *ptu, GEN *ptv)
    GEN     F2x_gcd(GEN a, GEN b)
    GEN     F2x_get_red(GEN T)
    GEN     F2x_halfgcd(GEN a, GEN b)
    int     F2x_issquare(GEN a)
    GEN     F2x_matFrobenius(GEN T)
    GEN     F2x_mul(GEN x, GEN y)
    GEN     F2x_recip(GEN T)
    GEN     F2x_rem(GEN x, GEN y)
    GEN     F2x_shift(GEN y, long d)
    GEN     F2x_sqr(GEN x)
    GEN     F2x_sqrt(GEN x)
    GEN     F2x_to_F2v(GEN x, long n)
    GEN     F2x_to_F2xX(GEN z, long sv)
    GEN     F2x_to_Flx(GEN x)
    GEN     F2x_to_ZX(GEN x)
    long    F2x_valrem(GEN x, GEN *Z)
    GEN     F2xC_to_FlxC(GEN v)
    GEN     F2xC_to_ZXC(GEN x)
    GEN     F2xV_to_F2m(GEN v, long n)
    void    F2xV_to_FlxV_inplace(GEN v)
    void    F2xV_to_ZXV_inplace(GEN v)
    GEN     F2xX_F2x_add(GEN x, GEN y)
    GEN     F2xX_F2x_mul(GEN P, GEN U)
    GEN     F2xX_add(GEN x, GEN y)
    GEN     F2xX_deriv(GEN z)
    GEN     F2xX_renormalize(GEN x, long lx)
    GEN     F2xX_to_Kronecker(GEN P, long d)
    GEN     F2xX_to_FlxX(GEN B)
    GEN     F2xX_to_ZXX(GEN B)
    GEN     F2xX_to_F2xC(GEN x, long N, long sv)
    GEN     F2xXV_to_F2xM(GEN v, long n, long sv)
    GEN     F2xXC_to_ZXXC(GEN B)
    GEN     F2xY_F2xq_evalx(GEN P, GEN x, GEN T)
    GEN     F2xY_F2xqV_evalx(GEN P, GEN x, GEN T)
    long    F2xY_degreex(GEN b)
    GEN     F2xn_inv(GEN f, long e)
    GEN     F2xn_red(GEN a, long n)
    GEN     F2xq_Artin_Schreier(GEN a, GEN T)
    GEN     F2xq_autpow(GEN x, long n, GEN T)
    GEN     F2xq_conjvec(GEN x, GEN T)
    GEN     F2xq_div(GEN x, GEN y, GEN T)
    GEN     F2xq_inv(GEN x, GEN T)
    GEN     F2xq_invsafe(GEN x, GEN T)
    GEN     F2xq_log(GEN a, GEN g, GEN ord, GEN T)
    GEN     F2xq_matrix_pow(GEN y, long n, long m, GEN P)
    GEN     F2xq_mul(GEN x, GEN y, GEN pol)
    GEN     F2xq_order(GEN a, GEN ord, GEN T)
    GEN     F2xq_pow(GEN x, GEN n, GEN pol)
    GEN     F2xq_pow_init(GEN x, GEN n, long k,  GEN T)
    GEN     F2xq_pow_table(GEN R, GEN n, GEN T)
    GEN     F2xq_powu(GEN x, ulong n, GEN pol)
    GEN     F2xq_powers(GEN x, long l, GEN T)
    GEN     F2xq_sqr(GEN x, GEN pol)
    GEN     F2xq_sqrt(GEN a, GEN T)
    GEN     F2xq_sqrt_fast(GEN c, GEN sqx, GEN T)
    GEN     F2xq_sqrtn(GEN a, GEN n, GEN T, GEN *zeta)
    ulong   F2xq_trace(GEN x, GEN T)
    GEN     F2xqX_F2xq_mul(GEN P, GEN U, GEN T)
    GEN     F2xqX_F2xq_mul_to_monic(GEN P, GEN U, GEN T)
    GEN     F2xqX_F2xqXQ_eval(GEN Q, GEN x, GEN S, GEN T)
    GEN     F2xqX_F2xqXQV_eval(GEN P, GEN V, GEN S, GEN T)
    GEN     F2xqX_disc(GEN x, GEN T)
    GEN     F2xqX_divrem(GEN x, GEN y, GEN T, GEN *pr)
    GEN     F2xqX_extgcd(GEN x, GEN y, GEN T,  GEN *ptu, GEN *ptv)
    GEN     F2xqX_gcd(GEN a, GEN b, GEN T)
    GEN     F2xqX_get_red(GEN S, GEN T)
    GEN     F2xqX_halfgcd(GEN x, GEN y, GEN T)
    GEN     F2xqX_invBarrett(GEN T, GEN Q)
    long    F2xqX_ispower(GEN f, long k, GEN T, GEN *pt_r)
    GEN     F2xqX_mul(GEN x, GEN y, GEN T)
    GEN     F2xqX_normalize(GEN z, GEN T)
    GEN     F2xqX_powu(GEN x, ulong n, GEN T)
    GEN     F2xqX_red(GEN z, GEN T)
    GEN     F2xqX_rem(GEN x, GEN S, GEN T)
    GEN     F2xqX_resultant(GEN x, GEN y, GEN T)
    GEN     F2xqX_sqr(GEN x, GEN T)
    GEN     F2xqXQ_inv(GEN x, GEN S, GEN T)
    GEN     F2xqXQ_invsafe(GEN x, GEN S, GEN T)
    GEN     F2xqXQ_mul(GEN x, GEN y, GEN S, GEN T)
    GEN     F2xqXQ_sqr(GEN x, GEN S, GEN T)
    GEN     F2xqXQ_pow(GEN x, GEN n, GEN S, GEN T)
    GEN     F2xqXQ_powers(GEN x, long l, GEN S, GEN T)
    GEN     F2xqXQ_autpow(GEN aut, long n, GEN S, GEN T)
    GEN     F2xqXQ_auttrace(GEN aut, long n, GEN S, GEN T)
    GEN     F2xqXQV_red(GEN z, GEN S, GEN T)
    GEN     Flm_to_F2m(GEN x)
    GEN     Flv_to_F2v(GEN x)
    GEN     Flx_to_F2x(GEN x)
    GEN     FlxC_to_F2xC(GEN x)
    GEN     FlxX_to_F2xX(GEN B)
    GEN     FlxXC_to_F2xXC(GEN B)
    GEN     Kronecker_to_F2xqX(GEN z, GEN T)
    GEN     Rg_to_F2xq(GEN x, GEN T)
    GEN     RgM_to_F2m(GEN x)
    GEN     RgV_to_F2v(GEN x)
    GEN     RgX_to_F2x(GEN x)
    GEN     Z_to_F2x(GEN x, long v)
    GEN     ZM_to_F2m(GEN x)
    GEN     ZV_to_F2v(GEN x)
    GEN     ZX_to_F2x(GEN x)
    GEN     ZXX_to_F2xX(GEN B, long v)
    GEN     const_F2v(long m)
    GEN     gener_F2xq(GEN T, GEN *po)
    GEN     monomial_F2x(long d, long vs)
    GEN     pol1_F2xX(long v, long sv)
    GEN     polx_F2xX(long v, long sv)
    GEN     random_F2xqX(long d1, long v, GEN T)

    # F2xqE.c

    GEN     F2xq_ellcard(GEN a2, GEN a6, GEN T)
    GEN     F2xq_ellgens(GEN a2, GEN a6, GEN ch, GEN D, GEN m, GEN T)
    GEN     F2xq_ellgroup(GEN a2, GEN a6, GEN N, GEN T, GEN *pt_m)
    void    F2xq_elltwist(GEN a, GEN a6, GEN T, GEN *pt_a, GEN *pt_a6)
    GEN     F2xqE_add(GEN P, GEN Q, GEN a2, GEN T)
    GEN     F2xqE_changepoint(GEN x, GEN ch, GEN T)
    GEN     F2xqE_changepointinv(GEN x, GEN ch, GEN T)
    GEN     F2xqE_dbl(GEN P, GEN a2, GEN T)
    GEN     F2xqE_log(GEN a, GEN b, GEN o, GEN a2, GEN T)
    GEN     F2xqE_mul(GEN P, GEN n, GEN a2, GEN T)
    GEN     F2xqE_neg(GEN P, GEN a2, GEN T)
    GEN     F2xqE_order(GEN z, GEN o, GEN a2, GEN T)
    GEN     F2xqE_sub(GEN P, GEN Q, GEN a2, GEN T)
    GEN     F2xqE_tatepairing(GEN t, GEN s, GEN m, GEN a2, GEN T)
    GEN     F2xqE_weilpairing(GEN t, GEN s, GEN m, GEN a2, GEN T)
    const bb_group * get_F2xqE_group(void **E, GEN a2, GEN a6, GEN T)
    GEN     RgE_to_F2xqE(GEN x, GEN T)
    GEN     random_F2xqE(GEN a2, GEN a6, GEN T)

    # Fle.c

    ulong   Fl_elldisc(ulong a4, ulong a6, ulong p)
    ulong   Fl_elldisc_pre(ulong a4, ulong a6, ulong p, ulong pi)
    ulong   Fl_ellj(ulong a4, ulong a6, ulong p)
    void    Fl_ellj_to_a4a6(ulong j, ulong p, ulong *pt_a4, ulong *pt_a6)
    void    Fl_elltwist(ulong a4, ulong a6, ulong p, ulong *pt_a4, ulong *pt_a6)
    void    Fl_elltwist_disc(ulong a4, ulong a6, ulong D, ulong p, ulong *pt_a4, ulong *pt_a6)
    GEN     Fle_add(GEN P, GEN Q, ulong a4, ulong p)
    GEN     Fle_dbl(GEN P, ulong a4, ulong p)
    GEN     Fle_changepoint(GEN x, GEN ch, ulong p)
    GEN     Fle_changepointinv(GEN x, GEN ch, ulong p)
    GEN     Fle_log(GEN a, GEN b, GEN o, ulong a4, ulong p)
    GEN     Fle_mul(GEN P, GEN n, ulong a4, ulong p)
    GEN     Fle_mulu(GEN P, ulong n, ulong a4, ulong p)
    GEN     Fle_order(GEN z, GEN o, ulong a4, ulong p)
    GEN     Fle_sub(GEN P, GEN Q, ulong a4, ulong p)
    GEN     Fle_to_Flj(GEN P)
    GEN     Flj_add_pre(GEN P, GEN Q, ulong a4, ulong p, ulong pi)
    GEN     Flj_dbl_pre(GEN P, ulong a4, ulong p, ulong pi)
    GEN     Flj_mulu_pre(GEN P, ulong n, ulong a4, ulong p, ulong pi)
    GEN     Flj_neg(GEN Q, ulong p)
    GEN     Flj_to_Fle_pre(GEN P, ulong p, ulong pi)
    GEN     random_Fle(ulong a4, ulong a6, ulong p)
    GEN     random_Fle_pre(ulong a4, ulong a6, ulong p, ulong pi)
    GEN     random_Flj_pre(ulong a4, ulong a6, ulong p, ulong pi)

    # Flv.c

    GEN     Flc_to_ZC(GEN z)
    GEN     Flc_to_ZC_inplace(GEN z)
    GEN     Flm_Flc_gauss(GEN a, GEN b, ulong p)
    GEN     Flm_Flc_invimage(GEN mat, GEN y, ulong p)
    GEN     Flm_adjoint(GEN A, ulong p)
    GEN     Flm_deplin(GEN x, ulong p)
    ulong   Flm_det(GEN x, ulong p)
    ulong   Flm_det_sp(GEN x, ulong p)
    GEN     Flm_gauss(GEN a, GEN b, ulong p)
    GEN     Flm_intersect(GEN x, GEN y, ulong p)
    GEN     Flm_inv(GEN x, ulong p)
    GEN     Flm_invimage(GEN m, GEN v, ulong p)
    GEN     Flm_ker(GEN x, ulong p)
    GEN     Flm_ker_sp(GEN x, ulong p, long deplin)
    long    Flm_rank(GEN x, ulong p)
    GEN     Flm_to_ZM(GEN z)
    GEN     Flm_to_ZM_inplace(GEN z)
    GEN     Flv_to_ZV(GEN z)

    # Flx.c

    GEN     Fl_to_Flx(ulong x, long sv)
    int     Fl2_equal1(GEN x)
    GEN     Fl2_inv_pre(GEN x, ulong D, ulong p, ulong pi)
    GEN     Fl2_mul_pre(GEN x, GEN y, ulong D, ulong p, ulong pi)
    ulong   Fl2_norm_pre(GEN x, ulong D, ulong p, ulong pi)
    GEN     Fl2_pow_pre(GEN x, GEN n, ulong D, ulong p, ulong pi)
    GEN     Fl2_sqr_pre(GEN x, ulong D, ulong p, ulong pi)
    GEN     Fl2_sqrtn_pre(GEN a, GEN n, ulong D, ulong p, ulong pi, GEN *zeta)
    GEN     Flm_to_FlxV(GEN x, long sv)
    GEN     Flm_to_FlxX(GEN x, long v, long w)
    GEN     Flv_Flm_polint(GEN xa, GEN ya, ulong p, long vs)
    GEN     Flv_inv(GEN x, ulong p)
    void    Flv_inv_inplace(GEN x, ulong p)
    void    Flv_inv_pre_inplace(GEN x, ulong p, ulong pi)
    GEN     Flv_inv_pre(GEN x, ulong p, ulong pi)
    GEN     Flv_invVandermonde(GEN L, ulong den, ulong p)
    GEN     Flv_polint(GEN xa, GEN ya, ulong p, long vs)
    ulong   Flv_prod(GEN v, ulong p)
    ulong   Flv_prod_pre(GEN x, ulong p, ulong pi)
    GEN     Flv_roots_to_pol(GEN a, ulong p, long vs)
    GEN     Flv_to_Flx(GEN x, long vs)
    GEN     Flx_Fl_add(GEN y, ulong x, ulong p)
    GEN     Flx_Fl_mul(GEN y, ulong x, ulong p)
    GEN     Flx_Fl_mul_to_monic(GEN y, ulong x, ulong p)
    GEN     Flx_Fl_sub(GEN y, ulong x, ulong p)
    GEN     Flx_Fl2_eval_pre(GEN x, GEN y, ulong D, ulong p, ulong pi)
    GEN     Flx_Flv_multieval(GEN P, GEN v, ulong p)
    GEN     Flx_Flxq_eval(GEN f, GEN x, GEN T, ulong p)
    GEN     Flx_FlxqV_eval(GEN f, GEN x, GEN T, ulong p)
    GEN     Flx_Frobenius(GEN T, ulong p)
    GEN     Flx_Laplace(GEN x, ulong p)
    GEN     Flx_Newton(GEN P, long n, ulong p)
    GEN     Flx_add(GEN x, GEN y, ulong p)
    GEN     Flx_blocks(GEN P, long n, long m)
    GEN     Flx_deflate(GEN x0, long d)
    GEN     Flx_deriv(GEN z, ulong p)
    GEN     Flx_diff1(GEN P, ulong p)
    GEN     Flx_digits(GEN x, GEN T, ulong p)
    GEN     Flx_div_by_X_x(GEN a, ulong x, ulong p, ulong *rem)
    GEN     Flx_divrem(GEN x, GEN y, ulong p, GEN *pr)
    GEN     Flx_double(GEN y, ulong p)
    int     Flx_equal(GEN V, GEN W)
    ulong   Flx_eval(GEN x, ulong y, ulong p)
    ulong   Flx_eval_powers_pre(GEN x, GEN y, ulong p, ulong pi)
    ulong   Flx_eval_pre(GEN x, ulong y, ulong p, ulong pi)
    GEN     Flx_extgcd(GEN a, GEN b, ulong p, GEN *ptu, GEN *ptv)
    ulong   Flx_extresultant(GEN a, GEN b, ulong p, GEN *ptU, GEN *ptV)
    GEN     Flx_fromNewton(GEN P, ulong p)
    GEN     Flx_gcd(GEN a, GEN b, ulong p)
    GEN     Flx_get_red(GEN T, ulong p)
    GEN     Flx_halfgcd(GEN a, GEN b, ulong p)
    GEN     Flx_halve(GEN y, ulong p)
    GEN     Flx_inflate(GEN x0, long d)
    GEN     Flx_integ(GEN z, ulong p)
    GEN     Flx_invBarrett(GEN T, ulong p)
    GEN     Flx_invLaplace(GEN x, ulong p)
    int     Flx_is_squarefree(GEN z, ulong p)
    int     Flx_is_smooth(GEN g, long r, ulong p)
    GEN     Flx_matFrobenius(GEN T, ulong p)
    GEN     Flx_mod_Xn1(GEN T, ulong n, ulong p)
    GEN     Flx_mod_Xnm1(GEN T, ulong n, ulong p)
    GEN     Flx_mul(GEN x, GEN y, ulong p)
    GEN     Flx_neg(GEN x, ulong p)
    GEN     Flx_neg_inplace(GEN x, ulong p)
    GEN     Flx_normalize(GEN z, ulong p)
    GEN     Flx_powu(GEN x, ulong n, ulong p)
    GEN     Flx_recip(GEN x)
    GEN     Flx_red(GEN z, ulong p)
    GEN     Flx_rem(GEN x, GEN y, ulong p)
    GEN     Flx_renormalize(GEN x, long l)
    GEN     Flx_rescale(GEN P, ulong h, ulong p)
    ulong   Flx_resultant(GEN a, GEN b, ulong p)
    GEN     Flx_shift(GEN a, long n)
    GEN     Flx_splitting(GEN p, long k)
    GEN     Flx_sqr(GEN x, ulong p)
    GEN     Flx_sub(GEN x, GEN y, ulong p)
    GEN     Flx_translate1(GEN P, ulong p)
    GEN     Flx_translate1_basecase(GEN P, ulong p)
    GEN     Flx_to_Flv(GEN x, long N)
    GEN     Flx_to_FlxX(GEN z, long v)
    GEN     Flx_to_ZX(GEN z)
    GEN     Flx_to_ZX_inplace(GEN z)
    GEN     Flx_triple(GEN y, ulong p)
    long    Flx_val(GEN x)
    long    Flx_valrem(GEN x, GEN *Z)
    GEN     FlxC_FlxqV_eval(GEN x, GEN v, GEN T, ulong p)
    GEN     FlxC_Flxq_eval(GEN x, GEN F, GEN T, ulong p)
    GEN     FlxC_eval_powers_pre(GEN z, GEN x, ulong p, ulong pi)
    GEN     FlxC_neg(GEN x, ulong p)
    GEN     FlxC_sub(GEN x, GEN y, ulong p)
    GEN     FlxC_to_ZXC(GEN x)
    GEN     FlxM_Flx_add_shallow(GEN x, GEN y, ulong p)
    GEN     FlxM_eval_powers_pre(GEN z, GEN x, ulong p, ulong pi)
    GEN     FlxM_neg(GEN x, ulong p)
    GEN     FlxM_sub(GEN x, GEN y, ulong p)
    GEN     FlxM_to_ZXM(GEN z)
    GEN     FlxT_red(GEN z, ulong p)
    GEN     FlxV_Flc_mul(GEN V, GEN W, ulong p)
    GEN     FlxV_Flv_multieval(GEN P, GEN v, ulong p)
    GEN     FlxV_Flx_fromdigits(GEN x, GEN T, ulong p)
    GEN     FlxV_prod(GEN V, ulong p)
    GEN     FlxV_red(GEN z, ulong p)
    GEN     FlxV_to_Flm(GEN v, long n)
    GEN     FlxV_to_FlxX(GEN x, long v)
    GEN     FlxV_to_ZXV(GEN x)
    void    FlxV_to_ZXV_inplace(GEN v)
    GEN     Flxn_exp(GEN h, long e, ulong p)
    GEN     Flxn_expint(GEN h, long e, ulong p)
    GEN     Flxn_inv(GEN f, long e, ulong p)
    GEN     Flxn_mul(GEN a, GEN b, long n, ulong p)
    GEN     Flxn_sqr(GEN a, long n, ulong p)
    GEN     Flxn_red(GEN a, long n)
    GEN     Flxq_autpow(GEN x, ulong n, GEN T, ulong p)
    GEN     Flxq_autpowers(GEN x, ulong n, GEN T, ulong p)
    GEN     Flxq_autsum(GEN x, ulong n, GEN T, ulong p)
    GEN     Flxq_auttrace(GEN x, ulong n, GEN T, ulong p)
    GEN     Flxq_charpoly(GEN x, GEN T, ulong p)
    GEN     Flxq_conjvec(GEN x, GEN T, ulong p)
    GEN     Flxq_div(GEN x, GEN y, GEN T, ulong p)
    GEN     Flxq_inv(GEN x, GEN T, ulong p)
    GEN     Flxq_invsafe(GEN x, GEN T, ulong p)
    int     Flxq_issquare(GEN x, GEN T, ulong p)
    int     Flxq_is2npower(GEN x, long n, GEN T, ulong p)
    GEN     Flxq_log(GEN a, GEN g, GEN ord, GEN T, ulong p)
    GEN     Flxq_lroot(GEN a, GEN T, long p)
    GEN     Flxq_lroot_fast(GEN a, GEN sqx, GEN T, long p)
    GEN     Flxq_matrix_pow(GEN y, long n, long m, GEN P, ulong l)
    GEN     Flxq_minpoly(GEN x, GEN T, ulong p)
    GEN     Flxq_mul(GEN x, GEN y, GEN T, ulong p)
    ulong   Flxq_norm(GEN x, GEN T, ulong p)
    GEN     Flxq_order(GEN a, GEN ord, GEN T, ulong p)
    GEN     Flxq_pow(GEN x, GEN n, GEN T, ulong p)
    GEN     Flxq_pow_init(GEN x, GEN n, long k,  GEN T, ulong p)
    GEN     Flxq_pow_table(GEN R, GEN n, GEN T, ulong p)
    GEN     Flxq_powu(GEN x, ulong n, GEN T, ulong p)
    GEN     Flxq_powers(GEN x, long l, GEN T, ulong p)
    GEN     Flxq_sqr(GEN y, GEN T, ulong p)
    GEN     Flxq_sqrt(GEN a, GEN T, ulong p)
    GEN     Flxq_sqrtn(GEN a, GEN n, GEN T, ulong p, GEN *zetan)
    ulong   Flxq_trace(GEN x, GEN T, ulong p)
    GEN     FlxqC_Flxq_mul(GEN x, GEN y, GEN T, ulong p)
    GEN     FlxqM_Flxq_mul(GEN x, GEN y, GEN T, ulong p)
    GEN     FlxqV_dotproduct(GEN x, GEN y, GEN T, ulong p)
    ulong   Rg_to_F2(GEN x)
    ulong   Rg_to_Fl(GEN x, ulong p)
    GEN     Rg_to_Flxq(GEN x, GEN T, ulong p)
    GEN     RgX_to_Flx(GEN x, ulong p)
    GEN     RgXV_to_FlxV(GEN x, ulong p)
    GEN     Z_to_Flx(GEN x, ulong p, long sv)
    GEN     ZX_to_Flx(GEN x, ulong p)
    GEN     ZXV_to_FlxV(GEN v, ulong p)
    GEN     ZXT_to_FlxT(GEN z, ulong p)
    GEN     gener_Flxq(GEN T, ulong p, GEN *o)
    GEN     monomial_Flx(ulong a, long d, long vs)
    GEN     random_Flx(long d1, long v, ulong p)
    GEN     zero_FlxC(long n, long sv)
    GEN     zero_FlxM(long r, long c, long sv)
    GEN     zlx_translate1(GEN P, ulong p, long e)
    GEN     zx_to_Flx(GEN x, ulong p)

    # FlxX.c

    GEN     FlxX_Fl_mul(GEN x, ulong y, ulong p)
    GEN     FlxX_Flx_add(GEN y, GEN x, ulong p)
    GEN     FlxX_Flx_mul(GEN x, GEN y, ulong p)
    GEN     FlxX_Flx_sub(GEN y, GEN x, ulong p)
    GEN     FlxX_Laplace(GEN x, ulong p)
    GEN     FlxX_add(GEN P, GEN Q, ulong p)
    GEN     FlxX_blocks(GEN P, long n, long m, long vs)
    GEN     FlxX_deriv(GEN z, ulong p)
    GEN     FlxX_double(GEN x, ulong p)
    GEN     FlxX_invLaplace(GEN x, ulong p)
    GEN     FlxX_neg(GEN x, ulong p)
    GEN     FlxX_renormalize(GEN x, long lx)
    GEN     FlxX_shift(GEN a, long n, long vs)
    GEN     FlxX_sub(GEN P, GEN Q, ulong p)
    GEN     FlxX_swap(GEN x, long n, long ws)
    GEN     FlxX_to_Flm(GEN v, long n)
    GEN     FlxX_to_Flx(GEN f)
    GEN     FlxX_to_FlxC(GEN x, long N, long sv)
    GEN     FlxX_to_ZXX(GEN B)
    GEN     FlxX_translate1(GEN P, long p, long n)
    GEN     FlxX_triple(GEN x, ulong p)
    GEN     FlxXC_to_ZXXC(GEN B)
    GEN     FlxXM_to_ZXXM(GEN B)
    GEN     FlxXV_to_FlxM(GEN v, long n, long sv)
    GEN     FlxXn_red(GEN a, long n)
    GEN     FlxY_Flx_div(GEN x, GEN y, ulong p)
    GEN     FlxY_Flx_translate(GEN P, GEN c, ulong p)
    GEN     FlxY_Flxq_evalx(GEN P, GEN x, GEN T, ulong p)
    GEN     FlxY_FlxqV_evalx(GEN P, GEN x, GEN T, ulong p)
    long    FlxY_degreex(GEN b)
    ulong   FlxY_eval_powers_pre(GEN pol, GEN ypowers, GEN xpowers, ulong p, ulong pi)
    GEN     FlxY_evalx(GEN Q, ulong x, ulong p)
    GEN     FlxY_evalx_powers_pre(GEN pol, GEN ypowers, ulong p, ulong pi)
    GEN     FlxYqq_pow(GEN x, GEN n, GEN S, GEN T, ulong p)
    GEN     FlxqV_roots_to_pol(GEN V, GEN T, ulong p, long v)
    GEN     FlxqX_FlxqXQ_eval(GEN Q, GEN x, GEN S, GEN T, ulong p)
    GEN     FlxqX_FlxqXQV_eval(GEN P, GEN V, GEN S, GEN T, ulong p)
    GEN     FlxqX_Flxq_mul(GEN P, GEN U, GEN T, ulong p)
    GEN     FlxqX_Flxq_mul_to_monic(GEN P, GEN U, GEN T, ulong p)
    GEN     FlxqX_Newton(GEN P, long n, GEN T, ulong p)
    GEN     FlxqX_divrem(GEN x, GEN y, GEN T, ulong p, GEN *pr)
    GEN     FlxqX_disc(GEN x, GEN T, ulong p)
    GEN     FlxqX_dotproduct(GEN x, GEN y, GEN T, ulong p)
    GEN     FlxqX_extgcd(GEN a, GEN b, GEN T, ulong p, GEN *ptu, GEN *ptv)
    GEN     FlxqX_fromNewton(GEN P, GEN T, ulong p)
    GEN     FlxqX_gcd(GEN P, GEN Q, GEN T, ulong p)
    GEN     FlxqX_get_red(GEN S, GEN T, ulong p)
    GEN     FlxqX_halfgcd(GEN x, GEN y, GEN T, ulong p)
    GEN     FlxqX_invBarrett(GEN T, GEN Q, ulong p)
    GEN     FlxqX_mul(GEN x, GEN y, GEN T, ulong p)
    GEN     FlxqX_normalize(GEN z, GEN T, ulong p)
    GEN     FlxqX_powu(GEN V, ulong n, GEN T, ulong p)
    GEN     FlxqX_red(GEN z, GEN T, ulong p)
    GEN     FlxqX_rem(GEN x, GEN y, GEN T, ulong p)
    GEN     FlxqX_resultant(GEN x, GEN y, GEN T, ulong p)
    GEN     FlxqX_safegcd(GEN P, GEN Q, GEN T, ulong p)
    GEN     FlxqX_saferesultant(GEN a, GEN b, GEN T, ulong p)
    GEN     FlxqX_sqr(GEN x, GEN T, ulong p)
    GEN     FlxqXQ_div(GEN x, GEN y, GEN S, GEN T, ulong p)
    GEN     FlxqXQ_inv(GEN x, GEN S, GEN T, ulong p)
    GEN     FlxqXQ_invsafe(GEN x, GEN S, GEN T, ulong p)
    GEN     FlxqXQ_matrix_pow(GEN x, long n, long m, GEN S, GEN T, ulong p)
    GEN     FlxqXQ_minpoly(GEN x, GEN S, GEN T, ulong p)
    GEN     FlxqXQ_mul(GEN x, GEN y, GEN S, GEN T, ulong p)
    GEN     FlxqXQ_pow(GEN x, GEN n, GEN S, GEN T, ulong p)
    GEN     FlxqXQ_powu(GEN x, ulong n, GEN S, GEN T, ulong p)
    GEN     FlxqXQ_powers(GEN x, long n, GEN S, GEN T, ulong p)
    GEN     FlxqXQ_sqr(GEN x, GEN S, GEN T, ulong p)
    GEN     FlxqXQ_autpow(GEN x, long n, GEN S, GEN T, ulong p)
    GEN     FlxqXQ_autsum(GEN aut, long n, GEN S, GEN T, ulong p)
    GEN     FlxqXQ_auttrace(GEN x, ulong n, GEN S, GEN T, ulong p)
    GEN     FlxqXV_prod(GEN V, GEN T, ulong p)
    GEN     FlxqXn_expint(GEN h, long e, GEN T, ulong p)
    GEN     FlxqXn_inv(GEN f, long e, GEN T, ulong p)
    GEN     FlxqXn_mul(GEN a, GEN b, long n, GEN T, ulong p)
    GEN     FlxqXn_sqr(GEN a, long n, GEN T, ulong p)
    GEN     Fly_to_FlxY(GEN B, long v)
    GEN     Kronecker_to_FlxqX(GEN z, GEN T, ulong p)
    GEN     RgX_to_FlxqX(GEN x, GEN T, ulong p)
    GEN     pol1_FlxX(long v, long sv)
    GEN     polx_FlxX(long v, long sv)
    GEN     random_FlxqX(long d1, long v, GEN T, ulong p)
    GEN     zlxX_translate1(GEN P, long p, long e, long n)
    GEN     zxX_to_FlxX(GEN B, ulong p)
    GEN     zxX_to_Kronecker(GEN P, GEN Q)

    # FlxqE.c

    GEN     Flxq_ellcard(GEN a4, GEN a6, GEN T, ulong p)
    GEN     Flxq_ellgens(GEN a4, GEN a6, GEN ch, GEN D, GEN m, GEN T, ulong p)
    GEN     Flxq_ellgroup(GEN a4, GEN a6, GEN N, GEN T, ulong p, GEN *pt_m)
    void    Flxq_elltwist(GEN a, GEN a6, GEN T, ulong p, GEN *pt_a, GEN *pt_a6)
    GEN     Flxq_ellj(GEN a4, GEN a6, GEN T, ulong p)
    void    Flxq_ellj_to_a4a6(GEN j, GEN T, ulong p, GEN *pt_a4, GEN *pt_a6)
    GEN     FlxqE_add(GEN P, GEN Q, GEN a4, GEN T, ulong p)
    GEN     FlxqE_changepoint(GEN x, GEN ch, GEN T, ulong p)
    GEN     FlxqE_changepointinv(GEN x, GEN ch, GEN T, ulong p)
    GEN     FlxqE_dbl(GEN P, GEN a4, GEN T, ulong p)
    GEN     FlxqE_log(GEN a, GEN b, GEN o, GEN a4, GEN T, ulong p)
    GEN     FlxqE_mul(GEN P, GEN n, GEN a4, GEN T, ulong p)
    GEN     FlxqE_neg(GEN P, GEN T, ulong p)
    GEN     FlxqE_order(GEN z, GEN o, GEN a4, GEN T, ulong p)
    GEN     FlxqE_sub(GEN P, GEN Q, GEN a4, GEN T, ulong p)
    GEN     FlxqE_tatepairing(GEN t, GEN s, GEN m, GEN a4, GEN T, ulong p)
    GEN     FlxqE_weilpairing(GEN t, GEN s, GEN m, GEN a4, GEN T, ulong p)
    const bb_group * get_FlxqE_group(void **E, GEN a4, GEN a6, GEN T, ulong p)
    GEN     RgE_to_FlxqE(GEN x, GEN T, ulong p)
    GEN     random_FlxqE(GEN a4, GEN a6, GEN T, ulong p)

    # FpE.c

    long    Fl_elltrace(ulong a4, ulong a6, ulong p)
    long    Fl_elltrace_CM(long CM, ulong a4, ulong a6, ulong p)
    GEN     Fp_ellcard(GEN a4, GEN a6, GEN p)
    GEN     Fp_elldivpol(GEN a4, GEN a6, long n, GEN p)
    GEN     Fp_ellgens(GEN a4, GEN a6, GEN ch, GEN D, GEN m, GEN p)
    GEN     Fp_ellgroup(GEN a4, GEN a6, GEN N, GEN p, GEN *pt_m)
    GEN     Fp_ellj(GEN a4, GEN a6, GEN p)
    int     Fp_elljissupersingular(GEN j, GEN p)
    void    Fp_elltwist(GEN a4, GEN a6, GEN p, GEN *pt_a4, GEN *pt_a6)
    GEN     Fp_ffellcard(GEN a4, GEN a6, GEN q, long n, GEN p)
    GEN     FpE_add(GEN P, GEN Q, GEN a4, GEN p)
    GEN     FpE_changepoint(GEN x, GEN ch, GEN p)
    GEN     FpE_changepointinv(GEN x, GEN ch, GEN p)
    GEN     FpE_dbl(GEN P, GEN a4, GEN p)
    GEN     FpE_log(GEN a, GEN b, GEN o, GEN a4, GEN p)
    GEN     FpE_mul(GEN P, GEN n, GEN a4, GEN p)
    GEN     FpE_neg(GEN P, GEN p)
    GEN     FpE_order(GEN z, GEN o, GEN a4, GEN p)
    GEN     FpE_sub(GEN P, GEN Q, GEN a4, GEN p)
    GEN     FpE_to_mod(GEN P, GEN p)
    GEN     FpE_tatepairing(GEN t, GEN s, GEN m, GEN a4, GEN p)
    GEN     FpE_weilpairing(GEN t, GEN s, GEN m, GEN a4, GEN p)
    GEN     FpXQ_ellcard(GEN a4, GEN a6, GEN T, GEN p)
    GEN     FpXQ_elldivpol(GEN a4, GEN a6, long n, GEN T, GEN p)
    GEN     FpXQ_ellgens(GEN a4, GEN a6, GEN ch, GEN D, GEN m, GEN T, GEN p)
    GEN     FpXQ_ellgroup(GEN a4, GEN a6, GEN N, GEN T, GEN p, GEN *pt_m)
    GEN     FpXQ_ellj(GEN a4, GEN a6, GEN T, GEN p)
    int     FpXQ_elljissupersingular(GEN j, GEN T, GEN p)
    void    FpXQ_elltwist(GEN a4, GEN a6, GEN T, GEN p, GEN *pt_a4, GEN *pt_a6)
    GEN     FpXQE_add(GEN P, GEN Q, GEN a4, GEN T, GEN p)
    GEN     FpXQE_changepoint(GEN x, GEN ch, GEN T, GEN p)
    GEN     FpXQE_changepointinv(GEN x, GEN ch, GEN T, GEN p)
    GEN     FpXQE_dbl(GEN P, GEN a4, GEN T, GEN p)
    GEN     FpXQE_log(GEN a, GEN b, GEN o, GEN a4, GEN T, GEN p)
    GEN     FpXQE_mul(GEN P, GEN n, GEN a4, GEN T, GEN p)
    GEN     FpXQE_neg(GEN P, GEN T, GEN p)
    GEN     FpXQE_order(GEN z, GEN o, GEN a4, GEN T, GEN p)
    GEN     FpXQE_sub(GEN P, GEN Q, GEN a4, GEN T, GEN p)
    GEN     FpXQE_tatepairing(GEN t, GEN s, GEN m, GEN a4, GEN T, GEN p)
    GEN     FpXQE_weilpairing(GEN t, GEN s, GEN m, GEN a4, GEN T, GEN p)
    GEN     Fq_elldivpolmod(GEN a4, GEN a6, long n, GEN h, GEN T, GEN p)
    GEN     RgE_to_FpE(GEN x, GEN p)
    GEN     RgE_to_FpXQE(GEN x, GEN T, GEN p)
    const bb_group * get_FpE_group(void **E, GEN a4, GEN a6, GEN p)
    const bb_group * get_FpXQE_group(void **E, GEN a4, GEN a6, GEN T, GEN p)
    GEN     elltrace_extension(GEN t, long n, GEN p)
    GEN     random_FpE(GEN a4, GEN a6, GEN p)
    GEN     random_FpXQE(GEN a4, GEN a6, GEN T, GEN p)

    # FpX.c

    int     Fp_issquare(GEN x, GEN p)
    GEN     Fp_FpX_sub(GEN x, GEN y, GEN p)
    GEN     Fp_FpXQ_log(GEN a, GEN g, GEN ord, GEN T, GEN p)
    GEN     FpV_FpM_polint(GEN xa, GEN ya, GEN p, long vs)
    GEN     FpV_inv(GEN x, GEN p)
    GEN     FpV_invVandermonde(GEN L, GEN den, GEN p)
    GEN     FpV_polint(GEN xa, GEN ya, GEN p, long v)
    GEN     FpV_roots_to_pol(GEN V, GEN p, long v)
    GEN     FpX_Fp_add(GEN x, GEN y, GEN p)
    GEN     FpX_Fp_add_shallow(GEN y, GEN x, GEN p)
    GEN     FpX_Fp_mul(GEN x, GEN y, GEN p)
    GEN     FpX_Fp_mul_to_monic(GEN y, GEN x, GEN p)
    GEN     FpX_Fp_mulspec(GEN y, GEN x, GEN p, long ly)
    GEN     FpX_Fp_sub(GEN x, GEN y, GEN p)
    GEN     FpX_Fp_sub_shallow(GEN y, GEN x, GEN p)
    GEN     FpX_FpV_multieval(GEN P, GEN xa, GEN p)
    GEN     FpX_FpXQ_eval(GEN f, GEN x, GEN T, GEN p)
    GEN     FpX_FpXQV_eval(GEN f, GEN x, GEN T, GEN p)
    GEN     FpX_Frobenius(GEN T, GEN p)
    GEN     FpX_add(GEN x, GEN y, GEN p)
    GEN     FpX_center(GEN x, GEN p, GEN pov2)
    GEN     FpX_chinese_coprime(GEN x, GEN y, GEN Tx, GEN Ty, GEN Tz, GEN p)
    GEN     FpX_deriv(GEN x, GEN p)
    GEN     FpX_digits(GEN x, GEN y, GEN p)
    GEN     FpX_disc(GEN x, GEN p)
    GEN     FpX_div_by_X_x(GEN a, GEN x, GEN p, GEN *r)
    GEN     FpX_divrem(GEN x, GEN y, GEN p, GEN *pr)
    GEN     FpX_dotproduct(GEN x, GEN y, GEN p)
    GEN     FpX_eval(GEN x, GEN y, GEN p)
    GEN     FpX_extgcd(GEN x, GEN y, GEN p, GEN *ptu, GEN *ptv)
    GEN     FpX_fromdigits(GEN x, GEN T, GEN p)
    GEN     FpX_gcd(GEN x, GEN y, GEN p)
    GEN     FpX_get_red(GEN T, GEN p)
    GEN     FpX_halve(GEN y, GEN p)
    GEN     FpX_halfgcd(GEN x, GEN y, GEN p)
    GEN     FpX_invBarrett(GEN T, GEN p)
    int     FpX_is_squarefree(GEN f, GEN p)
    GEN     FpX_matFrobenius(GEN T, GEN p)
    GEN     FpX_mul(GEN x, GEN y, GEN p)
    GEN     FpX_mulspec(GEN a, GEN b, GEN p, long na, long nb)
    GEN     FpX_mulu(GEN x, ulong y, GEN p)
    GEN     FpX_neg(GEN x, GEN p)
    GEN     FpX_normalize(GEN z, GEN p)
    GEN     FpX_powu(GEN x, ulong n, GEN p)
    GEN     FpX_red(GEN z, GEN p)
    GEN     FpX_rem(GEN x, GEN y, GEN p)
    GEN     FpX_rescale(GEN P, GEN h, GEN p)
    GEN     FpX_resultant(GEN a, GEN b, GEN p)
    GEN     FpX_sqr(GEN x, GEN p)
    GEN     FpX_sub(GEN x, GEN y, GEN p)
    long    FpX_valrem(GEN x0, GEN t, GEN p, GEN *py)
    GEN     FpXC_FpXQV_eval(GEN Q, GEN x, GEN T, GEN p)
    GEN     FpXM_FpXQV_eval(GEN Q, GEN x, GEN T, GEN p)
    GEN     FpXQ_autpow(GEN x, ulong n, GEN T, GEN p)
    GEN     FpXQ_autpowers(GEN aut, long f, GEN T, GEN p)
    GEN     FpXQ_autsum(GEN x, ulong n, GEN T, GEN p)
    GEN     FpXQ_auttrace(GEN x, ulong n, GEN T, GEN p)
    GEN     FpXQ_charpoly(GEN x, GEN T, GEN p)
    GEN     FpXQ_conjvec(GEN x, GEN T, GEN p)
    GEN     FpXQ_div(GEN x, GEN y, GEN T, GEN p)
    GEN     FpXQ_inv(GEN x, GEN T, GEN p)
    GEN     FpXQ_invsafe(GEN x, GEN T, GEN p)
    int     FpXQ_issquare(GEN x, GEN T, GEN p)
    GEN     FpXQ_log(GEN a, GEN g, GEN ord, GEN T, GEN p)
    GEN     FpXQ_matrix_pow(GEN y, long n, long m, GEN P, GEN l)
    GEN     FpXQ_minpoly(GEN x, GEN T, GEN p)
    GEN     FpXQ_mul(GEN y, GEN x, GEN T, GEN p)
    GEN     FpXQ_norm(GEN x, GEN T, GEN p)
    GEN     FpXQ_order(GEN a, GEN ord, GEN T, GEN p)
    GEN     FpXQ_pow(GEN x, GEN n, GEN T, GEN p)
    GEN     FpXQ_powu(GEN x, ulong n, GEN T, GEN p)
    GEN     FpXQ_powers(GEN x, long l, GEN T, GEN p)
    GEN     FpXQ_red(GEN x, GEN T, GEN p)
    GEN     FpXQ_sqr(GEN y, GEN T, GEN p)
    GEN     FpXQ_sqrt(GEN a, GEN T, GEN p)
    GEN     FpXQ_sqrtn(GEN a, GEN n, GEN T, GEN p, GEN *zetan)
    GEN     FpXQ_trace(GEN x, GEN T, GEN p)
    GEN     FpXQC_to_mod(GEN z, GEN T, GEN p)
    GEN     FpXQM_autsum(GEN x, ulong n, GEN T, GEN p)
    GEN     FpXT_red(GEN z, GEN p)
    GEN     FpXV_prod(GEN V, GEN p)
    GEN     FpXV_red(GEN z, GEN p)
    int     Fq_issquare(GEN x, GEN T, GEN p)
    long    Fq_ispower(GEN x, GEN K, GEN T, GEN p)
    GEN     Fq_log(GEN a, GEN g, GEN ord, GEN T, GEN p)
    GEN     Fq_sqrtn(GEN a, GEN n, GEN T, GEN p, GEN *z)
    GEN     Fq_sqrt(GEN a, GEN T, GEN p)
    long    FqX_ispower(GEN f, ulong k, GEN T, GEN p, GEN *pt)
    GEN     FqV_inv(GEN x, GEN T, GEN p)
    GEN     Z_to_FpX(GEN a, GEN p, long v)
    GEN     gener_FpXQ(GEN T, GEN p, GEN *o)
    GEN     gener_FpXQ_local(GEN T, GEN p, GEN L)
    long    get_FpX_degree(GEN T)
    GEN     get_FpX_mod(GEN T)
    long    get_FpX_var(GEN T)
    const bb_group *get_FpXQ_star(void **E, GEN T, GEN p)
    GEN     random_FpX(long d, long v, GEN p)

    # FpX_factor.c

    GEN     F2x_factor(GEN f)
    int     F2x_is_irred(GEN f)
    void    F2xV_to_FlxV_inplace(GEN v)
    void    F2xV_to_ZXV_inplace(GEN v)
    int     Flx_is_irred(GEN f, ulong p)
    GEN     Flx_degfact(GEN f, ulong p)
    GEN     Flx_factor(GEN f, ulong p)
    long    Flx_nbfact(GEN z, ulong p)
    long    Flx_nbfact_Frobenius(GEN T, GEN XP, ulong p)
    GEN     Flx_nbfact_by_degree(GEN z, long *nb, ulong p)
    long    Flx_nbroots(GEN f, ulong p)
    ulong   Flx_oneroot(GEN f, ulong p)
    ulong   Flx_oneroot_split(GEN f, ulong p)
    GEN     Flx_roots(GEN f, ulong p)
    GEN     Flx_rootsff(GEN P, GEN T, ulong p)
    void    FlxV_to_ZXV_inplace(GEN v)
    GEN     FpX_degfact(GEN f, GEN p)
    int     FpX_is_irred(GEN f, GEN p)
    int     FpX_is_totally_split(GEN f, GEN p)
    GEN     FpX_factor(GEN f, GEN p)
    GEN     FpX_factorff(GEN P, GEN T, GEN p)
    long    FpX_nbfact(GEN f, GEN p)
    long    FpX_nbfact_Frobenius(GEN T, GEN XP, GEN p)
    long    FpX_nbroots(GEN f, GEN p)
    GEN     FpX_oneroot(GEN f, GEN p)
    GEN     FpX_roots(GEN f, GEN p)
    GEN     FpX_rootsff(GEN P, GEN T, GEN p)
    GEN     FpX_split_part(GEN f, GEN p)
    GEN     factcantor(GEN x, GEN p)
    GEN     factormod0(GEN f, GEN p, long flag)
    GEN     rootmod0(GEN f, GEN p, long flag)

    # FpXQX_factor.c

    GEN     F2xqX_roots(GEN x, GEN T)
    GEN     FlxqX_Frobenius(GEN S, GEN T, ulong p)
    GEN     FlxqXQ_halfFrobenius(GEN a, GEN S, GEN T, ulong p)
    GEN     FlxqX_roots(GEN S, GEN T, ulong p)
    long    FlxqX_nbroots(GEN f, GEN T, ulong p)
    GEN     FpXQX_Frobenius(GEN S, GEN T, GEN p)
    GEN     FpXQX_factor(GEN x, GEN T, GEN p)
    long    FpXQX_nbfact(GEN u, GEN T, GEN p)
    long    FpXQX_nbroots(GEN f, GEN T, GEN p)
    GEN     FpXQX_roots(GEN f, GEN T, GEN p)
    GEN     FpXQXQ_halfFrobenius(GEN a, GEN S, GEN T, GEN p)
    long    FqX_is_squarefree(GEN P, GEN T, GEN p)
    long    FqX_nbfact(GEN u, GEN T, GEN p)
    long    FqX_nbroots(GEN f, GEN T, GEN p)
    GEN     factorff(GEN f, GEN p, GEN a)
    GEN     polrootsff(GEN f, GEN p, GEN T)

    # FpXX.c

    GEN     FpXQX_FpXQ_mul(GEN P, GEN U, GEN T, GEN p)
    GEN     FpXQX_FpXQXQV_eval(GEN P, GEN V, GEN S, GEN T, GEN p)
    GEN     FpXQX_FpXQXQ_eval(GEN P, GEN x, GEN S, GEN T, GEN p)
    GEN     FpXQX_div_by_X_x(GEN a, GEN x, GEN T, GEN p, GEN *pr)
    GEN     FpXQX_divrem(GEN x, GEN y, GEN T, GEN p, GEN *pr)
    GEN     FpXQX_digits(GEN x, GEN B, GEN T, GEN p)
    GEN     FpXQX_extgcd(GEN x, GEN y, GEN T, GEN p, GEN *ptu, GEN *ptv)
    GEN     FpXQX_fromdigits(GEN x, GEN B, GEN T, GEN p)
    GEN     FpXQX_gcd(GEN P, GEN Q, GEN T, GEN p)
    GEN     FpXQX_get_red(GEN S, GEN T, GEN p)
    GEN     FpXQX_halfgcd(GEN x, GEN y, GEN T, GEN p)
    GEN     FpXQX_invBarrett(GEN S, GEN T, GEN p)
    GEN     FpXQX_mul(GEN x, GEN y, GEN T, GEN p)
    GEN     FpXQX_powu(GEN x, ulong n, GEN T, GEN p)
    GEN     FpXQX_red(GEN z, GEN T, GEN p)
    GEN     FpXQX_rem(GEN x, GEN S, GEN T, GEN p)
    GEN     FpXQX_sqr(GEN x, GEN T, GEN p)
    GEN     FpXQXQ_div(GEN x, GEN y, GEN S, GEN T, GEN p)
    GEN     FpXQXQ_inv(GEN x, GEN S, GEN T, GEN p)
    GEN     FpXQXQ_invsafe(GEN x, GEN S, GEN T, GEN p)
    GEN     FpXQXQ_matrix_pow(GEN y, long n, long m, GEN S, GEN T, GEN p)
    GEN     FpXQXQ_mul(GEN x, GEN y, GEN S, GEN T, GEN p)
    GEN     FpXQXQ_pow(GEN x, GEN n, GEN S, GEN T, GEN p)
    GEN     FpXQXQ_powers(GEN x, long n, GEN S, GEN T, GEN p)
    GEN     FpXQXQ_sqr(GEN x, GEN S, GEN T, GEN p)
    GEN     FpXQXQV_autpow(GEN aut, long n, GEN S, GEN T, GEN p)
    GEN     FpXQXQV_autsum(GEN aut, long n, GEN S, GEN T, GEN p)
    GEN     FpXQXQV_auttrace(GEN aut, long n, GEN S, GEN T, GEN p)
    GEN     FpXQXV_prod(GEN V, GEN Tp, GEN p)
    GEN     FpXX_Fp_mul(GEN x, GEN y, GEN p)
    GEN     FpXX_FpX_mul(GEN x, GEN y, GEN p)
    GEN     FpXX_add(GEN x, GEN y, GEN p)
    GEN     FpXX_deriv(GEN P, GEN p)
    GEN     FpXX_mulu(GEN P, ulong u, GEN p)
    GEN     FpXX_neg(GEN x, GEN p)
    GEN     FpXX_red(GEN z, GEN p)
    GEN     FpXX_sub(GEN x, GEN y, GEN p)
    GEN     FpXY_FpXQ_evalx(GEN P, GEN x, GEN T, GEN p)
    GEN     FpXY_FpXQV_evalx(GEN P, GEN x, GEN T, GEN p)
    GEN     FpXY_eval(GEN Q, GEN y, GEN x, GEN p)
    GEN     FpXY_evalx(GEN Q, GEN x, GEN p)
    GEN     FpXY_evaly(GEN Q, GEN y, GEN p, long vy)
    GEN     FpXYQQ_pow(GEN x, GEN n, GEN S, GEN T, GEN p)
    GEN     Kronecker_to_FpXQX(GEN z, GEN pol, GEN p)
    GEN     Kronecker_to_ZXX(GEN z, long N, long v)
    GEN     ZXX_mul_Kronecker(GEN x, GEN y, long n)
    GEN     ZXX_sqr_Kronecker(GEN x, long n)
    long    get_FpXQX_degree(GEN T)
    GEN     get_FpXQX_mod(GEN T)
    long    get_FpXQX_var(GEN T)
    GEN     random_FpXQX(long d1, long v, GEN T, GEN p)

    # FpV.c

    GEN     F2m_F2c_mul(GEN x, GEN y)
    GEN     F2m_mul(GEN x, GEN y)
    GEN     F2m_powu(GEN x, ulong n)
    GEN     Flc_to_mod(GEN z, ulong pp)
    GEN     Flm_Fl_add(GEN x, ulong y, ulong p)
    GEN     Flm_Fl_mul(GEN y, ulong x, ulong p)
    void    Flm_Fl_mul_inplace(GEN y, ulong x, ulong p)
    GEN     Flm_Flc_mul(GEN x, GEN y, ulong p)
    GEN     Flm_Flc_mul_pre(GEN x, GEN y, ulong p, ulong pi)
    GEN     Flm_add(GEN x, GEN y, ulong p)
    GEN     Flm_center(GEN z, ulong p, ulong ps2)
    GEN     Flm_mul(GEN x, GEN y, ulong p)
    GEN     Flm_neg(GEN y, ulong p)
    GEN     Flm_powu(GEN x, ulong n, ulong p)
    GEN     Flm_sub(GEN x, GEN y, ulong p)
    GEN     Flm_to_mod(GEN z, ulong pp)
    GEN     Flm_transpose(GEN x)
    GEN     Flv_Fl_div(GEN x, ulong y, ulong p)
    void    Flv_Fl_div_inplace(GEN x, ulong y, ulong p)
    GEN     Flv_Fl_mul(GEN x, ulong y, ulong p)
    void    Flv_Fl_mul_inplace(GEN x, ulong y, ulong p)
    void    Flv_Fl_mul_part_inplace(GEN x, ulong y, ulong p, long l)
    GEN     Flv_add(GEN x, GEN y, ulong p)
    void    Flv_add_inplace(GEN x, GEN y, ulong p)
    GEN     Flv_center(GEN z, ulong p, ulong ps2)
    ulong   Flv_dotproduct(GEN x, GEN y, ulong p)
    ulong   Flv_dotproduct_pre(GEN x, GEN y, ulong p, ulong pi)
    GEN     Flv_neg(GEN v, ulong p)
    void    Flv_neg_inplace(GEN v, ulong p)
    GEN     Flv_sub(GEN x, GEN y, ulong p)
    void    Flv_sub_inplace(GEN x, GEN y, ulong p)
    ulong   Flv_sum(GEN x, ulong p)
    ulong   Flx_dotproduct(GEN x, GEN y, ulong p)
    GEN     Fp_to_mod(GEN z, GEN p)
    GEN     FpC_FpV_mul(GEN x, GEN y, GEN p)
    GEN     FpC_Fp_mul(GEN x, GEN y, GEN p)
    GEN     FpC_center(GEN z, GEN p, GEN pov2)
    void    FpC_center_inplace(GEN z, GEN p, GEN pov2)
    GEN     FpC_red(GEN z, GEN p)
    GEN     FpC_to_mod(GEN z, GEN p)
    GEN     FpM_add(GEN x, GEN y, GEN p)
    GEN     FpM_Fp_mul(GEN X, GEN c, GEN p)
    GEN     FpM_FpC_mul(GEN x, GEN y, GEN p)
    GEN     FpM_FpC_mul_FpX(GEN x, GEN y, GEN p, long v)
    GEN     FpM_center(GEN z, GEN p, GEN pov2)
    void    FpM_center_inplace(GEN z, GEN p, GEN pov2)
    GEN     FpM_mul(GEN x, GEN y, GEN p)
    GEN     FpM_powu(GEN x, ulong n, GEN p)
    GEN     FpM_red(GEN z, GEN p)
    GEN     FpM_sub(GEN x, GEN y, GEN p)
    GEN     FpM_to_mod(GEN z, GEN p)
    GEN     FpMs_FpC_mul(GEN M, GEN B, GEN p)
    GEN     FpMs_FpCs_solve(GEN M, GEN B, long nbrow, GEN p)
    GEN     FpMs_FpCs_solve_safe(GEN M, GEN A, long nbrow, GEN p)
    GEN     FpMs_leftkernel_elt(GEN M, long nbrow, GEN p)
    GEN     FpC_add(GEN x, GEN y, GEN p)
    GEN     FpC_sub(GEN x, GEN y, GEN p)
    GEN     FpV_FpMs_mul(GEN B, GEN M, GEN p)
    GEN     FpV_add(GEN x, GEN y, GEN p)
    GEN     FpV_sub(GEN x, GEN y, GEN p)
    GEN     FpV_dotproduct(GEN x, GEN y, GEN p)
    GEN     FpV_dotsquare(GEN x, GEN p)
    GEN     FpV_red(GEN z, GEN p)
    GEN     FpV_to_mod(GEN z, GEN p)
    GEN     FpVV_to_mod(GEN z, GEN p)
    GEN     FpX_to_mod(GEN z, GEN p)
    GEN     ZV_zMs_mul(GEN B, GEN M)
    GEN     ZpMs_ZpCs_solve(GEN M, GEN B, long nbrow, GEN p, long e)
    GEN     gen_FpM_Wiedemann(void *E, GEN (*f)(void*, GEN), GEN B, GEN p)
    GEN     gen_ZpM_Dixon(void *E, GEN (*f)(void*, GEN), GEN B, GEN p, long e)
    GEN     gen_matid(long n, void *E, const bb_field *S)
    GEN     matid_F2m(long n)
    GEN     matid_Flm(long n)
    GEN     matid_F2xqM(long n, GEN T)
    GEN     matid_FlxqM(long n, GEN T, ulong p)
    GEN     scalar_Flm(long s, long n)
    GEN     zCs_to_ZC(GEN C, long nbrow)
    GEN     zMs_to_ZM(GEN M, long nbrow)
    GEN     zMs_ZC_mul(GEN M, GEN B)
    GEN     ZMV_to_FlmV(GEN z, ulong m)

    # Hensel.c

    GEN     Z2_sqrt(GEN x, long e)
    GEN     Zp_sqrt(GEN x, GEN p, long e)
    GEN     Zp_sqrtlift(GEN b, GEN a, GEN p, long e)
    GEN     Zp_sqrtnlift(GEN b, GEN n, GEN a, GEN p, long e)
    GEN     ZpX_Frobenius(GEN T, GEN p, long e)
    GEN     ZpX_ZpXQ_liftroot(GEN P, GEN S, GEN T, GEN p, long e)
    GEN     ZpX_ZpXQ_liftroot_ea(GEN P, GEN S, GEN T, GEN p, long n, void *E,
                                 int early(void *E, GEN x, GEN q))
    GEN     ZpX_liftfact(GEN pol, GEN Q, GEN T, GEN p, long e, GEN pe)
    GEN     ZpX_liftroot(GEN f, GEN a, GEN p, long e)
    GEN     ZpX_liftroots(GEN f, GEN S, GEN p, long e)
    GEN     ZpX_roots(GEN f, GEN p, long e)
    GEN     ZpXQ_inv(GEN a, GEN T, GEN p, long e)
    GEN     ZpXQ_invlift(GEN b, GEN a, GEN T, GEN p, long e)
    GEN     ZpXQ_log(GEN a, GEN T, GEN p, long N)
    GEN     ZpXQ_sqrt(GEN a, GEN T, GEN p, long e)
    GEN     ZpXQ_sqrtnlift(GEN b, GEN n, GEN a, GEN T, GEN p, long e)
    GEN     ZpXQM_prodFrobenius(GEN M, GEN T, GEN p, long e)
    GEN     ZpXQX_liftroot(GEN f, GEN a, GEN T, GEN p, long e)
    GEN     ZpXQX_liftroot_vald(GEN f, GEN a, long v, GEN T, GEN p, long e)
    GEN     gen_ZpX_Dixon(GEN F, GEN V, GEN q, GEN p, long N, void *E,
                          GEN lin(void *E, GEN F, GEN d, GEN q),
                          GEN invl(void *E, GEN d))
    GEN     gen_ZpX_Newton(GEN x, GEN p, long n, void *E,
                           GEN eval(void *E, GEN f, GEN q),
                           GEN invd(void *E, GEN V, GEN v, GEN q, long M))
    GEN     polhensellift(GEN pol, GEN fct, GEN p, long exp)
    ulong   quadratic_prec_mask(long n)

    # QX_factor.c

    GEN     QX_factor(GEN x)
    GEN     ZX_factor(GEN x)
    long    ZX_is_irred(GEN x)
    GEN     ZX_squff(GEN f, GEN *ex)
    GEN     polcyclofactors(GEN f)
    long    poliscyclo(GEN f)
    long    poliscycloprod(GEN f)

    # RgV.c

    GEN     Rg_RgC_sub(GEN a, GEN x)
    GEN     RgC_Rg_add(GEN x, GEN y)
    GEN     RgC_Rg_div(GEN x, GEN y)
    GEN     RgC_Rg_mul(GEN x, GEN y)
    GEN     RgC_Rg_sub(GEN x, GEN y)
    GEN     RgC_RgM_mul(GEN x, GEN y)
    GEN     RgC_RgV_mul(GEN x, GEN y)
    GEN     RgC_add(GEN x, GEN y)
    long    RgC_is_ei(GEN x)
    GEN     RgC_neg(GEN x)
    GEN     RgC_sub(GEN x, GEN y)
    GEN     RgM_Rg_add(GEN x, GEN y)
    GEN     RgM_Rg_add_shallow(GEN x, GEN y)
    GEN     RgM_Rg_div(GEN x, GEN y)
    GEN     RgM_Rg_mul(GEN x, GEN y)
    GEN     RgM_Rg_sub(GEN x, GEN y)
    GEN     RgM_Rg_sub_shallow(GEN x, GEN y)
    GEN     RgM_RgC_mul(GEN x, GEN y)
    GEN     RgM_RgV_mul(GEN x, GEN y)
    GEN     RgM_ZM_mul(GEN x, GEN y)
    GEN     RgM_add(GEN x, GEN y)
    GEN     RgM_det_triangular(GEN x)
    int     RgM_is_QM(GEN x)
    int     RgM_is_ZM(GEN x)
    int     RgM_isdiagonal(GEN x)
    int     RgM_isidentity(GEN x)
    int     RgM_isscalar(GEN x, GEN s)
    GEN     RgM_mul(GEN x, GEN y)
    GEN     RgM_multosym(GEN x, GEN y)
    GEN     RgM_neg(GEN x)
    GEN     RgM_powers(GEN x, long l)
    GEN     RgM_sqr(GEN x)
    GEN     RgM_sub(GEN x, GEN y)
    GEN     RgM_sumcol(GEN A)
    GEN     RgM_transmul(GEN x, GEN y)
    GEN     RgM_transmultosym(GEN x, GEN y)
    GEN     RgMrow_zc_mul(GEN x, GEN y, long i)
    GEN     RgM_zc_mul(GEN x, GEN y)
    GEN     RgM_zm_mul(GEN x, GEN y)
    GEN     RgMrow_RgC_mul(GEN x, GEN y, long i)
    GEN     RgV_RgM_mul(GEN x, GEN y)
    GEN     RgV_RgC_mul(GEN x, GEN y)
    GEN     RgV_Rg_mul(GEN x, GEN y)
    GEN     RgV_add(GEN x, GEN y)
    GEN     RgV_dotproduct(GEN x, GEN y)
    GEN     RgV_dotsquare(GEN x)
    int     RgV_is_ZMV(GEN V)
    GEN     RgV_kill0(GEN v)
    GEN     RgV_neg(GEN x)
    GEN     RgV_prod(GEN v)
    GEN     RgV_sub(GEN x, GEN y)
    GEN     RgV_sum(GEN v)
    GEN     RgV_sumpart(GEN v, long n)
    GEN     RgV_sumpart2(GEN v, long m, long n)
    GEN     RgV_zc_mul(GEN x, GEN y)
    GEN     RgV_zm_mul(GEN x, GEN y)
    GEN     RgX_RgM_eval(GEN x, GEN y)
    GEN     RgX_RgMV_eval(GEN x, GEN y)
    int     isdiagonal(GEN x)
    GEN     matid(long n)
    GEN     scalarcol(GEN x, long n)
    GEN     scalarcol_shallow(GEN x, long n)
    GEN     scalarmat(GEN x, long n)
    GEN     scalarmat_shallow(GEN x, long n)
    GEN     scalarmat_s(long x, long n)

    # RgX.c

    GEN     Kronecker_to_mod(GEN z, GEN pol)
    GEN     QX_ZXQV_eval(GEN P, GEN V, GEN dV)
    GEN     QXQ_charpoly(GEN A, GEN T, long v)
    GEN     QXQ_powers(GEN a, long n, GEN T)
    GEN     QXQX_to_mod_shallow(GEN z, GEN T)
    GEN     QXQV_to_mod(GEN V, GEN T)
    GEN     QXQXV_to_mod(GEN V, GEN T)
    GEN     QXV_QXQ_eval(GEN v, GEN a, GEN T)
    GEN     QXX_QXQ_eval(GEN v, GEN a, GEN T)
    GEN     Rg_RgX_sub(GEN x, GEN y)
    GEN     Rg_to_RgC(GEN x, long N)
    GEN     RgM_to_RgXV(GEN x, long v)
    GEN     RgM_to_RgXX(GEN x, long v, long w)
    GEN     RgV_to_RgX(GEN x, long v)
    GEN     RgV_to_RgM(GEN v, long n)
    GEN     RgV_to_RgX_reverse(GEN x, long v)
    GEN     RgX_RgXQ_eval(GEN f, GEN x, GEN T)
    GEN     RgX_RgXQV_eval(GEN P, GEN V, GEN T)
    GEN     RgX_RgXn_eval(GEN Q, GEN x, long n)
    GEN     RgX_RgXnV_eval(GEN Q, GEN x, long n)
    GEN     RgX_Rg_add(GEN y, GEN x)
    GEN     RgX_Rg_add_shallow(GEN y, GEN x)
    GEN     RgX_Rg_div(GEN y, GEN x)
    GEN     RgX_Rg_divexact(GEN x, GEN y)
    GEN     RgX_Rg_eval_bk(GEN Q, GEN x)
    GEN     RgX_Rg_mul(GEN y, GEN x)
    GEN     RgX_Rg_sub(GEN y, GEN x)
    GEN     RgX_RgV_eval(GEN Q, GEN x)
    GEN     RgX_add(GEN x, GEN y)
    GEN     RgX_blocks(GEN P, long n, long m)
    GEN     RgX_deflate(GEN x0, long d)
    GEN     RgX_deriv(GEN x)
    GEN     RgX_div_by_X_x(GEN a, GEN x, GEN *r)
    GEN     RgX_divrem(GEN x, GEN y, GEN *r)
    GEN     RgX_divs(GEN y, long x)
    long    RgX_equal(GEN x, GEN y)
    void    RgX_even_odd(GEN p, GEN *pe, GEN *po)
    GEN     RgX_get_0(GEN x)
    GEN     RgX_get_1(GEN x)
    GEN     RgX_inflate(GEN x0, long d)
    GEN     RgX_mul(GEN x, GEN y)
    GEN     RgX_mul_normalized(GEN A, long a, GEN B, long b)
    GEN     RgX_mulXn(GEN x, long d)
    GEN     RgX_muls(GEN y, long x)
    GEN     RgX_mulspec(GEN a, GEN b, long na, long nb)
    GEN     RgX_neg(GEN x)
    GEN     RgX_normalize(GEN x)
    GEN     RgX_pseudodivrem(GEN x, GEN y, GEN *ptr)
    GEN     RgX_pseudorem(GEN x, GEN y)
    GEN     RgX_recip(GEN x)
    GEN     RgX_recip_shallow(GEN x)
    GEN     RgX_renormalize_lg(GEN x, long lx)
    GEN     RgX_rescale(GEN P, GEN h)
    GEN     RgX_rotate_shallow(GEN P, long k, long p)
    GEN     RgX_shift(GEN a, long n)
    GEN     RgX_shift_shallow(GEN x, long n)
    GEN     RgX_splitting(GEN p, long k)
    GEN     RgX_sqr(GEN x)
    GEN     RgX_sqrspec(GEN a, long na)
    GEN     RgX_sub(GEN x, GEN y)
    GEN     RgX_to_RgC(GEN x, long N)
    GEN     RgX_translate(GEN P, GEN c)
    GEN     RgX_unscale(GEN P, GEN h)
    GEN     RgXQ_matrix_pow(GEN y, long n, long m, GEN P)
    GEN     RgXQ_norm(GEN x, GEN T)
    GEN     RgXQ_pow(GEN x, GEN n, GEN T)
    GEN     RgXQ_powers(GEN x, long l, GEN T)
    GEN     RgXQ_powu(GEN x, ulong n, GEN T)
    GEN     RgXQC_red(GEN P, GEN T)
    GEN     RgXQV_RgXQ_mul(GEN v, GEN x, GEN T)
    GEN     RgXQV_red(GEN P, GEN T)
    GEN     RgXQX_RgXQ_mul(GEN x, GEN y, GEN T)
    GEN     RgXQX_divrem(GEN x, GEN y, GEN T, GEN *r)
    GEN     RgXQX_mul(GEN x, GEN y, GEN T)
    GEN     RgXQX_pseudodivrem(GEN x, GEN y, GEN T, GEN *ptr)
    GEN     RgXQX_pseudorem(GEN x, GEN y, GEN T)
    GEN     RgXQX_red(GEN P, GEN T)
    GEN     RgXQX_sqr(GEN x, GEN T)
    GEN     RgXQX_translate(GEN P, GEN c, GEN T)
    GEN     RgXV_RgV_eval(GEN Q, GEN x)
    GEN     RgXV_to_RgM(GEN v, long n)
    GEN     RgXV_unscale(GEN v, GEN h)
    GEN     RgXX_to_RgM(GEN v, long n)
    long    RgXY_degreex(GEN bpol)
    GEN     RgXY_swap(GEN x, long n, long w)
    GEN     RgXY_swapspec(GEN x, long n, long w, long nx)
    GEN     RgXn_eval(GEN Q, GEN x, long n)
    GEN     RgXn_exp(GEN f, long e)
    GEN     RgXn_inv(GEN f, long e)
    GEN     RgXn_mul(GEN f, GEN g, long n)
    GEN     RgXn_powers(GEN f, long m, long n)
    GEN     RgXn_red_shallow(GEN a, long n)
    GEN     RgXn_reverse(GEN f, long e)
    GEN     RgXn_sqr(GEN f, long n)
    GEN     RgXnV_red_shallow(GEN P, long n)
    GEN     RgXn_powu(GEN x, ulong m, long n)
    GEN     RgXn_powu_i(GEN x, ulong m, long n)
    GEN     ZX_translate(GEN P, GEN c)
    GEN     ZX_unscale2n(GEN P, long n)
    GEN     ZX_unscale(GEN P, GEN h)
    GEN     ZX_unscale_div(GEN P, GEN h)
    int     ZXQX_dvd(GEN x, GEN y, GEN T)
    long    brent_kung_optpow(long d, long n, long m)
    GEN     gen_bkeval(GEN Q, long d, GEN x, int use_sqr, void *E,
                       const bb_algebra *ff,
                       GEN cmul(void *E, GEN P, long a, GEN x))
    GEN     gen_bkeval_powers(GEN P, long d, GEN V, void *E,
                              const bb_algebra *ff,
                              GEN cmul(void *E, GEN P, long a, GEN x))
    const bb_algebra * get_Rg_algebra()

    # ZG.c
    void    ZGC_G_mul_inplace(GEN v, GEN x)
    void    ZGC_add_inplace(GEN x, GEN y)
    GEN     ZGC_add_sparse(GEN x, GEN y)
    void    ZGM_add_inplace(GEN x, GEN y)
    GEN     ZGM_add_sparse(GEN x, GEN y)
    GEN     G_ZGC_mul(GEN x, GEN v)
    GEN     G_ZG_mul(GEN x, GEN y)
    GEN     ZGC_G_mul(GEN v, GEN x)
    GEN     ZGC_Z_mul(GEN v, GEN x)
    GEN     ZG_G_mul(GEN x, GEN y)
    GEN     ZG_Z_mul(GEN x, GEN c)
    GEN     ZG_add(GEN x, GEN y)
    GEN     ZG_mul(GEN x, GEN y)
    GEN     ZG_neg(GEN x)
    GEN     ZG_normalize(GEN x)
    GEN     ZG_sub(GEN x, GEN y)

    # ZV.c

    void    Flc_lincomb1_inplace(GEN X, GEN Y, ulong v, ulong q)
    void    RgM_check_ZM(GEN A, const char *s)
    void    RgV_check_ZV(GEN A, const char *s)
    GEN     ZV_zc_mul(GEN x, GEN y)
    GEN     ZC_ZV_mul(GEN x, GEN y)
    GEN     ZC_Z_add(GEN x, GEN y)
    GEN     ZC_Z_divexact(GEN X, GEN c)
    GEN     ZC_Z_mul(GEN X, GEN c)
    GEN     ZC_Z_sub(GEN x, GEN y)
    GEN     ZC_add(GEN x, GEN y)
    GEN     ZC_copy(GEN x)
    GEN     ZC_hnfremdiv(GEN x, GEN y, GEN *Q)
    long    ZC_is_ei(GEN x)
    GEN     ZC_lincomb(GEN u, GEN v, GEN X, GEN Y)
    void    ZC_lincomb1_inplace(GEN X, GEN Y, GEN v)
    GEN     ZC_neg(GEN M)
    GEN     ZC_reducemodlll(GEN x, GEN y)
    GEN     ZC_reducemodmatrix(GEN v, GEN y)
    GEN     ZC_sub(GEN x, GEN y)
    GEN     ZC_z_mul(GEN X, long c)
    GEN     ZM_ZC_mul(GEN x, GEN y)
    GEN     ZM_Z_div(GEN X, GEN c)
    GEN     ZM_Z_divexact(GEN X, GEN c)
    GEN     ZM_Z_mul(GEN X, GEN c)
    GEN     ZM_add(GEN x, GEN y)
    GEN     ZM_copy(GEN x)
    GEN     ZM_det_triangular(GEN mat)
    GEN     ZM_diag_mul(GEN m, GEN d)
    int     ZM_equal(GEN A, GEN B)
    GEN     ZM_hnfdivrem(GEN x, GEN y, GEN *Q)
    int     ZM_ishnf(GEN x)
    int     ZM_isidentity(GEN x)
    int     ZM_isscalar(GEN x, GEN s)
    long    ZM_max_lg(GEN x)
    GEN     ZM_mul(GEN x, GEN y)
    GEN     ZM_mul_diag(GEN m, GEN d)
    GEN     ZM_multosym(GEN x, GEN y)
    GEN     ZM_neg(GEN x)
    GEN     ZM_nm_mul(GEN x, GEN y)
    GEN     ZM_pow(GEN x, GEN n)
    GEN     ZM_powu(GEN x, ulong n)
    GEN     ZM_reducemodlll(GEN x, GEN y)
    GEN     ZM_reducemodmatrix(GEN v, GEN y)
    GEN     ZM_sqr(GEN x)
    GEN     ZM_sub(GEN x, GEN y)
    GEN     ZM_supnorm(GEN x)
    GEN     ZM_to_Flm(GEN x, ulong p)
    GEN     ZM_to_zm(GEN z)
    GEN     ZM_transmul(GEN x, GEN y)
    GEN     ZM_transmultosym(GEN x, GEN y)
    GEN     ZMV_to_zmV(GEN z)
    void    ZM_togglesign(GEN M)
    GEN     ZM_zc_mul(GEN x, GEN y)
    GEN     ZM_zm_mul(GEN x, GEN y)
    GEN     ZMrow_ZC_mul(GEN x, GEN y, long i)
    GEN     ZV_ZM_mul(GEN x, GEN y)
    int     ZV_abscmp(GEN x, GEN y)
    int     ZV_cmp(GEN x, GEN y)
    GEN     ZV_content(GEN x)
    GEN     ZV_dotproduct(GEN x, GEN y)
    GEN     ZV_dotsquare(GEN x)
    int     ZV_equal(GEN V, GEN W)
    int     ZV_equal0(GEN V)
    long    ZV_max_lg(GEN x)
    void    ZV_neg_inplace(GEN M)
    GEN     ZV_prod(GEN v)
    GEN     ZV_sum(GEN v)
    GEN     ZV_to_Flv(GEN x, ulong p)
    GEN     ZV_to_nv(GEN z)
    void    ZV_togglesign(GEN M)
    GEN     gram_matrix(GEN M)
    GEN     nm_Z_mul(GEN X, GEN c)
    GEN     zm_mul(GEN x, GEN y)
    GEN     zm_to_Flm(GEN z, ulong p)
    GEN     zm_to_ZM(GEN z)
    GEN     zm_zc_mul(GEN x, GEN y)
    GEN     zmV_to_ZMV(GEN z)
    long    zv_content(GEN x)
    long    zv_dotproduct(GEN x, GEN y)
    int     zv_equal(GEN V, GEN W)
    int     zv_equal0(GEN V)
    GEN     zv_neg(GEN x)
    GEN     zv_neg_inplace(GEN M)
    long    zv_prod(GEN v)
    GEN     zv_prod_Z(GEN v)
    long    zv_sum(GEN v)
    GEN     zv_to_Flv(GEN z, ulong p)
    GEN     zv_z_mul(GEN v, long n)
    GEN     zv_ZM_mul(GEN x, GEN y)
    int     zvV_equal(GEN V, GEN W)

    # ZX.c

    void    RgX_check_QX(GEN x, const char *s)
    void    RgX_check_ZX(GEN x, const char *s)
    void    RgX_check_ZXX(GEN x, const char *s)
    GEN     Z_ZX_sub(GEN x, GEN y)
    GEN     ZX_Z_add(GEN y, GEN x)
    GEN     ZX_Z_add_shallow(GEN y, GEN x)
    GEN     ZX_Z_divexact(GEN y, GEN x)
    GEN     ZX_Z_mul(GEN y, GEN x)
    GEN     ZX_Z_sub(GEN y, GEN x)
    GEN     ZX_add(GEN x, GEN y)
    GEN     ZX_copy(GEN x)
    GEN     ZX_deriv(GEN x)
    GEN     ZX_div_by_X_1(GEN a, GEN *r)
    int     ZX_equal(GEN V, GEN W)
    GEN     ZX_eval1(GEN x)
    long    ZX_max_lg(GEN x)
    GEN     ZX_mod_Xnm1(GEN T, ulong n)
    GEN     ZX_mul(GEN x, GEN y)
    GEN     ZX_mulspec(GEN a, GEN b, long na, long nb)
    GEN     ZX_mulu(GEN y, ulong x)
    GEN     ZX_neg(GEN x)
    GEN     ZX_rem(GEN x, GEN y)
    GEN     ZX_remi2n(GEN y, long n)
    GEN     ZX_rescale2n(GEN P, long n)
    GEN     ZX_rescale(GEN P, GEN h)
    GEN     ZX_rescale_lt(GEN P)
    GEN     ZX_shifti(GEN x, long n)
    GEN     ZX_sqr(GEN x)
    GEN     ZX_sqrspec(GEN a, long na)
    GEN     ZX_sub(GEN x, GEN y)
    long    ZX_val(GEN x)
    long    ZX_valrem(GEN x, GEN *Z)
    GEN     ZXT_remi2n(GEN z, long n)
    GEN     ZXV_Z_mul(GEN y, GEN x)
    GEN     ZXV_dotproduct(GEN V, GEN W)
    int     ZXV_equal(GEN V, GEN W)
    GEN     ZXV_remi2n(GEN x, long n)
    GEN     ZXX_Z_divexact(GEN y, GEN x)
    GEN     ZXX_Z_mul(GEN y, GEN x)
    GEN     ZXX_Z_add_shallow(GEN x, GEN y)
    long    ZXX_max_lg(GEN x)
    GEN     ZXX_renormalize(GEN x, long lx)
    GEN     ZXX_to_Kronecker(GEN P, long n)
    GEN     ZXX_to_Kronecker_spec(GEN P, long lP, long n)
    GEN     scalar_ZX(GEN x, long v)
    GEN     scalar_ZX_shallow(GEN x, long v)
    GEN     zx_to_ZX(GEN z)

    # algebras.c

    GEN     alg_centralproj(GEN al, GEN z, int maps)
    GEN     alg_change_overorder_shallow(GEN al, GEN ord)
    GEN     alg_complete(GEN rnf, GEN aut, GEN hi, GEN hf, long maxord)
    GEN     alg_csa_table(GEN nf, GEN mt, long v, long maxord)
    GEN     alg_cyclic(GEN rnf, GEN aut, GEN b, long maxord)
    GEN     alg_decomposition(GEN al)
    long    alg_get_absdim(GEN al)
    long    algabsdim(GEN al)
    GEN     alg_get_abssplitting(GEN al)
    GEN     alg_get_aut(GEN al)
    GEN     algaut(GEN al)
    GEN     alg_get_auts(GEN al)
    GEN     alg_get_b(GEN al)
    GEN     algb(GEN al)
    GEN     algcenter(GEN al)
    GEN     alg_get_center(GEN al)
    GEN     alg_get_char(GEN al)
    GEN     algchar(GEN al)
    long    alg_get_degree(GEN al)
    long    algdegree(GEN al)
    long    alg_get_dim(GEN al)
    long    algdim(GEN al)
    GEN     alg_get_hasse_f(GEN al)
    GEN     alghassef(GEN al)
    GEN     alg_get_hasse_i(GEN al)
    GEN     alghassei(GEN al)
    GEN     alg_get_invbasis(GEN al)
    GEN     alginvbasis(GEN al)
    GEN     alg_get_multable(GEN al)
    GEN     alg_get_basis(GEN al)
    GEN     algbasis(GEN al)
    GEN     alg_get_relmultable(GEN al)
    GEN     algrelmultable(GEN al)
    GEN     alg_get_splitpol(GEN al)
    GEN     alg_get_splittingfield(GEN al)
    GEN     algsplittingfield(GEN al)
    GEN     alg_get_splittingbasis(GEN al)
    GEN     alg_get_splittingbasisinv(GEN al)
    GEN     alg_get_splittingdata(GEN al)
    GEN     algsplittingdata(GEN al)
    GEN     alg_get_tracebasis(GEN al)
    GEN     alg_hasse(GEN nf, long n, GEN hi, GEN hf, long var, long flag)
    GEN     alg_hilbert(GEN nf, GEN a, GEN b, long v, long flag)
    GEN     alg_matrix(GEN nf, long n, long v, GEN L, long flag)
    long    alg_model(GEN al, GEN x)
    GEN     alg_ordermodp(GEN al, GEN p)
    GEN     alg_quotient(GEN al, GEN I, int maps)
    GEN     algradical(GEN al)
    GEN     algsimpledec(GEN al, int maps)
    GEN     algsubalg(GEN al, GEN basis)
    long    alg_type(GEN al)
    GEN     algadd(GEN al, GEN x, GEN y)
    GEN     algalgtobasis(GEN al, GEN x)
    GEN     algbasischarpoly(GEN al, GEN x, long v)
    GEN     algbasismul(GEN al, GEN x, GEN y)
    GEN     algbasismultable(GEN al, GEN x)
    GEN     algbasismultable_Flm(GEN mt, GEN x, ulong m)
    GEN     algbasistoalg(GEN al, GEN x)
    GEN     algcharpoly(GEN al, GEN x, long v)
    GEN     algdisc(GEN al)
    GEN     algdivl(GEN al, GEN x, GEN y)
    GEN     algdivr(GEN al, GEN x, GEN y)
    GEN     alggroup(GEN gal, GEN p)
    GEN     alghasse(GEN al, GEN pl)
    GEN     alginit(GEN A, GEN B, long v, long flag)
    long    algindex(GEN al, GEN pl)
    GEN     alginv(GEN al, GEN x)
    int     algisassociative(GEN mt0, GEN p)
    int     algiscommutative(GEN al)
    int     algisdivision(GEN al, GEN pl)
    int     algisramified(GEN al, GEN pl)
    int     algissemisimple(GEN al)
    int     algissimple(GEN al, long ss)
    int     algissplit(GEN al, GEN pl)
    int     algisdivl(GEN al, GEN x, GEN y, GEN* ptz)
    int     algisinv(GEN al, GEN x, GEN* ptix)
    GEN     algleftordermodp(GEN al, GEN Ip, GEN p)
    GEN     algmul(GEN al, GEN x, GEN y)
    GEN     algmultable(GEN al)
    GEN     alglathnf(GEN al, GEN m)
    GEN     algleftmultable(GEN al, GEN x)
    GEN     algneg(GEN al, GEN x)
    GEN     algnorm(GEN al, GEN x)
    GEN     algpoleval(GEN al, GEN pol, GEN x)
    GEN     algpow(GEN al, GEN x, GEN n)
    GEN     algprimesubalg(GEN al)
    GEN     algramifiedplaces(GEN al)
    GEN     algrandom(GEN al, GEN b)
    GEN     algsplittingmatrix(GEN al, GEN x)
    GEN     algsqr(GEN al, GEN x)
    GEN     algsub(GEN al, GEN x, GEN y)
    GEN     algtableinit(GEN mt, GEN p)
    GEN     algtensor(GEN al1, GEN al2, long maxord)
    GEN     algtrace(GEN al, GEN x)
    long    algtype(GEN al)
    GEN     bnfgwgeneric(GEN bnf, GEN Lpr, GEN Ld, GEN pl, long var)
    GEN     bnrgwsearch(GEN bnr, GEN Lpr, GEN Ld, GEN pl)
    void    checkalg(GEN x)
    void    checkhasse(GEN nf, GEN hi, GEN hf, long n)
    long    cyclicrelfrob(GEN rnf, GEN auts, GEN pr)
    GEN     hassecoprime(GEN hi, GEN hf, long n)
    GEN     hassedown(GEN nf, long n, GEN hi, GEN hf)
    GEN     hassewedderburn(GEN hi, GEN hf, long n)
    long    localhasse(GEN rnf, GEN cnd, GEN pl, GEN auts, GEN b, long k)
    GEN     nfgrunwaldwang(GEN nf0, GEN Lpr, GEN Ld, GEN pl, long var)
    GEN     nfgwkummer(GEN nf, GEN Lpr, GEN Ld, GEN pl, long var)

    # alglin1.c

    GEN     F2m_F2c_gauss(GEN a, GEN b)
    GEN     F2m_F2c_invimage(GEN A, GEN y)
    GEN     F2m_deplin(GEN x)
    ulong   F2m_det(GEN x)
    ulong   F2m_det_sp(GEN x)
    GEN     F2m_gauss(GEN a, GEN b)
    GEN     F2m_image(GEN x)
    GEN     F2m_indexrank(GEN x)
    GEN     F2m_inv(GEN x)
    GEN     F2m_invimage(GEN A, GEN B)
    GEN     F2m_ker(GEN x)
    GEN     F2m_ker_sp(GEN x, long deplin)
    long    F2m_rank(GEN x)
    GEN     F2m_suppl(GEN x)
    GEN     F2xqM_F2xqC_mul(GEN a, GEN b, GEN T)
    GEN     F2xqM_det(GEN a, GEN T)
    GEN     F2xqM_ker(GEN x, GEN T)
    GEN     F2xqM_image(GEN x, GEN T)
    GEN     F2xqM_inv(GEN a, GEN T)
    GEN     F2xqM_mul(GEN a, GEN b, GEN T)
    long    F2xqM_rank(GEN x, GEN T)
    GEN     Flm_Flc_gauss(GEN a, GEN b, ulong p)
    GEN     Flm_Flc_invimage(GEN mat, GEN y, ulong p)
    GEN     Flm_deplin(GEN x, ulong p)
    ulong   Flm_det(GEN x, ulong p)
    ulong   Flm_det_sp(GEN x, ulong p)
    GEN     Flm_gauss(GEN a, GEN b, ulong p)
    GEN     Flm_image(GEN x, ulong p)
    GEN     Flm_invimage(GEN m, GEN v, ulong p)
    GEN     Flm_indexrank(GEN x, ulong p)
    GEN     Flm_intersect(GEN x, GEN y, ulong p)
    GEN     Flm_inv(GEN x, ulong p)
    GEN     Flm_ker(GEN x, ulong p)
    GEN     Flm_ker_sp(GEN x, ulong p, long deplin)
    long    Flm_rank(GEN x, ulong p)
    GEN     Flm_suppl(GEN x, ulong p)
    GEN     FlxqM_FlxqC_gauss(GEN a, GEN b, GEN T, ulong p)
    GEN     FlxqM_FlxqC_mul(GEN a, GEN b, GEN T, ulong p)
    GEN     FlxqM_det(GEN a, GEN T, ulong p)
    GEN     FlxqM_gauss(GEN a, GEN b, GEN T, ulong p)
    GEN     FlxqM_ker(GEN x, GEN T, ulong p)
    GEN     FlxqM_image(GEN x, GEN T, ulong p)
    GEN     FlxqM_inv(GEN x, GEN T, ulong p)
    GEN     FlxqM_mul(GEN a, GEN b, GEN T, ulong p)
    long    FlxqM_rank(GEN x, GEN T, ulong p)
    GEN     FpM_FpC_gauss(GEN a, GEN b, GEN p)
    GEN     FpM_FpC_invimage(GEN m, GEN v, GEN p)
    GEN     FpM_deplin(GEN x, GEN p)
    GEN     FpM_det(GEN x, GEN p)
    GEN     FpM_gauss(GEN a, GEN b, GEN p)
    GEN     FpM_image(GEN x, GEN p)
    GEN     FpM_indexrank(GEN x, GEN p)
    GEN     FpM_intersect(GEN x, GEN y, GEN p)
    GEN     FpM_inv(GEN x, GEN p)
    GEN     FpM_invimage(GEN m, GEN v, GEN p)
    GEN     FpM_ker(GEN x, GEN p)
    long    FpM_rank(GEN x, GEN p)
    GEN     FpM_suppl(GEN x, GEN p)
    GEN     FqM_FqC_gauss(GEN a, GEN b, GEN T, GEN p)
    GEN     FqM_FqC_mul(GEN a, GEN b, GEN T, GEN p)
    GEN     FqM_deplin(GEN x, GEN T, GEN p)
    GEN     FqM_det(GEN x, GEN T, GEN p)
    GEN     FqM_gauss(GEN a, GEN b, GEN T, GEN p)
    GEN     FqM_ker(GEN x, GEN T, GEN p)
    GEN     FqM_image(GEN x, GEN T, GEN p)
    GEN     FqM_inv(GEN x, GEN T, GEN p)
    GEN     FqM_mul(GEN a, GEN b, GEN T, GEN p)
    long    FqM_rank(GEN a, GEN T, GEN p)
    GEN     FqM_suppl(GEN x, GEN T, GEN p)
    GEN     QM_inv(GEN M, GEN dM)
    GEN     RgM_Fp_init(GEN a, GEN p, ulong *pp)
    GEN     RgM_RgC_invimage(GEN A, GEN B)
    GEN     RgM_diagonal(GEN m)
    GEN     RgM_diagonal_shallow(GEN m)
    GEN     RgM_Hadamard(GEN a)
    GEN     RgM_inv_upper(GEN a)
    GEN     RgM_invimage(GEN A, GEN B)
    GEN     RgM_solve(GEN a, GEN b)
    GEN     RgM_solve_realimag(GEN x, GEN y)
    void    RgMs_structelim(GEN M, long nbrow, GEN A, GEN *p_col, GEN *p_lin)
    GEN     ZM_det(GEN a)
    GEN     ZM_detmult(GEN A)
    GEN     ZM_gauss(GEN a, GEN b)
    GEN     ZM_imagecompl(GEN x)
    GEN     ZM_indeximage(GEN x)
    GEN     ZM_indexrank(GEN x)
    GEN     ZM_inv(GEN M, GEN dM)
    GEN     ZM_inv_ratlift(GEN M, GEN *pden)
    long    ZM_rank(GEN x)
    GEN     ZlM_gauss(GEN a, GEN b, ulong p, long e, GEN C)
    GEN     closemodinvertible(GEN x, GEN y)
    GEN     deplin(GEN x)
    GEN     det(GEN a)
    GEN     det0(GEN a, long flag)
    GEN     det2(GEN a)
    GEN     detint(GEN x)
    GEN     eigen(GEN x, long prec)
    GEN     gauss(GEN a, GEN b)
    GEN     gaussmodulo(GEN M, GEN D, GEN Y)
    GEN     gaussmodulo2(GEN M, GEN D, GEN Y)
    GEN     gen_Gauss(GEN a, GEN b, void *E, const bb_field *ff)
    GEN     gen_Gauss_pivot(GEN x, long *rr, void *E, const bb_field *ff)
    GEN     gen_det(GEN a, void *E, const bb_field *ff)
    GEN     gen_ker(GEN x, long deplin, void *E, const bb_field *ff)
    GEN     gen_matcolmul(GEN a, GEN b, void *E, const bb_field *ff)
    GEN     gen_matmul(GEN a, GEN b, void *E, const bb_field *ff)
    GEN     image(GEN x)
    GEN     image2(GEN x)
    GEN     imagecompl(GEN x)
    GEN     indexrank(GEN x)
    GEN     inverseimage(GEN mat, GEN y)
    GEN     ker(GEN x)
    GEN     keri(GEN x)
    GEN     mateigen(GEN x, long flag, long prec)
    GEN     matimage0(GEN x, long flag)
    GEN     matker0(GEN x, long flag)
    GEN     matsolvemod0(GEN M, GEN D, GEN Y, long flag)
    long    rank(GEN x)
    GEN     reducemodinvertible(GEN x, GEN y)
    GEN     reducemodlll(GEN x, GEN y)
    GEN     split_realimag(GEN x, long r1, long r2)
    GEN     suppl(GEN x)

    # alglin2.c

    GEN     Flm_charpoly(GEN x, ulong p)
    GEN     Flm_hess(GEN x, ulong p)
    GEN     FpM_charpoly(GEN x, GEN p)
    GEN     FpM_hess(GEN x, GEN p)
    GEN     Frobeniusform(GEN V, long n)
    GEN     QM_minors_coprime(GEN x, GEN pp)
    GEN     QM_ImZ_hnf(GEN x)
    GEN     QM_ImQ_hnf(GEN x)
    GEN     QM_charpoly_ZX(GEN M)
    GEN     QM_charpoly_ZX_bound(GEN M, long bit)
    GEN     QM_charpoly_ZX2_bound(GEN M, GEN M2, long bit)
    GEN     ZM_charpoly(GEN x)
    GEN     adj(GEN x)
    GEN     adjsafe(GEN x)
    GEN     caract(GEN x, long v)
    GEN     caradj(GEN x, long v, GEN *py)
    GEN     carberkowitz(GEN x, long v)
    GEN     carhess(GEN x, long v)
    GEN     charpoly(GEN x, long v)
    GEN     charpoly0(GEN x, long v, long flag)
    GEN     gnorm(GEN x)
    GEN     gnorml1(GEN x, long prec)
    GEN     gnorml1_fake(GEN x)
    GEN     gnormlp(GEN x, GEN p, long prec)
    GEN     gnorml2(GEN x)
    GEN     gsupnorm(GEN x, long prec)
    void    gsupnorm_aux(GEN x, GEN *m, GEN *msq, long prec)
    GEN     gtrace(GEN x)
    GEN     hess(GEN x)
    GEN     intersect(GEN x, GEN y)
    GEN     jacobi(GEN a, long prec)
    GEN     matadjoint0(GEN x, long flag)
    GEN     matcompanion(GEN x)
    GEN     matrixqz0(GEN x, GEN pp)
    GEN     minpoly(GEN x, long v)
    GEN     qfgaussred(GEN a)
    GEN     qfgaussred_positive(GEN a)
    GEN     qfsign(GEN a)

    # alglin3.c

    GEN     apply0(GEN f, GEN A)
    GEN     diagonal(GEN x)
    GEN     diagonal_shallow(GEN x)
    GEN     extract0(GEN x, GEN l1, GEN l2)
    GEN     fold0(GEN f, GEN A)
    GEN     genapply(void *E, GEN (*f)(void *E, GEN x), GEN A)
    GEN     genfold(void *E, GEN (*f)(void *E, GEN x, GEN y), GEN A)
    GEN     genindexselect(void *E, long (*f)(void *E, GEN x), GEN A)
    GEN     genselect(void *E, long (*f)(void *E, GEN x), GEN A)
    GEN     gtomat(GEN x)
    GEN     gtrans(GEN x)
    GEN     matmuldiagonal(GEN x, GEN d)
    GEN     matmultodiagonal(GEN x, GEN y)
    GEN     matslice0(GEN A, long x1, long x2, long y1, long y2)
    GEN     parapply(GEN V, GEN C)
    void    parfor(GEN a, GEN b, GEN code, void *E, long call(void*, GEN, GEN))
    void    parforprime(GEN a, GEN b, GEN code, void *E, long call(void*, GEN, GEN))
    void    parforvec(GEN x, GEN code, long flag, void *E, long call(void*, GEN, GEN))
    GEN     parselect(GEN C, GEN D, long flag)
    GEN     select0(GEN A, GEN f, long flag)
    GEN     shallowextract(GEN x, GEN L)
    GEN     shallowtrans(GEN x)
    GEN     vecapply(void *E, GEN (*f)(void* E, GEN x), GEN x)
    GEN     veccatapply(void *E, GEN (*f)(void* E, GEN x), GEN x)
    GEN     veccatselapply(void *Epred, long (*pred)(void* E, GEN x), void *Efun,
                           GEN (*fun)(void* E, GEN x), GEN A)
    GEN     vecrange(GEN a, GEN b)
    GEN     vecrangess(long a, long b)
    GEN     vecselapply(void *Epred, long (*pred)(void* E, GEN x), void *Efun,
                        GEN (*fun)(void* E, GEN x), GEN A)
    GEN     vecselect(void *E, long (*f)(void* E, GEN x), GEN A)
    GEN     vecslice0(GEN A, long y1, long y2)
    GEN     vecsum(GEN v)

    # anal.c

    void    addhelp(const char *e, char *s)
    void    alias0(const char *s, const char *old)
    GEN     compile_str(const char *s)
    GEN     chartoGENstr(char c)
    long    delete_var()
    long    fetch_user_var(const char *s)
    long    fetch_var()
    long    fetch_var_higher()
    GEN     fetch_var_value(long vx, GEN t)
    char *  gp_embedded(const char *s)
    void    gp_embedded_init(long rsize, long vsize)
    GEN     gp_read_str(const char *t)
    entree* install(void *f, const char *name, const char *code)
    entree* is_entry(const char *s)
    void    kill0(const char *e)
    void    pari_var_close()
    void    pari_var_init()
    long    pari_var_next()
    long    pari_var_next_temp()
    long    pari_var_create(entree *ep)
    void    name_var(long n, const char *s)
    GEN     readseq(char *t)
    GEN*    safegel(GEN x, long l)
    long*   safeel(GEN x, long l)
    GEN*    safelistel(GEN x, long l)
    GEN*    safegcoeff(GEN x, long a, long b)
    GEN     strntoGENstr(const char *s, long n0)
    GEN     strtoGENstr(const char *s)
    GEN     strtoi(const char *s)
    GEN     strtor(const char *s, long prec)
    GEN     type0(GEN x)
    GEN     varhigher(const char *s, long v)
    GEN     varlower(const char *s, long v)

    # aprcl.c

    long    isprimeAPRCL(GEN N)

    # Qfb.c

    GEN     Qfb0(GEN x, GEN y, GEN z, GEN d, long prec)
    void    check_quaddisc(GEN x, long *s, long *r, const char *f)
    void    check_quaddisc_imag(GEN x, long *r, const char *f)
    void    check_quaddisc_real(GEN x, long *r, const char *f)
    long    cornacchia(GEN d, GEN p, GEN *px, GEN *py)
    long    cornacchia2(GEN d, GEN p, GEN *px, GEN *py)
    GEN     nucomp(GEN x, GEN y, GEN L)
    GEN     nudupl(GEN x, GEN L)
    GEN     nupow(GEN x, GEN n, GEN L)
    GEN     primeform(GEN x, GEN p, long prec)
    GEN     primeform_u(GEN x, ulong p)
    int     qfb_equal1(GEN f)
    GEN     qfbcompraw(GEN x, GEN y)
    GEN     qfbpowraw(GEN x, long n)
    GEN     qfbred0(GEN x, long flag, GEN D, GEN isqrtD, GEN sqrtD)
    GEN     qfbredsl2(GEN q, GEN S)
    GEN     qfbsolve(GEN Q, GEN n)
    GEN     qfi(GEN x, GEN y, GEN z)
    GEN     qfi_1(GEN x)
    GEN     qfi_Shanks(GEN a, GEN g, long n)
    GEN     qfi_log(GEN a, GEN g, GEN o)
    GEN     qfi_order(GEN q, GEN o)
    GEN     qficomp(GEN x, GEN y)
    GEN     qficompraw(GEN x, GEN y)
    GEN     qfipowraw(GEN x, long n)
    GEN     qfisolvep(GEN Q, GEN p)
    GEN     qfisqr(GEN x)
    GEN     qfisqrraw(GEN x)
    GEN     qfr(GEN x, GEN y, GEN z, GEN d)
    GEN     qfr3_comp(GEN x, GEN y, qfr_data *S)
    GEN     qfr3_pow(GEN x, GEN n, qfr_data *S)
    GEN     qfr3_red(GEN x, qfr_data *S)
    GEN     qfr3_rho(GEN x, qfr_data *S)
    GEN     qfr3_to_qfr(GEN x, GEN z)
    GEN     qfr5_comp(GEN x, GEN y, qfr_data *S)
    GEN     qfr5_dist(GEN e, GEN d, long prec)
    GEN     qfr5_pow(GEN x, GEN n, qfr_data *S)
    GEN     qfr5_red(GEN x, qfr_data *S)
    GEN     qfr5_rho(GEN x, qfr_data *S)
    GEN     qfr5_to_qfr(GEN x, GEN d0)
    GEN     qfr_1(GEN x)
    void    qfr_data_init(GEN D, long prec, qfr_data *S)
    GEN     qfr_to_qfr5(GEN x, long prec)
    GEN     qfrcomp(GEN x, GEN y)
    GEN     qfrcompraw(GEN x, GEN y)
    GEN     qfrpow(GEN x, GEN n)
    GEN     qfrpowraw(GEN x, long n)
    GEN     qfrsolvep(GEN Q, GEN p)
    GEN     qfrsqr(GEN x)
    GEN     qfrsqrraw(GEN x)
    GEN     quadgen(GEN x)
    GEN     quadpoly(GEN x)
    GEN     quadpoly0(GEN x, long v)
    GEN     redimag(GEN x)
    GEN     redreal(GEN x)
    GEN     redrealnod(GEN x, GEN isqrtD)
    GEN     rhoreal(GEN x)
    GEN     rhorealnod(GEN x, GEN isqrtD)

    # arith1.c

    ulong   Fl_order(ulong a, ulong o, ulong p)
    GEN     Fl_powers(ulong x, long n, ulong p)
    GEN     Fl_powers_pre(ulong x, long n, ulong p, ulong pi)
    ulong   Fl_powu(ulong x, ulong n, ulong p)
    ulong   Fl_powu_pre(ulong x, ulong n, ulong p, ulong pi)
    ulong   Fl_sqrt(ulong a, ulong p)
    ulong   Fl_sqrt_pre(ulong a, ulong p, ulong pi)
    ulong   Fl_sqrtl(ulong a, ulong l, ulong p)
    ulong   Fl_sqrtl_pre(ulong a, ulong l, ulong p, ulong pi)
    GEN     Fp_factored_order(GEN a, GEN o, GEN p)
    int     Fp_ispower(GEN x, GEN K, GEN p)
    GEN     Fp_log(GEN a, GEN g, GEN ord, GEN p)
    GEN     Fp_order(GEN a, GEN o, GEN p)
    GEN     Fp_pow(GEN a, GEN n, GEN m)
    GEN     Fp_powers(GEN x, long n, GEN p)
    GEN     Fp_pows(GEN A, long k, GEN N)
    GEN     Fp_powu(GEN x, ulong k, GEN p)
    GEN     Fp_sqrt(GEN a, GEN p)
    GEN     Fp_sqrtn(GEN a, GEN n, GEN p, GEN *zetan)
    GEN     Z_ZV_mod(GEN P, GEN xa)
    GEN     Z_chinese(GEN a, GEN b, GEN A, GEN B)
    GEN     Z_chinese_all(GEN a, GEN b, GEN A, GEN B, GEN *pC)
    GEN     Z_chinese_coprime(GEN a, GEN b, GEN A, GEN B, GEN C)
    GEN     Z_chinese_post(GEN a, GEN b, GEN C, GEN U, GEN d)
    void    Z_chinese_pre(GEN A, GEN B, GEN *pC, GEN *pU, GEN *pd)
    GEN     Z_factor_listP(GEN N, GEN L)
    long    Z_isanypower(GEN x, GEN *y)
    long    Z_isfundamental(GEN x)
    long    Z_ispow2(GEN x)
    long    Z_ispowerall(GEN x, ulong k, GEN *pt)
    long    Z_issquareall(GEN x, GEN *pt)
    GEN     Z_nv_mod(GEN P, GEN xa)
    GEN     ZV_allpnqn(GEN x)
    GEN     ZV_chinese(GEN A, GEN P, GEN *pt_mod)
    GEN     ZV_chinese_tree(GEN A, GEN P, GEN tree, GEN *pt_mod)
    GEN     ZV_producttree(GEN xa)
    GEN     ZX_nv_mod_tree(GEN P, GEN xa, GEN T)
    GEN     Zideallog(GEN bid, GEN x)
    long    Zp_issquare(GEN a, GEN p)
    GEN     bestappr(GEN x, GEN k)
    GEN     bestapprPade(GEN x, long B)
    long    cgcd(long a, long b)
    GEN     chinese(GEN x, GEN y)
    GEN     chinese1(GEN x)
    GEN     chinese1_coprime_Z(GEN x)
    GEN     classno(GEN x)
    GEN     classno2(GEN x)
    long    clcm(long a, long b)
    GEN     contfrac0(GEN x, GEN b, long flag)
    GEN     contfracpnqn(GEN x, long n)
    GEN     fibo(long n)
    GEN     gboundcf(GEN x, long k)
    GEN     gcf(GEN x)
    GEN     gcf2(GEN b, GEN x)
    const bb_field *get_Fp_field(void **E, GEN p)
    ulong   pgener_Fl(ulong p)
    ulong   pgener_Fl_local(ulong p, GEN L)
    GEN     pgener_Fp(GEN p)
    GEN     pgener_Fp_local(GEN p, GEN L)
    ulong   pgener_Zl(ulong p)
    GEN     pgener_Zp(GEN p)
    long    gisanypower(GEN x, GEN *pty)
    GEN     gissquare(GEN x)
    GEN     gissquareall(GEN x, GEN *pt)
    GEN     hclassno(GEN x)
    long    hilbert(GEN x, GEN y, GEN p)
    long    hilbertii(GEN x, GEN y, GEN p)
    long    isfundamental(GEN x)
    long    ispolygonal(GEN x, GEN S, GEN *N)
    long    ispower(GEN x, GEN k, GEN *pty)
    long    isprimepower(GEN x, GEN *pty)
    long    ispseudoprimepower(GEN n, GEN *pt)
    long    issquare(GEN x)
    long    issquareall(GEN x, GEN *pt)
    long    krois(GEN x, long y)
    long    kroiu(GEN x, ulong y)
    long    kronecker(GEN x, GEN y)
    long    krosi(long s, GEN x)
    long    kross(long x, long y)
    long    kroui(ulong x, GEN y)
    long    krouu(ulong x, ulong y)
    GEN     lcmii(GEN a, GEN b)
    long    logint0(GEN B, GEN y, GEN *ptq)
    GEN     mpfact(long n)
    GEN     muls_interval(long a, long b)
    GEN     mulu_interval(ulong a, ulong b)
    GEN     ncV_chinese_center(GEN A, GEN P, GEN *pt_mod)
    GEN     nmV_chinese_center(GEN A, GEN P, GEN *pt_mod)
    GEN     odd_prime_divisors(GEN q)
    GEN     order(GEN x)
    GEN     pnqn(GEN x)
    GEN     qfbclassno0(GEN x, long flag)
    GEN     quaddisc(GEN x)
    GEN     quadregulator(GEN x, long prec)
    GEN     quadunit(GEN x)
    ulong   rootsof1_Fl(ulong n, ulong p)
    GEN     rootsof1_Fp(GEN n, GEN p)
    GEN     rootsof1u_Fp(ulong n, GEN p)
    long    sisfundamental(long x)
    GEN     sqrtint(GEN a)
    GEN     ramanujantau(GEN n)
    ulong   ugcd(ulong a, ulong b)
    long    uisprimepower(ulong n, ulong *p)
    long    uissquare(ulong A)
    long    uissquareall(ulong A, ulong *sqrtA)
    long    unegisfundamental(ulong x)
    long    uposisfundamental(ulong x)
    GEN     znlog(GEN x, GEN g, GEN o)
    GEN     znorder(GEN x, GEN o)
    GEN     znprimroot(GEN m)
    GEN     znstar(GEN x)
    GEN     znstar0(GEN N, long flag)

    # arith2.c

    GEN     Z_smoothen(GEN N, GEN L, GEN *pP, GEN *pe)
    GEN     boundfact(GEN n, ulong lim)
    GEN     check_arith_pos(GEN n, const char *f)
    GEN     check_arith_non0(GEN n, const char *f)
    GEN     check_arith_all(GEN n, const char *f)
    GEN     clean_Z_factor(GEN f)
    GEN     corepartial(GEN n, long l)
    GEN     core0(GEN n, long flag)
    GEN     core2(GEN n)
    GEN     core2partial(GEN n, long l)
    GEN     coredisc(GEN n)
    GEN     coredisc0(GEN n, long flag)
    GEN     coredisc2(GEN n)
    long    corediscs(long D, ulong *f)
    GEN     digits(GEN N, GEN B)
    GEN     divisors(GEN n)
    GEN     divisorsu(ulong n)
    GEN     divisorsu_fact(GEN P, GEN e)
    GEN     factor_pn_1(GEN p, ulong n)
    GEN     factor_pn_1_limit(GEN p, long n, ulong lim)
    GEN     factoru_pow(ulong n)
    GEN     fromdigits(GEN x, GEN B)
    GEN     fuse_Z_factor(GEN f, GEN B)
    GEN     gen_digits(GEN x, GEN B, long n, void *E, bb_ring *r,
                       GEN (*div)(void *E, GEN x, GEN y, GEN *r))
    GEN     gen_fromdigits(GEN x, GEN B, void *E, bb_ring *r)
    byteptr initprimes(ulong maxnum, long *lenp, ulong *lastp)
    void    initprimetable(ulong maxnum)
    ulong   init_primepointer_geq(ulong a, byteptr *pd)
    ulong   init_primepointer_gt(ulong a, byteptr *pd)
    ulong   init_primepointer_leq(ulong a, byteptr *pd)
    ulong   init_primepointer_lt(ulong a, byteptr *pd)
    int     is_Z_factor(GEN f)
    int     is_Z_factornon0(GEN f)
    int     is_Z_factorpos(GEN f)
    ulong   maxprime()
    void    maxprime_check(ulong c)
    GEN     sumdigits(GEN n)
    GEN     sumdigits0(GEN n, GEN B)
    ulong   sumdigitsu(ulong n)
    GEN     usumdiv_fact(GEN f)
    GEN     usumdivk_fact(GEN f, ulong k)

    # base1.c

    GEN     FpX_FpC_nfpoleval(GEN nf, GEN pol, GEN a, GEN p)
    GEN     embed_T2(GEN x, long r1)
    GEN     embednorm_T2(GEN x, long r1)
    GEN     embed_norm(GEN x, long r1)
    void    check_ZKmodule(GEN x, const char *s)
    void    checkbid(GEN bid)
    GEN     checkbnf(GEN bnf)
    void    checkbnr(GEN bnr)
    void    checkbnrgen(GEN bnr)
    void    checkabgrp(GEN v)
    void    checksqmat(GEN x, long N)
    GEN     checknf(GEN nf)
    GEN     checknfelt_mod(GEN nf, GEN x, const char *s)
    void    checkprid(GEN bid)
    void    checkrnf(GEN rnf)
    GEN     factoredpolred(GEN x, GEN fa)
    GEN     factoredpolred2(GEN x, GEN fa)
    GEN     galoisapply(GEN nf, GEN aut, GEN x)
    GEN     get_bnf(GEN x, long *t)
    GEN     get_bnfpol(GEN x, GEN *bnf, GEN *nf)
    GEN     get_nf(GEN x, long *t)
    GEN     get_nfpol(GEN x, GEN *nf)
    GEN     get_prid(GEN x)
    GEN     idealfrobenius(GEN nf, GEN gal, GEN pr)
    GEN     idealfrobenius_aut(GEN nf, GEN gal, GEN pr, GEN aut)
    GEN     idealramfrobenius(GEN nf, GEN gal, GEN pr, GEN ram)
    GEN     idealramgroups(GEN nf, GEN gal, GEN pr)
    GEN     nf_get_allroots(GEN nf)
    long    nf_get_prec(GEN x)
    GEN     nfcertify(GEN x)
    GEN     nfgaloismatrix(GEN nf, GEN s)
    GEN     nfgaloispermtobasis(GEN nf, GEN gal)
    void    nfinit_step1(nfbasic_t *T, GEN x, long flag)
    GEN     nfinit_step2(nfbasic_t *T, long flag, long prec)
    GEN     nfinit(GEN x, long prec)
    GEN     nfinit0(GEN x, long flag, long prec)
    GEN     nfinitall(GEN x, long flag, long prec)
    GEN     nfinitred(GEN x, long prec)
    GEN     nfinitred2(GEN x, long prec)
    GEN     nfisincl(GEN a, GEN b)
    GEN     nfisisom(GEN a, GEN b)
    GEN     nfnewprec(GEN nf, long prec)
    GEN     nfnewprec_shallow(GEN nf, long prec)
    GEN     nfpoleval(GEN nf, GEN pol, GEN a)
    long    nftyp(GEN x)
    GEN     polredord(GEN x)
    GEN     polgalois(GEN x, long prec)
    GEN     polred(GEN x)
    GEN     polred0(GEN x, long flag, GEN fa)
    GEN     polred2(GEN x)
    GEN     polredabs(GEN x)
    GEN     polredabs0(GEN x, long flag)
    GEN     polredabs2(GEN x)
    GEN     polredabsall(GEN x, long flun)
    GEN     polredbest(GEN x, long flag)
    GEN     rnfpolredabs(GEN nf, GEN pol, long flag)
    GEN     rnfpolredbest(GEN nf, GEN relpol, long flag)
    GEN     smallpolred(GEN x)
    GEN     smallpolred2(GEN x)
    GEN     tschirnhaus(GEN x)
    GEN     ZX_Q_normalize(GEN pol, GEN *ptlc)
    GEN     ZX_Z_normalize(GEN pol, GEN *ptk)
    GEN     ZX_to_monic(GEN pol, GEN *lead)
    GEN     ZX_primitive_to_monic(GEN pol, GEN *lead)

    # base2.c

    GEN     Fq_to_nf(GEN x, GEN modpr)
    GEN     FqM_to_nfM(GEN z, GEN modpr)
    GEN     FqV_to_nfV(GEN z, GEN modpr)
    GEN     FqX_to_nfX(GEN x, GEN modpr)
    GEN     Rg_nffix(const char *f, GEN T, GEN c, int lift)
    GEN     RgV_nffix(const char *f, GEN T, GEN P, int lift)
    GEN     RgX_nffix(const char *s, GEN nf, GEN x, int lift)
    long    ZpX_disc_val(GEN f, GEN p)
    GEN     ZpX_gcd(GEN f1, GEN f2, GEN p, GEN pm)
    GEN     ZpX_reduced_resultant(GEN x, GEN y, GEN p, GEN pm)
    GEN     ZpX_reduced_resultant_fast(GEN f, GEN g, GEN p, long M)
    long    ZpX_resultant_val(GEN f, GEN g, GEN p, long M)
    void    checkmodpr(GEN modpr)
    GEN     ZX_compositum_disjoint(GEN A, GEN B)
    GEN     compositum(GEN P, GEN Q)
    GEN     compositum2(GEN P, GEN Q)
    GEN     nfdisc(GEN x)
    GEN     get_modpr(GEN x)
    GEN     indexpartial(GEN P, GEN DP)
    GEN     modpr_genFq(GEN modpr)
    GEN     nf_to_Fq_init(GEN nf, GEN *pr, GEN *T, GEN *p)
    GEN     nf_to_Fq(GEN nf, GEN x, GEN modpr)
    GEN     nfM_to_FqM(GEN z, GEN nf, GEN modpr)
    GEN     nfV_to_FqV(GEN z, GEN nf, GEN modpr)
    GEN     nfX_to_FqX(GEN x, GEN nf, GEN modpr)
    GEN     nfbasis(GEN x, GEN *y, GEN p)   # PARI <= (2,12,0)
    GEN     nfcompositum(GEN nf, GEN A, GEN B, long flag)
    void    nfmaxord(nfmaxord_t *S, GEN T, long flag)
    GEN     nfmodprinit(GEN nf, GEN pr)
    GEN     nfreducemodpr(GEN nf, GEN x, GEN modpr)
    GEN     nfsplitting(GEN T, GEN D)
    GEN     polcompositum0(GEN P, GEN Q, long flag)
    GEN     idealprimedec(GEN nf, GEN p)
    GEN     idealprimedec_limit_f(GEN nf, GEN p, long f)
    GEN     idealprimedec_limit_norm(GEN nf, GEN p, GEN B)
    GEN     rnfbasis(GEN bnf, GEN order)
    GEN     rnfdedekind(GEN nf, GEN T, GEN pr, long flag)
    GEN     rnfdet(GEN nf, GEN order)
    GEN     rnfdiscf(GEN nf, GEN pol)
    GEN     rnfequation(GEN nf, GEN pol)
    GEN     rnfequation0(GEN nf, GEN pol, long flall)
    GEN     rnfequation2(GEN nf, GEN pol)
    GEN     nf_rnfeq(GEN nf, GEN relpol)
    GEN     nf_rnfeqsimple(GEN nf, GEN relpol)
    GEN     rnfequationall(GEN A, GEN B, long *pk, GEN *pLPRS)
    GEN     rnfhnfbasis(GEN bnf, GEN order)
    long    rnfisfree(GEN bnf, GEN order)
    GEN     rnflllgram(GEN nf, GEN pol, GEN order, long prec)
    GEN     rnfpolred(GEN nf, GEN pol, long prec)
    GEN     rnfpseudobasis(GEN nf, GEN pol)
    GEN     rnfsimplifybasis(GEN bnf, GEN order)
    GEN     rnfsteinitz(GEN nf, GEN order)
    long    factorial_lval(ulong n, ulong p)
    GEN     zk_to_Fq_init(GEN nf, GEN *pr, GEN *T, GEN *p)
    GEN     zk_to_Fq(GEN x, GEN modpr)
    GEN     zkmodprinit(GEN nf, GEN pr)

    # base3.c

    GEN     Idealstar(GEN nf, GEN x, long flun)
    GEN     RgC_to_nfC(GEN nf, GEN x)
    GEN     RgM_to_nfM(GEN nf, GEN x)
    GEN     RgX_to_nfX(GEN nf, GEN pol)
    GEN     algtobasis(GEN nf, GEN x)
    GEN     basistoalg(GEN nf, GEN x)
    GEN     gpnfvalrem(GEN nf, GEN x, GEN pr, GEN *py)
    GEN     ideallist(GEN nf, long bound)
    GEN     ideallist0(GEN nf, long bound, long flag)
    GEN     ideallistarch(GEN nf, GEN list, GEN arch)
    GEN     idealprincipalunits(GEN nf, GEN pr, long e)
    GEN     idealstar0(GEN nf, GEN x, long flag)
    GEN     indices_to_vec01(GEN archp, long r)
    GEN     matalgtobasis(GEN nf, GEN x)
    GEN     matbasistoalg(GEN nf, GEN x)
    GEN     nf_to_scalar_or_alg(GEN nf, GEN x)
    GEN     nf_to_scalar_or_basis(GEN nf, GEN x)
    GEN     nfadd(GEN nf, GEN x, GEN y)
    GEN     nfarchstar(GEN nf, GEN x, GEN arch)
    GEN     nfdiv(GEN nf, GEN x, GEN y)
    GEN     nfdiveuc(GEN nf, GEN a, GEN b)
    GEN     nfdivrem(GEN nf, GEN a, GEN b)
    GEN     nfembed(GEN nf, GEN x, long k)
    GEN     nfinv(GEN nf, GEN x)
    GEN     nfinvmodideal(GEN nf, GEN x, GEN ideal)
    int     nfchecksigns(GEN nf, GEN x, GEN pl)
    GEN     nfmod(GEN nf, GEN a, GEN b)
    GEN     nfmul(GEN nf, GEN x, GEN y)
    GEN     nfmuli(GEN nf, GEN x, GEN y)
    GEN     nfnorm(GEN nf, GEN x)
    GEN     nfpow(GEN nf, GEN x, GEN k)
    GEN     nfpow_u(GEN nf, GEN z, ulong n)
    GEN     nfpowmodideal(GEN nf, GEN x, GEN k, GEN ideal)
    GEN     nfsign(GEN nf, GEN alpha)
    GEN     nfsign_arch(GEN nf, GEN alpha, GEN arch)
    GEN     nfsign_from_logarch(GEN Larch, GEN invpi, GEN archp)
    GEN     nfsqr(GEN nf, GEN x)
    GEN     nfsqri(GEN nf, GEN x)
    GEN     nftrace(GEN nf, GEN x)
    long    nfval(GEN nf, GEN x, GEN vp)
    long    nfvalrem(GEN nf, GEN x, GEN pr, GEN *py)
    GEN     polmod_nffix(const char *f, GEN rnf, GEN x, int lift)
    GEN     polmod_nffix2(const char *f, GEN T, GEN relpol, GEN x, int lift)
    int     pr_equal(GEN nf, GEN P, GEN Q)
    GEN     rnfalgtobasis(GEN rnf, GEN x)
    GEN     rnfbasistoalg(GEN rnf, GEN x)
    GEN     rnfeltnorm(GEN rnf, GEN x)
    GEN     rnfelttrace(GEN rnf, GEN x)
    GEN     set_sign_mod_divisor(GEN nf, GEN x, GEN y, GEN idele, GEN sarch)
    GEN     vec01_to_indices(GEN arch)
    GEN     vecsmall01_to_indices(GEN v)
    GEN     vecmodii(GEN a, GEN b)
    GEN     ideallog(GEN nf, GEN x, GEN bigideal)

    GEN     multable(GEN nf, GEN x)
    GEN     tablemul(GEN TAB, GEN x, GEN y)
    GEN     tablemul_ei(GEN M, GEN x, long i)
    GEN     tablemul_ei_ej(GEN M, long i, long j)
    GEN     tablemulvec(GEN M, GEN x, GEN v)
    GEN     tablesqr(GEN tab, GEN x)
    GEN     ei_multable(GEN nf, long i)
    long    ZC_nfval(GEN nf, GEN x, GEN P)
    long    ZC_nfvalrem(GEN nf, GEN x, GEN P, GEN *t)
    GEN     zk_multable(GEN nf, GEN x)
    GEN     zk_scalar_or_multable(GEN, GEN x)
    int     ZC_prdvd(GEN nf, GEN x, GEN P)

    # base4.c

    GEN     RM_round_maxrank(GEN G)
    GEN     ZM_famat_limit(GEN fa, GEN limit)
    GEN     famat_Z_gcd(GEN M, GEN n)
    GEN     famat_inv(GEN f)
    GEN     famat_inv_shallow(GEN f)
    GEN     famat_makecoprime(GEN nf, GEN g, GEN e, GEN pr, GEN prk, GEN EX)
    GEN     famat_mul(GEN f, GEN g)
    GEN     famat_pow(GEN f, GEN n)
    GEN     famat_sqr(GEN f)
    GEN     famat_reduce(GEN fa)
    GEN     famat_to_nf(GEN nf, GEN f)
    GEN     famat_to_nf_modideal_coprime(GEN nf, GEN g, GEN e, GEN id, GEN EX)
    GEN     famat_to_nf_moddivisor(GEN nf, GEN g, GEN e, GEN bid)
    GEN     famatsmall_reduce(GEN fa)
    GEN     gpidealval(GEN nf, GEN ix, GEN P)
    GEN     idealtwoelt(GEN nf, GEN ix)
    GEN     idealtwoelt0(GEN nf, GEN ix, GEN a)
    GEN     idealtwoelt2(GEN nf, GEN x, GEN a)
    GEN     idealadd(GEN nf, GEN x, GEN y)
    GEN     idealaddmultoone(GEN nf, GEN list)
    GEN     idealaddtoone(GEN nf, GEN x, GEN y)
    GEN     idealaddtoone_i(GEN nf, GEN x, GEN y)
    GEN     idealaddtoone0(GEN nf, GEN x, GEN y)
    GEN     idealappr(GEN nf, GEN x)
    GEN     idealappr0(GEN nf, GEN x, long fl)
    GEN     idealapprfact(GEN nf, GEN x)
    GEN     idealchinese(GEN nf, GEN x, GEN y)
    GEN     idealcoprime(GEN nf, GEN x, GEN y)
    GEN     idealcoprimefact(GEN nf, GEN x, GEN fy)
    GEN     idealdiv(GEN nf, GEN x, GEN y)
    GEN     idealdiv0(GEN nf, GEN x, GEN y, long flag)
    GEN     idealdivexact(GEN nf, GEN x, GEN y)
    GEN     idealdivpowprime(GEN nf, GEN x, GEN vp, GEN n)
    GEN     idealmulpowprime(GEN nf, GEN x, GEN vp, GEN n)
    GEN     idealfactor(GEN nf, GEN x)
    GEN     idealhnf(GEN nf, GEN x)
    GEN     idealhnf_principal(GEN nf, GEN x)
    GEN     idealhnf_shallow(GEN nf, GEN x)
    GEN     idealhnf_two(GEN nf, GEN vp)
    GEN     idealhnf0(GEN nf, GEN a, GEN b)
    GEN     idealintersect(GEN nf, GEN x, GEN y)
    GEN     idealinv(GEN nf, GEN ix)
    GEN     idealinv_HNF(GEN nf, GEN I)
    GEN     idealred0(GEN nf, GEN I, GEN vdir)
    GEN     idealmul(GEN nf, GEN ix, GEN iy)
    GEN     idealmul0(GEN nf, GEN ix, GEN iy, long flag)
    GEN     idealmul_HNF(GEN nf, GEN ix, GEN iy)
    GEN     idealmulred(GEN nf, GEN ix, GEN iy)
    GEN     idealnorm(GEN nf, GEN x)
    GEN     idealnumden(GEN nf, GEN x)
    GEN     idealpow(GEN nf, GEN ix, GEN n)
    GEN     idealpow0(GEN nf, GEN ix, GEN n, long flag)
    GEN     idealpowred(GEN nf, GEN ix, GEN n)
    GEN     idealpows(GEN nf, GEN ideal, long iexp)
    GEN     idealprodprime(GEN nf, GEN L)
    GEN     idealsqr(GEN nf, GEN x)
    long    idealtyp(GEN *ideal, GEN *arch)
    long    idealval(GEN nf, GEN ix, GEN vp)
    long    isideal(GEN nf, GEN x)
    GEN     idealmin(GEN nf, GEN ix, GEN vdir)
    GEN     nf_get_Gtwist(GEN nf, GEN vdir)
    GEN     nf_get_Gtwist1(GEN nf, long i)
    GEN     nfC_nf_mul(GEN nf, GEN v, GEN x)
    GEN     nfdetint(GEN nf, GEN pseudo)
    GEN     nfdivmodpr(GEN nf, GEN x, GEN y, GEN modpr)
    GEN     nfhnf(GEN nf, GEN x)
    GEN     nfhnf0(GEN nf, GEN x, long flag)
    GEN     nfhnfmod(GEN nf, GEN x, GEN d)
    GEN     nfkermodpr(GEN nf, GEN x, GEN modpr)
    GEN     nfmulmodpr(GEN nf, GEN x, GEN y, GEN modpr)
    GEN     nfpowmodpr(GEN nf, GEN x, GEN k, GEN modpr)
    GEN     nfreduce(GEN nf, GEN x, GEN ideal)
    GEN     nfsnf(GEN nf, GEN x)
    GEN     nfsnf0(GEN nf, GEN x, long flag)
    GEN     nfsolvemodpr(GEN nf, GEN a, GEN b, GEN modpr)
    GEN     to_famat(GEN x, GEN y)
    GEN     to_famat_shallow(GEN x, GEN y)
    GEN     vecdiv(GEN x, GEN y)
    GEN     vecinv(GEN x)
    GEN     vecmul(GEN x, GEN y)
    GEN     vecpow(GEN x, GEN n)

    # base5.c

    GEN     eltreltoabs(GEN rnfeq, GEN x)
    GEN     eltabstorel(GEN eq, GEN P)
    GEN     eltabstorel_lift(GEN rnfeq, GEN P)
    GEN     rnfeltabstorel(GEN rnf, GEN x)
    GEN     rnfeltdown(GEN rnf, GEN x)
    GEN     rnfeltdown0(GEN rnf, GEN x, long flag)
    GEN     rnfeltreltoabs(GEN rnf, GEN x)
    GEN     rnfeltup(GEN rnf, GEN x)
    GEN     rnfeltup0(GEN rnf, GEN x, long flag)
    GEN     rnfidealabstorel(GEN rnf, GEN x)
    GEN     rnfidealdown(GEN rnf, GEN x)
    GEN     rnfidealhnf(GEN rnf, GEN x)
    GEN     rnfidealmul(GEN rnf, GEN x, GEN y)
    GEN     rnfidealnormabs(GEN rnf, GEN x)
    GEN     rnfidealnormrel(GEN rnf, GEN x)
    GEN     rnfidealprimedec(GEN rnf, GEN pr)
    GEN     rnfidealreltoabs(GEN rnf, GEN x)
    GEN     rnfidealreltoabs0(GEN rnf, GEN x, long flag)
    GEN     rnfidealtwoelement(GEN rnf, GEN x)
    GEN     rnfidealup(GEN rnf, GEN x)
    GEN     rnfidealup0(GEN rnf, GEN x, long flag)
    GEN     rnfinit(GEN nf, GEN pol)
    GEN     rnfinit0(GEN nf, GEN pol, long flag)

    # bb_group.c

    GEN dlog_get_ordfa(GEN o)
    GEN dlog_get_ord(GEN o)
    GEN gen_PH_log(GEN a, GEN g, GEN ord, void *E, const bb_group *grp)
    GEN gen_Shanks_init(GEN g, long n, void *E, const bb_group *grp)
    GEN gen_Shanks(GEN T, GEN x, ulong N, void *E, const bb_group *grp)
    GEN gen_Shanks_sqrtn(GEN a, GEN n, GEN q, GEN *zetan, void *E, const bb_group *grp)
    GEN gen_gener(GEN o, void *E, const bb_group *grp)
    GEN gen_ellgens(GEN d1, GEN d2, GEN m, void *E, const bb_group *grp,
                    GEN pairorder(void *E, GEN P, GEN Q, GEN m, GEN F))
    GEN gen_ellgroup(GEN N, GEN F, GEN *pt_m, void *E, const bb_group *grp,
                     GEN pairorder(void *E, GEN P, GEN Q, GEN m, GEN F))
    GEN gen_factored_order(GEN a, GEN o, void *E, const bb_group *grp)
    GEN gen_order(GEN x, GEN o, void *E, const bb_group *grp)
    GEN gen_select_order(GEN o, void *E, const bb_group *grp)

    GEN gen_plog(GEN x, GEN g0, GEN q, void *E, const bb_group *grp)
    GEN gen_pow(GEN x, GEN n, void *E, GEN (*sqr)(void*, GEN), GEN (*mul)(void*, GEN, GEN))
    GEN gen_pow_i(GEN x, GEN n, void *E, GEN (*sqr)(void*, GEN), GEN (*mul)(void*, GEN, GEN))
    GEN gen_pow_fold(GEN x, GEN n, void *E, GEN (*sqr)(void*, GEN), GEN (*msqr)(void*, GEN))
    GEN gen_pow_fold_i(GEN x, GEN n, void *E, GEN (*sqr)(void*, GEN), GEN (*msqr)(void*, GEN))
    GEN gen_powers(GEN x, long l, int use_sqr, void *E, GEN (*sqr)(void*, GEN), GEN (*mul)(void*, GEN, GEN), GEN (*one)(void*))
    GEN gen_powu(GEN x, ulong n, void *E, GEN (*sqr)(void*, GEN), GEN (*mul)(void*, GEN, GEN))
    GEN gen_powu_i(GEN x, ulong n, void *E, GEN (*sqr)(void*, GEN), GEN (*mul)(void*, GEN, GEN))
    GEN gen_powu_fold(GEN x, ulong n, void *E, GEN (*sqr)(void*, GEN), GEN (*msqr)(void*, GEN))
    GEN gen_powu_fold_i(GEN x, ulong n, void *E, GEN  (*sqr)(void*, GEN), GEN (*msqr)(void*, GEN))
    GEN gen_product(GEN x, void *data, GEN (*mul)(void*, GEN, GEN))

    # bb_hnf.c

    GEN     matdetmod(GEN A, GEN d)
    GEN     matimagemod(GEN A, GEN d, GEN* U)
    GEN     matinvmod(GEN A, GEN d)
    GEN     matkermod(GEN A, GEN d, GEN* im)
    GEN     matsolvemod(GEN M, GEN D, GEN Y, long flag)

    # bern.c

    GEN     bernfrac(long n)
    GEN     bernpol(long k, long v)
    GEN     bernreal(long n, long prec)
    GEN     bernvec(long nomb)
    void    constbern(long n)
    GEN     eulerfrac(long k)
    GEN     eulerpol(long k, long v)
    GEN     eulerreal(long n, long prec)
    GEN     eulervec(long n)

    # bibli1.c

    int     QR_init(GEN x, GEN *pB, GEN *pQ, GEN *pL, long prec)
    GEN     R_from_QR(GEN x, long prec)
    GEN     RgM_Babai(GEN B, GEN t)
    int     RgM_QR_init(GEN x, GEN *pB, GEN *pQ, GEN *pL, long prec)
    GEN     RgM_gram_schmidt(GEN e, GEN *ptB)
    GEN     Xadic_lindep(GEN x)
    GEN     algdep(GEN x, long n)
    GEN     algdep0(GEN x, long n, long bit)
    void    forqfvec(void *E, long (*fun)(void *, GEN, GEN, double), GEN a, GEN BORNE)
    void    forqfvec0(GEN a, GEN BORNE, GEN code)
    GEN     gaussred_from_QR(GEN x, long prec)
    GEN     lindep0(GEN x, long flag)
    GEN     lindep(GEN x)
    GEN     lindep2(GEN x, long bit)
    GEN     mathouseholder(GEN Q, GEN v)
    GEN     matqr(GEN x, long flag, long prec)
    GEN     minim(GEN a, GEN borne, GEN stockmax)
    GEN     minim_raw(GEN a, GEN borne, GEN stockmax)
    GEN     minim2(GEN a, GEN borne, GEN stockmax)
    GEN     padic_lindep(GEN x)
    GEN     perf(GEN a)
    GEN     qfrep0(GEN a, GEN borne, long flag)
    GEN     qfminim0(GEN a, GEN borne, GEN stockmax, long flag, long prec)
    GEN     seralgdep(GEN s, long p, long r)
    GEN     zncoppersmith(GEN P0, GEN N, GEN X, GEN B)

    # bibli2.c

    GEN     QXQ_reverse(GEN a, GEN T)
    GEN     RgV_polint(GEN X, GEN Y, long v)
    GEN     RgXQ_reverse(GEN a, GEN T)
    GEN     ZV_indexsort(GEN L)
    long    ZV_search(GEN x, GEN y)
    GEN     ZV_sort(GEN L)
    GEN     ZV_sort_uniq(GEN L)
    GEN     ZV_union_shallow(GEN x, GEN y)
    GEN     binomial(GEN x, long k)
    GEN     binomialuu(ulong n, ulong k)
    int     cmp_Flx(GEN x, GEN y)
    int     cmp_RgX(GEN x, GEN y)
    int     cmp_nodata(void *data, GEN x, GEN y)
    int     cmp_prime_ideal(GEN x, GEN y)
    int     cmp_prime_over_p(GEN x, GEN y)
    int     cmp_universal(GEN x, GEN y)
    GEN     convol(GEN x, GEN y)
    int     gen_cmp_RgX(void *data, GEN x, GEN y)
    GEN     polcyclo(long n, long v)
    GEN     polcyclo_eval(long n, GEN x)
    GEN     dirdiv(GEN x, GEN y)
    GEN     dirmul(GEN x, GEN y)
    GEN     gen_indexsort(GEN x, void *E, int (*cmp)(void*, GEN, GEN))
    GEN     gen_indexsort_uniq(GEN x, void *E, int (*cmp)(void*, GEN, GEN))
    long    gen_search(GEN x, GEN y, long flag, void *data, int (*cmp)(void*, GEN, GEN))
    GEN     gen_setminus(GEN set1, GEN set2, int (*cmp)(GEN, GEN))
    GEN     gen_sort(GEN x, void *E, int (*cmp)(void*, GEN, GEN))
    void    gen_sort_inplace(GEN x, void *E, int (*cmp)(void*, GEN, GEN), GEN *perm)
    GEN     gen_sort_uniq(GEN x, void *E, int (*cmp)(void*, GEN, GEN))
    long    getstack()
    long    gettime()
    long    getabstime()
    GEN     getwalltime()
    GEN     gprec(GEN x, long l)
    GEN     gprec_wtrunc(GEN x, long pr)
    GEN     gprec_w(GEN x, long pr)
    GEN     gtoset(GEN x)
    GEN     indexlexsort(GEN x)
    GEN     indexsort(GEN x)
    GEN     indexvecsort(GEN x, GEN k)
    GEN     laplace(GEN x)
    GEN     lexsort(GEN x)
    GEN     mathilbert(long n)
    GEN     matqpascal(long n, GEN q)
    GEN     merge_factor(GEN fx, GEN fy, void *data, int (*cmp)(void *, GEN, GEN))
    GEN     merge_sort_uniq(GEN x, GEN y, void *data, int (*cmp)(void *, GEN, GEN))
    GEN     modreverse(GEN x)
    GEN     numtoperm(long n, GEN x)
    GEN     permtonum(GEN x)
    GEN     polhermite(long n, long v)
    GEN     polhermite_eval(long n, GEN x)
    GEN     pollegendre(long n, long v)
    GEN     pollegendre_eval(long n, GEN x)
    GEN     polint(GEN xa, GEN ya, GEN x, GEN *dy)
    GEN     polchebyshev(long n, long kind, long v)
    GEN     polchebyshev_eval(long n, long kind, GEN x)
    GEN     polchebyshev1(long n, long v)
    GEN     polchebyshev2(long n, long v)
    GEN     polrecip(GEN x)
    GEN     setbinop(GEN f, GEN x, GEN y)
    GEN     setintersect(GEN x, GEN y)
    long    setisset(GEN x)
    GEN     setminus(GEN x, GEN y)
    long    setsearch(GEN x, GEN y, long flag)
    GEN     setunion(GEN x, GEN y)
    GEN     sort(GEN x)
    GEN     sort_factor(GEN y, void *data, int (*cmp)(void*, GEN, GEN))
    GEN     stirling(long n, long m, long flag)
    GEN     stirling1(ulong n, ulong m)
    GEN     stirling2(ulong n, ulong m)
    long    tablesearch(GEN T, GEN x, int (*cmp)(GEN, GEN))
    GEN     vecbinome(long n)
    long    vecsearch(GEN v, GEN x, GEN k)
    GEN     vecsort(GEN x, GEN k)
    GEN     vecsort0(GEN x, GEN k, long flag)
    long    zv_search(GEN x, long y)

    # bit.c

    GEN     bits_to_int(GEN x, long l)
    ulong   bits_to_u(GEN v, long l)
    GEN     binaire(GEN x)
    GEN     binary_2k(GEN x, long k)
    GEN     binary_2k_nv(GEN x, long k)
    GEN     binary_zv(GEN x)
    long    bittest(GEN x, long n)
    GEN     fromdigits_2k(GEN x, long k)
    GEN     gbitand(GEN x, GEN y)
    GEN     gbitneg(GEN x, long n)
    GEN     gbitnegimply(GEN x, GEN y)
    GEN     gbitor(GEN x, GEN y)
    GEN     gbittest(GEN x, long n)
    GEN     gbitxor(GEN x, GEN y)
    long    hammingweight(GEN n)
    GEN     ibitand(GEN x, GEN y)
    GEN     ibitnegimply(GEN x, GEN y)
    GEN     ibitor(GEN x, GEN y)
    GEN     ibitxor(GEN x, GEN y)
    GEN     nv_fromdigits_2k(GEN x, long k)

    # buch1.c

    GEN     Buchquad(GEN D, double c1, double c2, long prec)
    GEN     quadclassunit0(GEN x, long flag, GEN data, long prec)
    GEN     quadhilbert(GEN D, long prec)
    GEN     quadray(GEN bnf, GEN f, long prec)

    # buch2.c

    GEN     Buchall(GEN P, long flag, long prec)
    GEN     Buchall_param(GEN P, double bach, double bach2, long nbrelpid, long flun, long prec)
    GEN     bnfcompress(GEN bnf)
    GEN     bnfinit0(GEN P, long flag, GEN data, long prec)
    GEN     bnfisprincipal0(GEN bnf, GEN x, long flall)
    GEN     bnfisunit(GEN bignf, GEN x)
    GEN     bnfnewprec(GEN nf, long prec)
    GEN     bnfnewprec_shallow(GEN nf, long prec)
    GEN     bnrnewprec(GEN bnr, long prec)
    GEN     bnrnewprec_shallow(GEN bnr, long prec)
    GEN     isprincipalfact(GEN bnf, GEN C, GEN L, GEN f, long flag)
    GEN     isprincipalfact_or_fail(GEN bnf, GEN C, GEN P, GEN e)
    GEN     isprincipal(GEN bnf, GEN x)
    GEN     nfcyclotomicunits(GEN nf, GEN zu)
    GEN     nfsign_units(GEN bnf, GEN archp, int add_zu)
    GEN     signunits(GEN bignf)

    # buch3.c

    GEN     ABC_to_bnr(GEN A, GEN B, GEN C, GEN *H, int gen)
    GEN     Buchray(GEN bnf, GEN module, long flag)
    GEN     bnrautmatrix(GEN bnr, GEN aut)
    GEN     bnrchar(GEN bnr, GEN g, GEN v)
    GEN     bnrchar_primitive(GEN bnr, GEN chi, GEN bnrc)
    GEN     bnrclassno(GEN bignf, GEN ideal)
    GEN     bnrclassno0(GEN A, GEN B, GEN C)
    GEN     bnrclassnolist(GEN bnf, GEN listes)
    GEN     bnrconductor0(GEN A, GEN B, GEN C, long flag)
    GEN     bnrconductor(GEN bnr, GEN H0, long flag)
    GEN     bnrconductor_i(GEN bnr, GEN H0, long flag)
    GEN     bnrconductorofchar(GEN bnr, GEN chi)
    GEN     bnrdisc0(GEN A, GEN B, GEN C, long flag)
    GEN     bnrdisc(GEN bnr, GEN H, long flag)
    GEN     bnrdisclist0(GEN bnf, GEN borne, GEN arch)
    GEN     bnrgaloismatrix(GEN bnr, GEN aut)
    GEN     bnrgaloisapply(GEN bnr, GEN mat, GEN x)
    GEN     bnrinit0(GEN bignf, GEN ideal, long flag)
    long    bnrisconductor0(GEN A, GEN B, GEN C)
    long    bnrisconductor(GEN bnr, GEN H)
    long    bnrisgalois(GEN bnr, GEN M, GEN H)
    GEN     bnrisprincipal(GEN bnf, GEN x, long flag)
    GEN     bnrsurjection(GEN bnr1, GEN bnr2)
    GEN     buchnarrow(GEN bignf)
    long    bnfcertify(GEN bnf)
    long    bnfcertify0(GEN bnf, long flag)
    GEN     decodemodule(GEN nf, GEN fa)
    GEN     discrayabslist(GEN bnf, GEN listes)
    GEN     discrayabslistarch(GEN bnf, GEN arch, ulong bound)
    GEN     discrayabslistlong(GEN bnf, ulong bound)
    GEN     idealmoddivisor(GEN bnr, GEN x)
    GEN     isprincipalray(GEN bnf, GEN x)
    GEN     isprincipalraygen(GEN bnf, GEN x)
    GEN     rnfconductor(GEN bnf, GEN polrel)
    long    rnfisabelian(GEN nf, GEN pol)
    GEN     rnfnormgroup(GEN bnr, GEN polrel)
    GEN     subgrouplist0(GEN bnr, GEN indexbound, long all)

    # buch4.c

    GEN     bnfisnorm(GEN bnf, GEN x, long flag)
    GEN     rnfisnorm(GEN S, GEN x, long flag)
    GEN     rnfisnorminit(GEN bnf, GEN relpol, int galois)
    GEN     bnfissunit(GEN bnf, GEN suni, GEN x)
    GEN     bnfsunit(GEN bnf, GEN s, long PREC)
    long    nfhilbert(GEN bnf, GEN a, GEN b)
    long    nfhilbert0(GEN bnf, GEN a, GEN b, GEN p)
    long    hyperell_locally_soluble(GEN pol, GEN p)
    long    nf_hyperell_locally_soluble(GEN nf, GEN pol, GEN p)

    # char.c

    int     char_check(GEN cyc, GEN chi)
    GEN     charconj(GEN cyc, GEN chi)
    GEN     charconj0(GEN cyc, GEN chi)
    GEN     chardiv(GEN x, GEN a, GEN b)
    GEN     chardiv0(GEN x, GEN a, GEN b)
    GEN     chareval(GEN G, GEN chi, GEN n, GEN z)
    GEN     charker(GEN cyc, GEN chi)
    GEN     charker0(GEN cyc, GEN chi)
    GEN     charmul(GEN x, GEN a, GEN b)
    GEN     charmul0(GEN x, GEN a, GEN b)
    GEN     charorder(GEN cyc, GEN x)
    GEN     charorder0(GEN x, GEN chi)
    GEN     char_denormalize(GEN cyc, GEN D, GEN chic)
    GEN     char_normalize(GEN chi, GEN ncyc)
    GEN     char_rootof1(GEN d, long prec)
    GEN     char_rootof1_u(ulong d, long prec)
    GEN     char_simplify(GEN D, GEN C)
    GEN     cyc_normalize(GEN c)
    int     zncharcheck(GEN G, GEN chi)
    GEN     zncharconj(GEN G, GEN chi)
    GEN     znchardiv(GEN G, GEN a, GEN b)
    GEN     zncharker(GEN G, GEN chi)
    GEN     znchareval(GEN G, GEN chi, GEN n, GEN z)
    GEN     zncharinduce(GEN G, GEN chi, GEN N)
    long    zncharisodd(GEN G, GEN chi)
    GEN     zncharmul(GEN G, GEN a, GEN b)
    GEN     zncharorder(GEN G, GEN chi)
    int     znconrey_check(GEN cyc, GEN chi)
    GEN     znconrey_normalized(GEN G, GEN chi)
    GEN     znconreychar(GEN bid, GEN m)
    GEN     znconreyfromchar_normalized(GEN bid, GEN chi)
    GEN     znconreyconductor(GEN bid, GEN co, GEN *pm)
    GEN     znconreyexp(GEN bid, GEN x)
    GEN     znconreyfromchar(GEN bid, GEN chi)
    GEN     znconreylog(GEN bid, GEN x)
    GEN     znconreylog_normalize(GEN G, GEN m)

    # compile.c

    GEN     closure_deriv(GEN G)
    long    localvars_find(GEN pack, entree *ep)
    GEN     localvars_read_str(const char *str, GEN pack)
    GEN     snm_closure(entree *ep, GEN data)
    GEN     strtoclosure(const char *s, long n, ...)
    GEN     strtofunction(const char *s)

    # concat.c

    GEN     gconcat(GEN x, GEN y)
    GEN     gconcat1(GEN x)
    GEN     matconcat(GEN v)
    GEN     shallowconcat(GEN x, GEN y)
    GEN     shallowconcat1(GEN x)
    GEN     shallowmatconcat(GEN v)
    GEN     vconcat(GEN A, GEN B)

    # default.c
    extern int d_SILENT, d_ACKNOWLEDGE, d_INITRC, d_RETURN

    GEN default0(const char *a, const char *b)
    long getrealprecision()
    entree *pari_is_default(const char *s)
    GEN sd_TeXstyle(const char *v, long flag)
    GEN sd_colors(const char *v, long flag)
    GEN sd_compatible(const char *v, long flag)
    GEN sd_datadir(const char *v, long flag)
    GEN sd_debug(const char *v, long flag)
    GEN sd_debugfiles(const char *v, long flag)
    GEN sd_debugmem(const char *v, long flag)
    GEN sd_factor_add_primes(const char *v, long flag)
    GEN sd_factor_proven(const char *v, long flag)
    GEN sd_format(const char *v, long flag)
    GEN sd_histsize(const char *v, long flag)
    GEN sd_log(const char *v, long flag)
    GEN sd_logfile(const char *v, long flag)
    GEN sd_nbthreads(const char *v, long flag)
    GEN sd_new_galois_format(const char *v, long flag)
    GEN sd_output(const char *v, long flag)
    GEN sd_parisize(const char *v, long flag)
    GEN sd_parisizemax(const char *v, long flag)
    GEN sd_path(const char *v, long flag)
    GEN sd_prettyprinter(const char *v, long flag)
    GEN sd_primelimit(const char *v, long flag)
    GEN sd_realbitprecision(const char *v, long flag)
    GEN sd_realprecision(const char *v, long flag)
    GEN sd_secure(const char *v, long flag)
    GEN sd_seriesprecision(const char *v, long flag)
    GEN sd_simplify(const char *v, long flag)
    GEN sd_sopath(char *v, int flag)
    GEN sd_strictargs(const char *v, long flag)
    GEN sd_strictmatch(const char *v, long flag)
    GEN sd_string(const char *v, long flag, const char *s, char **f)
    GEN sd_threadsize(const char *v, long flag)
    GEN sd_threadsizemax(const char *v, long flag)
    GEN sd_toggle(const char *v, long flag, const char *s, int *ptn)
    GEN sd_ulong(const char *v, long flag, const char *s, ulong *ptn, ulong Min, ulong Max, const char **msg)
    GEN setdefault(const char *s, const char *v, long flag)
    long setrealprecision(long n, long *prec)

    # gplib.c
    GEN sd_breakloop(const char *v, long flag)
    GEN sd_echo(const char *v, long flag)
    GEN sd_graphcolormap(const char *v, long flag)
    GEN sd_graphcolors(const char *v, long flag)
    GEN sd_help(const char *v, long flag)
    GEN sd_histfile(const char *v, long flag)
    GEN sd_lines(const char *v, long flag)
    GEN sd_linewrap(const char *v, long flag)
    GEN sd_prompt(const char *v, long flag)
    GEN sd_prompt_cont(const char *v, long flag)
    GEN sd_psfile(const char *v, long flag)
    GEN sd_readline(const char *v, long flag)
    GEN sd_recover(const char *v, long flag)
    GEN sd_timer(const char *v, long flag)
    void pari_hit_return()
    void gp_load_gprc()
    int  gp_meta(const char *buf, int ismain)
    const char **gphelp_keyword_list()
    void pari_center(const char *s)
    void pari_print_version()
    const char *gp_format_time(long delay)
    const char *gp_format_prompt(const char *p)
    void pari_alarm(long s)
    GEN  gp_alarm(long s, GEN code)
    GEN  gp_input()
    void gp_allocatemem(GEN z)
    int  gp_handle_exception(long numerr)
    void gp_alarm_handler(int sig)
    void gp_sigint_fun()
    extern int h_REGULAR, h_LONG, h_APROPOS, h_RL
    void gp_help(const char *s, long flag)
    void gp_echo_and_log(const char *prompt, const char *s)
    void print_fun_list(char **list, long nbli)

    # dirichlet.c

    GEN     direxpand(GEN a, long L)
    GEN     direuler(void *E, GEN (*eval)(void *, GEN), GEN a, GEN b, GEN c)

    # ellanal.c

    GEN     ellanalyticrank(GEN e, GEN eps, long prec)
    GEN     ellanalyticrank_bitprec(GEN e, GEN eps, long bitprec)
    GEN     ellanal_globalred_all(GEN e, GEN *N, GEN *cb, GEN *tam)
    GEN     ellheegner(GEN e)
    GEN     ellL1(GEN E, long r, long prec)
    GEN     ellL1_bitprec(GEN E, long r, long bitprec)

    # elldata.c

    GEN     ellconvertname(GEN s)
    GEN     elldatagenerators(GEN E)
    GEN     ellidentify(GEN E)
    GEN     ellsearch(GEN A)
    GEN     ellsearchcurve(GEN name)
    void    forell(void *E, long call(void*, GEN), long a, long b, long flag)

    # ellfromeqn.c

    GEN     ellfromeqn(GEN s)

    # elliptic.c
    extern int t_ELL_Rg, t_ELL_Q, t_ELL_Qp, t_ELL_Fp, t_ELL_Fq, t_ELL_NF
    long    ellQ_get_CM(GEN e)
    int     ell_is_integral(GEN E)
    GEN     ellbasechar(GEN E)
    GEN     akell(GEN e, GEN n)
    GEN     anell(GEN e, long n)
    GEN     anellsmall(GEN e, long n)
    GEN     bilhell(GEN e, GEN z1, GEN z2, long prec)
    void    checkell(GEN e)
    void    checkell_Fq(GEN e)
    void    checkell_Q(GEN e)
    void    checkell_Qp(GEN e)
    void    checkellisog(GEN v)
    void    checkellpt(GEN z)
    void    checkell5(GEN e)
    GEN     ec_bmodel(GEN e)
    GEN     ec_f_evalx(GEN E, GEN x)
    GEN     ec_h_evalx(GEN e, GEN x)
    GEN     ec_dFdx_evalQ(GEN E, GEN Q)
    GEN     ec_dFdy_evalQ(GEN E, GEN Q)
    GEN     ec_dmFdy_evalQ(GEN e, GEN Q)
    GEN     ec_2divpol_evalx(GEN E, GEN x)
    GEN     ec_half_deriv_2divpol_evalx(GEN E, GEN x)
    GEN     ellanal_globalred(GEN e, GEN *gr)
    GEN     ellQ_get_N(GEN e)
    void    ellQ_get_Nfa(GEN e, GEN *N, GEN *faN)
    GEN     ellQp_Tate_uniformization(GEN E, long prec)
    GEN     ellQp_u(GEN E, long prec)
    GEN     ellQp_u2(GEN E, long prec)
    GEN     ellQp_q(GEN E, long prec)
    GEN     ellQp_ab(GEN E, long prec)
    GEN     ellQp_root(GEN E, long prec)
    GEN     ellR_ab(GEN E, long prec)
    GEN     ellR_eta(GEN E, long prec)
    GEN     ellR_omega(GEN x, long prec)
    GEN     ellR_roots(GEN E, long prec)
    GEN     elladd(GEN e, GEN z1, GEN z2)
    GEN     ellap(GEN e, GEN p)
    long    ellap_CM_fast(GEN E, ulong p, long CM)
    GEN     ellcard(GEN E, GEN p)
    GEN     ellchangecurve(GEN e, GEN ch)
    GEN     ellchangeinvert(GEN w)
    GEN     ellchangepoint(GEN x, GEN ch)
    GEN     ellchangepointinv(GEN x, GEN ch)
    GEN     elldivpol(GEN e, long n, long v)
    GEN     elleisnum(GEN om, long k, long flag, long prec)
    GEN     elleta(GEN om, long prec)
    GEN     ellff_get_card(GEN E)
    GEN     ellff_get_gens(GEN E)
    GEN     ellff_get_group(GEN E)
    GEN     ellff_get_o(GEN x)
    GEN     ellff_get_p(GEN E)
    GEN     ellfromj(GEN j)
    GEN     ellformaldifferential(GEN e, long n, long v)
    GEN     ellformalexp(GEN e, long n, long v)
    GEN     ellformallog(GEN e, long n, long v)
    GEN     ellformalpoint(GEN e, long n, long v)
    GEN     ellformalw(GEN e, long n, long v)
    GEN     ellgenerators(GEN E)
    GEN     ellglobalred(GEN e1)
    GEN     ellgroup(GEN E, GEN p)
    GEN     ellgroup0(GEN E, GEN p, long flag)
    GEN     ellheight0(GEN e, GEN a, GEN b, long prec)
    GEN     ellheight(GEN e, GEN a, long prec)
    GEN     ellheightmatrix(GEN E, GEN x, long n)
    GEN     ellheightoo(GEN e, GEN z, long prec)
    GEN     ellinit(GEN x, GEN p, long prec)
    GEN     ellintegralmodel(GEN e, GEN *pv)
    GEN     ellisoncurve(GEN e, GEN z)
    int     ellissupersingular(GEN x, GEN p)
    int     elljissupersingular(GEN x)
    GEN     elllseries(GEN e, GEN s, GEN A, long prec)
    GEN     elllocalred(GEN e, GEN p1)
    GEN     elllog(GEN e, GEN a, GEN g, GEN o)
    GEN     ellminimalmodel(GEN E, GEN *ptv)
    GEN     ellminimaltwist(GEN e)
    GEN     ellminimaltwist0(GEN e, long fl)
    GEN     ellminimaltwistcond(GEN e)
    GEN     ellmul(GEN e, GEN z, GEN n)
    GEN     ellnonsingularmultiple(GEN e, GEN P)
    GEN     ellneg(GEN e, GEN z)
    GEN     ellorder(GEN e, GEN p, GEN o)
    long    ellorder_Q(GEN E, GEN P)
    GEN     ellordinate(GEN e, GEN x, long prec)
    GEN     ellpadicfrobenius(GEN E, ulong p, long n)
    GEN     ellpadicheight(GEN e, GEN p, long n, GEN P)
    GEN     ellpadicheight0(GEN e, GEN p, long n, GEN P, GEN Q)
    GEN     ellpadicheightmatrix(GEN e, GEN p, long n, GEN P)
    GEN     ellpadiclog(GEN E, GEN p, long n, GEN P)
    GEN     ellpadics2(GEN E, GEN p, long n)
    GEN     ellperiods(GEN w, long flag, long prec)
    GEN     elltwist(GEN E, GEN D)
    GEN     ellrandom(GEN e)
    long    ellrootno(GEN e, GEN p)
    long    ellrootno_global(GEN e)
    GEN     ellsea(GEN E, ulong smallfact)
    GEN     ellsigma(GEN om, GEN z, long flag, long prec)
    GEN     ellsub(GEN e, GEN z1, GEN z2)
    GEN     elltaniyama(GEN e, long prec)
    GEN     elltatepairing(GEN E, GEN t, GEN s, GEN m)
    GEN     elltors(GEN e)
    GEN     elltors0(GEN e, long flag)
    GEN     ellweilpairing(GEN E, GEN t, GEN s, GEN m)
    GEN     ellwp(GEN w, GEN z, long prec)
    GEN     ellwp0(GEN w, GEN z, long flag, long prec)
    GEN     ellwpseries(GEN e, long v, long PRECDL)
    GEN     ellxn(GEN e, long n, long v)
    GEN     ellzeta(GEN om, GEN z, long prec)
    GEN     expIxy(GEN x, GEN y, long prec)
    int     oncurve(GEN e, GEN z)
    GEN     orderell(GEN e, GEN p)
    GEN     pointell(GEN e, GEN z, long prec)
    GEN     point_to_a4a6(GEN E, GEN P, GEN p, GEN *pa4)
    GEN     point_to_a4a6_Fl(GEN E, GEN P, ulong p, ulong *pa4)
    GEN     zell(GEN e, GEN z, long prec)

    # elltors.c
    long    ellisdivisible(GEN E, GEN P, GEN n, GEN *Q)

    # ellisogeny.c

    GEN     ellisogenyapply(GEN f, GEN P)
    GEN     ellisogeny(GEN e, GEN G, long only_image, long vx, long vy)
    GEN     ellisomat(GEN E, long flag)

    # ellsea.c

    GEN     Fp_ellcard_SEA(GEN a4, GEN a6, GEN p, long early_abort)
    GEN     Fq_ellcard_SEA(GEN a4, GEN a6, GEN q, GEN T, GEN p, long early_abort)
    GEN     ellmodulareqn(long l, long vx, long vy)

    # es.c

    GEN     externstr(const char *cmd)
    char    *gp_filter(const char *s)
    GEN     gpextern(const char *cmd)
    void    gpsystem(const char *s)
    GEN     readstr(const char *s)
    GEN     GENtoGENstr_nospace(GEN x)
    GEN     GENtoGENstr(GEN x)
    char*   GENtoTeXstr(GEN x)
    char*   GENtostr(GEN x)
    char*   GENtostr_raw(GEN x)
    char*   GENtostr_unquoted(GEN x)
    GEN     Str(GEN g)
    GEN     Strchr(GEN g)
    GEN     Strexpand(GEN g)
    GEN     Strtex(GEN g)
    void    brute(GEN g, char format, long dec)
    void    dbgGEN(GEN x, long nb)
    void    error0(GEN g)
    void    dbg_pari_heap()
    int     file_is_binary(FILE *f)
    void    err_flush()
    void    err_printf(const char* pat, ...)
    GEN     gp_getenv(const char *s)
    GEN     gp_read_file(const char *s)
    GEN     gp_read_str_multiline(const char *s, char *last)
    GEN     gp_read_stream(FILE *f)
    GEN     gp_readvec_file(char *s)
    GEN     gp_readvec_stream(FILE *f)
    void    gpinstall(const char *s, const char *code,
                      const char *gpname, const char *lib)
    GEN     gsprintf(const char *fmt, ...)
    GEN     gvsprintf(const char *fmt, va_list ap)
    char*   itostr(GEN x)
    void    matbrute(GEN g, char format, long dec)
    char*   os_getenv(const char *s)
    void    (*os_signal(int sig, void (*f)(int)))(int)
    void    outmat(GEN x)
    void    output(GEN x)
    char*   RgV_to_str(GEN g, long flag)
    void    pari_add_hist(GEN z, long t)
    void    pari_ask_confirm(const char *s)
    void    pari_fclose(pariFILE *f)
    void    pari_flush()
    pariFILE* pari_fopen(const char *s, const char *mode)
    pariFILE* pari_fopen_or_fail(const char *s, const char *mode)
    pariFILE* pari_fopengz(const char *s)
    void    pari_fprintf(FILE *file, const char *fmt, ...)
    void    pari_fread_chars(void *b, size_t n, FILE *f)
    GEN     pari_get_hist(long p)
    long    pari_get_histtime(long p)
    char*   pari_get_homedir(const char *user)
    int     pari_is_dir(const char *name)
    int     pari_is_file(const char *name)
    int     pari_last_was_newline()
    void    pari_set_last_newline(int last)
    ulong   pari_nb_hist()
    void    pari_printf(const char *fmt, ...)
    void    pari_putc(char c)
    void    pari_puts(const char *s)
    pariFILE* pari_safefopen(const char *s, const char *mode)
    char*   pari_sprintf(const char *fmt, ...)
    int     pari_stdin_isatty()
    char*   pari_strdup(const char *s)
    char*   pari_strndup(const char *s, long n)
    char*   pari_unique_dir(const char *s)
    char*   pari_unique_filename(const char *s)
    void    pari_unlink(const char *s)
    void    pari_vfprintf(FILE *file, const char *fmt, va_list ap)
    void    pari_vprintf(const char *fmt, va_list ap)
    char*   pari_vsprintf(const char *fmt, va_list ap)
    char*   path_expand(const char *s)
    void    out_print0(PariOUT *out, const char *sep, GEN g, long flag)
    void    out_printf(PariOUT *out, const char *fmt, ...)
    void    out_putc(PariOUT *out, char c)
    void    out_puts(PariOUT *out, const char *s)
    void    out_term_color(PariOUT *out, long c)
    void    out_vprintf(PariOUT *out, const char *fmt, va_list ap)
    char*   pari_sprint0(const char *msg, GEN g, long flag)
    extern int f_RAW, f_PRETTYMAT, f_PRETTY, f_TEX
    void    print0(GEN g, long flag)
    void    print1(GEN g)
    void    printf0(const char *fmt, GEN args)
    void    printsep(const char *s, GEN g)
    void    printsep1(const char *s, GEN g)
    void    printtex(GEN g)
    char*   stack_sprintf(const char *fmt, ...)
    char*   stack_strcat(const char *s, const char *t)
    char*   stack_strdup(const char *s)
    void    strftime_expand(const char *s, char *buf, long max)
    GEN     Strprintf(const char *fmt, GEN args)
    FILE*   switchin(const char *name)
    void    switchout(const char *name)
    void    term_color(long c)
    char*   term_get_color(char *s, long c)
    void    texe(GEN g, char format, long dec)
    const char* type_name(long t)
    void    warning0(GEN g)
    void    write0(const char *s, GEN g)
    void    write1(const char *s, GEN g)
    void    writebin(const char *name, GEN x)
    void    writetex(const char *s, GEN g)

    # eval.c

    extern int br_NONE, br_BREAK, br_NEXT, br_MULTINEXT, br_RETURN
    void    bincopy_relink(GEN C, GEN vi)
    GEN     break0(long n)
    GEN     call0(GEN fun, GEN args)
    GEN     closure_callgen1(GEN C, GEN x)
    GEN     closure_callgen1prec(GEN C, GEN x, long prec)
    GEN     closure_callgen2(GEN C, GEN x, GEN y)
    GEN     closure_callgenall(GEN C, long n, ...)
    GEN     closure_callgenvec(GEN C, GEN args)
    GEN     closure_callgenvecprec(GEN C, GEN args, long prec)
    void    closure_callvoid1(GEN C, GEN x)
    long    closure_context(long start, long level)
    void    closure_disassemble(GEN n)
    void    closure_err(long level)
    GEN     closure_evalbrk(GEN C, long *status)
    GEN     closure_evalgen(GEN C)
    GEN     closure_evalnobrk(GEN C)
    GEN     closure_evalres(GEN C)
    void    closure_evalvoid(GEN C)
    GEN     closure_trapgen(GEN C, long numerr)
    GEN     copybin_unlink(GEN C)
    GEN     get_lex(long vn)
    long    get_localprec()
    long    get_localbitprec()
    GEN     gp_call(void *E, GEN x)
    GEN     gp_callprec(void *E, GEN x, long prec)
    GEN     gp_call2(void *E, GEN x, GEN y)
    long    gp_callbool(void *E, GEN x)
    long    gp_callvoid(void *E, GEN x)
    GEN     gp_eval(void *E, GEN x)
    long    gp_evalbool(void *E, GEN x)
    GEN     gp_evalprec(void *E, GEN x, long prec)
    GEN     gp_evalupto(void *E, GEN x)
    long    gp_evalvoid(void *E, GEN x)
    void    localprec(long p)
    void    localbitprec(long p)
    long    loop_break()
    GEN     next0(long n)
    GEN     pareval(GEN C)
    GEN     pari_self()
    GEN     parsum(GEN a, GEN b, GEN code, GEN x)
    GEN     parvector(long n, GEN code)
    void    pop_lex(long n)
    void    pop_localprec()
    void    push_lex(GEN a, GEN C)
    void    push_localbitprec(long p)
    void    push_localprec(long p)
    GEN     return0(GEN x)
    void    set_lex(long vn, GEN x)

    # FF.c

    GEN     FF_1(GEN a)
    GEN     FF_Z_Z_muldiv(GEN x, GEN y, GEN z)
    GEN     FF_Q_add(GEN x, GEN y)
    GEN     FF_Z_add(GEN a, GEN b)
    GEN     FF_Z_mul(GEN a, GEN b)
    GEN     FF_add(GEN a, GEN b)
    GEN     FF_charpoly(GEN x)
    GEN     FF_conjvec(GEN x)
    GEN     FF_div(GEN a, GEN b)
    GEN     FF_ellcard(GEN E)
    GEN     FF_ellcard_SEA(GEN E, long smallfact)
    GEN     FF_ellgens(GEN E)
    GEN     FF_ellgroup(GEN E)
    GEN     FF_elllog(GEN E, GEN P, GEN Q, GEN o)
    GEN     FF_ellmul(GEN E, GEN P, GEN n)
    GEN     FF_ellorder(GEN E, GEN P, GEN o)
    GEN     FF_elltwist(GEN E)
    GEN     FF_ellrandom(GEN E)
    GEN     FF_elltatepairing(GEN E, GEN P, GEN Q, GEN m)
    GEN     FF_ellweilpairing(GEN E, GEN P, GEN Q, GEN m)
    int     FF_equal(GEN a, GEN b)
    int     FF_equal0(GEN x)
    int     FF_equal1(GEN x)
    int     FF_equalm1(GEN x)
    long    FF_f(GEN x)
    GEN     FF_inv(GEN a)
    long    FF_issquare(GEN x)
    long    FF_issquareall(GEN x, GEN *pt)
    long    FF_ispower(GEN x, GEN K, GEN *pt)
    GEN     FF_log(GEN a, GEN b, GEN o)
    GEN     FF_minpoly(GEN x)
    GEN     FF_mod(GEN x)
    GEN     FF_mul(GEN a, GEN b)
    GEN     FF_mul2n(GEN a, long n)
    GEN     FF_neg(GEN a)
    GEN     FF_neg_i(GEN a)
    GEN     FF_norm(GEN x)
    GEN     FF_order(GEN x, GEN o)
    GEN     FF_p(GEN x)
    GEN     FF_p_i(GEN x)
    GEN     FF_pow(GEN x, GEN n)
    GEN     FF_primroot(GEN x, GEN *o)
    GEN     FF_q(GEN x)
    int     FF_samefield(GEN x, GEN y)
    GEN     FF_sqr(GEN a)
    GEN     FF_sqrt(GEN a)
    GEN     FF_sqrtn(GEN x, GEN n, GEN *zetan)
    GEN     FF_sub(GEN x, GEN y)
    GEN     FF_to_F2xq(GEN x)
    GEN     FF_to_F2xq_i(GEN x)
    GEN     FF_to_Flxq(GEN x)
    GEN     FF_to_Flxq_i(GEN x)
    GEN     FF_to_FpXQ(GEN x)
    GEN     FF_to_FpXQ_i(GEN x)
    GEN     FF_trace(GEN x)
    GEN     FF_zero(GEN a)
    GEN     FFM_FFC_mul(GEN M, GEN C, GEN ff)
    GEN     FFM_det(GEN M, GEN ff)
    GEN     FFM_image(GEN M, GEN ff)
    GEN     FFM_inv(GEN M, GEN ff)
    GEN     FFM_ker(GEN M, GEN ff)
    GEN     FFM_mul(GEN M, GEN N, GEN ff)
    long    FFM_rank(GEN M, GEN ff)
    GEN     FFX_factor(GEN f, GEN x)
    GEN     FFX_roots(GEN f, GEN x)
    GEN     FqX_to_FFX(GEN x, GEN ff)
    GEN     Fq_to_FF(GEN x, GEN ff)
    GEN     Z_FF_div(GEN a, GEN b)
    GEN     ffgen(GEN T, long v)
    GEN     fflog(GEN x, GEN g, GEN o)
    GEN     fforder(GEN x, GEN o)
    GEN     ffprimroot(GEN x, GEN *o)
    GEN     ffrandom(GEN ff)
    int     Rg_is_FF(GEN c, GEN *ff)
    int     RgC_is_FFC(GEN x, GEN *ff)
    int     RgM_is_FFM(GEN x, GEN *ff)
    GEN     p_to_FF(GEN p, long v)
    GEN     Tp_to_FF(GEN T, GEN p)

    # galconj.c

    GEN     checkgal(GEN gal)
    GEN     checkgroup(GEN g, GEN *S)
    GEN     embed_disc(GEN r, long r1, long prec)
    GEN     embed_roots(GEN r, long r1)
    GEN     galois_group(GEN gal)
    GEN     galoisconj(GEN nf, GEN d)
    GEN     galoisconj0(GEN nf, long flag, GEN d, long prec)
    GEN     galoisexport(GEN gal, long format)
    GEN     galoisfixedfield(GEN gal, GEN v, long flag, long y)
    GEN     galoisidentify(GEN gal)
    GEN     galoisinit(GEN nf, GEN den)
    GEN     galoisisabelian(GEN gal, long flag)
    long    galoisisnormal(GEN gal, GEN sub)
    GEN     galoispermtopol(GEN gal, GEN perm)
    GEN     galoissubgroups(GEN G)
    GEN     galoissubfields(GEN G, long flag, long v)
    long    numberofconjugates(GEN T, long pdepart)
    GEN     vandermondeinverse(GEN L, GEN T, GEN den, GEN prep)

    # galpol.c

    GEN     galoisnbpol(long a)
    GEN     galoisgetpol(long a, long b, long s)

    # gen1.c
    GEN     conjvec(GEN x, long prec)
    GEN     gadd(GEN x, GEN y)
    GEN     gaddsg(long x, GEN y)
    GEN     gconj(GEN x)
    GEN     gdiv(GEN x, GEN y)
    GEN     gdivgs(GEN x, long s)
    GEN     ginv(GEN x)
    GEN     gmul(GEN x, GEN y)
    GEN     gmul2n(GEN x, long n)
    GEN     gmulsg(long s, GEN y)
    GEN     gsqr(GEN x)
    GEN     gsub(GEN x, GEN y)
    GEN     gsubsg(long x, GEN y)
    GEN     inv_ser(GEN b)
    GEN     mulcxI(GEN x)
    GEN     mulcxmI(GEN x)
    GEN     ser_normalize(GEN x)

    # gen2.c

    GEN     gassoc_proto(GEN f(GEN, GEN), GEN, GEN)
    GEN     map_proto_G(GEN f(GEN), GEN x)
    GEN     map_proto_lG(long f(GEN), GEN x)
    GEN     map_proto_lGL(long f(GEN, long), GEN x, long y)

    long    Q_pval(GEN x, GEN p)
    long    Q_pvalrem(GEN x, GEN p, GEN *y)
    long    RgX_val(GEN x)
    long    RgX_valrem(GEN x, GEN *z)
    long    RgX_valrem_inexact(GEN x, GEN *Z)
    int     ZV_Z_dvd(GEN v, GEN p)
    long    ZV_pval(GEN x, GEN p)
    long    ZV_pvalrem(GEN x, GEN p, GEN *px)
    long    ZV_lval(GEN x, ulong p)
    long    ZV_lvalrem(GEN x, ulong p, GEN *px)
    long    ZX_lvalrem(GEN x, ulong p, GEN *px)
    long    ZX_lval(GEN x, ulong p)
    long    ZX_pval(GEN x, GEN p)
    long    ZX_pvalrem(GEN x, GEN p, GEN *px)
    long    Z_lval(GEN n, ulong p)
    long    Z_lvalrem(GEN n, ulong p, GEN *py)
    long    Z_lvalrem_stop(GEN *n, ulong p, int *stop)
    long    Z_pval(GEN n, GEN p)
    long    Z_pvalrem(GEN x, GEN p, GEN *py)
    GEN     cgetp(GEN x)
    GEN     cvstop2(long s, GEN y)
    GEN     cvtop(GEN x, GEN p, long l)
    GEN     cvtop2(GEN x, GEN y)
    GEN     gabs(GEN x, long prec)
    void    gaffect(GEN x, GEN y)
    void    gaffsg(long s, GEN x)
    int     gcmp(GEN x, GEN y)
    int     gequal0(GEN x)
    int     gequal1(GEN x)
    int     gequalX(GEN x)
    int     gequalm1(GEN x)
    int     gcmpsg(long x, GEN y)
    GEN     gcvtop(GEN x, GEN p, long r)
    int     gequal(GEN x, GEN y)
    int     gequalsg(long s, GEN x)
    long    gexpo(GEN x)
    GEN     gpvaluation(GEN x, GEN p)
    long    gvaluation(GEN x, GEN p)
    int     gidentical(GEN x, GEN y)
    long    glength(GEN x)
    GEN     gmax(GEN x, GEN y)
    GEN     gmaxgs(GEN x, long y)
    GEN     gmin(GEN x, GEN y)
    GEN     gmings(GEN x, long y)
    GEN     gneg(GEN x)
    GEN     gneg_i(GEN x)
    GEN     RgX_to_ser(GEN x, long l)
    GEN     RgX_to_ser_inexact(GEN x, long l)
    int     gsigne(GEN x)
    GEN     gtolist(GEN x)
    long    gtolong(GEN x)
    int     lexcmp(GEN x, GEN y)
    GEN     listcreate_typ(long t)
    GEN     listcreate()
    GEN     listinsert(GEN list, GEN object, long index)
    void    listpop(GEN L, long index)
    void    listpop0(GEN L, long index)
    GEN     listput(GEN list, GEN object, long index)
    GEN     listput0(GEN list, GEN object, long index)
    void    listsort(GEN list, long flag)
    GEN     matsize(GEN x)
    GEN     mklist()
    GEN     mklistcopy(GEN x)
    GEN     normalize(GEN x)
    GEN     normalizepol(GEN x)
    GEN     normalizepol_approx(GEN x, long lx)
    GEN     normalizepol_lg(GEN x, long lx)
    ulong   padic_to_Fl(GEN x, ulong p)
    GEN     padic_to_Fp(GEN x, GEN Y)
    GEN     quadtofp(GEN x, long l)
    GEN     rfrac_to_ser(GEN x, long l)
    long    sizedigit(GEN x)
    long    u_lval(ulong x, ulong p)
    long    u_lvalrem(ulong x, ulong p, ulong *py)
    long    u_lvalrem_stop(ulong *n, ulong p, int *stop)
    long    u_pval(ulong x, GEN p)
    long    u_pvalrem(ulong x, GEN p, ulong *py)
    long    vecindexmax(GEN x)
    long    vecindexmin(GEN x)
    GEN     vecmax0(GEN x, GEN *pv)
    GEN     vecmax(GEN x)
    GEN     vecmin0(GEN x, GEN *pv)
    GEN     vecmin(GEN x)
    long    z_lval(long s, ulong p)
    long    z_lvalrem(long s, ulong p, long *py)
    long    z_pval(long n, GEN p)
    long    z_pvalrem(long n, GEN p, long *py)

    # gen3.c

    GEN     padic_to_Q(GEN x)
    GEN     padic_to_Q_shallow(GEN x)
    GEN     QpV_to_QV(GEN v)
    GEN     RgM_mulreal(GEN x, GEN y)
    GEN     RgX_cxeval(GEN T, GEN u, GEN ui)
    GEN     RgX_deflate_max(GEN x0, long *m)
    long    RgX_deflate_order(GEN x)
    long    ZX_deflate_order(GEN x)
    GEN     ZX_deflate_max(GEN x, long *m)
    long    RgX_degree(GEN x, long v)
    GEN     RgX_integ(GEN x)
    GEN     bitprecision0(GEN x, long n)
    GEN     bitprecision00(GEN x, GEN n)
    GEN     ceil_safe(GEN x)
    GEN     ceilr(GEN x)
    GEN     centerlift(GEN x)
    GEN     centerlift0(GEN x, long v)
    GEN     compo(GEN x, long n)
    GEN     deg1pol(GEN x1, GEN x0, long v)
    GEN     deg1pol_shallow(GEN x1, GEN x0, long v)
    long    degree(GEN x)
    GEN     denom(GEN x)
    GEN     deriv(GEN x, long v)
    GEN     derivser(GEN x)
    GEN     diffop(GEN x, GEN v, GEN dv)
    GEN     diffop0(GEN x, GEN v, GEN dv, long n)
    GEN     diviiround(GEN x, GEN y)
    GEN     divrem(GEN x, GEN y, long v)
    GEN     floor_safe(GEN x)
    GEN     gceil(GEN x)
    GEN     gcvtoi(GEN x, long *e)
    GEN     gdeflate(GEN x, long v, long d)
    GEN     gdivent(GEN x, GEN y)
    GEN     gdiventgs(GEN x, long y)
    GEN     gdiventsg(long x, GEN y)
    GEN     gdiventres(GEN x, GEN y)
    GEN     gdivmod(GEN x, GEN y, GEN *pr)
    GEN     gdivround(GEN x, GEN y)
    int     gdvd(GEN x, GEN y)
    GEN     geq(GEN x, GEN y)
    GEN     geval(GEN x)
    GEN     gfloor(GEN x)
    GEN     gtrunc2n(GEN x, long s)
    GEN     gfrac(GEN x)
    GEN     gge(GEN x, GEN y)
    GEN     ggrando(GEN x, long n)
    GEN     ggt(GEN x, GEN y)
    GEN     gimag(GEN x)
    GEN     gisexactzero(GEN g)
    GEN     gle(GEN x, GEN y)
    GEN     glt(GEN x, GEN y)
    GEN     gmod(GEN x, GEN y)
    GEN     gmodgs(GEN x, long y)
    GEN     gmodsg(long x, GEN y)
    GEN     gmodulo(GEN x, GEN y)
    GEN     gmodulsg(long x, GEN y)
    GEN     gmodulss(long x, long y)
    GEN     gne(GEN x, GEN y)
    GEN     gnot(GEN x)
    GEN     gpolvar(GEN y)
    GEN     gppadicprec(GEN x, GEN p)
    GEN     gppoldegree(GEN x, long v)
    long    gprecision(GEN x)
    GEN     gpserprec(GEN x, long v)
    GEN     greal(GEN x)
    GEN     grndtoi(GEN x, long *e)
    GEN     ground(GEN x)
    GEN     gshift(GEN x, long n)
    GEN     gsubst(GEN x, long v, GEN y)
    GEN     gsubstpol(GEN x, GEN v, GEN y)
    GEN     gsubstvec(GEN x, GEN v, GEN y)
    GEN     gtocol(GEN x)
    GEN     gtocol0(GEN x, long n)
    GEN     gtocolrev(GEN x)
    GEN     gtocolrev0(GEN x, long n)
    GEN     gtopoly(GEN x, long v)
    GEN     gtopolyrev(GEN x, long v)
    GEN     gtoser(GEN x, long v, long precdl)
    GEN     gtovec(GEN x)
    GEN     gtovec0(GEN x, long n)
    GEN     gtovecrev(GEN x)
    GEN     gtovecrev0(GEN x, long n)
    GEN     gtovecsmall(GEN x)
    GEN     gtovecsmall0(GEN x, long n)
    GEN     gtrunc(GEN x)
    long    gvar(GEN x)
    long    gvar2(GEN x)
    GEN     hqfeval(GEN q, GEN x)
    GEN     imag_i(GEN x)
    GEN     integ(GEN x, long v)
    GEN     integser(GEN x)
    GEN     inv_ser(GEN b)
    int     iscomplex(GEN x)
    int     isexactzero(GEN g)
    int     isrationalzeroscalar(GEN g)
    int     isinexact(GEN x)
    int     isinexactreal(GEN x)
    int     isint(GEN n, GEN *ptk)
    int     isrationalzero(GEN g)
    int     issmall(GEN n, long *ptk)
    GEN     lift(GEN x)
    GEN     lift0(GEN x, long v)
    GEN     liftall(GEN x)
    GEN     liftall_shallow(GEN x)
    GEN     liftint(GEN x)
    GEN     liftint_shallow(GEN x)
    GEN     liftpol(GEN x)
    GEN     liftpol_shallow(GEN x)
    GEN     mkcoln(long n, ...)
    GEN     mkintn(long n, ...)
    GEN     mkpoln(long n, ...)
    GEN     mkvecn(long n, ...)
    GEN     mkvecsmalln(long n, ...)
    GEN     mulreal(GEN x, GEN y)
    GEN     numer(GEN x)
    long    padicprec(GEN x, GEN p)
    long    padicprec_relative(GEN x)
    GEN     polcoeff0(GEN x, long n, long v)
    GEN     polcoeff_i(GEN x, long n, long v)
    long    poldegree(GEN x, long v)
    GEN     poleval(GEN x, GEN y)
    GEN     pollead(GEN x, long v)
    long    precision(GEN x)
    GEN     precision0(GEN x, long n)
    GEN     precision00(GEN x, GEN n)
    GEN     qf_apply_RgM(GEN q, GEN M)
    GEN     qf_apply_ZM(GEN q, GEN M)
    GEN     qfbil(GEN x, GEN y, GEN q)
    GEN     qfeval(GEN q, GEN x)
    GEN     qfevalb(GEN q, GEN x, GEN y)
    GEN     qfnorm(GEN x, GEN q)
    GEN     real_i(GEN x)
    GEN     round0(GEN x, GEN *pte)
    GEN     roundr(GEN x)
    GEN     roundr_safe(GEN x)
    GEN     scalarpol(GEN x, long v)
    GEN     scalarpol_shallow(GEN x, long v)
    GEN     scalarser(GEN x, long v, long prec)
    GEN     ser_unscale(GEN P, GEN h)
    long    serprec(GEN x, long v)
    GEN     serreverse(GEN x)
    GEN     sertoser(GEN x, long prec)
    GEN     simplify(GEN x)
    GEN     simplify_shallow(GEN x)
    GEN     tayl(GEN x, long v, long precdl)
    GEN     toser_i(GEN x)
    GEN     trunc0(GEN x, GEN *pte)
    GEN     uu32toi(ulong a, ulong b)
    GEN     vars_sort_inplace(GEN z)
    GEN     vars_to_RgXV(GEN h)
    GEN     variables_vecsmall(GEN x)
    GEN     variables_vec(GEN x)

    # genus2red.c

    GEN     genus2red(GEN PQ, GEN p)

    # groupid.c

    long    group_ident(GEN G, GEN S)
    long    group_ident_trans(GEN G, GEN S)

    # hash.c

    hashtable *hash_create_ulong(ulong s, long stack)
    hashtable *hash_create_str(ulong s, long stack)
    hashtable *hash_create(ulong minsize, ulong (*hash)(void*), int (*eq)(void*, void*), int use_stack)
    void hash_insert(hashtable *h, void *k, void *v)
    void hash_insert2(hashtable *h, void *k, void *v, ulong hash)
    GEN hash_keys(hashtable *h)
    GEN hash_values(hashtable *h)
    hashentry *hash_search(hashtable *h, void *k)
    hashentry *hash_search2(hashtable *h, void *k, ulong hash)
    hashentry *hash_select(hashtable *h, void *k, void *E, int(*select)(void *, hashentry *))
    hashentry *hash_remove(hashtable *h, void *k)
    hashentry *hash_remove_select(hashtable *h, void *k, void *E, int (*select)(void*, hashentry*))
    void hash_destroy(hashtable *h)
    ulong hash_str(const char *str)
    ulong hash_str2(const char *s)
    ulong hash_GEN(GEN x)

    # hyperell.c

    GEN     hyperellpadicfrobenius(GEN x, ulong p, long e)
    GEN     hyperellcharpoly(GEN x)
    GEN     nfhyperellpadicfrobenius(GEN H, GEN T, ulong p, long n)

    # hnf_snf.c

    GEN     RgM_hnfall(GEN A, GEN *pB, long remove)
    GEN     ZM_hnf(GEN x)
    GEN     ZM_hnfall(GEN A, GEN *ptB, long remove)
    GEN     ZM_hnfcenter(GEN M)
    GEN     ZM_hnflll(GEN A, GEN *ptB, int remove)
    GEN     ZV_extgcd(GEN A)
    GEN     ZV_snfall(GEN D, GEN *pU, GEN *pV)
    GEN     ZV_snf_group(GEN d, GEN *newU, GEN *newUi)
    GEN     ZM_hnfmod(GEN x, GEN d)
    GEN     ZM_hnfmodall(GEN x, GEN dm, long flag)
    GEN     ZM_hnfmodid(GEN x, GEN d)
    GEN     ZM_hnfperm(GEN A, GEN *ptU, GEN *ptperm)
    void    ZM_snfclean(GEN d, GEN u, GEN v)
    GEN     ZM_snf(GEN x)
    GEN     ZM_snf_group(GEN H, GEN *newU, GEN *newUi)
    GEN     ZM_snfall(GEN x, GEN *ptU, GEN *ptV)
    GEN     ZM_snfall_i(GEN x, GEN *ptU, GEN *ptV, int return_vec)
    GEN     zlm_echelon(GEN x, long early_abort, ulong p, ulong pm)
    GEN     ZpM_echelon(GEN x, long early_abort, GEN p, GEN pm)
    GEN     gsmith(GEN x)
    GEN     gsmithall(GEN x)
    GEN     hnf(GEN x)
    GEN     hnf_divscale(GEN A, GEN B, GEN t)
    GEN     hnf_solve(GEN A, GEN B)
    GEN     hnf_invimage(GEN A, GEN b)
    GEN     hnfall(GEN x)
    int     hnfdivide(GEN A, GEN B)
    GEN     hnflll(GEN x)
    GEN     hnfmerge_get_1(GEN A, GEN B)
    GEN     hnfmod(GEN x, GEN d)
    GEN     hnfmodid(GEN x, GEN p)
    GEN     hnfperm(GEN x)
    GEN     matfrobenius(GEN M, long flag, long v)
    GEN     mathnf0(GEN x, long flag)
    GEN     matsnf0(GEN x, long flag)
    GEN     smith(GEN x)
    GEN     smithall(GEN x)
    GEN     smithclean(GEN z)

    # ifactor1.c

    GEN     Z_factor(GEN n)
    GEN     Z_factor_limit(GEN n, ulong all)
    GEN     Z_factor_until(GEN n, GEN limit)
    long    Z_issmooth(GEN m, ulong lim)
    GEN     Z_issmooth_fact(GEN m, ulong lim)
    long    Z_issquarefree(GEN x)
    GEN     absi_factor(GEN n)
    GEN     absi_factor_limit(GEN n, ulong all)
    long    bigomega(GEN n)
    long    bigomegau(ulong n)
    GEN     core(GEN n)
    ulong   coreu(ulong n)
    GEN     eulerphi(GEN n)
    ulong   eulerphiu(ulong n)
    ulong   eulerphiu_fact(GEN f)
    GEN     factorint(GEN n, long flag)
    GEN     factoru(ulong n)
    int     ifac_isprime(GEN x)
    int     ifac_next(GEN *part, GEN *p, long *e)
    int     ifac_read(GEN part, GEN *p, long *e)
    void    ifac_skip(GEN part)
    GEN     ifac_start(GEN n, int moebius)
    int     is_357_power(GEN x, GEN *pt, ulong *mask)
    int     is_pth_power(GEN x, GEN *pt, forprime_t *T, ulong cutoffbits)
    long    ispowerful(GEN n)
    long    issquarefree(GEN x)
    long    istotient(GEN n, GEN *px)
    long    moebius(GEN n)
    long    moebiusu(ulong n)
    GEN     nextprime(GEN n)
    GEN     numdiv(GEN n)
    long    omega(GEN n)
    long    omegau(ulong n)
    GEN     precprime(GEN n)
    GEN     sumdiv(GEN n)
    GEN     sumdivk(GEN n, long k)
    ulong   tridiv_bound(GEN n)
    int     uis_357_power(ulong x, ulong *pt, ulong *mask)
    int     uis_357_powermod(ulong x, ulong *mask)
    long    uissquarefree(ulong n)
    long    uissquarefree_fact(GEN f)
    ulong   unextprime(ulong n)
    ulong   uprecprime(ulong n)
    GEN     usumdivkvec(ulong n, GEN K)

    # init.c

    long    timer_delay(pari_timer *T)
    long    timer_get(pari_timer *T)
    void    timer_start(pari_timer *T)
    int     chk_gerepileupto(GEN x)
    GENbin* copy_bin(GEN x)
    GENbin* copy_bin_canon(GEN x)
    void    dbg_gerepile(pari_sp av)
    void    dbg_gerepileupto(GEN q)
    GEN     errname(GEN err)
    GEN     gclone(GEN x)
    GEN     gcloneref(GEN x)
    void    gclone_refc(GEN x)
    GEN     gcopy(GEN x)
    GEN     gcopy_avma(GEN x, pari_sp *AVMA)
    GEN     gcopy_lg(GEN x, long lx)
    GEN     gerepile(pari_sp ltop, pari_sp lbot, GEN q)
    void    gerepileallsp(pari_sp av, pari_sp tetpil, int n, ...)
    void    gerepilecoeffssp(pari_sp av, pari_sp tetpil, long *g, int n)
    void    gerepilemanysp(pari_sp av, pari_sp tetpil, GEN* g[], int n)
    GEN     getheap()
    void    gp_context_save(gp_context* rec)
    void    gp_context_restore(gp_context* rec)
    long    gsizeword(GEN x)
    long    gsizebyte(GEN x)
    void    gunclone(GEN x)
    void    gunclone_deep(GEN x)
    GEN     listcopy(GEN x)
    void    timer_printf(pari_timer *T, const char *format, ...)
    void    msgtimer(const char *format, ...)
    long    name_numerr(const char *s)
    void    new_chunk_resize(size_t x)
    GEN     newblock(size_t n)
    const char * numerr_name(long errnum)
    GEN     obj_check(GEN S, long K)
    GEN     obj_checkbuild(GEN S, long tag, GEN (*build)(GEN))
    GEN     obj_checkbuild_padicprec(GEN S, long tag, GEN (*build)(GEN, long), long prec)
    GEN     obj_checkbuild_realprec(GEN S, long tag, GEN (*build)(GEN, long), long prec)
    GEN     obj_checkbuild_prec(GEN S, long tag, GEN (*build)(GEN, long), long (*pr)(GEN), long prec)
    void    obj_free(GEN S)
    GEN     obj_init(long d, long n)
    GEN     obj_insert(GEN S, long K, GEN O)
    GEN     obj_insert_shallow(GEN S, long K, GEN O)
    void    pari_add_function(entree *ep)
    void    pari_add_module(entree *ep)
    void    pari_add_defaults_module(entree *ep)
    void    pari_close()
    void    pari_close_opts(ulong init_opts)
    GEN     pari_compile_str(const char *lex)
    int     pari_daemon()
    void    pari_err(int numerr, ...)
    GEN     pari_err_last()
    char *  pari_err2str(GEN err)
    void    pari_init_opts(size_t parisize, ulong maxprime, ulong init_opts)
    void    pari_init(size_t parisize, ulong maxprime)
    void    pari_stackcheck_init(void *pari_stack_base)
    void    pari_sighandler(int sig)
    void    pari_sig_init(void (*f)(int))
    void    pari_thread_alloc(pari_thread *t, size_t s, GEN arg)
    void    pari_thread_close()
    void    pari_thread_free(pari_thread *t)
    void    pari_thread_init()
    GEN     pari_thread_start(pari_thread *t)
    void    pari_thread_valloc(pari_thread *t, size_t s, size_t v, GEN arg)
    GEN     pari_version()
    void    pari_warn(int numerr, ...)
    void    paristack_newrsize(ulong newsize)
    void    paristack_resize(ulong newsize)
    void    paristack_setsize(size_t rsize, size_t vsize)
    void    parivstack_resize(ulong newsize)
    void    parivstack_reset()
    GEN     trap0(const char *e, GEN f, GEN r)
    void    shiftaddress(GEN x, long dec)
    void    shiftaddress_canon(GEN x, long dec)
    long    timer()
    long    timer2()
    void    traverseheap(void(*f)(GEN, void *), void *data)

    # intnum.c

    GEN     contfraceval(GEN CF, GEN t, long nlim)
    GEN     contfracinit(GEN M, long lim)
    GEN     intcirc(void *E, GEN (*eval) (void *, GEN), GEN a, GEN R, GEN tab, long prec)
    GEN     intfuncinit(void *E, GEN (*eval) (void *, GEN), GEN a, GEN b, long m, long prec)
    GEN     intnum(void *E, GEN (*eval) (void *, GEN), GEN a, GEN b, GEN tab, long prec)
    GEN     intnumgauss(void *E, GEN (*eval)(void*, GEN), GEN a, GEN b, GEN tab, long prec)
    GEN     intnumgaussinit(long n, long prec)
    GEN     intnuminit(GEN a, GEN b, long m, long prec)
    GEN     intnumromb(void *E, GEN (*eval)(void *, GEN), GEN a, GEN b, long flag, long prec)
    GEN     intnumromb_bitprec(void *E, GEN (*eval)(void *, GEN), GEN a, GEN b, long flag, long bit)
    GEN     sumnum(void *E, GEN (*eval)(void*, GEN), GEN a, GEN tab, long prec)
    GEN     sumnuminit(GEN fast, long prec)
    GEN     sumnummonien(void *E, GEN (*eval)(void*, GEN), GEN a, GEN tab, long prec)
    GEN     sumnummonieninit(GEN asymp, GEN w, GEN n0, long prec)

    # krasner.c

    GEN     padicfields0(GEN p, GEN n, long flag)
    GEN     padicfields(GEN p, long m, long d, long flag)

    # kummer.c

    GEN     rnfkummer(GEN bnr, GEN subgroup, long all, long prec)

    # lfun.c

    long    is_linit(GEN data)
    GEN     ldata_get_an(GEN ldata)
    GEN     ldata_get_dual(GEN ldata)
    GEN     ldata_get_gammavec(GEN ldata)
    long    ldata_get_degree(GEN ldata)
    long    ldata_get_k(GEN ldata)
    GEN     ldata_get_conductor(GEN ldata)
    GEN     ldata_get_rootno(GEN ldata)
    GEN     ldata_get_residue(GEN ldata)
    long    ldata_get_type(GEN ldata)
    long    ldata_isreal(GEN ldata)
    GEN     ldata_vecan(GEN ldata, long L, long prec)
    long    linit_get_type(GEN linit)
    GEN     linit_get_ldata(GEN linit)
    GEN     linit_get_tech(GEN linit)
    GEN     lfun_get_domain(GEN tech)
    GEN     lfun_get_dom(GEN tech)
    long    lfun_get_bitprec(GEN tech)
    GEN     lfun_get_factgammavec(GEN tech)
    GEN     lfun_get_step(GEN tech)
    GEN     lfun_get_pol(GEN tech)
    GEN     lfun_get_Residue(GEN tech)
    GEN     lfun_get_k2(GEN tech)
    GEN     lfun_get_w2(GEN tech)
    GEN     lfun_get_expot(GEN tech)
    long    lfun_get_der(GEN tech)
    long    lfun_get_bitprec(GEN tech)
    GEN     lfun(GEN ldata, GEN s, long bitprec)
    GEN     lfun0(GEN ldata, GEN s, long der, long bitprec)
    long    lfuncheckfeq(GEN data, GEN t0, long bitprec)
    GEN     lfunconductor(GEN data, GEN maxcond, long flag, long bitprec)
    GEN     lfuncost(GEN lmisc, GEN dom, long der, long bitprec)
    GEN     lfuncost0(GEN L, GEN dom, long der, long bitprec)
    GEN     lfuncreate(GEN obj)
    GEN     lfunan(GEN ldata, long L, long prec)
    GEN     lfunhardy(GEN ldata, GEN t, long bitprec)
    GEN     lfuninit(GEN ldata, GEN dom, long der, long bitprec)
    GEN     lfuninit0(GEN ldata, GEN dom, long der, long bitprec)
    GEN     lfuninit_make(long t, GEN ldata, GEN molin, GEN domain)
    long    lfunisvgaell(GEN Vga, long flag)
    GEN     lfunlambda(GEN ldata, GEN s, long bitprec)
    GEN     lfunlambda0(GEN ldata, GEN s, long der, long bitprec)
    GEN     lfunmisc_to_ldata(GEN ldata)
    GEN     lfunmisc_to_ldata_shallow(GEN ldata)
    long    lfunorderzero(GEN ldata, long m, long bitprec)
    GEN     lfunprod_get_fact(GEN tech)
    GEN     lfunrootno(GEN data, long bitprec)
    GEN     lfunrootres(GEN data, long bitprec)
    GEN     lfunrtopoles(GEN r)
    GEN     lfuntheta(GEN data, GEN t, long m, long bitprec)
    long    lfunthetacost0(GEN L, GEN tdom, long m, long bitprec)
    long    lfunthetacost(GEN ldata, GEN tdom, long m, long bitprec)
    GEN     lfunthetainit(GEN ldata, GEN tdom, long m, long bitprec)
    GEN     lfunthetacheckinit(GEN data, GEN tinf, long m, long *ptbitprec, long fl)
    GEN     lfunzeros(GEN ldata, GEN lim, long divz, long bitprec)
    int     sdomain_isincl(long k, GEN dom, GEN dom0)
    GEN     theta_get_an(GEN tdata)
    GEN     theta_get_K(GEN tdata)
    GEN     theta_get_R(GEN tdata)
    long    theta_get_bitprec(GEN tdata)
    long    theta_get_m(GEN tdata)
    GEN     theta_get_tdom(GEN tdata)
    GEN     theta_get_sqrtN(GEN tdata)

    # lfunutils.c

    GEN     dirzetak(GEN nf, GEN b)
    GEN     ellmoddegree(GEN e, long bitprec)
    GEN     lfunabelianrelinit(GEN bnfabs, GEN bnf, GEN polrel, GEN dom, long der, long bitprec)
    GEN     lfunartin(GEN N, GEN G, GEN M, long o)
    GEN     lfundiv(GEN ldata1, GEN ldata2, long bitprec)
    GEN     lfunellmfpeters(GEN E, long bitprec)
    GEN     lfunetaquo(GEN eta)
    GEN     lfungenus2(GEN PS)
    GEN     lfunmfspec(GEN lmisc, long bitprec)
    GEN     lfunmfpeters(GEN ldata, long bitprec)
    GEN     lfunmul(GEN ldata1, GEN ldata2, long bitprec)
    GEN     lfunqf(GEN ldata, long prec)
    GEN     lfunsymsq(GEN ldata, GEN known, long prec)
    GEN     lfunsymsqspec(GEN lmisc, long bitprec)
    GEN     lfunzetakinit(GEN pol, GEN dom, long der, long flag, long bitprec)

    # lll.c

    GEN     ZM_lll_norms(GEN x, double D, long flag, GEN *B)
    GEN     kerint(GEN x)
    GEN     lll(GEN x)
    GEN     lllfp(GEN x, double D, long flag)
    GEN     lllgen(GEN x)
    GEN     lllgram(GEN x)
    GEN     lllgramgen(GEN x)
    GEN     lllgramint(GEN x)
    GEN     lllgramkerim(GEN x)
    GEN     lllgramkerimgen(GEN x)
    GEN     lllint(GEN x)
    GEN     lllintpartial(GEN mat)
    GEN     lllintpartial_inplace(GEN mat)
    GEN     lllkerim(GEN x)
    GEN     lllkerimgen(GEN x)
    GEN     matkerint0(GEN x, long flag)
    GEN     qflll0(GEN x, long flag)
    GEN     qflllgram0(GEN x, long flag)

    # map.c

    GEN     gtomap(GEN M)
    void    mapdelete(GEN T, GEN a)
    GEN     mapdomain(GEN T)
    GEN     mapdomain_shallow(GEN T)
    GEN     mapget(GEN T, GEN a)
    int     mapisdefined(GEN T, GEN a, GEN *pt_z)
    void    mapput(GEN T, GEN a, GEN b)
    GEN     maptomat(GEN T)
    GEN     maptomat_shallow(GEN T)

    # mellininv.c

    double  dbllambertW0(double a)
    double  dbllambertW_1(double a)
    double  dbllemma526(double a, double b, double c, double B)
    double  dblcoro526(double a, double c, double B)
    GEN     gammamellininv(GEN Vga, GEN s, long m, long bitprec)
    GEN     gammamellininvasymp(GEN Vga, long nlimmax, long m)
    GEN     gammamellininvinit(GEN Vga, long m, long bitprec)
    GEN     gammamellininvrt(GEN K, GEN s, long bitprec)

    # members.c

    GEN     member_a1(GEN x)
    GEN     member_a2(GEN x)
    GEN     member_a3(GEN x)
    GEN     member_a4(GEN x)
    GEN     member_a6(GEN x)
    GEN     member_area(GEN x)
    GEN     member_b2(GEN x)
    GEN     member_b4(GEN x)
    GEN     member_b6(GEN x)
    GEN     member_b8(GEN x)
    GEN     member_bid(GEN x)
    GEN     member_bnf(GEN x)
    GEN     member_c4(GEN x)
    GEN     member_c6(GEN x)
    GEN     member_clgp(GEN x)
    GEN     member_codiff(GEN x)
    GEN     member_cyc(GEN clg)
    GEN     member_diff(GEN x)
    GEN     member_disc(GEN x)
    GEN     member_e(GEN x)
    GEN     member_eta(GEN x)
    GEN     member_f(GEN x)
    GEN     member_fu(GEN x)
    GEN     member_futu(GEN x)
    GEN     member_gen(GEN x)
    GEN     member_group(GEN x)
    GEN     member_index(GEN x)
    GEN     member_j(GEN x)
    GEN     member_mod(GEN x)
    GEN     member_nf(GEN x)
    GEN     member_no(GEN clg)
    GEN     member_omega(GEN x)
    GEN     member_orders(GEN x)
    GEN     member_p(GEN x)
    GEN     member_pol(GEN x)
    GEN     member_polabs(GEN x)
    GEN     member_reg(GEN x)
    GEN     member_r1(GEN x)
    GEN     member_r2(GEN x)
    GEN     member_roots(GEN x)
    GEN     member_sign(GEN x)
    GEN     member_t2(GEN x)
    GEN     member_tate(GEN x)
    GEN     member_tufu(GEN x)
    GEN     member_tu(GEN x)
    GEN     member_zk(GEN x)
    GEN     member_zkst(GEN bid)

    # mp.c

    GEN     addmulii(GEN x, GEN y, GEN z)
    GEN     addmulii_inplace(GEN x, GEN y, GEN z)
    ulong   Fl_inv(ulong x, ulong p)
    ulong   Fl_invgen(ulong x, ulong p, ulong *pg)
    ulong   Fl_invsafe(ulong x, ulong p)
    int     Fp_ratlift(GEN x, GEN m, GEN amax, GEN bmax, GEN *a, GEN *b)
    int     absi_cmp(GEN x, GEN y)
    int     absi_equal(GEN x, GEN y)
    int     absr_cmp(GEN x, GEN y)
    GEN     addii_sign(GEN x, long sx, GEN y, long sy)
    GEN     addir_sign(GEN x, long sx, GEN y, long sy)
    GEN     addrr_sign(GEN x, long sx, GEN y, long sy)
    GEN     addsi_sign(long x, GEN y, long sy)
    GEN     addui_sign(ulong x, GEN y, long sy)
    GEN     addsr(long x, GEN y)
    GEN     addumului(ulong a, ulong b, GEN Y)
    void    affir(GEN x, GEN y)
    void    affrr(GEN x, GEN y)
    GEN     bezout(GEN a, GEN b, GEN *u, GEN *v)
    long    cbezout(long a, long b, long *uu, long *vv)
    GEN     cbrtr_abs(GEN x)
    int     cmpii(GEN x, GEN y)
    int     cmprr(GEN x, GEN y)
    long    dblexpo(double x)
    ulong   dblmantissa(double x)
    GEN     dbltor(double x)
    GEN     diviiexact(GEN x, GEN y)
    GEN     divir(GEN x, GEN y)
    GEN     divis(GEN y, long x)
    GEN     divis_rem(GEN x, long y, long *rem)
    GEN     diviu_rem(GEN y, ulong x, ulong *rem)
    GEN     diviuuexact(GEN x, ulong y, ulong z)
    GEN     diviuexact(GEN x, ulong y)
    GEN     divri(GEN x, GEN y)
    GEN     divrr(GEN x, GEN y)
    GEN     divrs(GEN x, long y)
    GEN     divru(GEN x, ulong y)
    GEN     divsi(long x, GEN y)
    GEN     divsr(long x, GEN y)
    GEN     divur(ulong x, GEN y)
    GEN     dvmdii(GEN x, GEN y, GEN *z)
    int     equalii(GEN x, GEN y)
    int     equalrr(GEN x, GEN y)
    GEN     floorr(GEN x)
    GEN     gcdii(GEN x, GEN y)
    GEN     int2n(long n)
    GEN     int2u(ulong n)
    GEN     int_normalize(GEN x, long known_zero_words)
    int     invmod(GEN a, GEN b, GEN *res)
    ulong   invmod2BIL(ulong b)
    GEN     invr(GEN b)
    GEN     mantissa_real(GEN x, long *e)
    GEN     modii(GEN x, GEN y)
    void    modiiz(GEN x, GEN y, GEN z)
    GEN     mulii(GEN x, GEN y)
    GEN     mulir(GEN x, GEN y)
    GEN     mulrr(GEN x, GEN y)
    GEN     mulsi(long x, GEN y)
    GEN     mulsr(long x, GEN y)
    GEN     mulss(long x, long y)
    GEN     mului(ulong x, GEN y)
    GEN     mulur(ulong x, GEN y)
    GEN     muluu(ulong x, ulong y)
    GEN     muluui(ulong x, ulong y, GEN z)
    GEN     remi2n(GEN x, long n)
    double  rtodbl(GEN x)
    GEN     shifti(GEN x, long n)
    GEN     sqri(GEN x)
    GEN     sqrr(GEN x)
    GEN     sqrs(long x)
    GEN     sqrtr_abs(GEN x)
    GEN     sqrtremi(GEN S, GEN *R)
    GEN     sqru(ulong x)
    GEN     subsr(long x, GEN y)
    GEN     truedvmdii(GEN x, GEN y, GEN *z)
    GEN     truedvmdis(GEN x, long y, GEN *z)
    GEN     truedvmdsi(long x, GEN y, GEN *z)
    GEN     trunc2nr(GEN x, long n)
    GEN     mantissa2nr(GEN x, long n)
    GEN     truncr(GEN x)
    ulong   umodiu(GEN y, ulong x)
    long    vals(ulong x)

    # nffactor.c

    GEN     FpC_ratlift(GEN P, GEN mod, GEN amax, GEN bmax, GEN denom)
    GEN     FpM_ratlift(GEN M, GEN mod, GEN amax, GEN bmax, GEN denom)
    GEN     FpX_ratlift(GEN P, GEN mod, GEN amax, GEN bmax, GEN denom)
    GEN     nffactor(GEN nf, GEN x)
    GEN     nffactormod(GEN nf, GEN pol, GEN pr)
    GEN     nfgcd(GEN P, GEN Q, GEN nf, GEN den)
    GEN     nfgcd_all(GEN P, GEN Q, GEN T, GEN den, GEN *Pnew)
    int     nfissquarefree(GEN nf, GEN x)
    GEN     nfroots(GEN nf, GEN pol)
    GEN     polfnf(GEN a, GEN t)
    GEN     rootsof1(GEN x)
    GEN     rootsof1_kannan(GEN nf)

    # paricfg.c

    extern const char *paricfg_datadir
    extern const char *paricfg_version
    extern const char *paricfg_buildinfo
    extern const long  paricfg_version_code
    extern const char *paricfg_vcsversion
    extern const char *paricfg_compiledate
    extern const char *paricfg_mt_engine

    # part.c

    void    forpart(void *E, long call(void*, GEN), long k, GEN nbound, GEN abound)
    void    forpart_init(forpart_t *T, long k, GEN abound, GEN nbound)
    GEN     forpart_next(forpart_t *T)
    GEN     forpart_prev(forpart_t *T)
    GEN     numbpart(GEN x)
    GEN     partitions(long k, GEN nbound, GEN abound)

    # perm.c

    GEN     abelian_group(GEN G)
    GEN     cyclicgroup(GEN g, long s)
    GEN     cyc_pow(GEN cyc, long exp)
    GEN     cyc_pow_perm(GEN cyc, long exp)
    GEN     dicyclicgroup(GEN g1, GEN g2, long s1, long s2)
    GEN     group_abelianHNF(GEN G, GEN L)
    GEN     group_abelianSNF(GEN G, GEN L)
    long    group_domain(GEN G)
    GEN     group_elts(GEN G, long n)
    GEN     group_export(GEN G, long format)
    long    group_isA4S4(GEN G)
    long    group_isabelian(GEN G)
    GEN     group_leftcoset(GEN G, GEN g)
    long    group_order(GEN G)
    long    group_perm_normalize(GEN N, GEN g)
    GEN     group_quotient(GEN G, GEN H)
    GEN     group_rightcoset(GEN G, GEN g)
    GEN     group_set(GEN G, long n)
    long    group_subgroup_isnormal(GEN G, GEN H)
    GEN     group_subgroups(GEN G)
    GEN     groupelts_abelian_group(GEN S)
    GEN     groupelts_center(GEN S)
    GEN     groupelts_set(GEN G, long n)
    int     perm_commute(GEN p, GEN q)
    GEN     perm_cycles(GEN v)
    long    perm_order(GEN perm)
    GEN     perm_pow(GEN perm, long exp)
    GEN     quotient_group(GEN C, GEN G)
    GEN     quotient_perm(GEN C, GEN p)
    GEN     quotient_subgroup_lift(GEN C, GEN H, GEN S)
    GEN     subgroups_tableset(GEN S, long n)
    long    tableset_find_index(GEN tbl, GEN set)
    GEN     trivialgroup()
    GEN     vecperm_orbits(GEN v, long n)
    GEN     vec_insert(GEN v, long n, GEN x)
    int     vec_is1to1(GEN v)
    int     vec_isconst(GEN v)
    long    vecsmall_duplicate(GEN x)
    long    vecsmall_duplicate_sorted(GEN x)
    GEN     vecsmall_indexsort(GEN V)
    void    vecsmall_sort(GEN V)
    GEN     vecsmall_uniq(GEN V)
    GEN     vecsmall_uniq_sorted(GEN V)
    GEN     vecvecsmall_indexsort(GEN x)
    long    vecvecsmall_search(GEN x, GEN y, long flag)
    GEN     vecvecsmall_sort(GEN x)
    GEN     vecvecsmall_sort_uniq(GEN x)

    # mt.c

    void    mt_broadcast(GEN code)
    void    mt_sigint_block()
    void    mt_sigint_unblock()
    void    mt_queue_end(pari_mt *pt)
    GEN     mt_queue_get(pari_mt *pt, long *jobid, long *pending)
    void    mt_queue_start(pari_mt *pt, GEN worker)
    void    mt_queue_submit(pari_mt *pt, long jobid, GEN work)
    void    pari_mt_init()
    void    pari_mt_close()

    # plotport.c

    void    color_to_rgb(GEN c, int *r, int *g, int *b)
    void    colorname_to_rgb(const char *s, int *r, int *g, int *b)
    void    pari_plot_by_file(const char *env, const char *suf, const char *img)
    void    pari_set_plot_engine(void (*plot)(PARI_plot *))
    void    pari_kill_plot_engine()
    void    plotbox(long ne, GEN gx2, GEN gy2)
    void    plotclip(long rect)
    void    plotcolor(long ne, long color)
    void    plotcopy(long source, long dest, GEN xoff, GEN yoff, long flag)
    GEN     plotcursor(long ne)
    void    plotdraw(GEN list, long flag)
    GEN     ploth(void *E, GEN(*f)(void*, GEN), GEN a, GEN b, long flags, long n, long prec)
    GEN     plothraw(GEN listx, GEN listy, long flag)
    GEN     plothsizes(long flag)
    void    plotinit(long ne, GEN x, GEN y, long flag)
    void    plotkill(long ne)
    void    plotline(long ne, GEN gx2, GEN gy2)
    void    plotlines(long ne, GEN listx, GEN listy, long flag)
    void    plotlinetype(long ne, long t)
    void    plotmove(long ne, GEN x, GEN y)
    void    plotpoints(long ne, GEN listx, GEN listy)
    void    plotpointsize(long ne, GEN size)
    void    plotpointtype(long ne, long t)
    void    plotrbox(long ne, GEN x2, GEN y2)
    GEN     plotrecth(void *E, GEN(*f)(void*, GEN), long ne, GEN a, GEN b, ulong flags, long n, long prec)
    GEN     plotrecthraw(long ne, GEN data, long flags)
    void    plotrline(long ne, GEN x2, GEN y2)
    void    plotrmove(long ne, GEN x, GEN y)
    void    plotrpoint(long ne, GEN x, GEN y)
    void    plotscale(long ne, GEN x1, GEN x2, GEN y1, GEN y2)
    void    plotstring(long ne, char *x, long dir)
    void    psdraw(GEN list, long flag)
    GEN     psploth(void *E, GEN(*f)(void*, GEN), GEN a, GEN b, long flags, long n, long prec)
    GEN     psplothraw(GEN listx, GEN listy, long flag)
    char*   rect2ps(GEN w, GEN x, GEN y, PARI_plot *T)
    char*   rect2ps_i(GEN w, GEN x, GEN y, PARI_plot *T, int plotps)
    char*   rect2svg(GEN w, GEN x, GEN y, PARI_plot *T)

    # polarit1.c

    GEN     ZX_Zp_root(GEN f, GEN a, GEN p, long prec)
    GEN     Zp_appr(GEN f, GEN a)
    GEN     factorpadic(GEN x, GEN p, long r)
    GEN     gdeuc(GEN x, GEN y)
    GEN     grem(GEN x, GEN y)
    GEN     padicappr(GEN f, GEN a)
    GEN     poldivrem(GEN x, GEN y, GEN *pr)
    GEN     rootpadic(GEN f, GEN p, long r)

    # polarit2.c

    GEN     FpV_factorback(GEN L, GEN e, GEN p)
    GEN     Q_content(GEN x)
    GEN     Q_denom(GEN x)
    GEN     Q_div_to_int(GEN x, GEN c)
    GEN     Q_gcd(GEN x, GEN y)
    GEN     Q_mul_to_int(GEN x, GEN c)
    GEN     Q_muli_to_int(GEN x, GEN d)
    GEN     Q_primitive_part(GEN x, GEN *ptc)
    GEN     Q_primpart(GEN x)
    GEN     Q_remove_denom(GEN x, GEN *ptd)
    GEN     RgXQ_charpoly(GEN x, GEN T, long v)
    GEN     RgXQ_inv(GEN x, GEN y)
    GEN     RgX_disc(GEN x)
    GEN     RgX_extgcd(GEN x, GEN y, GEN *U, GEN *V)
    GEN     RgX_extgcd_simple(GEN a, GEN b, GEN *pu, GEN *pv)
    GEN     RgX_gcd(GEN x, GEN y)
    GEN     RgX_gcd_simple(GEN x, GEN y)
    int     RgXQ_ratlift(GEN y, GEN x, long amax, long bmax, GEN *P, GEN *Q)
    GEN     RgX_resultant_all(GEN P, GEN Q, GEN *sol)
    long    RgX_sturmpart(GEN x, GEN ab)
    long    RgX_type(GEN x, GEN *ptp, GEN *ptpol, long *ptpa)
    void    RgX_type_decode(long x, long *t1, long *t2)
    int     RgX_type_is_composite(long t)
    GEN     ZX_content(GEN x)
    GEN     centermod(GEN x, GEN p)
    GEN     centermod_i(GEN x, GEN p, GEN ps2)
    GEN     centermodii(GEN x, GEN p, GEN po2)
    GEN     content(GEN x)
    GEN     deg1_from_roots(GEN L, long v)
    GEN     factor(GEN x)
    GEN     factor0(GEN x, long flag)
    GEN     factorback(GEN fa)
    GEN     factorback2(GEN fa, GEN e)
    GEN     famat_mul_shallow(GEN f, GEN g)
    GEN     gbezout(GEN x, GEN y, GEN *u, GEN *v)
    GEN     gdivexact(GEN x, GEN y)
    GEN     gen_factorback(GEN L, GEN e, GEN (*_mul)(void*, GEN, GEN), GEN (*_pow)(void*, GEN, GEN), void *data)
    GEN     ggcd(GEN x, GEN y)
    GEN     ggcd0(GEN x, GEN y)
    GEN     ginvmod(GEN x, GEN y)
    GEN     glcm(GEN x, GEN y)
    GEN     glcm0(GEN x, GEN y)
    GEN     gp_factor0(GEN x, GEN flag)
    GEN     idealfactorback(GEN nf, GEN L, GEN e, int red)
    long    polisirreducible(GEN x)
    GEN     newtonpoly(GEN x, GEN p)
    GEN     nffactorback(GEN nf, GEN L, GEN e)
    GEN     nfrootsQ(GEN x)
    GEN     poldisc0(GEN x, long v)
    GEN     polresultant0(GEN x, GEN y, long v, long flag)
    GEN     polsym(GEN x, long n)
    GEN     primitive_part(GEN x, GEN *c)
    GEN     primpart(GEN x)
    GEN     reduceddiscsmith(GEN pol)
    GEN     resultant2(GEN x, GEN y)
    GEN     resultant_all(GEN u, GEN v, GEN *sol)
    GEN     rnfcharpoly(GEN nf, GEN T, GEN alpha, long v)
    GEN     roots_from_deg1(GEN x)
    GEN     roots_to_pol(GEN a, long v)
    GEN     roots_to_pol_r1(GEN a, long v, long r1)
    long    sturmpart(GEN x, GEN a, GEN b)
    GEN     subresext(GEN x, GEN y, GEN *U, GEN *V)
    GEN     sylvestermatrix(GEN x, GEN y)
    GEN     trivial_fact()
    GEN     gcdext0(GEN x, GEN y)
    GEN     polresultantext0(GEN x, GEN y, long v)
    GEN     polresultantext(GEN x, GEN y)
    GEN     prime_fact(GEN x)

    # polarit3.c

    GEN     Flx_FlxY_resultant(GEN a, GEN b, ulong pp)
    GEN     Flx_factorff_irred(GEN P, GEN Q, ulong p)
    void    Flx_ffintersect(GEN P, GEN Q, long n, ulong l, GEN *SP, GEN *SQ, GEN MA, GEN MB)
    GEN     Flx_ffisom(GEN P, GEN Q, ulong l)
    GEN     Flx_roots_naive(GEN f, ulong p)
    GEN     FlxX_resultant(GEN u, GEN v, ulong p, long sx)
    GEN     Flxq_ffisom_inv(GEN S, GEN Tp, ulong p)
    GEN     FpX_FpXY_resultant(GEN a, GEN b0, GEN p)
    GEN     FpX_factorff_irred(GEN P, GEN Q, GEN p)
    void    FpX_ffintersect(GEN P, GEN Q, long n, GEN l, GEN *SP, GEN *SQ, GEN MA, GEN MB)
    GEN     FpX_ffisom(GEN P, GEN Q, GEN l)
    GEN     FpX_translate(GEN P, GEN c, GEN p)
    GEN     FpXQ_ffisom_inv(GEN S, GEN Tp, GEN p)
    GEN     FpXQX_normalize(GEN z, GEN T, GEN p)
    GEN     FpXV_FpC_mul(GEN V, GEN W, GEN p)
    GEN     FpXY_Fq_evaly(GEN Q, GEN y, GEN T, GEN p, long vx)
    GEN     Fq_Fp_mul(GEN x, GEN y, GEN T, GEN p)
    GEN     Fq_add(GEN x, GEN y, GEN T, GEN p)
    GEN     Fq_div(GEN x, GEN y, GEN T, GEN p)
    GEN     Fq_halve(GEN x, GEN T, GEN p)
    GEN     Fq_inv(GEN x, GEN T, GEN p)
    GEN     Fq_invsafe(GEN x, GEN T, GEN p)
    GEN     Fq_mul(GEN x, GEN y, GEN T, GEN p)
    GEN     Fq_mulu(GEN x, ulong y, GEN T, GEN p)
    GEN     Fq_neg(GEN x, GEN T, GEN p)
    GEN     Fq_neg_inv(GEN x, GEN T, GEN p)
    GEN     Fq_pow(GEN x, GEN n, GEN T, GEN p)
    GEN     Fq_powu(GEN x, ulong n, GEN pol, GEN p)
    GEN     Fq_sub(GEN x, GEN y, GEN T, GEN p)
    GEN     Fq_sqr(GEN x, GEN T, GEN p)
    GEN     Fq_sqrt(GEN x, GEN T, GEN p)
    GEN     Fq_sqrtn(GEN x, GEN n, GEN T, GEN p, GEN *zeta)
    GEN     FqC_add(GEN x, GEN y, GEN T, GEN p)
    GEN     FqC_sub(GEN x, GEN y, GEN T, GEN p)
    GEN     FqC_Fq_mul(GEN x, GEN y, GEN T, GEN p)
    GEN     FqC_to_FlxC(GEN v, GEN T, GEN pp)
    GEN     FqM_to_FlxM(GEN x, GEN T, GEN pp)
    GEN     FqV_roots_to_pol(GEN V, GEN T, GEN p, long v)
    GEN     FqV_red(GEN z, GEN T, GEN p)
    GEN     FqV_to_FlxV(GEN v, GEN T, GEN pp)
    GEN     FqX_Fq_add(GEN y, GEN x, GEN T, GEN p)
    GEN     FqX_Fq_mul_to_monic(GEN P, GEN U, GEN T, GEN p)
    GEN     FqX_eval(GEN x, GEN y, GEN T, GEN p)
    GEN     FqX_translate(GEN P, GEN c, GEN T, GEN p)
    GEN     FqXQ_powers(GEN x, long l, GEN S, GEN T, GEN p)
    GEN     FqXQ_matrix_pow(GEN y, long n, long m, GEN S, GEN T, GEN p)
    GEN     FqXY_eval(GEN Q, GEN y, GEN x, GEN T, GEN p)
    GEN     FqXY_evalx(GEN Q, GEN x, GEN T, GEN p)
    GEN     QX_disc(GEN x)
    GEN     QX_gcd(GEN a, GEN b)
    GEN     QX_resultant(GEN A, GEN B)
    GEN     QXQ_intnorm(GEN A, GEN B)
    GEN     QXQ_inv(GEN A, GEN B)
    GEN     QXQ_norm(GEN A, GEN B)
    int     Rg_is_Fp(GEN x, GEN *p)
    int     Rg_is_FpXQ(GEN x, GEN *pT, GEN *pp)
    GEN     Rg_to_Fp(GEN x, GEN p)
    GEN     Rg_to_FpXQ(GEN x, GEN T, GEN p)
    GEN     RgC_to_FpC(GEN x, GEN p)
    int     RgM_is_FpM(GEN x, GEN *p)
    GEN     RgM_to_Flm(GEN x, ulong p)
    GEN     RgM_to_FpM(GEN x, GEN p)
    int     RgV_is_FpV(GEN x, GEN *p)
    GEN     RgV_to_Flv(GEN x, ulong p)
    GEN     RgV_to_FpV(GEN x, GEN p)
    int     RgX_is_FpX(GEN x, GEN *p)
    GEN     RgX_to_FpX(GEN x, GEN p)
    int     RgX_is_FpXQX(GEN x, GEN *pT, GEN *pp)
    GEN     RgX_to_FpXQX(GEN x, GEN T, GEN p)
    GEN     RgX_to_FqX(GEN x, GEN T, GEN p)
    GEN     ZX_ZXY_rnfequation(GEN A, GEN B, long *Lambda)
    GEN     ZXQ_charpoly(GEN A, GEN T, long v)
    GEN     ZX_disc(GEN x)
    int     ZX_is_squarefree(GEN x)
    GEN     ZX_gcd(GEN A, GEN B)
    GEN     ZX_gcd_all(GEN A, GEN B, GEN *Anew)
    GEN     ZX_resultant(GEN A, GEN B)
    int     Z_incremental_CRT(GEN *H, ulong Hp, GEN *q, ulong p)
    GEN     Z_init_CRT(ulong Hp, ulong p)
    int     ZM_incremental_CRT(GEN *H, GEN Hp, GEN *q, ulong p)
    GEN     ZM_init_CRT(GEN Hp, ulong p)
    int     ZX_incremental_CRT(GEN *ptH, GEN Hp, GEN *q, ulong p)
    GEN     ZX_init_CRT(GEN Hp, ulong p, long v)
    GEN     characteristic(GEN x)
    GEN     ffinit(GEN p, long n, long v)
    GEN     ffnbirred(GEN p, long n)
    GEN     ffnbirred0(GEN p, long n, long flag)
    GEN     ffsumnbirred(GEN p, long n)
    const bb_field *get_Fq_field(void **E, GEN T, GEN p)
    GEN     init_Fq(GEN p, long n, long v)
    GEN     pol_x_powers(long N, long v)
    GEN     residual_characteristic(GEN x)

    # polclass.c

    GEN     polclass(GEN D, long inv, long xvar)

    # polmodular.c

    GEN     Flm_Fl_polmodular_evalx(GEN phi, long L, ulong j, ulong p, ulong pi)
    GEN     Fp_polmodular_evalx(long L, long inv, GEN J, GEN P, long v, int compute_derivs)
    GEN     polmodular(long L, long inv, GEN x, long yvar, long compute_derivs)
    GEN     polmodular_ZM(long L, long inv)
    GEN     polmodular_ZXX(long L, long inv, long xvar, long yvar)

    # prime.c

    long    BPSW_isprime(GEN x)
    long    BPSW_psp(GEN N)
    GEN     addprimes(GEN primes)
    GEN     gisprime(GEN x, long flag)
    GEN     gispseudoprime(GEN x, long flag)
    GEN     gprimepi_upper_bound(GEN x)
    GEN     gprimepi_lower_bound(GEN x)
    long    isprime(GEN x)
    long    ispseudoprime(GEN x, long flag)
    long    millerrabin(GEN n, long k)
    GEN     prime(long n)
    GEN     primepi(GEN x)
    double  primepi_upper_bound(double x)
    double  primepi_lower_bound(double x)
    GEN     primes(long n)
    GEN     primes_interval(GEN a, GEN b)
    GEN     primes_interval_zv(ulong a, ulong b)
    GEN     primes_upto_zv(ulong b)
    GEN     primes0(GEN n)
    GEN     primes_zv(long m)
    GEN     randomprime(GEN N)
    GEN     removeprimes(GEN primes)
    int     uislucaspsp(ulong n)
    int     uisprime(ulong n)
    ulong   uprime(long n)
    ulong   uprimepi(ulong n)

    # qfisom.c

    GEN     qfauto(GEN g, GEN flags)
    GEN     qfauto0(GEN g, GEN flags)
    GEN     qfautoexport(GEN g, long flag)
    GEN     qfisom(GEN g, GEN h, GEN flags)
    GEN     qfisom0(GEN g, GEN h, GEN flags)
    GEN     qfisominit(GEN g, GEN flags, GEN minvec)
    GEN     qfisominit0(GEN g, GEN flags, GEN minvec)
    GEN     qforbits(GEN G, GEN V)

    # qfparam.c

    GEN     qfsolve(GEN G)
    GEN     qfparam(GEN G, GEN sol, long fl)

    # random.c

    GEN     genrand(GEN N)
    GEN     getrand()
    ulong   pari_rand()
    GEN     randomi(GEN x)
    GEN     randomr(long prec)
    ulong   random_Fl(ulong n)
    long    random_bits(long k)
    void    setrand(GEN seed)

    # rootpol.c

    GEN     QX_complex_roots(GEN p, long l)
    GEN     ZX_graeffe(GEN p)
    GEN     cleanroots(GEN x, long l)
    double  fujiwara_bound(GEN p)
    double  fujiwara_bound_real(GEN p, long sign)
    int     isrealappr(GEN x, long l)
    GEN     polgraeffe(GEN p)
    GEN     polmod_to_embed(GEN x, long prec)
    GEN     roots(GEN x, long l)
    GEN     realroots(GEN P, GEN ab, long prec)
    long    ZX_sturm(GEN P)
    long    ZX_sturmpart(GEN P, GEN ab)
    GEN     ZX_Uspensky(GEN P, GEN ab, long flag, long prec)

    # subcyclo.c

    GEN     factor_Aurifeuille(GEN p, long n)
    GEN     factor_Aurifeuille_prime(GEN p, long n)
    GEN     galoissubcyclo(GEN N, GEN sg, long flag, long v)
    GEN     polsubcyclo(long n, long d, long v)

    # subfield.c

    GEN     nfsubfields(GEN nf, long d)

    # subgroup.c

    GEN     subgrouplist(GEN cyc, GEN bound)
    void    forsubgroup(void *E, long fun(void*, GEN), GEN cyc, GEN B)

    # stark.c

    GEN     bnrL1(GEN bnr, GEN sbgrp, long flag, long prec)
    GEN     bnrrootnumber(GEN bnr, GEN chi, long flag, long prec)
    GEN     bnrstark(GEN bnr, GEN subgroup, long prec)
    GEN     cyc2elts(GEN cyc)

    # sumiter.c

    GEN     asympnum(void *E, GEN (*f)(void *, GEN, long), long muli, GEN alpha, long prec)
    GEN     derivnum(void *E, GEN (*eval)(void *, GEN, long prec), GEN x, long prec)
    GEN     derivfun(void *E, GEN (*eval)(void *, GEN, long prec), GEN x, long prec)
    int     forcomposite_init(forcomposite_t *C, GEN a, GEN b)
    GEN     forcomposite_next(forcomposite_t *C)
    GEN     forprime_next(forprime_t *T)
    int     forprime_init(forprime_t *T, GEN a, GEN b)
    int     forvec_init(forvec_t *T, GEN x, long flag)
    GEN     forvec_next(forvec_t *T)
    GEN     limitnum(void *E, GEN (*f)(void *, GEN, long), long muli, GEN alpha, long prec)
    GEN     polzag(long n, long m)
    GEN     prodeuler(void *E, GEN (*eval)(void *, GEN), GEN ga, GEN gb, long prec)
    GEN     prodinf(void *E, GEN (*eval)(void *, GEN), GEN a, long prec)
    GEN     prodinf1(void *E, GEN (*eval)(void *, GEN), GEN a, long prec)
    GEN     sumalt(void *E, GEN (*eval)(void *, GEN), GEN a, long prec)
    GEN     sumalt2(void *E, GEN (*eval)(void *, GEN), GEN a, long prec)
    GEN     sumpos(void *E, GEN (*eval)(void *, GEN), GEN a, long prec)
    GEN     sumpos2(void *E, GEN (*eval)(void *, GEN), GEN a, long prec)
    GEN     suminf(void *E, GEN (*eval)(void *, GEN), GEN a, long prec)
    ulong   u_forprime_next(forprime_t *T)
    int     u_forprime_init(forprime_t *T, ulong a, ulong b)
    void    u_forprime_restrict(forprime_t *T, ulong c)
    int     u_forprime_arith_init(forprime_t *T, ulong a, ulong b, ulong c, ulong q)
    GEN     zbrent(void *E, GEN (*eval)(void *, GEN), GEN a, GEN b, long prec)
    GEN     solvestep(void *E, GEN (*eval)(void *, GEN), GEN a, GEN b, GEN step, long flag, long prec)

    # thue.c

    GEN     bnfisintnorm(GEN x, GEN y)
    GEN     bnfisintnormabs(GEN bnf, GEN a)
    GEN     thue(GEN thueres, GEN rhs, GEN ne)
    GEN     thueinit(GEN pol, long flag, long prec)

    # trans1.c

    GEN     Pi2n(long n, long prec)
    GEN     PiI2(long prec)
    GEN     PiI2n(long n, long prec)
    GEN     Qp_exp(GEN x)
    GEN     Qp_log(GEN x)
    GEN     Qp_sqrt(GEN x)
    GEN     Qp_sqrtn(GEN x, GEN n, GEN *zetan)
    long    Zn_ispower(GEN a, GEN q, GEN K, GEN *pt)
    long    Zn_issquare(GEN x, GEN n)
    GEN     Zn_sqrt(GEN x, GEN n)
    GEN     Zp_teichmuller(GEN x, GEN p, long n, GEN q)
    GEN     agm(GEN x, GEN y, long prec)
    GEN     constcatalan(long prec)
    GEN     consteuler(long prec)
    GEN     constlog2(long prec)
    GEN     constpi(long prec)
    GEN     cxexpm1(GEN z, long prec)
    GEN     expIr(GEN x)
    GEN     exp1r_abs(GEN x)
    GEN     gcos(GEN x, long prec)
    GEN     gcotan(GEN x, long prec)
    GEN     gcotanh(GEN x, long prec)
    GEN     gexp(GEN x, long prec)
    GEN     gexpm1(GEN x, long prec)
    GEN     glog(GEN x, long prec)
    GEN     gpow(GEN x, GEN n, long prec)
    GEN     gpowers(GEN x, long n)
    GEN     gpowers0(GEN x, long n, GEN x0)
    GEN     gpowgs(GEN x, long n)
    GEN     grootsof1(long N, long prec)
    GEN     gsin(GEN x, long prec)
    GEN     gsinc(GEN x, long prec)
    void    gsincos(GEN x, GEN *s, GEN *c, long prec)
    GEN     gsqrpowers(GEN q, long n)
    GEN     gsqrt(GEN x, long prec)
    GEN     gsqrtn(GEN x, GEN n, GEN *zetan, long prec)
    GEN     gtan(GEN x, long prec)
    GEN     logr_abs(GEN x)
    GEN     mpcos(GEN x)
    GEN     mpeuler(long prec)
    GEN     mpcatalan(long prec)
    void    mpsincosm1(GEN x, GEN *s, GEN *c)
    GEN     mpexp(GEN x)
    GEN     mpexpm1(GEN x)
    GEN     mplog(GEN x)
    GEN     mplog2(long prec)
    GEN     mppi(long prec)
    GEN     mpsin(GEN x)
    void    mpsincos(GEN x, GEN *s, GEN *c)
    GEN     powersr(GEN a, long n)
    GEN     powis(GEN x, long n)
    GEN     powiu(GEN p, ulong k)
    GEN     powrfrac(GEN x, long n, long d)
    GEN     powrs(GEN x, long n)
    GEN     powrshalf(GEN x, long s)
    GEN     powru(GEN x, ulong n)
    GEN     powruhalf(GEN x, ulong s)
    GEN     powuu(ulong p, ulong k)
    GEN     powgi(GEN x, GEN n)
    GEN     serchop0(GEN s)
    GEN     sqrtnint(GEN a, long n)
    GEN     teich(GEN x)
    GEN     teichmullerinit(long p, long n)
    GEN     teichmuller(GEN x, GEN tab)
    GEN     trans_eval(const char *fun, GEN (*f) (GEN, long), GEN x, long prec)
    ulong   upowuu(ulong p, ulong k)
    ulong   usqrtn(ulong a, ulong n)
    ulong   usqrt(ulong a)

    # trans2.c

    GEN     Qp_gamma(GEN x)
    GEN     bernfrac(long n)
    GEN     bernpol(long k, long v)
    GEN     bernreal(long n, long prec)
    GEN     gacosh(GEN x, long prec)
    GEN     gacos(GEN x, long prec)
    GEN     garg(GEN x, long prec)
    GEN     gasinh(GEN x, long prec)
    GEN     gasin(GEN x, long prec)
    GEN     gatan(GEN x, long prec)
    GEN     gatanh(GEN x, long prec)
    GEN     gcosh(GEN x, long prec)
    GEN     ggammah(GEN x, long prec)
    GEN     ggamma(GEN x, long prec)
    GEN     ggamma1m1(GEN x, long prec)
    GEN     glngamma(GEN x, long prec)
    GEN     gpsi(GEN x, long prec)
    GEN     gsinh(GEN x, long prec)
    GEN     gtanh(GEN x, long prec)
    GEN     mpfactr(long n, long prec)
    GEN     sumformal(GEN T, long v)

    # trans3.c

    double  dblmodulus(GEN x)
    GEN     dilog(GEN x, long prec)
    GEN     eint1(GEN x, long prec)
    GEN     eta(GEN x, long prec)
    GEN     eta0(GEN x, long flag, long prec)
    GEN     gerfc(GEN x, long prec)
    GEN     glambertW(GEN y, long prec)
    GEN     gpolylog(long m, GEN x, long prec)
    GEN     gzeta(GEN x, long prec)
    GEN     hbessel1(GEN n, GEN z, long prec)
    GEN     hbessel2(GEN n, GEN z, long prec)
    GEN     hyperu(GEN a, GEN b, GEN gx, long prec)
    GEN     ibessel(GEN n, GEN z, long prec)
    GEN     incgam(GEN a, GEN x, long prec)
    GEN     incgam0(GEN a, GEN x, GEN z, long prec)
    GEN     incgamc(GEN a, GEN x, long prec)
    GEN     jbessel(GEN n, GEN z, long prec)
    GEN     jbesselh(GEN n, GEN z, long prec)
    GEN     jell(GEN x, long prec)
    GEN     kbessel(GEN nu, GEN gx, long prec)
    GEN     mpeint1(GEN x, GEN expx)
    GEN     mplambertW(GEN y)
    GEN     mpveceint1(GEN C, GEN eC, long n)
    GEN     nbessel(GEN n, GEN z, long prec)
    GEN     polylog0(long m, GEN x, long flag, long prec)
    GEN     sumdedekind(GEN h, GEN k)
    GEN     sumdedekind_coprime(GEN h, GEN k)
    GEN     szeta(long x, long prec)
    GEN     theta(GEN q, GEN z, long prec)
    GEN     thetanullk(GEN q, long k, long prec)
    GEN     trueeta(GEN x, long prec)
    GEN     u_sumdedekind_coprime(long h, long k)
    GEN     veceint1(GEN nmax, GEN C, long prec)
    GEN     vecthetanullk(GEN q, long k, long prec)
    GEN     vecthetanullk_tau(GEN tau, long k, long prec)
    GEN     veczeta(GEN a, GEN b, long N, long prec)
    GEN     weber0(GEN x, long flag, long prec)
    GEN     weberf(GEN x, long prec)
    GEN     weberf1(GEN x, long prec)
    GEN     weberf2(GEN x, long prec)

    # modsym.c
    GEN     Qevproj_apply(GEN T, GEN pro)
    GEN     Qevproj_apply_vecei(GEN T, GEN pro, long k)
    GEN     Qevproj_init(GEN M)
    GEN     RgX_act_Gl2Q(GEN g, long k)
    GEN     RgX_act_ZGl2Q(GEN z, long k)
    void    checkms(GEN W)
    void    checkmspadic(GEN W)
    GEN     ellpadicL(GEN E, GEN p, long n, GEN s, long r, GEN D)
    GEN     msfromcusp(GEN W, GEN c)
    GEN     msfromell(GEN E, long signe)
    GEN     msfromhecke(GEN W, GEN v, GEN H)
    long    msgetlevel(GEN W)
    long    msgetsign(GEN W)
    long    msgetweight(GEN W)
    GEN     msatkinlehner(GEN W, long Q, GEN)
    GEN     mscuspidal(GEN W, long flag)
    GEN     mseisenstein(GEN W)
    GEN     mseval(GEN W, GEN s, GEN p)
    GEN     mshecke(GEN W, long p, GEN H)
    GEN     msinit(GEN N, GEN k, long sign)
    long    msissymbol(GEN W, GEN s)
    GEN     msomseval(GEN W, GEN phi, GEN path)
    GEN     mspadicinit(GEN W, long p, long n, long flag)
    GEN     mspadicL(GEN oms, GEN s, long r)
    GEN     mspadicmoments(GEN W, GEN phi, long D)
    GEN     mspadicseries(GEN M, long teichi)
    GEN     mspathgens(GEN W)
    GEN     mspathlog(GEN W, GEN path)
    GEN     msnew(GEN W)
    GEN     msstar(GEN W, GEN)
    GEN     msqexpansion(GEN W, GEN proV, ulong B)
    GEN     mssplit(GEN W, GEN H, long deglim)
    GEN     mstooms(GEN W, GEN phi)

    # zetamult.c
    GEN zetamult(GEN avec, long prec)

    # level1.h

    ulong  Fl_add(ulong a, ulong b, ulong p)
    ulong  Fl_addmul_pre(ulong x0, ulong x1, ulong y0, ulong p, ulong pi)
    ulong  Fl_addmulmul_pre(ulong x0, ulong y0, ulong x1, ulong y1, ulong p, ulong pi)
    long   Fl_center(ulong u, ulong p, ulong ps2)
    ulong  Fl_div(ulong a, ulong b, ulong p)
    ulong  Fl_double(ulong a, ulong p)
    ulong  Fl_ellj_pre(ulong a4, ulong a6, ulong p, ulong pi)
    ulong  Fl_halve(ulong y, ulong p)
    ulong  Fl_mul(ulong a, ulong b, ulong p)
    ulong  Fl_mul_pre(ulong a, ulong b, ulong p, ulong pi)
    ulong  Fl_neg(ulong x, ulong p)
    ulong  Fl_sqr(ulong a, ulong p)
    ulong  Fl_sqr_pre(ulong a, ulong p, ulong pi)
    ulong  Fl_sub(ulong a, ulong b, ulong p)
    ulong  Fl_triple(ulong a, ulong p)
    ulong  Mod2(GEN x)
    ulong  Mod4(GEN x)
    ulong  Mod8(GEN x)
    ulong  Mod16(GEN x)
    ulong  Mod32(GEN x)
    ulong  Mod64(GEN x)
    int    abscmpiu(GEN x, ulong y)
    int    abscmpui(ulong x, GEN y)
    int    absequaliu(GEN x, ulong y)
    GEN    absi(GEN x)
    GEN    absi_shallow(GEN x)
    GEN    absr(GEN x)
    int    absrnz_equal1(GEN x)
    int    absrnz_equal2n(GEN x)
    GEN    addii(GEN x, GEN y)
    void   addiiz(GEN x, GEN y, GEN z)
    GEN    addir(GEN x, GEN y)
    void   addirz(GEN x, GEN y, GEN z)
    GEN    addis(GEN x, long s)
    GEN    addri(GEN x, GEN y)
    void   addriz(GEN x, GEN y, GEN z)
    GEN    addrr(GEN x, GEN y)
    void   addrrz(GEN x, GEN y, GEN z)
    GEN    addrs(GEN x, long s)
    GEN    addsi(long x, GEN y)
    void   addsiz(long s, GEN y, GEN z)
    void   addsrz(long s, GEN y, GEN z)
    GEN    addss(long x, long y)
    void   addssz(long s, long y, GEN z)
    GEN    adduu(ulong x, ulong y)
    void   affgr(GEN x, GEN y)
    void   affii(GEN x, GEN y)
    void   affiz(GEN x, GEN y)
    void   affrr_fixlg(GEN y, GEN z)
    void   affsi(long s, GEN x)
    void   affsr(long s, GEN x)
    void   affsz(long x, GEN y)
    void   affui(ulong s, GEN x)
    void   affur(ulong s, GEN x)
    GEN    cgetg(long x, long y)
    GEN    cgetg_block(long x, long y)
    GEN    cgetg_copy(GEN x, long *plx)
    GEN    cgeti(long x)
    GEN    cgetineg(long x)
    GEN    cgetipos(long x)
    GEN    cgetr(long x)
    GEN    cgetr_block(long prec)
    int    cmpir(GEN x, GEN y)
    int    cmpis(GEN x, long y)
    int    cmpri(GEN x, GEN y)
    int    cmprs(GEN x, long y)
    int    cmpsi(long x, GEN y)
    int    cmpsr(long x, GEN y)
    GEN    cxtofp(GEN x, long prec)
    GEN    divii(GEN a, GEN b)
    void   diviiz(GEN x, GEN y, GEN z)
    void   divirz(GEN x, GEN y, GEN z)
    void   divisz(GEN x, long s, GEN z)
    void   divriz(GEN x, GEN y, GEN z)
    void   divrrz(GEN x, GEN y, GEN z)
    void   divrsz(GEN y, long s, GEN z)
    GEN    divsi_rem(long x, GEN y, long *rem)
    void   divsiz(long x, GEN y, GEN z)
    void   divsrz(long s, GEN y, GEN z)
    GEN    divss(long x, long y)
    GEN    divss_rem(long x, long y, long *rem)
    void   divssz(long x, long y, GEN z)
    int    dvdii(GEN x, GEN y)
    int    dvdiiz(GEN x, GEN y, GEN z)
    int    dvdis(GEN x, long y)
    int    dvdisz(GEN x, long y, GEN z)
    int    dvdiu(GEN x, ulong y)
    int    dvdiuz(GEN x, ulong y, GEN z)
    int    dvdsi(long x, GEN y)
    int    dvdui(ulong x, GEN y)
    void   dvmdiiz(GEN x, GEN y, GEN z, GEN t)
    GEN    dvmdis(GEN x, long y, GEN *z)
    void   dvmdisz(GEN x, long y, GEN z, GEN t)
    long   dvmdsBIL(long n, long *r)
    GEN    dvmdsi(long x, GEN y, GEN *z)
    void   dvmdsiz(long x, GEN y, GEN z, GEN t)
    GEN    dvmdss(long x, long y, GEN *z)
    void   dvmdssz(long x, long y, GEN z, GEN t)
    ulong  dvmduBIL(ulong n, ulong *r)
    int    equalis(GEN x, long y)
    int    equalsi(long x, GEN y)
    int    absequalui(ulong x, GEN y)
    ulong  ceildivuu(ulong a, ulong b)
    long   evalexpo(long x)
    long   evallg(long x)
    long   evalprecp(long x)
    long   evalvalp(long x)
    long   expi(GEN x)
    long   expu(ulong x)
    void   fixlg(GEN z, long ly)
    GEN    fractor(GEN x, long prec)
    GEN    icopy(GEN x)
    GEN    icopyspec(GEN x, long nx)
    GEN    icopy_avma(GEN x, pari_sp av)
    ulong  int_bit(GEN x, long n)
    GEN    itor(GEN x, long prec)
    long   itos(GEN x)
    long   itos_or_0(GEN x)
    ulong  itou(GEN x)
    ulong  itou_or_0(GEN x)
    GEN    leafcopy(GEN x)
    GEN    leafcopy_avma(GEN x, pari_sp av)
    double maxdd(double x, double y)
    long   maxss(long x, long y)
    long   maxuu(ulong x, ulong y)
    double mindd(double x, double y)
    long   minss(long x, long y)
    long   minuu(ulong x, ulong y)
    long   mod16(GEN x)
    long   mod2(GEN x)
    ulong  mod2BIL(GEN x)
    long   mod32(GEN x)
    long   mod4(GEN x)
    long   mod64(GEN x)
    long   mod8(GEN x)
    GEN    modis(GEN x, long y)
    void   modisz(GEN y, long s, GEN z)
    GEN    modsi(long x, GEN y)
    void   modsiz(long s, GEN y, GEN z)
    GEN    modss(long x, long y)
    void   modssz(long s, long y, GEN z)
    GEN    mpabs(GEN x)
    GEN    mpabs_shallow(GEN x)
    GEN    mpadd(GEN x, GEN y)
    void   mpaddz(GEN x, GEN y, GEN z)
    void   mpaff(GEN x, GEN y)
    GEN    mpceil(GEN x)
    int    mpcmp(GEN x, GEN y)
    GEN    mpcopy(GEN x)
    GEN    mpdiv(GEN x, GEN y)
    long   mpexpo(GEN x)
    GEN    mpfloor(GEN x)
    GEN    mpmul(GEN x, GEN y)
    void   mpmulz(GEN x, GEN y, GEN z)
    GEN    mpneg(GEN x)
    int    mpodd(GEN x)
    GEN    mpround(GEN x)
    GEN    mpshift(GEN x, long s)
    GEN    mpsqr(GEN x)
    GEN    mpsub(GEN x, GEN y)
    void   mpsubz(GEN x, GEN y, GEN z)
    GEN    mptrunc(GEN x)
    void   muliiz(GEN x, GEN y, GEN z)
    void   mulirz(GEN x, GEN y, GEN z)
    GEN    mulis(GEN x, long s)
    GEN    muliu(GEN x, ulong s)
    GEN    mulri(GEN x, GEN s)
    void   mulriz(GEN x, GEN y, GEN z)
    void   mulrrz(GEN x, GEN y, GEN z)
    GEN    mulrs(GEN x, long s)
    GEN    mulru(GEN x, ulong s)
    void   mulsiz(long s, GEN y, GEN z)
    void   mulsrz(long s, GEN y, GEN z)
    void   mulssz(long s, long y, GEN z)
    GEN    negi(GEN x)
    GEN    negr(GEN x)
    GEN    new_chunk(size_t x)
    GEN    rcopy(GEN x)
    GEN    rdivii(GEN x, GEN y, long prec)
    void   rdiviiz(GEN x, GEN y, GEN z)
    GEN    rdivis(GEN x, long y, long prec)
    GEN    rdivsi(long x, GEN y, long prec)
    GEN    rdivss(long x, long y, long prec)
    GEN    real2n(long n, long prec)
    GEN    real_m2n(long n, long prec)
    GEN    real_0(long prec)
    GEN    real_0_bit(long bitprec)
    GEN    real_1(long prec)
    GEN    real_1_bit(long bit)
    GEN    real_m1(long prec)
    GEN    remii(GEN a, GEN b)
    void   remiiz(GEN x, GEN y, GEN z)
    GEN    remis(GEN x, long y)
    void   remisz(GEN y, long s, GEN z)
    ulong  remlll_pre(ulong u2, ulong u1, ulong u0, ulong p, ulong pi)
    GEN    remsi(long x, GEN y)
    void   remsiz(long s, GEN y, GEN z)
    GEN    remss(long x, long y)
    void   remssz(long s, long y, GEN z)
    GEN    rtor(GEN x, long prec)
    long   sdivsi(long x, GEN y)
    long   sdivsi_rem(long x, GEN y, long *rem)
    long   sdivss_rem(long x, long y, long *rem)
    ulong  udiviu_rem(GEN n, ulong d, ulong *r)
    ulong  udivuu_rem(ulong x, ulong y, ulong *r)
    ulong  umodi2n(GEN x, long n)
    void   setabssign(GEN x)
    void   shift_left(GEN z2, GEN z1, long min, long M, ulong f, ulong sh)
    void   shift_right(GEN z2, GEN z1, long min, long M, ulong f, ulong sh)
    ulong  shiftl(ulong x, ulong y)
    ulong  shiftlr(ulong x, ulong y)
    GEN    shiftr(GEN x, long n)
    void   shiftr_inplace(GEN z, long d)
    long   smodis(GEN x, long y)
    long   smodss(long x, long y)
    void   stackdummy(pari_sp av, pari_sp ltop)
    char  *stack_malloc(size_t N)
    char  *stack_malloc_align(size_t N, long k)
    char  *stack_calloc(size_t N)
    GEN    stoi(long x)
    GEN    stor(long x, long prec)
    GEN    subii(GEN x, GEN y)
    void   subiiz(GEN x, GEN y, GEN z)
    GEN    subir(GEN x, GEN y)
    void   subirz(GEN x, GEN y, GEN z)
    GEN    subis(GEN x, long y)
    void   subisz(GEN y, long s, GEN z)
    GEN    subri(GEN x, GEN y)
    void   subriz(GEN x, GEN y, GEN z)
    GEN    subrr(GEN x, GEN y)
    void   subrrz(GEN x, GEN y, GEN z)
    GEN    subrs(GEN x, long y)
    void   subrsz(GEN y, long s, GEN z)
    GEN    subsi(long x, GEN y)
    void   subsiz(long s, GEN y, GEN z)
    void   subsrz(long s, GEN y, GEN z)
    GEN    subss(long x, long y)
    void   subssz(long x, long y, GEN z)
    GEN    subuu(ulong x, ulong y)
    void   togglesign(GEN x)
    void   togglesign_safe(GEN *px)
    void   affectsign(GEN x, GEN y)
    void   affectsign_safe(GEN x, GEN *py)
    GEN    truedivii(GEN a, GEN b)
    GEN    truedivis(GEN a, long b)
    GEN    truedivsi(long a, GEN b)
    ulong  udivui_rem(ulong x, GEN y, ulong *rem)
    ulong  umodsu(long x, ulong y)
    ulong  umodui(ulong x, GEN y)
    ulong  umuluu_or_0(ulong x, ulong y)
    GEN    utoi(ulong x)
    GEN    utoineg(ulong x)
    GEN    utoipos(ulong x)
    GEN    utor(ulong s, long prec)
    GEN    uutoi(ulong x, ulong y)
    GEN    uutoineg(ulong x, ulong y)
    long   vali(GEN x)
    int    varncmp(long x, long y)
    long   varnmax(long x, long y)
    long   varnmin(long x, long y)

    # pariinl.h

    GEN    abgrp_get_cyc(GEN x)
    GEN    abgrp_get_gen(GEN x)
    GEN    abgrp_get_no(GEN x)
    GEN    bid_get_arch(GEN bid)
    GEN    bid_get_archp(GEN bid)
    GEN    bid_get_cyc(GEN bid)
    GEN    bid_get_fact(GEN bid)
    GEN    bid_get_gen(GEN bid)
    GEN    bid_get_gen_nocheck(GEN bid)
    GEN    bid_get_grp(GEN bid)
    GEN    bid_get_ideal(GEN bid)
    GEN    bid_get_mod(GEN bid)
    GEN    bid_get_no(GEN bid)
    GEN    bid_get_sarch(GEN bid)
    GEN    bid_get_sprk(GEN bid)
    GEN    bid_get_U(GEN bid)
    GEN    bnf_get_clgp(GEN bnf)
    GEN    bnf_get_cyc(GEN bnf)
    GEN    bnf_get_fu(GEN bnf)
    GEN    bnf_get_fu_nocheck(GEN bnf)
    GEN    bnf_get_gen(GEN bnf)
    GEN    bnf_get_logfu(GEN bnf)
    GEN    bnf_get_nf(GEN bnf)
    GEN    bnf_get_no(GEN bnf)
    GEN    bnf_get_reg(GEN bnf)
    GEN    bnf_get_tuU(GEN bnf)
    long   bnf_get_tuN(GEN bnf)
    GEN    bnr_get_bnf(GEN bnr)
    GEN    bnr_get_clgp(GEN bnr)
    GEN    bnr_get_cyc(GEN bnr)
    GEN    bnr_get_gen(GEN bnr)
    GEN    bnr_get_gen_nocheck(GEN bnr)
    GEN    bnr_get_no(GEN bnr)
    GEN    bnr_get_bid(GEN bnr)
    GEN    bnr_get_mod(GEN bnr)
    GEN    bnr_get_nf(GEN bnr)
    GEN    ell_get_a1(GEN e)
    GEN    ell_get_a2(GEN e)
    GEN    ell_get_a3(GEN e)
    GEN    ell_get_a4(GEN e)
    GEN    ell_get_a6(GEN e)
    GEN    ell_get_b2(GEN e)
    GEN    ell_get_b4(GEN e)
    GEN    ell_get_b6(GEN e)
    GEN    ell_get_b8(GEN e)
    GEN    ell_get_c4(GEN e)
    GEN    ell_get_c6(GEN e)
    GEN    ell_get_disc(GEN e)
    GEN    ell_get_j(GEN e)
    long   ell_get_type(GEN e)
    int    ell_is_inf(GEN z)
    GEN    ellinf()
    GEN    ellff_get_field(GEN x)
    GEN    ellff_get_a4a6(GEN x)
    GEN    ellnf_get_nf(GEN x)
    GEN    ellQp_get_p(GEN E)
    long   ellQp_get_prec(GEN E)
    GEN    ellQp_get_zero(GEN x)
    long   ellR_get_prec(GEN x)
    long   ellR_get_sign(GEN x)
    GEN    gal_get_pol(GEN gal)
    GEN    gal_get_p(GEN gal)
    GEN    gal_get_e(GEN gal)
    GEN    gal_get_mod(GEN gal)
    GEN    gal_get_roots(GEN gal)
    GEN    gal_get_invvdm(GEN gal)
    GEN    gal_get_den(GEN gal)
    GEN    gal_get_group(GEN gal)
    GEN    gal_get_gen(GEN gal)
    GEN    gal_get_orders(GEN gal)
    GEN    idealchineseinit(GEN nf, GEN x)
    GEN    idealpseudomin(GEN I, GEN G)
    GEN    idealpseudomin_nonscalar(GEN I, GEN G)
    GEN    idealpseudored(GEN I, GEN G)
    GEN    idealred_elt(GEN nf, GEN I)
    GEN    idealred(GEN nf, GEN I)
    long   logint(GEN B, GEN y)
    ulong  ulogint(ulong B, ulong y)
    GEN    modpr_get_pr(GEN x)
    GEN    modpr_get_p(GEN x)
    GEN    modpr_get_T(GEN x)
    GEN    nf_get_M(GEN nf)
    GEN    nf_get_G(GEN nf)
    GEN    nf_get_Tr(GEN nf)
    GEN    nf_get_diff(GEN nf)
    long   nf_get_degree(GEN nf)
    GEN    nf_get_disc(GEN nf)
    GEN    nf_get_index(GEN nf)
    GEN    nf_get_invzk(GEN nf)
    GEN    nf_get_pol(GEN nf)
    long   nf_get_r1(GEN nf)
    long   nf_get_r2(GEN nf)
    GEN    nf_get_ramified_primes(GEN nf)
    GEN    nf_get_roots(GEN nf)
    GEN    nf_get_roundG(GEN nf)
    void   nf_get_sign(GEN nf, long *r1, long *r2)
    long   nf_get_varn(GEN nf)
    GEN    nf_get_zk(GEN nf)
    GEN    nf_get_zkden(GEN nf)
    GEN    nf_get_zkprimpart(GEN nf)
    long   pr_get_e(GEN pr)
    long   pr_get_f(GEN pr)
    GEN    pr_get_gen(GEN pr)
    GEN    pr_get_p(GEN pr)
    GEN    pr_get_tau(GEN pr)
    int    pr_is_inert(GEN P)
    GEN    pr_norm(GEN pr)
    GEN    rnf_get_alpha(GEN rnf)
    long   rnf_get_absdegree(GEN rnf)
    long   rnf_get_degree(GEN rnf)
    GEN    rnf_get_idealdisc(GEN rnf)
    GEN    rnf_get_invzk(GEN rnf)
    GEN    rnf_get_k(GEN rnf)
    GEN    rnf_get_map(GEN rnf)
    GEN    rnf_get_nf(GEN rnf)
    long   rnf_get_nfdegree(GEN rnf)
    GEN    rnf_get_nfpol(GEN rnf)
    long   rnf_get_nfvarn(GEN rnf)
    GEN    rnf_get_pol(GEN rnf)
    GEN    rnf_get_polabs(GEN rnf)
    GEN    rnf_get_zk(GEN nf)
    void   rnf_get_nfzk(GEN rnf, GEN *b, GEN *cb)
    long   rnf_get_varn(GEN rnf)
    ulong  upr_norm(GEN pr)
    GEN    znstar_get_N(GEN G)
    GEN    znstar_get_conreycyc(GEN G)
    GEN    znstar_get_conreygen(GEN G)
    GEN    znstar_get_faN(GEN G)
    GEN    znstar_get_no(GEN G)
    GEN    znstar_get_pe(GEN G)
    GEN    znstar_get_Ui(GEN G)

    long   closure_arity(GEN C)
    const char * closure_codestr(GEN C)
    GEN    closure_get_code(GEN C)
    GEN    closure_get_oper(GEN C)
    GEN    closure_get_data(GEN C)
    GEN    closure_get_dbg(GEN C)
    GEN    closure_get_text(GEN C)
    GEN    closure_get_frame(GEN C)
    long   closure_is_variadic(GEN C)

    GEN    addmuliu(GEN x, GEN y, ulong u)
    GEN    addmuliu_inplace(GEN x, GEN y, ulong u)
    GEN    lincombii(GEN u, GEN v, GEN x, GEN y)
    GEN    mulsubii(GEN y, GEN z, GEN x)
    GEN    submulii(GEN x, GEN y, GEN z)
    GEN    submuliu(GEN x, GEN y, ulong u)
    GEN    submuliu_inplace(GEN x, GEN y, ulong u)

    GEN    FpXQ_add(GEN x, GEN y, GEN T, GEN p)
    GEN    FpXQ_sub(GEN x, GEN y, GEN T, GEN p)
    GEN    Flxq_add(GEN x, GEN y, GEN T, ulong p)
    GEN    Flxq_sub(GEN x, GEN y, GEN T, ulong p)

    GEN    FpXQX_div(GEN x, GEN y, GEN T, GEN p)
    GEN    FlxqX_div(GEN x, GEN y, GEN T, ulong p)
    GEN    F2xqX_div(GEN x, GEN y, GEN T)

    GEN    Fq_red(GEN x, GEN T, GEN p)
    GEN    Fq_to_FpXQ(GEN x, GEN T, GEN p)
    GEN    gener_Fq_local(GEN T, GEN p, GEN L)
    GEN    FqX_Fp_mul(GEN P, GEN U, GEN T, GEN p)
    GEN    FqX_Fq_mul(GEN P, GEN U, GEN T, GEN p)
    GEN    FqX_add(GEN x, GEN y, GEN T, GEN p)
    GEN    FqX_deriv(GEN f, GEN T, GEN p)
    GEN    FqX_div(GEN x, GEN y, GEN T, GEN p)
    GEN    FqX_div_by_X_x(GEN x, GEN y, GEN T, GEN p, GEN *z)
    GEN    FqX_divrem(GEN x, GEN y, GEN T, GEN p, GEN *z)
    GEN    FqX_extgcd(GEN P, GEN Q, GEN T, GEN p, GEN *U, GEN *V)
    GEN    FqX_factor(GEN f, GEN T, GEN p)
    GEN    FqX_gcd(GEN P, GEN Q, GEN T, GEN p)
    GEN    FqX_get_red(GEN S, GEN T, GEN p)
    GEN    FqX_halfgcd(GEN P, GEN Q, GEN T, GEN p)
    GEN    FqX_mul(GEN x, GEN y, GEN T, GEN p)
    GEN    FqX_mulu(GEN x, ulong y, GEN T, GEN p)
    GEN    FqX_neg(GEN x, GEN T, GEN p)
    GEN    FqX_normalize(GEN z, GEN T, GEN p)
    GEN    FqX_powu(GEN x, ulong n, GEN T, GEN p)
    GEN    FqX_red(GEN z, GEN T, GEN p)
    GEN    FqX_rem(GEN x, GEN y, GEN T, GEN p)
    GEN    FqX_roots(GEN f, GEN T, GEN p)
    GEN    FqX_sqr(GEN x, GEN T, GEN p)
    GEN    FqX_sub(GEN x, GEN y, GEN T, GEN p)

    GEN    FqXQ_add(GEN x, GEN y, GEN S, GEN T, GEN p)
    GEN    FqXQ_div(GEN x, GEN y, GEN S, GEN T, GEN p)
    GEN    FqXQ_inv(GEN x, GEN S, GEN T, GEN p)
    GEN    FqXQ_invsafe(GEN x, GEN S, GEN T, GEN p)
    GEN    FqXQ_mul(GEN x, GEN y, GEN S, GEN T, GEN p)
    GEN    FqXQ_pow(GEN x, GEN n, GEN S, GEN T, GEN p)
    GEN    FqXQ_sqr(GEN x, GEN S, GEN T, GEN p)
    GEN    FqXQ_sub(GEN x, GEN y, GEN S, GEN T, GEN p)

    long   get_F2x_degree(GEN T)
    GEN    get_F2x_mod(GEN T)
    long   get_F2x_var(GEN T)
    long   get_F2xqX_degree(GEN T)
    GEN    get_F2xqX_mod(GEN T)
    long   get_F2xqX_var(GEN T)
    long   get_Flx_degree(GEN T)
    GEN    get_Flx_mod(GEN T)
    long   get_Flx_var(GEN T)
    long   get_FlxqX_degree(GEN T)
    GEN    get_FlxqX_mod(GEN T)
    long   get_FlxqX_var(GEN T)
    long   get_FpX_degree(GEN T)
    GEN    get_FpX_mod(GEN T)
    long   get_FpX_var(GEN T)
    long   get_FpXQX_degree(GEN T)
    GEN    get_FpXQX_mod(GEN T)
    long   get_FpXQX_var(GEN T)

    ulong  F2m_coeff(GEN x, long a, long b)
    void   F2m_clear(GEN x, long a, long b)
    void   F2m_flip(GEN x, long a, long b)
    void   F2m_set(GEN x, long a, long b)
    void   F2v_clear(GEN x, long v)
    ulong  F2v_coeff(GEN x, long v)
    void   F2v_flip(GEN x, long v)
    GEN    F2v_to_F2x(GEN x, long sv)
    void   F2v_set(GEN x, long v)
    void   F2x_clear(GEN x, long v)
    ulong  F2x_coeff(GEN x, long v)
    void   F2x_flip(GEN x, long v)
    void   F2x_set(GEN x, long v)
    int    F2x_equal1(GEN x)
    int    F2x_equal(GEN V, GEN W)
    GEN    F2x_div(GEN x, GEN y)
    GEN    F2x_renormalize(GEN x, long lx)
    GEN    F2m_copy(GEN x)
    GEN    F2v_copy(GEN x)
    GEN    F2x_copy(GEN x)
    GEN    F2v_ei(long n, long i)
    GEN    Flm_copy(GEN x)
    GEN    Flv_copy(GEN x)
    int    Flx_equal1(GEN x)
    GEN    Flx_copy(GEN x)
    GEN    Flx_div(GEN x, GEN y, ulong p)
    ulong  Flx_lead(GEN x)
    GEN    Flx_mulu(GEN x, ulong a, ulong p)
    GEN    FpV_FpC_mul(GEN x, GEN y, GEN p)
    GEN    FpXQX_renormalize(GEN x, long lx)
    GEN    FpXX_renormalize(GEN x, long lx)
    GEN    FpX_div(GEN x, GEN y, GEN p)
    GEN    FpX_renormalize(GEN x, long lx)
    GEN    Fp_add(GEN a, GEN b, GEN m)
    GEN    Fp_addmul(GEN x, GEN y, GEN z, GEN p)
    GEN    Fp_center(GEN u, GEN p, GEN ps2)
    GEN    Fp_div(GEN a, GEN b, GEN m)
    GEN    Fp_halve(GEN y, GEN p)
    GEN    Fp_inv(GEN a, GEN m)
    GEN    Fp_invsafe(GEN a, GEN m)
    GEN    Fp_mul(GEN a, GEN b, GEN m)
    GEN    Fp_muls(GEN a, long b, GEN m)
    GEN    Fp_mulu(GEN a, ulong b, GEN m)
    GEN    Fp_neg(GEN b, GEN m)
    GEN    Fp_red(GEN x, GEN p)
    GEN    Fp_sqr(GEN a, GEN m)
    GEN    Fp_sub(GEN a, GEN b, GEN m)
    GEN    GENbinbase(GENbin *p)
    GEN    Q_abs(GEN x)
    GEN    Q_abs_shallow(GEN x)
    int    QV_isscalar(GEN x)
    void   Qtoss(GEN q, long *n, long *d)
    GEN    R_abs(GEN x)
    GEN    R_abs_shallow(GEN x)
    GEN    RgC_fpnorml2(GEN x, long prec)
    GEN    RgC_gtofp(GEN x, long prec)
    GEN    RgC_gtomp(GEN x, long prec)
    void   RgM_dimensions(GEN x, long *m, long *n)
    GEN    RgM_fpnorml2(GEN x, long prec)
    GEN    RgM_gtofp(GEN x, long prec)
    GEN    RgM_gtomp(GEN x, long prec)
    GEN    RgM_inv(GEN a)
    GEN    RgM_minor(GEN a, long i, long j)
    GEN    RgM_shallowcopy(GEN x)
    GEN    RgV_gtofp(GEN x, long prec)
    int    RgV_isscalar(GEN x)
    int    RgV_is_ZV(GEN x)
    int    RgV_is_QV(GEN x)
    long   RgX_equal_var(GEN x, GEN y)
    int    RgX_is_monomial(GEN x)
    int    RgX_is_rational(GEN x)
    int    RgX_is_QX(GEN x)
    int    RgX_is_ZX(GEN x)
    int    RgX_isscalar(GEN x)
    GEN    RgX_shift_inplace(GEN x, long v)
    void   RgX_shift_inplace_init(long v)
    GEN    RgXQ_mul(GEN x, GEN y, GEN T)
    GEN    RgXQ_sqr(GEN x, GEN T)
    GEN    RgXQX_div(GEN x, GEN y, GEN T)
    GEN    RgXQX_rem(GEN x, GEN y, GEN T)
    GEN    RgX_coeff(GEN x, long n)
    GEN    RgX_copy(GEN x)
    GEN    RgX_div(GEN x, GEN y)
    GEN    RgX_fpnorml2(GEN x, long prec)
    GEN    RgX_gtofp(GEN x, long prec)
    GEN    RgX_rem(GEN x, GEN y)
    GEN    RgX_renormalize(GEN x)
    GEN    Rg_col_ei(GEN x, long n, long i)
    GEN    ZC_hnfrem(GEN x, GEN y)
    GEN    ZM_hnfrem(GEN x, GEN y)
    GEN    ZM_lll(GEN x, double D, long f)
    int    ZV_dvd(GEN x, GEN y)
    int    ZV_isscalar(GEN x)
    GEN    ZV_to_zv(GEN x)
    int    ZX_equal1(GEN x)
    GEN    ZX_renormalize(GEN x, long lx)
    GEN    ZXQ_mul(GEN x, GEN y, GEN T)
    GEN    ZXQ_sqr(GEN x, GEN T)
    long   Z_ispower(GEN x, ulong k)
    long   Z_issquare(GEN x)
    GEN    absfrac(GEN x)
    GEN    absfrac_shallow(GEN x)
    GEN    affc_fixlg(GEN x, GEN res)
    GEN    bin_copy(GENbin *p)
    long   bit_accuracy(long x)
    double bit_accuracy_mul(long x, double y)
    long   bit_prec(GEN x)
    int    both_odd(long x, long y)
    GEN    cbrtr(GEN x)
    GEN    cbrtr_abs(GEN x)
    GEN    cgetc(long x)
    GEN    cgetalloc(long t, size_t l)
    GEN    cxcompotor(GEN z, long prec)
    void   cgiv(GEN x)
    GEN    col_ei(long n, long i)
    GEN    const_col(long n, GEN x)
    GEN    const_vec(long n, GEN x)
    GEN    const_vecsmall(long n, long c)
    GEN    constant_coeff(GEN x)
    GEN    cxnorm(GEN x)
    GEN    cyclic_perm(long l, long d)
    double dbllog2r(GEN x)
    long   degpol(GEN x)
    long   divsBIL(long n)
    void   gabsz(GEN x, long prec, GEN z)
    GEN    gaddgs(GEN y, long s)
    void   gaddz(GEN x, GEN y, GEN z)
    int    gcmpgs(GEN y, long s)
    void   gdiventz(GEN x, GEN y, GEN z)
    GEN    gdivsg(long s, GEN y)
    void   gdivz(GEN x, GEN y, GEN z)
    GEN    gen_I()
    void   gerepileall(pari_sp av, int n, ...)
    void   gerepilecoeffs(pari_sp av, GEN x, int n)
    GEN    gerepilecopy(pari_sp av, GEN x)
    void   gerepilemany(pari_sp av, GEN* g[], int n)
    int    gequalgs(GEN y, long s)
    GEN    gerepileupto(pari_sp av, GEN q)
    GEN    gerepileuptoint(pari_sp av, GEN q)
    GEN    gerepileuptoleaf(pari_sp av, GEN q)
    GEN    gmaxsg(long s, GEN y)
    GEN    gminsg(long s, GEN y)
    void   gmodz(GEN x, GEN y, GEN z)
    void   gmul2nz(GEN x, long s, GEN z)
    GEN    gmulgs(GEN y, long s)
    void   gmulz(GEN x, GEN y, GEN z)
    void   gnegz(GEN x, GEN z)
    void   gshiftz(GEN x, long s, GEN z)
    GEN    gsubgs(GEN y, long s)
    void   gsubz(GEN x, GEN y, GEN z)
    double gtodouble(GEN x)
    GEN    gtofp(GEN z, long prec)
    GEN    gtomp(GEN z, long prec)
    long   gtos(GEN x)
    long   gval(GEN x, long v)
    GEN    identity_perm(long l)
    int    equali1(GEN n)
    int    equalim1(GEN n)
    long   inf_get_sign(GEN x)
    int    is_bigint(GEN n)
    int    is_const_t(long t)
    int    is_extscalar_t(long t)
    int    is_intreal_t(long t)
    int    is_matvec_t(long t)
    int    is_noncalc_t(long tx)
    int    is_pm1(GEN n)
    int    is_rational_t(long t)
    int    is_real_t(long t)
    int    is_recursive_t(long t)
    int    is_scalar_t(long t)
    int    _is_universal_constant "is_universal_constant"(GEN x)
    int    is_vec_t(long t)
    int    isint1(GEN x)
    int    isintm1(GEN x)
    int    isintzero(GEN x)
    int    ismpzero(GEN x)
    int    isonstack(GEN x)
    void   killblock(GEN x)
    GEN    leading_coeff(GEN x)
    void   lg_increase(GEN x)
    long   lgcols(GEN x)
    long   lgpol(GEN x)
    GEN    matpascal(long n)
    GEN    matslice(GEN A, long x1, long x2, long y1, long y2)
    GEN    mkcol(GEN x)
    GEN    mkcol2(GEN x, GEN y)
    GEN    mkcol2s(long x, long y)
    GEN    mkcol3(GEN x, GEN y, GEN z)
    GEN    mkcol3s(long x, long y, long z)
    GEN    mkcol4(GEN x, GEN y, GEN z, GEN t)
    GEN    mkcol4s(long x, long y, long z, long t)
    GEN    mkcol5(GEN x, GEN y, GEN z, GEN t, GEN u)
    GEN    mkcol6(GEN x, GEN y, GEN z, GEN t, GEN u, GEN v)
    GEN    mkcolcopy(GEN x)
    GEN    mkcols(long x)
    GEN    mkcomplex(GEN x, GEN y)
    GEN    mkerr(long n)
    GEN    mkmoo()
    GEN    mkoo()
    GEN    mkfrac(GEN x, GEN y)
    GEN    mkfracss(long x, long y)
    GEN    mkfraccopy(GEN x, GEN y)
    GEN    mkintmod(GEN x, GEN y)
    GEN    mkintmodu(ulong x, ulong y)
    GEN    mkmat(GEN x)
    GEN    mkmat2(GEN x, GEN y)
    GEN    mkmat3(GEN x, GEN y, GEN z)
    GEN    mkmat4(GEN x, GEN y, GEN z, GEN t)
    GEN    mkmat5(GEN x, GEN y, GEN z, GEN t, GEN u)
    GEN    mkmatcopy(GEN x)
    GEN    mkpolmod(GEN x, GEN y)
    GEN    mkqfi(GEN x, GEN y, GEN z)
    GEN    mkquad(GEN n, GEN x, GEN y)
    GEN    mkrfrac(GEN x, GEN y)
    GEN    mkrfraccopy(GEN x, GEN y)
    GEN    mkvec(GEN x)
    GEN    mkvec2(GEN x, GEN y)
    GEN    mkvec2copy(GEN x, GEN y)
    GEN    mkvec2s(long x, long y)
    GEN    mkvec3(GEN x, GEN y, GEN z)
    GEN    mkvec3s(long x, long y, long z)
    GEN    mkvec4(GEN x, GEN y, GEN z, GEN t)
    GEN    mkvec4s(long x, long y, long z, long t)
    GEN    mkvec5(GEN x, GEN y, GEN z, GEN t, GEN u)
    GEN    mkveccopy(GEN x)
    GEN    mkvecs(long x)
    GEN    mkvecsmall(long x)
    GEN    mkvecsmall2(long x, long y)
    GEN    mkvecsmall3(long x, long y, long z)
    GEN    mkvecsmall4(long x, long y, long z, long t)
    void   mpcosz(GEN x, GEN z)
    void   mpexpz(GEN x, GEN z)
    void   mplogz(GEN x, GEN z)
    void   mpsinz(GEN x, GEN z)
    GEN    mul_content(GEN cx, GEN cy)
    GEN    mul_denom(GEN cx, GEN cy)
    long   nbits2nlong(long x)
    long   nbits2extraprec(long x)
    long   nbits2ndec(long x)
    long   nbits2prec(long x)
    long   nbits2lg(long x)
    long   nbrows(GEN x)
    long   nchar2nlong(long x)
    long   ndec2nbits(long x)
    long   ndec2nlong(long x)
    long   ndec2prec(long x)
    void   normalize_frac(GEN z)
    int    odd(long x)
    void   pari_free(void *pointer)
    void*  pari_calloc(size_t size)
    void*  pari_malloc(size_t bytes)
    void*  pari_realloc(void *pointer, size_t size)
    GEN    perm_conj(GEN s, GEN t)
    GEN    perm_inv(GEN x)
    GEN    perm_mul(GEN s, GEN t)
    GEN    pol_0(long v)
    GEN    pol_1(long v)
    GEN    pol_x(long v)
    GEN    pol_xn(long n, long v)
    GEN    pol_xnall(long n, long v)
    GEN    pol0_F2x(long sv)
    GEN    pol1_F2x(long sv)
    GEN    polx_F2x(long sv)
    GEN    pol0_Flx(long sv)
    GEN    pol1_Flx(long sv)
    GEN    polx_Flx(long sv)
    GEN    polx_zx(long sv)
    GEN    powii(GEN x, GEN n)
    GEN    powIs(long n)
    long   prec2nbits(long x)
    double prec2nbits_mul(long x, double y)
    long   prec2ndec(long x)
    long   precdbl(long x)
    GEN    quad_disc(GEN x)
    GEN    qfb_disc(GEN x)
    GEN    qfb_disc3(GEN x, GEN y, GEN z)
    GEN    quadnorm(GEN q)
    long   remsBIL(long n)
    GEN    row(GEN A, long x1)
    GEN    Flm_row(GEN A, long x0)
    GEN    row_i(GEN A, long x0, long x1, long x2)
    GEN    zm_row(GEN x, long i)
    GEN    rowcopy(GEN A, long x0)
    GEN    rowpermute(GEN A, GEN p)
    GEN    rowslice(GEN A, long x1, long x2)
    GEN    rowslicepermute(GEN A, GEN p, long x1, long x2)
    GEN    rowsplice(GEN a, long j)
    int    ser_isexactzero(GEN x)
    GEN    shallowcopy(GEN x)
    GEN    sqrfrac(GEN x)
    GEN    sqrti(GEN x)
    GEN    sqrtnr(GEN x, long n)
    GEN    sqrtr(GEN x)
    GEN    sstoQ(long n, long d)
    void   pari_stack_alloc(pari_stack *s, long nb)
    void** pari_stack_base(pari_stack *s)
    void   pari_stack_delete(pari_stack *s)
    void   pari_stack_init(pari_stack *s, size_t size, void **data)
    long   pari_stack_new(pari_stack *s)
    void   pari_stack_pushp(pari_stack *s, void *u)
    long   sturm(GEN x)
    GEN    truecoeff(GEN x, long n)
    GEN    trunc_safe(GEN x)
    GEN    vec_ei(long n, long i)
    GEN    vec_append(GEN v, GEN s)
    GEN    vec_lengthen(GEN v, long n)
    GEN    vec_setconst(GEN v, GEN x)
    GEN    vec_shorten(GEN v, long n)
    GEN    vec_to_vecsmall(GEN z)
    GEN    vecpermute(GEN A, GEN p)
    GEN    vecreverse(GEN A)
    void   vecreverse_inplace(GEN y)
    GEN    vecsmallpermute(GEN A, GEN p)
    GEN    vecslice(GEN A, long y1, long y2)
    GEN    vecslicepermute(GEN A, GEN p, long y1, long y2)
    GEN    vecsplice(GEN a, long j)
    GEN    vecsmall_append(GEN V, long s)
    long   vecsmall_coincidence(GEN u, GEN v)
    GEN    vecsmall_concat(GEN u, GEN v)
    GEN    vecsmall_copy(GEN x)
    GEN    vecsmall_ei(long n, long i)
    long   vecsmall_indexmax(GEN x)
    long   vecsmall_indexmin(GEN x)
    long   vecsmall_isin(GEN v, long x)
    GEN    vecsmall_lengthen(GEN v, long n)
    int    vecsmall_lexcmp(GEN x, GEN y)
    long   vecsmall_max(GEN v)
    long   vecsmall_min(GEN v)
    long   vecsmall_pack(GEN V, long base, long mod)
    int    vecsmall_prefixcmp(GEN x, GEN y)
    GEN    vecsmall_prepend(GEN V, long s)
    GEN    vecsmall_reverse(GEN A)
    GEN    vecsmall_shorten(GEN v, long n)
    GEN    vecsmall_to_col(GEN z)
    GEN    vecsmall_to_vec(GEN z)
    GEN    vecsmall_to_vec_inplace(GEN z)
    void   vecsmalltrunc_append(GEN x, long t)
    GEN    vecsmalltrunc_init(long l)
    void   vectrunc_append(GEN x, GEN t)
    void   vectrunc_append_batch(GEN x, GEN y)
    GEN    vectrunc_init(long l)
    GEN    zc_to_ZC(GEN x)
    GEN    zero_F2m(long n, long m)
    GEN    zero_F2m_copy(long n, long m)
    GEN    zero_F2v(long m)
    GEN    zero_F2x(long sv)
    GEN    zero_Flm(long m, long n)
    GEN    zero_Flm_copy(long m, long n)
    GEN    zero_Flv(long n)
    GEN    zero_Flx(long sv)
    GEN    zero_zm(long x, long y)
    GEN    zero_zv(long x)
    GEN    zero_zx(long sv)
    GEN    zerocol(long n)
    GEN    zeromat(long m, long n)
    GEN    zeromatcopy(long m, long n)
    GEN    zeropadic(GEN p, long e)
    GEN    zeropadic_shallow(GEN p, long e)
    GEN    zeropol(long v)
    GEN    zeroser(long v, long e)
    GEN    zerovec(long n)
    GEN    zerovec_block(long len)
    GEN    zm_copy(GEN x)
    GEN    zm_to_zxV(GEN x, long sv)
    GEN    zm_transpose(GEN x)
    GEN    zv_copy(GEN x)
    GEN    zv_to_ZV(GEN x)
    GEN    zv_to_zx(GEN x, long sv)
    GEN    zx_renormalize(GEN x, long l)
    GEN    zx_shift(GEN x, long n)
    GEN    zx_to_zv(GEN x, long N)

    GEN    err_get_compo(GEN e, long i)
    long   err_get_num(GEN e)
    void   pari_err_BUG(const char *f)
    void   pari_err_COMPONENT(const char *f, const char *op, GEN l, GEN x)
    void   pari_err_CONSTPOL(const char *f)
    void   pari_err_COPRIME(const char *f, GEN x, GEN y)
    void   pari_err_DIM(const char *f)
    void   pari_err_DOMAIN(const char *f, const char *v, const char *op, GEN l, GEN x)
    void   pari_err_FILE(const char *f, const char *g)
    void   pari_err_FLAG(const char *f)
    void   pari_err_IMPL(const char *f)
    void   pari_err_INV(const char *f, GEN x)
    void   pari_err_IRREDPOL(const char *f, GEN x)
    void   pari_err_MAXPRIME(ulong c)
    void   pari_err_MODULUS(const char *f, GEN x, GEN y)
    void   pari_err_OP(const char *f, GEN x, GEN y)
    void   pari_err_OVERFLOW(const char *f)
    void   pari_err_PACKAGE(const char *f)
    void   pari_err_PREC(const char *f)
    void   pari_err_PRIME(const char *f, GEN x)
    void   pari_err_PRIORITY(const char *f, GEN x, const char *op, long v)
    void   pari_err_SQRTN(const char *f, GEN x)
    void   pari_err_TYPE(const char *f, GEN x)
    void   pari_err_TYPE2(const char *f, GEN x, GEN y)
    void   pari_err_VAR(const char *f, GEN x, GEN y)
    void   pari_err_ROOTS0(const char *f)


# Work around a bug in PARI's is_universal_constant()
cdef inline int is_universal_constant(GEN x) noexcept:
    return _is_universal_constant(x) or (x is err_e_STACK)


# Auto-generated declarations. There are taken from the PARI version
# on the system, so they more up-to-date than the above. In case of
# conflicting declarations, auto_paridecl should have priority.
from .auto_paridecl cimport *


cdef inline int is_on_stack(GEN x) except -1:
    """
    Is the GEN ``x`` stored on the PARI stack?
    """
    s = <pari_sp>x
    if avma <= s:
        return s < pari_mainstack.top
    if pari_mainstack.vbot <= s:
        raise SystemError("PARI object in unused part of PARI stack")
    return 0
