/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.legacy.query.planner.core;

import java.util.List;
import org.opensearch.client.Client;
import org.opensearch.search.SearchHit;
import org.opensearch.sql.legacy.executor.join.MetaSearchResult;
import org.opensearch.sql.legacy.query.planner.core.Config;
import org.opensearch.sql.legacy.query.planner.core.ExecuteParams;
import org.opensearch.sql.legacy.query.planner.core.QueryParams;
import org.opensearch.sql.legacy.query.planner.explain.Explanation;
import org.opensearch.sql.legacy.query.planner.explain.JsonExplanationFormat;
import org.opensearch.sql.legacy.query.planner.logical.LogicalPlan;
import org.opensearch.sql.legacy.query.planner.physical.PhysicalPlan;
import org.opensearch.sql.legacy.query.planner.resource.ResourceManager;
import org.opensearch.sql.legacy.query.planner.resource.Stats;

public class QueryPlanner {
    private final Client client;
    private final Config config;
    private final LogicalPlan logicalPlan;
    private final PhysicalPlan physicalPlan;
    private Stats stats;
    private ResourceManager resourceMgr;

    public QueryPlanner(Client client, Config config, QueryParams params) {
        this.client = client;
        this.config = config;
        this.stats = new Stats(client);
        this.resourceMgr = new ResourceManager(this.stats, config);
        this.logicalPlan = new LogicalPlan(config, params);
        this.logicalPlan.optimize();
        this.physicalPlan = new PhysicalPlan(this.logicalPlan);
        this.physicalPlan.optimize();
    }

    public List<SearchHit> execute() {
        ExecuteParams params = new ExecuteParams();
        params.add(ExecuteParams.ExecuteParamType.CLIENT, this.client);
        params.add(ExecuteParams.ExecuteParamType.TIMEOUT, this.config.timeout());
        params.add(ExecuteParams.ExecuteParamType.RESOURCE_MANAGER, this.resourceMgr);
        return this.physicalPlan.execute(params);
    }

    public String explain() {
        return new Explanation(this.logicalPlan, this.physicalPlan, new JsonExplanationFormat(4)).toString();
    }

    public MetaSearchResult getMetaResult() {
        return this.resourceMgr.getMetaResult();
    }

    public void setStats(Stats stats) {
        this.stats = stats;
        this.resourceMgr = new ResourceManager(stats, this.config);
    }
}

