# Print an optspec for argparse to handle cmd's options that are independent of any subcommand.
function __fish_rmpc_global_optspecs
	string join \n c/config= a/address= h/help
end

function __fish_rmpc_needs_command
	# Figure out if the current invocation already has a command.
	set -l cmd (commandline -opc)
	set -e cmd[1]
	argparse -s (__fish_rmpc_global_optspecs) -- $cmd 2>/dev/null
	or return
	if set -q argv[1]
		# Also print the command, so this can be used to figure out what it is.
		echo $argv[1]
		return 1
	end
	return 0
end

function __fish_rmpc_using_subcommand
	set -l cmd (__fish_rmpc_needs_command)
	test -z "$cmd"
	and return 1
	contains -- $cmd[1] $argv
end

complete -c rmpc -n "__fish_rmpc_needs_command" -s c -l config -r -F
complete -c rmpc -n "__fish_rmpc_needs_command" -s a -l address -d 'Override the address to connect to. Defaults to value in the config file' -r
complete -c rmpc -n "__fish_rmpc_needs_command" -s h -l help -d 'Print help'
complete -c rmpc -n "__fish_rmpc_needs_command" -f -a "config" -d 'Prints the default config. Can be used to bootstrap your config file'
complete -c rmpc -n "__fish_rmpc_needs_command" -f -a "theme" -d 'Prints the default theme. Can be used to bootstrap your theme file'
complete -c rmpc -n "__fish_rmpc_needs_command" -f -a "albumart" -d 'Saves the current album art to a file. Exit codes: * 0: Success * 1: Error * 2: No album art found * 3: No song playing'
complete -c rmpc -n "__fish_rmpc_needs_command" -f -a "debuginfo" -d 'Prints information about optional runtime dependencies'
complete -c rmpc -n "__fish_rmpc_needs_command" -f -a "version" -d 'Prints the rmpc version'
complete -c rmpc -n "__fish_rmpc_needs_command" -f -a "play" -d 'Plays song at the position in the current playlist. Defaults to current paused song'
complete -c rmpc -n "__fish_rmpc_needs_command" -f -a "pause" -d 'Pause playback'
complete -c rmpc -n "__fish_rmpc_needs_command" -f -a "unpause" -d 'Unpause playback'
complete -c rmpc -n "__fish_rmpc_needs_command" -f -a "togglepause" -d 'Toggles between play and pause'
complete -c rmpc -n "__fish_rmpc_needs_command" -f -a "stop" -d 'Stops playback'
complete -c rmpc -n "__fish_rmpc_needs_command" -f -a "next" -d 'Plays the next song in the playlist'
complete -c rmpc -n "__fish_rmpc_needs_command" -f -a "prev" -d 'Plays the previous song in the playlist'
complete -c rmpc -n "__fish_rmpc_needs_command" -f -a "volume" -d 'Sets volume, relative if prefixed by + or -. Prints current volume if no arguments is given'
complete -c rmpc -n "__fish_rmpc_needs_command" -f -a "repeat" -d 'On or off'
complete -c rmpc -n "__fish_rmpc_needs_command" -f -a "random" -d 'On or off'
complete -c rmpc -n "__fish_rmpc_needs_command" -f -a "single" -d 'On, off or oneshot'
complete -c rmpc -n "__fish_rmpc_needs_command" -f -a "consume" -d 'On, off or oneshot'
complete -c rmpc -n "__fish_rmpc_needs_command" -f -a "seek" -d 'Seeks current song(seconds), relative if prefixed by + or -'
complete -c rmpc -n "__fish_rmpc_needs_command" -f -a "clear" -d 'Clear the current queue'
complete -c rmpc -n "__fish_rmpc_needs_command" -f -a "add" -d 'Add a song to the current queue. Relative to music database root. \'/\' to add all files to the queue'
complete -c rmpc -n "__fish_rmpc_needs_command" -f -a "addyt" -d 'Add a song from youtube to the current queue'
complete -c rmpc -n "__fish_rmpc_needs_command" -f -a "outputs" -d 'List MPD outputs'
complete -c rmpc -n "__fish_rmpc_needs_command" -f -a "toggleoutput" -d 'Toggle MPD output on or off'
complete -c rmpc -n "__fish_rmpc_needs_command" -f -a "enableoutput" -d 'Enable MPD output'
complete -c rmpc -n "__fish_rmpc_needs_command" -f -a "disableoutput" -d 'Disable MPD output'
complete -c rmpc -n "__fish_rmpc_needs_command" -f -a "status" -d 'Prints various information like the playback status'
complete -c rmpc -n "__fish_rmpc_needs_command" -f -a "song" -d 'Prints info about the current song. If --path specified, prints information about the song at the given path instead. If --path is specified multiple times, prints an array containing all the songs'
complete -c rmpc -n "__fish_rmpc_needs_command" -f -a "mount" -d 'Mounts supported storage to MPD'
complete -c rmpc -n "__fish_rmpc_needs_command" -f -a "unmount" -d 'Unmounts storage with given name'
complete -c rmpc -n "__fish_rmpc_needs_command" -f -a "listmounts" -d 'List currently mounted storages'
complete -c rmpc -n "__fish_rmpc_needs_command" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c rmpc -n "__fish_rmpc_using_subcommand config" -s h -l help -d 'Print help'
complete -c rmpc -n "__fish_rmpc_using_subcommand theme" -s h -l help -d 'Print help'
complete -c rmpc -n "__fish_rmpc_using_subcommand albumart" -s o -l output -d 'Output file where to save the album art, "-" for stdout' -r
complete -c rmpc -n "__fish_rmpc_using_subcommand albumart" -s h -l help -d 'Print help'
complete -c rmpc -n "__fish_rmpc_using_subcommand debuginfo" -s h -l help -d 'Print help'
complete -c rmpc -n "__fish_rmpc_using_subcommand version" -s h -l help -d 'Print help'
complete -c rmpc -n "__fish_rmpc_using_subcommand play" -s h -l help -d 'Print help'
complete -c rmpc -n "__fish_rmpc_using_subcommand pause" -s h -l help -d 'Print help'
complete -c rmpc -n "__fish_rmpc_using_subcommand unpause" -s h -l help -d 'Print help'
complete -c rmpc -n "__fish_rmpc_using_subcommand togglepause" -s h -l help -d 'Print help'
complete -c rmpc -n "__fish_rmpc_using_subcommand stop" -s h -l help -d 'Print help'
complete -c rmpc -n "__fish_rmpc_using_subcommand next" -s h -l help -d 'Print help'
complete -c rmpc -n "__fish_rmpc_using_subcommand prev" -s h -l help -d 'Print help'
complete -c rmpc -n "__fish_rmpc_using_subcommand volume" -s h -l help -d 'Print help'
complete -c rmpc -n "__fish_rmpc_using_subcommand repeat" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c rmpc -n "__fish_rmpc_using_subcommand random" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c rmpc -n "__fish_rmpc_using_subcommand single" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c rmpc -n "__fish_rmpc_using_subcommand consume" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c rmpc -n "__fish_rmpc_using_subcommand seek" -s h -l help -d 'Print help'
complete -c rmpc -n "__fish_rmpc_using_subcommand clear" -s h -l help -d 'Print help'
complete -c rmpc -n "__fish_rmpc_using_subcommand add" -s h -l help -d 'Print help'
complete -c rmpc -n "__fish_rmpc_using_subcommand addyt" -s h -l help -d 'Print help'
complete -c rmpc -n "__fish_rmpc_using_subcommand outputs" -s h -l help -d 'Print help'
complete -c rmpc -n "__fish_rmpc_using_subcommand toggleoutput" -s h -l help -d 'Print help'
complete -c rmpc -n "__fish_rmpc_using_subcommand enableoutput" -s h -l help -d 'Print help'
complete -c rmpc -n "__fish_rmpc_using_subcommand disableoutput" -s h -l help -d 'Print help'
complete -c rmpc -n "__fish_rmpc_using_subcommand status" -s h -l help -d 'Print help'
complete -c rmpc -n "__fish_rmpc_using_subcommand song" -s p -l path -r
complete -c rmpc -n "__fish_rmpc_using_subcommand song" -s h -l help -d 'Print help'
complete -c rmpc -n "__fish_rmpc_using_subcommand mount" -s h -l help -d 'Print help'
complete -c rmpc -n "__fish_rmpc_using_subcommand unmount" -s h -l help -d 'Print help'
complete -c rmpc -n "__fish_rmpc_using_subcommand listmounts" -s h -l help -d 'Print help'
complete -c rmpc -n "__fish_rmpc_using_subcommand help; and not __fish_seen_subcommand_from config theme albumart debuginfo version play pause unpause togglepause stop next prev volume repeat random single consume seek clear add addyt outputs toggleoutput enableoutput disableoutput status song mount unmount listmounts help" -f -a "config" -d 'Prints the default config. Can be used to bootstrap your config file'
complete -c rmpc -n "__fish_rmpc_using_subcommand help; and not __fish_seen_subcommand_from config theme albumart debuginfo version play pause unpause togglepause stop next prev volume repeat random single consume seek clear add addyt outputs toggleoutput enableoutput disableoutput status song mount unmount listmounts help" -f -a "theme" -d 'Prints the default theme. Can be used to bootstrap your theme file'
complete -c rmpc -n "__fish_rmpc_using_subcommand help; and not __fish_seen_subcommand_from config theme albumart debuginfo version play pause unpause togglepause stop next prev volume repeat random single consume seek clear add addyt outputs toggleoutput enableoutput disableoutput status song mount unmount listmounts help" -f -a "albumart" -d 'Saves the current album art to a file. Exit codes: * 0: Success * 1: Error * 2: No album art found * 3: No song playing'
complete -c rmpc -n "__fish_rmpc_using_subcommand help; and not __fish_seen_subcommand_from config theme albumart debuginfo version play pause unpause togglepause stop next prev volume repeat random single consume seek clear add addyt outputs toggleoutput enableoutput disableoutput status song mount unmount listmounts help" -f -a "debuginfo" -d 'Prints information about optional runtime dependencies'
complete -c rmpc -n "__fish_rmpc_using_subcommand help; and not __fish_seen_subcommand_from config theme albumart debuginfo version play pause unpause togglepause stop next prev volume repeat random single consume seek clear add addyt outputs toggleoutput enableoutput disableoutput status song mount unmount listmounts help" -f -a "version" -d 'Prints the rmpc version'
complete -c rmpc -n "__fish_rmpc_using_subcommand help; and not __fish_seen_subcommand_from config theme albumart debuginfo version play pause unpause togglepause stop next prev volume repeat random single consume seek clear add addyt outputs toggleoutput enableoutput disableoutput status song mount unmount listmounts help" -f -a "play" -d 'Plays song at the position in the current playlist. Defaults to current paused song'
complete -c rmpc -n "__fish_rmpc_using_subcommand help; and not __fish_seen_subcommand_from config theme albumart debuginfo version play pause unpause togglepause stop next prev volume repeat random single consume seek clear add addyt outputs toggleoutput enableoutput disableoutput status song mount unmount listmounts help" -f -a "pause" -d 'Pause playback'
complete -c rmpc -n "__fish_rmpc_using_subcommand help; and not __fish_seen_subcommand_from config theme albumart debuginfo version play pause unpause togglepause stop next prev volume repeat random single consume seek clear add addyt outputs toggleoutput enableoutput disableoutput status song mount unmount listmounts help" -f -a "unpause" -d 'Unpause playback'
complete -c rmpc -n "__fish_rmpc_using_subcommand help; and not __fish_seen_subcommand_from config theme albumart debuginfo version play pause unpause togglepause stop next prev volume repeat random single consume seek clear add addyt outputs toggleoutput enableoutput disableoutput status song mount unmount listmounts help" -f -a "togglepause" -d 'Toggles between play and pause'
complete -c rmpc -n "__fish_rmpc_using_subcommand help; and not __fish_seen_subcommand_from config theme albumart debuginfo version play pause unpause togglepause stop next prev volume repeat random single consume seek clear add addyt outputs toggleoutput enableoutput disableoutput status song mount unmount listmounts help" -f -a "stop" -d 'Stops playback'
complete -c rmpc -n "__fish_rmpc_using_subcommand help; and not __fish_seen_subcommand_from config theme albumart debuginfo version play pause unpause togglepause stop next prev volume repeat random single consume seek clear add addyt outputs toggleoutput enableoutput disableoutput status song mount unmount listmounts help" -f -a "next" -d 'Plays the next song in the playlist'
complete -c rmpc -n "__fish_rmpc_using_subcommand help; and not __fish_seen_subcommand_from config theme albumart debuginfo version play pause unpause togglepause stop next prev volume repeat random single consume seek clear add addyt outputs toggleoutput enableoutput disableoutput status song mount unmount listmounts help" -f -a "prev" -d 'Plays the previous song in the playlist'
complete -c rmpc -n "__fish_rmpc_using_subcommand help; and not __fish_seen_subcommand_from config theme albumart debuginfo version play pause unpause togglepause stop next prev volume repeat random single consume seek clear add addyt outputs toggleoutput enableoutput disableoutput status song mount unmount listmounts help" -f -a "volume" -d 'Sets volume, relative if prefixed by + or -. Prints current volume if no arguments is given'
complete -c rmpc -n "__fish_rmpc_using_subcommand help; and not __fish_seen_subcommand_from config theme albumart debuginfo version play pause unpause togglepause stop next prev volume repeat random single consume seek clear add addyt outputs toggleoutput enableoutput disableoutput status song mount unmount listmounts help" -f -a "repeat" -d 'On or off'
complete -c rmpc -n "__fish_rmpc_using_subcommand help; and not __fish_seen_subcommand_from config theme albumart debuginfo version play pause unpause togglepause stop next prev volume repeat random single consume seek clear add addyt outputs toggleoutput enableoutput disableoutput status song mount unmount listmounts help" -f -a "random" -d 'On or off'
complete -c rmpc -n "__fish_rmpc_using_subcommand help; and not __fish_seen_subcommand_from config theme albumart debuginfo version play pause unpause togglepause stop next prev volume repeat random single consume seek clear add addyt outputs toggleoutput enableoutput disableoutput status song mount unmount listmounts help" -f -a "single" -d 'On, off or oneshot'
complete -c rmpc -n "__fish_rmpc_using_subcommand help; and not __fish_seen_subcommand_from config theme albumart debuginfo version play pause unpause togglepause stop next prev volume repeat random single consume seek clear add addyt outputs toggleoutput enableoutput disableoutput status song mount unmount listmounts help" -f -a "consume" -d 'On, off or oneshot'
complete -c rmpc -n "__fish_rmpc_using_subcommand help; and not __fish_seen_subcommand_from config theme albumart debuginfo version play pause unpause togglepause stop next prev volume repeat random single consume seek clear add addyt outputs toggleoutput enableoutput disableoutput status song mount unmount listmounts help" -f -a "seek" -d 'Seeks current song(seconds), relative if prefixed by + or -'
complete -c rmpc -n "__fish_rmpc_using_subcommand help; and not __fish_seen_subcommand_from config theme albumart debuginfo version play pause unpause togglepause stop next prev volume repeat random single consume seek clear add addyt outputs toggleoutput enableoutput disableoutput status song mount unmount listmounts help" -f -a "clear" -d 'Clear the current queue'
complete -c rmpc -n "__fish_rmpc_using_subcommand help; and not __fish_seen_subcommand_from config theme albumart debuginfo version play pause unpause togglepause stop next prev volume repeat random single consume seek clear add addyt outputs toggleoutput enableoutput disableoutput status song mount unmount listmounts help" -f -a "add" -d 'Add a song to the current queue. Relative to music database root. \'/\' to add all files to the queue'
complete -c rmpc -n "__fish_rmpc_using_subcommand help; and not __fish_seen_subcommand_from config theme albumart debuginfo version play pause unpause togglepause stop next prev volume repeat random single consume seek clear add addyt outputs toggleoutput enableoutput disableoutput status song mount unmount listmounts help" -f -a "addyt" -d 'Add a song from youtube to the current queue'
complete -c rmpc -n "__fish_rmpc_using_subcommand help; and not __fish_seen_subcommand_from config theme albumart debuginfo version play pause unpause togglepause stop next prev volume repeat random single consume seek clear add addyt outputs toggleoutput enableoutput disableoutput status song mount unmount listmounts help" -f -a "outputs" -d 'List MPD outputs'
complete -c rmpc -n "__fish_rmpc_using_subcommand help; and not __fish_seen_subcommand_from config theme albumart debuginfo version play pause unpause togglepause stop next prev volume repeat random single consume seek clear add addyt outputs toggleoutput enableoutput disableoutput status song mount unmount listmounts help" -f -a "toggleoutput" -d 'Toggle MPD output on or off'
complete -c rmpc -n "__fish_rmpc_using_subcommand help; and not __fish_seen_subcommand_from config theme albumart debuginfo version play pause unpause togglepause stop next prev volume repeat random single consume seek clear add addyt outputs toggleoutput enableoutput disableoutput status song mount unmount listmounts help" -f -a "enableoutput" -d 'Enable MPD output'
complete -c rmpc -n "__fish_rmpc_using_subcommand help; and not __fish_seen_subcommand_from config theme albumart debuginfo version play pause unpause togglepause stop next prev volume repeat random single consume seek clear add addyt outputs toggleoutput enableoutput disableoutput status song mount unmount listmounts help" -f -a "disableoutput" -d 'Disable MPD output'
complete -c rmpc -n "__fish_rmpc_using_subcommand help; and not __fish_seen_subcommand_from config theme albumart debuginfo version play pause unpause togglepause stop next prev volume repeat random single consume seek clear add addyt outputs toggleoutput enableoutput disableoutput status song mount unmount listmounts help" -f -a "status" -d 'Prints various information like the playback status'
complete -c rmpc -n "__fish_rmpc_using_subcommand help; and not __fish_seen_subcommand_from config theme albumart debuginfo version play pause unpause togglepause stop next prev volume repeat random single consume seek clear add addyt outputs toggleoutput enableoutput disableoutput status song mount unmount listmounts help" -f -a "song" -d 'Prints info about the current song. If --path specified, prints information about the song at the given path instead. If --path is specified multiple times, prints an array containing all the songs'
complete -c rmpc -n "__fish_rmpc_using_subcommand help; and not __fish_seen_subcommand_from config theme albumart debuginfo version play pause unpause togglepause stop next prev volume repeat random single consume seek clear add addyt outputs toggleoutput enableoutput disableoutput status song mount unmount listmounts help" -f -a "mount" -d 'Mounts supported storage to MPD'
complete -c rmpc -n "__fish_rmpc_using_subcommand help; and not __fish_seen_subcommand_from config theme albumart debuginfo version play pause unpause togglepause stop next prev volume repeat random single consume seek clear add addyt outputs toggleoutput enableoutput disableoutput status song mount unmount listmounts help" -f -a "unmount" -d 'Unmounts storage with given name'
complete -c rmpc -n "__fish_rmpc_using_subcommand help; and not __fish_seen_subcommand_from config theme albumart debuginfo version play pause unpause togglepause stop next prev volume repeat random single consume seek clear add addyt outputs toggleoutput enableoutput disableoutput status song mount unmount listmounts help" -f -a "listmounts" -d 'List currently mounted storages'
complete -c rmpc -n "__fish_rmpc_using_subcommand help; and not __fish_seen_subcommand_from config theme albumart debuginfo version play pause unpause togglepause stop next prev volume repeat random single consume seek clear add addyt outputs toggleoutput enableoutput disableoutput status song mount unmount listmounts help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
