# frozen_string_literal: true

# The code was auto-generated by {this script}[https://github.com/cucumber/messages/blob/main/jsonschema/scripts/codegen.rb]
module Cucumber
  module Messages
    ##
    # Represents the Envelope message in Cucumber's {message protocol}[https://github.com/cucumber/messages].
    ##
    #
    # When removing a field, replace it with reserved, rather than deleting the line.
    #  When adding a field, add it to the end and increment the number by one.
    #  See https://developers.google.com/protocol-buffers/docs/proto#updating for details
    #
    # *
    #  All the messages that are passed between different components/processes are Envelope
    #  messages.
    ##
    class Envelope < Message
      attr_reader :attachment

      attr_reader :gherkin_document

      attr_reader :hook

      attr_reader :meta

      attr_reader :parameter_type

      attr_reader :parse_error

      attr_reader :pickle

      attr_reader :source

      attr_reader :step_definition

      attr_reader :test_case

      attr_reader :test_case_finished

      attr_reader :test_case_started

      attr_reader :test_run_finished

      attr_reader :test_run_started

      attr_reader :test_step_finished

      attr_reader :test_step_started

      attr_reader :undefined_parameter_type

      def initialize(
        attachment: nil,
        gherkin_document: nil,
        hook: nil,
        meta: nil,
        parameter_type: nil,
        parse_error: nil,
        pickle: nil,
        source: nil,
        step_definition: nil,
        test_case: nil,
        test_case_finished: nil,
        test_case_started: nil,
        test_run_finished: nil,
        test_run_started: nil,
        test_step_finished: nil,
        test_step_started: nil,
        undefined_parameter_type: nil
      )
        @attachment = attachment
        @gherkin_document = gherkin_document
        @hook = hook
        @meta = meta
        @parameter_type = parameter_type
        @parse_error = parse_error
        @pickle = pickle
        @source = source
        @step_definition = step_definition
        @test_case = test_case
        @test_case_finished = test_case_finished
        @test_case_started = test_case_started
        @test_run_finished = test_run_finished
        @test_run_started = test_run_started
        @test_step_finished = test_step_finished
        @test_step_started = test_step_started
        @undefined_parameter_type = undefined_parameter_type
        super()
      end

      ##
      # Returns a new Envelope from the given hash.
      # If the hash keys are camelCased, they are properly assigned to the
      # corresponding snake_cased attributes.
      #
      #   Cucumber::Messages::Envelope.from_h(some_hash) # => #<Cucumber::Messages::Envelope:0x... ...>
      ##
      def self.from_h(hash)
        return nil if hash.nil?

        new(
          attachment: Attachment.from_h(hash[:attachment]),
          gherkin_document: GherkinDocument.from_h(hash[:gherkinDocument]),
          hook: Hook.from_h(hash[:hook]),
          meta: Meta.from_h(hash[:meta]),
          parameter_type: ParameterType.from_h(hash[:parameterType]),
          parse_error: ParseError.from_h(hash[:parseError]),
          pickle: Pickle.from_h(hash[:pickle]),
          source: Source.from_h(hash[:source]),
          step_definition: StepDefinition.from_h(hash[:stepDefinition]),
          test_case: TestCase.from_h(hash[:testCase]),
          test_case_finished: TestCaseFinished.from_h(hash[:testCaseFinished]),
          test_case_started: TestCaseStarted.from_h(hash[:testCaseStarted]),
          test_run_finished: TestRunFinished.from_h(hash[:testRunFinished]),
          test_run_started: TestRunStarted.from_h(hash[:testRunStarted]),
          test_step_finished: TestStepFinished.from_h(hash[:testStepFinished]),
          test_step_started: TestStepStarted.from_h(hash[:testStepStarted]),
          undefined_parameter_type: UndefinedParameterType.from_h(hash[:undefinedParameterType])
        )
      end
    end
  end
end
