"use strict";
/* eslint-disable @typescript-eslint/explicit-function-return-type */
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.nib = void 0;
const assert_1 = __importDefault(require("assert"));
const struct_1 = require("../struct");
const nwk_key_descriptor_1 = require("./nwk-key-descriptor");
/**
 * Creates a NIB (Network Information Base) struct.
 *
 * *Definition from Z-Stack 3.0.2 `nwk.h`*
 *
 * @param data Data to initialize structure with.
 */
const nib = (data) => {
    (0, assert_1.default)(!Array.isArray(data));
    return struct_1.Struct.new()
        .member('uint8', 'SequenceNum')
        .member('uint8', 'PassiveAckTimeout')
        .member('uint8', 'MaxBroadcastRetries')
        .member('uint8', 'MaxChildren')
        .member('uint8', 'MaxDepth')
        .member('uint8', 'MaxRouters')
        .member('uint8', 'dummyNeighborTable')
        .member('uint8', 'BroadcastDeliveryTime')
        .member('uint8', 'ReportConstantCost')
        .member('uint8', 'RouteDiscRetries')
        .member('uint8', 'dummyRoutingTable')
        .member('uint8', 'SecureAllFrames')
        .member('uint8', 'SecurityLevel')
        .member('uint8', 'SymLink')
        .member('uint8', 'CapabilityFlags')
        .member('uint16', 'TransactionPersistenceTime')
        .member('uint8', 'nwkProtocolVersion')
        .member('uint8', 'RouteDiscoveryTime')
        .member('uint8', 'RouteExpiryTime')
        .member('uint16', 'nwkDevAddress')
        .member('uint8', 'nwkLogicalChannel')
        .member('uint16', 'nwkCoordAddress')
        .member('uint8array-reversed', 'nwkCoordExtAddress', 8)
        .member('uint16', 'nwkPanId')
        .member('uint8', 'nwkState')
        .member('uint32', 'channelList')
        .member('uint8', 'beaconOrder')
        .member('uint8', 'superFrameOrder')
        .member('uint8', 'scanDuration')
        .member('uint8', 'battLifeExt')
        .member('uint32', 'allocatedRouterAddresses')
        .member('uint32', 'allocatedEndDeviceAddresses')
        .member('uint8', 'nodeDepth')
        .member('uint8array-reversed', 'extendedPANID', 8)
        .member('uint8', 'nwkKeyLoaded')
        .member('struct', 'spare1', nwk_key_descriptor_1.nwkKeyDescriptor)
        .member('struct', 'spare2', nwk_key_descriptor_1.nwkKeyDescriptor)
        .member('uint8', 'spare3')
        .member('uint8', 'spare4')
        .member('uint8', 'nwkLinkStatusPeriod')
        .member('uint8', 'nwkRouterAgeLimit')
        .member('uint8', 'nwkUseMultiCast')
        .member('uint8', 'nwkIsConcentrator')
        .member('uint8', 'nwkConcentratorDiscoveryTime')
        .member('uint8', 'nwkConcentratorRadius')
        .member('uint8', 'nwkAllFresh')
        .member('uint16', 'nwkManagerAddr')
        .member('uint16', 'nwkTotalTransmissions')
        .member('uint8', 'nwkUpdateId')
        .build(data);
};
exports.nib = nib;
//# sourceMappingURL=nib.js.map