/*
 * Decompiled with CFR 0.152.
 */
package com.password4j;

import com.password4j.AbstractHashingFunction;
import com.password4j.BadParametersException;
import com.password4j.Blake2b;
import com.password4j.Hash;
import com.password4j.HashingFunction;
import com.password4j.SaltGenerator;
import com.password4j.Utils;
import com.password4j.types.Argon2;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

public class Argon2Function
extends AbstractHashingFunction {
    public static final int ARGON2_VERSION_10 = 16;
    public static final int ARGON2_VERSION_13 = 19;
    public static final int ARGON2_INITIAL_DIGEST_LENGTH = 64;
    public static final int ARGON2_ADDRESSES_IN_BLOCK = 128;
    private static final ConcurrentMap<String, Argon2Function> INSTANCES = new ConcurrentHashMap<String, Argon2Function>();
    private static final int ARGON2_SYNC_POINTS = 4;
    private static final int ARGON2_INITIAL_SEED_LENGTH = 72;
    private static final int ARGON2_BLOCK_SIZE = 1024;
    public static final int ARGON2_QWORDS_IN_BLOCK = 128;
    private final int iterations;
    private final int memory;
    private final long[][] initialBlockMemory;
    private final int parallelism;
    private final int outputLength;
    private final int segmentLength;
    private final Argon2 variant;
    private final int version;
    private final int laneLength;
    private ExecutorService service;

    Argon2Function(int memory, int iterations, int parallelism, int outputLength, Argon2 variant, int version) {
        this.variant = variant;
        this.iterations = iterations;
        this.memory = memory;
        this.parallelism = parallelism;
        this.outputLength = outputLength;
        this.version = version;
        int memoryBlocks = this.memory;
        if (this.memory < 8 * parallelism) {
            memoryBlocks = 8 * parallelism;
        }
        this.segmentLength = memoryBlocks / (parallelism * 4);
        this.laneLength = this.segmentLength * 4;
        memoryBlocks = this.segmentLength * (parallelism * 4);
        this.initialBlockMemory = new long[memoryBlocks][128];
        for (int i = 0; i < memoryBlocks; ++i) {
            this.initialBlockMemory[i] = new long[128];
        }
        if (parallelism >= 1) {
            this.service = Utils.createExecutorService();
        }
    }

    public static Argon2Function getInstance(int memory, int iterations, int parallelism, int outputLength, Argon2 type) {
        return Argon2Function.getInstance(memory, iterations, parallelism, outputLength, type, 19);
    }

    public static Argon2Function getInstance(int memory, int iterations, int parallelism, int outputLength, Argon2 type, int version) {
        String key = Argon2Function.getUID(memory, iterations, parallelism, outputLength, type, version);
        if (INSTANCES.containsKey(key)) {
            return (Argon2Function)INSTANCES.get(key);
        }
        Argon2Function function = new Argon2Function(memory, iterations, parallelism, outputLength, type, version);
        INSTANCES.put(key, function);
        return function;
    }

    public static Argon2Function getInstanceFromHash(String hashed) {
        Object[] params = Argon2Function.decodeHash(hashed);
        Argon2 type = Argon2.valueOf(((String)params[0]).toUpperCase());
        int version = (Integer)params[1];
        int memory = (Integer)params[2];
        int iterations = (Integer)params[3];
        int parallelism = (Integer)params[4];
        int outputLength = ((byte[])params[6]).length;
        return Argon2Function.getInstance(memory, iterations, parallelism, outputLength, type, version);
    }

    protected static String getUID(int memory, int iterations, int parallelism, int outputLength, Argon2 type, int version) {
        return memory + "|" + iterations + "|" + parallelism + "|" + outputLength + "|" + type.ordinal() + "|" + version;
    }

    private static byte[] getInitialHashLong(byte[] initialHash, byte[] appendix) {
        byte[] initialHashLong = new byte[72];
        System.arraycopy(initialHash, 0, initialHashLong, 0, 64);
        System.arraycopy(appendix, 0, initialHashLong, 64, 4);
        return initialHashLong;
    }

    private static void updateWithLength(Blake2b blake2b, byte[] input) {
        if (input != null) {
            blake2b.update(Utils.intToLittleEndianBytes(input.length));
            blake2b.update(input);
        } else {
            blake2b.update(Utils.intToLittleEndianBytes(0));
        }
    }

    private static int getStartingIndex(int pass, int slice) {
        if (pass == 0 && slice == 0) {
            return 2;
        }
        return 0;
    }

    private static void nextAddresses(long[] zeroBlock, long[] inputBlock, long[] addressBlock) {
        inputBlock[6] = inputBlock[6] + 1L;
        Argon2Function.fillBlock(zeroBlock, inputBlock, addressBlock, false);
        Argon2Function.fillBlock(zeroBlock, addressBlock, addressBlock, false);
    }

    private static void fillBlock(long[] x, long[] y, long[] currentBlock, boolean withXor) {
        int i;
        long[] r = new long[128];
        long[] z = new long[128];
        Utils.xor(r, x, y);
        System.arraycopy(r, 0, z, 0, z.length);
        for (i = 0; i < 8; ++i) {
            Argon2Function.roundFunction(z, 16 * i, 16 * i + 1, 16 * i + 2, 16 * i + 3, 16 * i + 4, 16 * i + 5, 16 * i + 6, 16 * i + 7, 16 * i + 8, 16 * i + 9, 16 * i + 10, 16 * i + 11, 16 * i + 12, 16 * i + 13, 16 * i + 14, 16 * i + 15);
        }
        for (i = 0; i < 8; ++i) {
            Argon2Function.roundFunction(z, 2 * i, 2 * i + 1, 2 * i + 16, 2 * i + 17, 2 * i + 32, 2 * i + 33, 2 * i + 48, 2 * i + 49, 2 * i + 64, 2 * i + 65, 2 * i + 80, 2 * i + 81, 2 * i + 96, 2 * i + 97, 2 * i + 112, 2 * i + 113);
        }
        if (withXor) {
            Utils.xor(currentBlock, r, z, currentBlock);
        } else {
            Utils.xor(currentBlock, r, z);
        }
    }

    private static void roundFunction(long[] block, int v0, int v1, int v2, int v3, int v4, int v5, int v6, int v7, int v8, int v9, int v10, int v11, int v12, int v13, int v14, int v15) {
        Argon2Function.f(block, v0, v4, v8, v12);
        Argon2Function.f(block, v1, v5, v9, v13);
        Argon2Function.f(block, v2, v6, v10, v14);
        Argon2Function.f(block, v3, v7, v11, v15);
        Argon2Function.f(block, v0, v5, v10, v15);
        Argon2Function.f(block, v1, v6, v11, v12);
        Argon2Function.f(block, v2, v7, v8, v13);
        Argon2Function.f(block, v3, v4, v9, v14);
    }

    private static void f(long[] block, int a, int b, int c, int d) {
        Argon2Function.fBlaMka(block, a, b);
        Argon2Function.rotr64(block, d, a, 32L);
        Argon2Function.fBlaMka(block, c, d);
        Argon2Function.rotr64(block, b, c, 24L);
        Argon2Function.fBlaMka(block, a, b);
        Argon2Function.rotr64(block, d, a, 16L);
        Argon2Function.fBlaMka(block, c, d);
        Argon2Function.rotr64(block, b, c, 63L);
    }

    private static void fBlaMka(long[] block, int x, int y) {
        long m = 0xFFFFFFFFL;
        long xy = (block[x] & 0xFFFFFFFFL) * (block[y] & 0xFFFFFFFFL);
        block[x] = block[x] + block[y] + 2L * xy;
    }

    private static void rotr64(long[] block, int v, int w, long c) {
        long temp = block[v] ^ block[w];
        block[v] = temp >>> (int)c | temp << (int)(64L - c);
    }

    private static Object[] decodeHash(String hash) {
        Object[] result = new Object[7];
        String[] parts = hash.split("\\$");
        if (parts.length == 6) {
            result[0] = Argon2Function.remove(parts[1], "argon2");
            String[] params = parts[3].split(",");
            result[1] = Integer.parseInt(Argon2Function.remove(parts[2], "v="));
            result[2] = Integer.parseInt(Argon2Function.remove(params[0], "m="));
            result[3] = Integer.parseInt(Argon2Function.remove(params[1], "t="));
            result[4] = Integer.parseInt(Argon2Function.remove(params[2], "p="));
            result[5] = Utils.decodeBase64(parts[4]);
            result[6] = Utils.decodeBase64(parts[5]);
            return result;
        }
        throw new BadParametersException("Invalid hashed value");
    }

    protected static String toString(int memory, int iterations, int parallelism, int outputLength, Argon2 type, int version) {
        return "m=" + memory + ", i=" + iterations + ", p=" + parallelism + ", l=" + outputLength + ", t=" + type.name() + ", v=" + version;
    }

    private static String remove(String source, String remove) {
        return source.substring(remove.length());
    }

    @Override
    public Hash hash(CharSequence plainTextPassword) {
        byte[] salt = SaltGenerator.generate();
        return this.internalHash(Utils.fromCharSequenceToBytes(plainTextPassword), salt, null);
    }

    @Override
    public Hash hash(byte[] plainTextPassword) {
        byte[] salt = SaltGenerator.generate();
        return this.internalHash(plainTextPassword, salt, null);
    }

    @Override
    public Hash hash(CharSequence plainTextPassword, String salt) {
        return this.hash(plainTextPassword, salt, null);
    }

    @Override
    public Hash hash(byte[] plainTextPassword, byte[] salt) {
        return this.hash(plainTextPassword, salt, null);
    }

    @Override
    public Hash hash(CharSequence plainTextPassword, String salt, CharSequence pepper) {
        return this.internalHash(Utils.fromCharSequenceToBytes(plainTextPassword), Utils.fromCharSequenceToBytes(salt), pepper);
    }

    @Override
    public Hash hash(byte[] plainTextPassword, byte[] salt, CharSequence pepper) {
        return this.internalHash(plainTextPassword, salt, pepper);
    }

    private Hash internalHash(byte[] plainTextPassword, byte[] salt, CharSequence pepper) {
        long[][] blockMemory = this.copyOf(this.initialBlockMemory);
        if (salt == null) {
            salt = SaltGenerator.generate();
        }
        this.initialize(plainTextPassword, salt, Utils.fromCharSequenceToBytes(pepper), null, blockMemory);
        this.fillMemoryBlocks(blockMemory);
        byte[] hash = this.ending(blockMemory);
        Hash result = new Hash((HashingFunction)this, this.encodeHash(hash, salt), hash, salt);
        result.setPepper(pepper);
        return result;
    }

    @Override
    public boolean check(CharSequence plainTextPassword, String hashed) {
        return this.check(plainTextPassword, hashed, null, null);
    }

    @Override
    public boolean check(byte[] plainTextPassword, byte[] hashed) {
        return this.check(plainTextPassword, hashed, null, null);
    }

    @Override
    public boolean check(CharSequence plainTextPassword, String hashed, String salt, CharSequence pepper) {
        byte[] plainTextPasswordAsBytes = Utils.fromCharSequenceToBytes(plainTextPassword);
        byte[] saltAsBytes = Utils.fromCharSequenceToBytes(salt);
        byte[] hashedAsBytes = Utils.fromCharSequenceToBytes(hashed);
        return this.check(plainTextPasswordAsBytes, hashedAsBytes, saltAsBytes, pepper);
    }

    @Override
    public boolean check(byte[] plainTextPassword, byte[] hashed, byte[] salt, CharSequence pepper) {
        byte[] theSalt;
        if (salt == null || salt.length == 0) {
            Object[] params = Argon2Function.decodeHash(Utils.fromBytesToString(hashed));
            theSalt = (byte[])params[5];
        } else {
            theSalt = salt;
        }
        Hash internalHash = this.internalHash(plainTextPassword, theSalt, pepper);
        return Argon2Function.slowEquals(internalHash.getResultAsBytes(), hashed);
    }

    public int getMemory() {
        return this.memory;
    }

    public int getIterations() {
        return this.iterations;
    }

    public int getParallelism() {
        return this.parallelism;
    }

    public int getOutputLength() {
        return this.outputLength;
    }

    public Argon2 getVariant() {
        return this.variant;
    }

    public int getVersion() {
        return this.version;
    }

    private void initialize(byte[] plainTextPassword, byte[] salt, byte[] secret, byte[] additional, long[][] blockMemory) {
        Blake2b blake2b = new Blake2b(64);
        blake2b.update(Utils.intToLittleEndianBytes(this.parallelism));
        blake2b.update(Utils.intToLittleEndianBytes(this.outputLength));
        blake2b.update(Utils.intToLittleEndianBytes(this.memory));
        blake2b.update(Utils.intToLittleEndianBytes(this.iterations));
        blake2b.update(Utils.intToLittleEndianBytes(this.version));
        blake2b.update(Utils.intToLittleEndianBytes(this.variant.ordinal()));
        Argon2Function.updateWithLength(blake2b, plainTextPassword);
        Argon2Function.updateWithLength(blake2b, salt);
        Argon2Function.updateWithLength(blake2b, secret);
        Argon2Function.updateWithLength(blake2b, additional);
        byte[] initialHash = new byte[64];
        blake2b.doFinal(initialHash, 0);
        byte[] zeroBytes = new byte[]{0, 0, 0, 0};
        byte[] oneBytes = new byte[]{1, 0, 0, 0};
        byte[] initialHashWithZeros = Argon2Function.getInitialHashLong(initialHash, zeroBytes);
        byte[] initialHashWithOnes = Argon2Function.getInitialHashLong(initialHash, oneBytes);
        for (int i = 0; i < this.parallelism; ++i) {
            byte[] iBytes = Utils.intToLittleEndianBytes(i);
            System.arraycopy(iBytes, 0, initialHashWithZeros, 68, 4);
            System.arraycopy(iBytes, 0, initialHashWithOnes, 68, 4);
            byte[] blockHashBytes = this.blake2bLong(initialHashWithZeros, 1024);
            blockMemory[i * this.laneLength] = Utils.fromBytesToLongs(blockHashBytes);
            blockHashBytes = this.blake2bLong(initialHashWithOnes, 1024);
            blockMemory[i * this.laneLength + 1] = Utils.fromBytesToLongs(blockHashBytes);
        }
    }

    private byte[] blake2bLong(byte[] input, int outputLength) {
        byte[] result = new byte[outputLength];
        byte[] outlenBytes = Utils.intToLittleEndianBytes(outputLength);
        int blake2bLength = 64;
        if (outputLength <= blake2bLength) {
            result = this.simpleBlake2b(input, outlenBytes, outputLength);
        } else {
            byte[] outBuffer = this.simpleBlake2b(input, outlenBytes, blake2bLength);
            System.arraycopy(outBuffer, 0, result, 0, blake2bLength / 2);
            int r = outputLength / 32 + (outputLength % 32 == 0 ? 0 : 1) - 2;
            int position = blake2bLength / 2;
            int i = 2;
            while (i <= r) {
                outBuffer = this.simpleBlake2b(outBuffer, null, blake2bLength);
                System.arraycopy(outBuffer, 0, result, position, blake2bLength / 2);
                ++i;
                position += blake2bLength / 2;
            }
            int lastLength = outputLength - 32 * r;
            outBuffer = this.simpleBlake2b(outBuffer, null, lastLength);
            System.arraycopy(outBuffer, 0, result, position, lastLength);
        }
        return result;
    }

    private byte[] simpleBlake2b(byte[] input, byte[] outlenBytes, int outputLength) {
        Blake2b blake2b = new Blake2b(outputLength);
        if (outlenBytes != null) {
            blake2b.update(outlenBytes);
        }
        blake2b.update(input);
        byte[] buff = new byte[outputLength];
        blake2b.doFinal(buff, 0);
        return buff;
    }

    private void fillMemoryBlocks(long[][] blockMemory) {
        if (this.parallelism == 1) {
            this.fillMemoryBlockSingleThreaded(blockMemory);
        } else {
            this.fillMemoryBlockMultiThreaded(blockMemory);
        }
    }

    private void fillMemoryBlockSingleThreaded(long[][] blockMemory) {
        for (int pass = 0; pass < this.iterations; ++pass) {
            for (int slice = 0; slice < 4; ++slice) {
                this.fillSegment(pass, 0, slice, blockMemory);
            }
        }
    }

    private void fillMemoryBlockMultiThreaded(long[][] blockMemory) {
        ArrayList futures = new ArrayList();
        for (int i = 0; i < this.iterations; ++i) {
            for (int j = 0; j < 4; ++j) {
                int k = 0;
                while (k < this.parallelism) {
                    int n = i;
                    int lane = k++;
                    int slice = j;
                    Future<?> future = this.service.submit(() -> this.fillSegment(pass, lane, slice, blockMemory));
                    futures.add(future);
                }
                try {
                    for (Future future : futures) {
                        future.get();
                    }
                    continue;
                }
                catch (InterruptedException | ExecutionException e) {
                    this.clear(blockMemory);
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    private void fillSegment(int pass, int lane, int slice, long[][] blockMemory) {
        long[] addressBlock = null;
        long[] inputBlock = null;
        long[] zeroBlock = null;
        boolean dataIndependentAddressing = this.isDataIndependentAddressing(pass, slice);
        int startingIndex = Argon2Function.getStartingIndex(pass, slice);
        int currentOffset = lane * this.laneLength + slice * this.segmentLength + startingIndex;
        int prevOffset = this.getPrevOffset(currentOffset);
        if (dataIndependentAddressing) {
            addressBlock = new long[128];
            zeroBlock = new long[128];
            inputBlock = new long[128];
            this.initAddressBlocks(pass, lane, slice, zeroBlock, inputBlock, addressBlock, blockMemory);
        }
        int i = startingIndex;
        while (i < this.segmentLength) {
            long pseudoRandom;
            int refLane = this.getRefLane(pass, lane, slice, pseudoRandom = this.getPseudoRandom(i, addressBlock, inputBlock, zeroBlock, prevOffset = this.rotatePrevOffset(currentOffset, prevOffset), dataIndependentAddressing, blockMemory));
            int refColumn = this.getRefColumn(pass, slice, i, pseudoRandom, refLane == lane);
            long[] prevBlock = blockMemory[prevOffset];
            long[] refBlock = blockMemory[this.laneLength * refLane + refColumn];
            long[] currentBlock = blockMemory[currentOffset];
            boolean withXor = this.isWithXor(pass);
            Argon2Function.fillBlock(prevBlock, refBlock, currentBlock, withXor);
            ++i;
            ++currentOffset;
            ++prevOffset;
        }
    }

    private boolean isDataIndependentAddressing(int pass, int slice) {
        return this.variant == Argon2.I || this.variant == Argon2.ID && pass == 0 && slice < 2;
    }

    private int getPrevOffset(int currentOffset) {
        if (currentOffset % this.laneLength == 0) {
            return currentOffset + this.laneLength - 1;
        }
        return currentOffset - 1;
    }

    private int rotatePrevOffset(int currentOffset, int prevOffset) {
        if (currentOffset % this.laneLength == 1) {
            prevOffset = currentOffset - 1;
        }
        return prevOffset;
    }

    private long getPseudoRandom(int index, long[] addressBlock, long[] inputBlock, long[] zeroBlock, int prevOffset, boolean dataIndependentAddressing, long[][] blockMemory) {
        if (dataIndependentAddressing) {
            if (index % 128 == 0) {
                Argon2Function.nextAddresses(zeroBlock, inputBlock, addressBlock);
            }
            return addressBlock[index % 128];
        }
        return blockMemory[prevOffset][0];
    }

    private int getRefLane(int pass, int lane, int slice, long pseudoRandom) {
        int refLane = (int)((pseudoRandom >>> 32) % (long)this.parallelism);
        if (pass == 0 && slice == 0) {
            refLane = lane;
        }
        return refLane;
    }

    private void initAddressBlocks(int pass, int lane, int slice, long[] zeroBlock, long[] inputBlock, long[] addressBlock, long[][] blockMemory) {
        inputBlock[0] = Utils.intToLong(pass);
        inputBlock[1] = Utils.intToLong(lane);
        inputBlock[2] = Utils.intToLong(slice);
        inputBlock[3] = Utils.intToLong(blockMemory.length);
        inputBlock[4] = Utils.intToLong(this.iterations);
        inputBlock[5] = Utils.intToLong(this.variant.ordinal());
        if (pass == 0 && slice == 0) {
            Argon2Function.nextAddresses(zeroBlock, inputBlock, addressBlock);
        }
    }

    private int getRefColumn(int pass, int slice, int index, long pseudoRandom, boolean sameLane) {
        int referenceAreaSize;
        int startPosition;
        if (pass == 0) {
            startPosition = 0;
            referenceAreaSize = sameLane ? slice * this.segmentLength + index - 1 : slice * this.segmentLength + (index == 0 ? -1 : 0);
        } else {
            startPosition = (slice + 1) * this.segmentLength % this.laneLength;
            referenceAreaSize = sameLane ? this.laneLength - this.segmentLength + index - 1 : this.laneLength - this.segmentLength + (index == 0 ? -1 : 0);
        }
        long relativePosition = pseudoRandom & 0xFFFFFFFFL;
        relativePosition = relativePosition * relativePosition >>> 32;
        relativePosition = (long)(referenceAreaSize - 1) - ((long)referenceAreaSize * relativePosition >>> 32);
        return (int)((long)startPosition + relativePosition) % this.laneLength;
    }

    private boolean isWithXor(int pass) {
        return pass != 0 && this.version != 16;
    }

    private byte[] ending(long[][] blockMemory) {
        long[] finalBlock = blockMemory[this.laneLength - 1];
        for (int i = 1; i < this.parallelism; ++i) {
            int lastBlockInLane = i * this.laneLength + (this.laneLength - 1);
            Utils.xor(finalBlock, blockMemory[lastBlockInLane]);
        }
        byte[] finalBlockBytes = new byte[1024];
        for (int i = 0; i < finalBlock.length; ++i) {
            byte[] bytes = Utils.longToLittleEndianBytes(finalBlock[i]);
            System.arraycopy(bytes, 0, finalBlockBytes, i * bytes.length, bytes.length);
        }
        byte[] finalResult = this.blake2bLong(finalBlockBytes, this.outputLength);
        this.clear(blockMemory);
        return finalResult;
    }

    private void clear(long[][] blockMemory) {
        for (long[] block : blockMemory) {
            Arrays.fill(block, 0L);
        }
    }

    private long[][] copyOf(long[][] old) {
        long[][] current = new long[old.length][128];
        for (int i = 0; i < old.length; ++i) {
            System.arraycopy(current[i], 0, old[i], 0, 128);
        }
        return current;
    }

    private String encodeHash(byte[] hash, byte[] salt) {
        return "$argon2" + this.variant.name().toLowerCase() + "$v=" + this.version + "$m=" + this.memory + ",t=" + this.iterations + ",p=" + this.parallelism + "$" + Utils.encodeBase64(salt, false) + "$" + Utils.encodeBase64(hash, false);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Argon2Function)) {
            return false;
        }
        Argon2Function other = (Argon2Function)o;
        return this.iterations == other.iterations && this.memory == other.memory && this.parallelism == other.parallelism && this.outputLength == other.outputLength && this.version == other.version && this.variant == other.variant;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.iterations, this.memory, this.parallelism, this.outputLength, this.variant, this.version});
    }

    public String toString() {
        return this.getClass().getSimpleName() + '[' + Argon2Function.toString(this.memory, this.iterations, this.parallelism, this.outputLength, this.variant, this.version) + ']';
    }
}

