/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.ast.tree;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.opensearch.sql.ast.AbstractNodeVisitor;
import org.opensearch.sql.ast.expression.QualifiedName;
import org.opensearch.sql.ast.expression.UnresolvedExpression;
import org.opensearch.sql.ast.tree.UnresolvedPlan;

public class Relation
extends UnresolvedPlan {
    private static final String COMMA = ",";
    private final List<UnresolvedExpression> tableName;
    private String alias;

    public Relation(UnresolvedExpression tableName) {
        this(tableName, null);
    }

    public Relation(UnresolvedExpression tableName, String alias) {
        this.tableName = Arrays.asList(tableName);
        this.alias = alias;
    }

    public String getTableName() {
        return this.getTableQualifiedName().toString();
    }

    public String getTableNameOrAlias() {
        return this.alias == null ? this.getTableName() : this.alias;
    }

    public String getAlias() {
        return this.alias;
    }

    public QualifiedName getTableQualifiedName() {
        if (this.tableName.size() == 1) {
            return (QualifiedName)this.tableName.get(0);
        }
        return new QualifiedName(this.tableName.stream().map(UnresolvedExpression::toString).collect(Collectors.joining(COMMA)));
    }

    public List<UnresolvedPlan> getChild() {
        return ImmutableList.of();
    }

    @Override
    public <T, C> T accept(AbstractNodeVisitor<T, C> nodeVisitor, C context) {
        return nodeVisitor.visitRelation(this, context);
    }

    @Override
    public UnresolvedPlan attach(UnresolvedPlan child) {
        return this;
    }

    @Generated
    public Relation(List<UnresolvedExpression> tableName, String alias) {
        this.tableName = tableName;
        this.alias = alias;
    }

    @Override
    @Generated
    public String toString() {
        return "Relation(tableName=" + this.getTableName() + ", alias=" + this.getAlias() + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Relation)) {
            return false;
        }
        Relation other = (Relation)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$tableName = this.getTableName();
        String other$tableName = other.getTableName();
        if (this$tableName == null ? other$tableName != null : !this$tableName.equals(other$tableName)) {
            return false;
        }
        String this$alias = this.getAlias();
        String other$alias = other.getAlias();
        return !(this$alias == null ? other$alias != null : !this$alias.equals(other$alias));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Relation;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $tableName = this.getTableName();
        result = result * 59 + ($tableName == null ? 43 : $tableName.hashCode());
        String $alias = this.getAlias();
        result = result * 59 + ($alias == null ? 43 : $alias.hashCode());
        return result;
    }

    @Generated
    public Relation(List<UnresolvedExpression> tableName) {
        this.tableName = tableName;
    }
}

