/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.generic;

import com.dickimawbooks.texparserlib.Command;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.TeXParserUtils;
import java.io.IOException;

public class PadNumber
extends Command {
    protected int numDigits;

    public PadNumber(String string, int n) {
        super(string);
        this.numDigits = n;
    }

    @Override
    public Object clone() {
        return new PadNumber(this.getName(), this.numDigits);
    }

    @Override
    public TeXObjectList expandonce(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        int n = TeXParserUtils.popInt(teXParser, teXObjectList);
        return teXParser.getListener().createString(String.format("%0" + this.numDigits + "d", n));
    }

    @Override
    public TeXObjectList expandonce(TeXParser teXParser) throws IOException {
        return this.expandonce(teXParser, teXParser);
    }

    @Override
    public TeXObjectList expandfully(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        return this.expandonce(teXParser, teXObjectList);
    }

    @Override
    public TeXObjectList expandfully(TeXParser teXParser) throws IOException {
        return this.expandonce(teXParser);
    }

    @Override
    public void process(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        int n = TeXParserUtils.popInt(teXParser, teXObjectList);
        teXParser.getListener().getWriteable().write(String.format("%0" + this.numDigits + "d", n));
    }

    @Override
    public void process(TeXParser teXParser) throws IOException {
        this.process(teXParser, teXParser);
    }
}

