/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.protocol.response.format;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.opensearch.sql.protocol.response.QueryResult;
import org.opensearch.sql.protocol.response.format.FlatResponseBase;

public class FlatResponseWithPrettifier
extends FlatResponseBase {
    private int[] maxWidths;

    FlatResponseWithPrettifier(QueryResult response, String inlineSeparator) {
        super(response, inlineSeparator);
        this.calculateMaxWidths();
    }

    private void calculateMaxWidths() {
        int columns = this.getHeaders().size();
        this.maxWidths = new int[columns];
        for (int i = 0; i < columns; ++i) {
            int maxWidth = this.getHeaders().get(i).length();
            for (List<String> row : this.getData()) {
                maxWidth = Math.max(maxWidth, row.get(i).length());
            }
            this.maxWidths[i] = maxWidth;
        }
    }

    @Override
    protected List<String> getDataLines() {
        return this.getData().stream().map(this::prettyFormatLine).collect(Collectors.toList());
    }

    @Override
    protected String getHeaderLine() {
        return this.prettyFormatLine(this.getHeaders());
    }

    private String prettyFormatLine(List<String> line) {
        return IntStream.range(0, line.size()).mapToObj(i -> this.padRight((String)line.get(i), this.maxWidths[i])).collect(Collectors.joining(this.separator));
    }

    private String padRight(String s, int n) {
        return String.format("%-" + n + "s", s);
    }
}

