# Contributing

## Bug Reports
A good bug report involves a *demonstrable* problem in the existing code with
steps to reproduce it.  In general, include the following:

  - What was your environment?
    - ex. operating system, J-Link model, weather.
  - What was the expected behaviour vs. what was the actual behaviour?
  - Steps to reproduce.
  - Any other information you feel is relevant.
    - ex. where you think the bug might be.


## Feature Requests
Feature requests are always welcome, but please detail your feature request in
full, and explain how it would fit into the current project.


## Pull Requests
Pull requests are always welcome, but please ask first before embarking on any
significant pull request (e.g. implementing a new feature, refactoring existing
code, porting to a different language), otherwise you risk spending a lot of
time working on something that the project's developers might not want to merge
into the project.

Please adhere to the coding conventions used through the project (indentation,
comments, etc.), and any other requirements (such as test coverage).
