/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.incremental.ClassProtoData;
import org.jetbrains.kotlin.incremental.PackagePartProtoData;
import org.jetbrains.kotlin.incremental.ProtoData;
import org.jetbrains.kotlin.metadata.ProtoBuf;
import org.jetbrains.kotlin.metadata.deserialization.NameResolver;
import org.jetbrains.kotlin.metadata.deserialization.NameResolverImpl;
import org.jetbrains.kotlin.metadata.deserialization.ProtoBufUtilKt;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.serialization.SerializerExtensionProtocol;
import org.jetbrains.kotlin.serialization.deserialization.NameResolverUtilKt;
import org.jetbrains.kotlin.util.capitalizeDecapitalize.CapitalizeDecapitalizeKt;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J%\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0086\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/incremental/ProtoDataProvider;", "", "serializerProtocol", "Lorg/jetbrains/kotlin/serialization/SerializerExtensionProtocol;", "(Lorg/jetbrains/kotlin/serialization/SerializerExtensionProtocol;)V", "invoke", "", "Lorg/jetbrains/kotlin/name/ClassId;", "Lorg/jetbrains/kotlin/incremental/ProtoData;", "sourceFile", "Ljava/io/File;", "metadata", "", "kotlin-build-common"})
final class ProtoDataProvider {
    @NotNull
    private final SerializerExtensionProtocol serializerProtocol;

    public ProtoDataProvider(@NotNull SerializerExtensionProtocol serializerProtocol) {
        Intrinsics.checkNotNullParameter((Object)serializerProtocol, (String)"serializerProtocol");
        this.serializerProtocol = serializerProtocol;
    }

    @NotNull
    public final Map<ClassId, ProtoData> invoke(@NotNull File sourceFile, @NotNull byte[] metadata) {
        FqName fqName2;
        Integer packageNameId;
        ProtoBuf.Package package_;
        Intrinsics.checkNotNullParameter((Object)sourceFile, (String)"sourceFile");
        Intrinsics.checkNotNullParameter((Object)metadata, (String)"metadata");
        HashMap classes2 = new HashMap();
        ProtoBuf.PackageFragment proto = ProtoBuf.PackageFragment.parseFrom(metadata, this.serializerProtocol.getExtensionRegistry());
        ProtoBuf.StringTable stringTable2 = proto.getStrings();
        Intrinsics.checkNotNullExpressionValue((Object)stringTable2, (String)"proto.strings");
        ProtoBuf.QualifiedNameTable qualifiedNameTable = proto.getQualifiedNames();
        Intrinsics.checkNotNullExpressionValue((Object)qualifiedNameTable, (String)"proto.qualifiedNames");
        NameResolverImpl nameResolver2 = new NameResolverImpl(stringTable2, qualifiedNameTable);
        List<ProtoBuf.Class> list2 = proto.getClass_List();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"proto.class_List");
        Iterable $this$forEach$iv = list2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ProtoBuf.Class it = (ProtoBuf.Class)element$iv;
            boolean bl = false;
            ClassId classId = NameResolverUtilKt.getClassId(nameResolver2, it.getFqName());
            Map map = classes2;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            map.put(classId, new ClassProtoData(it, nameResolver2));
        }
        ProtoBuf.Package $this$invoke_u24lambda_u2d2 = package_ = proto.getPackage();
        boolean bl = false;
        Intrinsics.checkNotNullExpressionValue((Object)$this$invoke_u24lambda_u2d2, (String)"");
        Integer n = packageNameId = ProtoBufUtilKt.getExtensionOrNull($this$invoke_u24lambda_u2d2, this.serializerProtocol.getPackageFqName());
        if (n != null) {
            int it = ((Number)n).intValue();
            boolean bl2 = false;
            fqName2 = new FqName(nameResolver2.getPackageFqName(it));
        } else {
            fqName2 = FqName.ROOT;
        }
        FqName packageFqName = fqName2;
        ClassId packagePartClassId = new ClassId(packageFqName, Name.identifier(CapitalizeDecapitalizeKt.capitalizeAsciiOnly(FilesKt.getNameWithoutExtension((File)sourceFile)) + "Kt"));
        Map map = classes2;
        NameResolver nameResolver3 = nameResolver2;
        Intrinsics.checkNotNullExpressionValue((Object)packageFqName, (String)"packageFqName");
        map.put(packagePartClassId, new PackagePartProtoData($this$invoke_u24lambda_u2d2, nameResolver3, packageFqName));
        return classes2;
    }
}

