/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.common.transport.upload_chunk;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import lombok.Generated;
import org.opensearch.Version;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.ml.common.AccessMode;
import org.opensearch.ml.common.FunctionName;
import org.opensearch.ml.common.MLModel;
import org.opensearch.ml.common.controller.MLRateLimiter;
import org.opensearch.ml.common.model.MLDeploySetting;
import org.opensearch.ml.common.model.MLModelConfig;
import org.opensearch.ml.common.model.MLModelFormat;
import org.opensearch.ml.common.model.MLModelState;
import org.opensearch.ml.common.model.QuestionAnsweringModelConfig;
import org.opensearch.ml.common.model.TextEmbeddingModelConfig;
import org.opensearch.ml.common.transport.register.MLRegisterModelInput;
import org.opensearch.ml.common.utils.StringUtils;

public class MLRegisterModelMetaInput
implements ToXContentObject,
Writeable {
    public static final String FUNCTION_NAME_FIELD = "function_name";
    public static final String MODEL_NAME_FIELD = "name";
    public static final String DESCRIPTION_FIELD = "description";
    public static final String IS_ENABLED_FIELD = "is_enabled";
    public static final String RATE_LIMITER_FIELD = "rate_limiter";
    public static final String VERSION_FIELD = "version";
    public static final String MODEL_FORMAT_FIELD = "model_format";
    public static final String MODEL_STATE_FIELD = "model_state";
    public static final String MODEL_CONTENT_SIZE_IN_BYTES_FIELD = "model_content_size_in_bytes";
    public static final String MODEL_CONTENT_HASH_VALUE_FIELD = "model_content_hash_value";
    public static final String MODEL_CONFIG_FIELD = "model_config";
    public static final String DEPLOY_SETTING_FIELD = "deploy_setting";
    public static final String TOTAL_CHUNKS_FIELD = "total_chunks";
    public static final String MODEL_GROUP_ID_FIELD = "model_group_id";
    public static final String BACKEND_ROLES_FIELD = "backend_roles";
    public static final String ACCESS_MODE = "access_mode";
    public static final String ADD_ALL_BACKEND_ROLES = "add_all_backend_roles";
    public static final String DOES_VERSION_CREATE_MODEL_GROUP = "does_version_create_model_group";
    private FunctionName functionName;
    private String name;
    private String modelGroupId;
    private String description;
    private String version;
    private Boolean isEnabled;
    private MLRateLimiter rateLimiter;
    private MLModelFormat modelFormat;
    private MLModelState modelState;
    private Long modelContentSizeInBytes;
    private String modelContentHashValue;
    private MLModelConfig modelConfig;
    private MLDeploySetting deploySetting;
    private Integer totalChunks;
    private List<String> backendRoles;
    private AccessMode accessMode;
    private Boolean isAddAllBackendRoles;
    private Boolean doesVersionCreateModelGroup;
    private Boolean isHidden;
    private Map<String, String> modelInterface;

    public MLRegisterModelMetaInput(String name, FunctionName functionName, String modelGroupId, String version, String description, Boolean isEnabled, MLRateLimiter rateLimiter, MLModelFormat modelFormat, MLModelState modelState, Long modelContentSizeInBytes, String modelContentHashValue, MLModelConfig modelConfig, MLDeploySetting deploySetting, Integer totalChunks, List<String> backendRoles, AccessMode accessMode, Boolean isAddAllBackendRoles, Boolean doesVersionCreateModelGroup, Boolean isHidden, Map<String, String> modelInterface) {
        if (name == null) {
            throw new IllegalArgumentException("model name is null");
        }
        this.functionName = functionName == null ? FunctionName.TEXT_EMBEDDING : functionName;
        if (modelFormat == null) {
            throw new IllegalArgumentException("model format is null");
        }
        if (modelContentHashValue == null) {
            throw new IllegalArgumentException("model content hash value is null");
        }
        if (modelConfig == null && functionName != FunctionName.SPARSE_TOKENIZE && functionName != FunctionName.SPARSE_ENCODING) {
            throw new IllegalArgumentException("model config is null");
        }
        if (totalChunks == null) {
            throw new IllegalArgumentException("total chunks field is null");
        }
        this.name = name;
        this.modelGroupId = modelGroupId;
        this.version = version;
        this.description = description;
        this.isEnabled = isEnabled;
        this.rateLimiter = rateLimiter;
        this.modelFormat = modelFormat;
        this.modelState = modelState;
        this.modelContentSizeInBytes = modelContentSizeInBytes;
        this.modelContentHashValue = modelContentHashValue;
        this.modelConfig = modelConfig;
        this.deploySetting = deploySetting;
        this.totalChunks = totalChunks;
        this.backendRoles = backendRoles;
        this.accessMode = accessMode;
        this.isAddAllBackendRoles = isAddAllBackendRoles;
        this.doesVersionCreateModelGroup = doesVersionCreateModelGroup;
        this.isHidden = isHidden;
        this.modelInterface = modelInterface;
    }

    public MLRegisterModelMetaInput(StreamInput in) throws IOException {
        Version streamInputVersion = in.getVersion();
        this.name = in.readString();
        this.functionName = (FunctionName)in.readEnum(FunctionName.class);
        this.modelGroupId = in.readOptionalString();
        this.version = in.readOptionalString();
        this.description = in.readOptionalString();
        if (in.readBoolean()) {
            this.modelFormat = (MLModelFormat)in.readEnum(MLModelFormat.class);
        }
        if (in.readBoolean()) {
            this.modelState = (MLModelState)in.readEnum(MLModelState.class);
        }
        this.modelContentSizeInBytes = in.readOptionalLong();
        this.modelContentHashValue = in.readString();
        if (in.readBoolean()) {
            this.modelConfig = this.functionName.equals((Object)FunctionName.QUESTION_ANSWERING) ? new QuestionAnsweringModelConfig(in) : new TextEmbeddingModelConfig(in);
        }
        this.totalChunks = in.readInt();
        this.backendRoles = in.readOptionalStringList();
        if (in.readBoolean()) {
            this.accessMode = (AccessMode)in.readEnum(AccessMode.class);
        }
        this.isAddAllBackendRoles = in.readOptionalBoolean();
        if (streamInputVersion.onOrAfter(MLRegisterModelInput.MINIMAL_SUPPORTED_VERSION_FOR_DOES_VERSION_CREATE_MODEL_GROUP)) {
            this.doesVersionCreateModelGroup = in.readOptionalBoolean();
        }
        if (streamInputVersion.onOrAfter(MLRegisterModelInput.MINIMAL_SUPPORTED_VERSION_FOR_AGENT_FRAMEWORK)) {
            this.isEnabled = in.readOptionalBoolean();
            if (in.readBoolean()) {
                this.rateLimiter = new MLRateLimiter(in);
            }
            this.isHidden = in.readOptionalBoolean();
        }
        if (streamInputVersion.onOrAfter(MLRegisterModelInput.MINIMAL_SUPPORTED_VERSION_FOR_GUARDRAILS_AND_AUTO_DEPLOY) && in.readBoolean()) {
            this.deploySetting = new MLDeploySetting(in);
        }
        if (streamInputVersion.onOrAfter(MLRegisterModelInput.MINIMAL_SUPPORTED_VERSION_FOR_INTERFACE) && in.readBoolean()) {
            this.modelInterface = in.readMap(StreamInput::readString, StreamInput::readString);
        }
    }

    public void writeTo(StreamOutput out) throws IOException {
        Version streamOutputVersion = out.getVersion();
        out.writeString(this.name);
        out.writeEnum((Enum)this.functionName);
        out.writeOptionalString(this.modelGroupId);
        out.writeOptionalString(this.version);
        out.writeOptionalString(this.description);
        if (this.modelFormat != null) {
            out.writeBoolean(true);
            out.writeEnum((Enum)this.modelFormat);
        } else {
            out.writeBoolean(false);
        }
        if (this.modelState != null) {
            out.writeBoolean(true);
            out.writeEnum((Enum)this.modelState);
        } else {
            out.writeBoolean(false);
        }
        out.writeOptionalLong(this.modelContentSizeInBytes);
        out.writeString(this.modelContentHashValue);
        if (this.modelConfig != null) {
            out.writeBoolean(true);
            this.modelConfig.writeTo(out);
        } else {
            out.writeBoolean(false);
        }
        out.writeInt(this.totalChunks.intValue());
        if (this.backendRoles != null) {
            out.writeBoolean(true);
            out.writeStringCollection(this.backendRoles);
        } else {
            out.writeBoolean(false);
        }
        if (this.accessMode != null) {
            out.writeBoolean(true);
            out.writeEnum((Enum)this.accessMode);
        } else {
            out.writeBoolean(false);
        }
        out.writeOptionalBoolean(this.isAddAllBackendRoles);
        if (streamOutputVersion.onOrAfter(MLRegisterModelInput.MINIMAL_SUPPORTED_VERSION_FOR_DOES_VERSION_CREATE_MODEL_GROUP)) {
            out.writeOptionalBoolean(this.doesVersionCreateModelGroup);
        }
        if (streamOutputVersion.onOrAfter(MLRegisterModelInput.MINIMAL_SUPPORTED_VERSION_FOR_AGENT_FRAMEWORK)) {
            out.writeOptionalBoolean(this.isEnabled);
            if (this.rateLimiter != null) {
                out.writeBoolean(true);
                this.rateLimiter.writeTo(out);
            } else {
                out.writeBoolean(false);
            }
            out.writeOptionalBoolean(this.isHidden);
        }
        if (streamOutputVersion.onOrAfter(MLRegisterModelInput.MINIMAL_SUPPORTED_VERSION_FOR_GUARDRAILS_AND_AUTO_DEPLOY)) {
            if (this.deploySetting != null) {
                out.writeBoolean(true);
                this.deploySetting.writeTo(out);
            } else {
                out.writeBoolean(false);
            }
        }
        if (streamOutputVersion.onOrAfter(MLRegisterModelInput.MINIMAL_SUPPORTED_VERSION_FOR_INTERFACE)) {
            if (this.modelInterface != null) {
                out.writeBoolean(true);
                out.writeMap(this.modelInterface, StreamOutput::writeString, StreamOutput::writeString);
            } else {
                out.writeBoolean(false);
            }
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(MODEL_NAME_FIELD, this.name);
        builder.field(FUNCTION_NAME_FIELD, (Object)this.functionName);
        if (this.modelGroupId != null) {
            builder.field(MODEL_GROUP_ID_FIELD, this.modelGroupId);
        }
        if (this.version != null) {
            builder.field(VERSION_FIELD, this.version);
        }
        if (this.description != null) {
            builder.field(DESCRIPTION_FIELD, this.description);
        }
        if (this.isEnabled != null) {
            builder.field(IS_ENABLED_FIELD, this.isEnabled);
        }
        if (this.rateLimiter != null) {
            builder.field(RATE_LIMITER_FIELD, (ToXContent)this.rateLimiter);
        }
        builder.field(MODEL_FORMAT_FIELD, (Object)this.modelFormat);
        if (this.modelState != null) {
            builder.field(MODEL_STATE_FIELD, (Object)this.modelState);
        }
        if (this.modelContentSizeInBytes != null) {
            builder.field(MODEL_CONTENT_SIZE_IN_BYTES_FIELD, this.modelContentSizeInBytes);
        }
        builder.field(MODEL_CONTENT_HASH_VALUE_FIELD, this.modelContentHashValue);
        builder.field(MODEL_CONFIG_FIELD, (ToXContent)this.modelConfig);
        builder.field(TOTAL_CHUNKS_FIELD, this.totalChunks);
        if (this.deploySetting != null) {
            builder.field(DEPLOY_SETTING_FIELD, (ToXContent)this.deploySetting);
        }
        if (this.backendRoles != null && this.backendRoles.size() > 0) {
            builder.field(BACKEND_ROLES_FIELD, this.backendRoles);
        }
        if (this.accessMode != null) {
            builder.field(ACCESS_MODE, (Object)this.accessMode);
        }
        if (this.isAddAllBackendRoles != null) {
            builder.field(ADD_ALL_BACKEND_ROLES, this.isAddAllBackendRoles);
        }
        if (this.doesVersionCreateModelGroup != null) {
            builder.field(DOES_VERSION_CREATE_MODEL_GROUP, this.doesVersionCreateModelGroup);
        }
        if (this.isHidden != null) {
            builder.field("is_hidden", this.isHidden);
        }
        if (this.modelInterface != null) {
            builder.field("interface", this.modelInterface);
        }
        builder.endObject();
        return builder;
    }

    public static MLRegisterModelMetaInput parse(XContentParser parser) throws IOException {
        String name = null;
        FunctionName functionName = null;
        String modelGroupId = null;
        String version = null;
        String description = null;
        Boolean isEnabled = null;
        MLRateLimiter rateLimiter = null;
        MLModelFormat modelFormat = null;
        MLModelState modelState = null;
        Long modelContentSizeInBytes = null;
        String modelContentHashValue = null;
        MLModelConfig modelConfig = null;
        MLDeploySetting deploySetting = null;
        Integer totalChunks = null;
        ArrayList<String> backendRoles = null;
        AccessMode accessMode = null;
        Boolean isAddAllBackendRoles = null;
        Boolean doesVersionCreateModelGroup = null;
        Boolean isHidden = null;
        Map<String, String> modelInterface = null;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        block44: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            switch (fieldName) {
                case "name": {
                    name = parser.text();
                    continue block44;
                }
                case "function_name": {
                    functionName = FunctionName.from(parser.text());
                    continue block44;
                }
                case "model_group_id": {
                    modelGroupId = parser.text();
                    continue block44;
                }
                case "version": {
                    version = parser.text();
                    continue block44;
                }
                case "description": {
                    description = parser.text();
                    continue block44;
                }
                case "is_enabled": {
                    isEnabled = parser.booleanValue();
                    continue block44;
                }
                case "rate_limiter": {
                    rateLimiter = MLRateLimiter.parse(parser);
                    continue block44;
                }
                case "model_format": {
                    modelFormat = MLModelFormat.from(parser.text());
                    continue block44;
                }
                case "model_state": {
                    modelState = MLModelState.from(parser.text());
                    continue block44;
                }
                case "model_content_size_in_bytes": {
                    modelContentSizeInBytes = parser.longValue();
                    continue block44;
                }
                case "model_content_hash_value": {
                    modelContentHashValue = parser.text();
                    continue block44;
                }
                case "model_config": {
                    if (FunctionName.QUESTION_ANSWERING.equals((Object)functionName)) {
                        modelConfig = QuestionAnsweringModelConfig.parse(parser);
                        continue block44;
                    }
                    modelConfig = TextEmbeddingModelConfig.parse(parser);
                    continue block44;
                }
                case "deploy_setting": {
                    deploySetting = MLDeploySetting.parse(parser);
                    continue block44;
                }
                case "total_chunks": {
                    totalChunks = parser.intValue(false);
                    continue block44;
                }
                case "backend_roles": {
                    backendRoles = new ArrayList<String>();
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
                    while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                        backendRoles.add(parser.text());
                    }
                    continue block44;
                }
                case "access_mode": {
                    accessMode = AccessMode.from(parser.text().toLowerCase(Locale.ROOT));
                    continue block44;
                }
                case "add_all_backend_roles": {
                    isAddAllBackendRoles = parser.booleanValue();
                    continue block44;
                }
                case "does_version_create_model_group": {
                    doesVersionCreateModelGroup = parser.booleanValue();
                    continue block44;
                }
                case "is_hidden": {
                    isHidden = parser.booleanValue();
                    continue block44;
                }
                case "interface": {
                    modelInterface = StringUtils.filteredParameterMap(parser.map(), MLModel.allowedInterfaceFieldKeys);
                }
            }
            parser.skipChildren();
        }
        return new MLRegisterModelMetaInput(name, functionName, modelGroupId, version, description, isEnabled, rateLimiter, modelFormat, modelState, modelContentSizeInBytes, modelContentHashValue, modelConfig, deploySetting, totalChunks, backendRoles, accessMode, isAddAllBackendRoles, doesVersionCreateModelGroup, isHidden, modelInterface);
    }

    @Generated
    public static MLRegisterModelMetaInputBuilder builder() {
        return new MLRegisterModelMetaInputBuilder();
    }

    @Generated
    public MLRegisterModelMetaInputBuilder toBuilder() {
        return new MLRegisterModelMetaInputBuilder().name(this.name).functionName(this.functionName).modelGroupId(this.modelGroupId).version(this.version).description(this.description).isEnabled(this.isEnabled).rateLimiter(this.rateLimiter).modelFormat(this.modelFormat).modelState(this.modelState).modelContentSizeInBytes(this.modelContentSizeInBytes).modelContentHashValue(this.modelContentHashValue).modelConfig(this.modelConfig).deploySetting(this.deploySetting).totalChunks(this.totalChunks).backendRoles(this.backendRoles).accessMode(this.accessMode).isAddAllBackendRoles(this.isAddAllBackendRoles).doesVersionCreateModelGroup(this.doesVersionCreateModelGroup).isHidden(this.isHidden).modelInterface(this.modelInterface);
    }

    @Generated
    public FunctionName getFunctionName() {
        return this.functionName;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getModelGroupId() {
        return this.modelGroupId;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public String getVersion() {
        return this.version;
    }

    @Generated
    public Boolean getIsEnabled() {
        return this.isEnabled;
    }

    @Generated
    public MLRateLimiter getRateLimiter() {
        return this.rateLimiter;
    }

    @Generated
    public MLModelFormat getModelFormat() {
        return this.modelFormat;
    }

    @Generated
    public MLModelState getModelState() {
        return this.modelState;
    }

    @Generated
    public Long getModelContentSizeInBytes() {
        return this.modelContentSizeInBytes;
    }

    @Generated
    public String getModelContentHashValue() {
        return this.modelContentHashValue;
    }

    @Generated
    public MLModelConfig getModelConfig() {
        return this.modelConfig;
    }

    @Generated
    public MLDeploySetting getDeploySetting() {
        return this.deploySetting;
    }

    @Generated
    public Integer getTotalChunks() {
        return this.totalChunks;
    }

    @Generated
    public List<String> getBackendRoles() {
        return this.backendRoles;
    }

    @Generated
    public AccessMode getAccessMode() {
        return this.accessMode;
    }

    @Generated
    public Boolean getIsAddAllBackendRoles() {
        return this.isAddAllBackendRoles;
    }

    @Generated
    public Boolean getDoesVersionCreateModelGroup() {
        return this.doesVersionCreateModelGroup;
    }

    @Generated
    public Boolean getIsHidden() {
        return this.isHidden;
    }

    @Generated
    public Map<String, String> getModelInterface() {
        return this.modelInterface;
    }

    @Generated
    public void setFunctionName(FunctionName functionName) {
        this.functionName = functionName;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setModelGroupId(String modelGroupId) {
        this.modelGroupId = modelGroupId;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public void setVersion(String version) {
        this.version = version;
    }

    @Generated
    public void setIsEnabled(Boolean isEnabled) {
        this.isEnabled = isEnabled;
    }

    @Generated
    public void setRateLimiter(MLRateLimiter rateLimiter) {
        this.rateLimiter = rateLimiter;
    }

    @Generated
    public void setModelFormat(MLModelFormat modelFormat) {
        this.modelFormat = modelFormat;
    }

    @Generated
    public void setModelState(MLModelState modelState) {
        this.modelState = modelState;
    }

    @Generated
    public void setModelContentSizeInBytes(Long modelContentSizeInBytes) {
        this.modelContentSizeInBytes = modelContentSizeInBytes;
    }

    @Generated
    public void setModelContentHashValue(String modelContentHashValue) {
        this.modelContentHashValue = modelContentHashValue;
    }

    @Generated
    public void setModelConfig(MLModelConfig modelConfig) {
        this.modelConfig = modelConfig;
    }

    @Generated
    public void setDeploySetting(MLDeploySetting deploySetting) {
        this.deploySetting = deploySetting;
    }

    @Generated
    public void setTotalChunks(Integer totalChunks) {
        this.totalChunks = totalChunks;
    }

    @Generated
    public void setBackendRoles(List<String> backendRoles) {
        this.backendRoles = backendRoles;
    }

    @Generated
    public void setAccessMode(AccessMode accessMode) {
        this.accessMode = accessMode;
    }

    @Generated
    public void setIsAddAllBackendRoles(Boolean isAddAllBackendRoles) {
        this.isAddAllBackendRoles = isAddAllBackendRoles;
    }

    @Generated
    public void setDoesVersionCreateModelGroup(Boolean doesVersionCreateModelGroup) {
        this.doesVersionCreateModelGroup = doesVersionCreateModelGroup;
    }

    @Generated
    public void setIsHidden(Boolean isHidden) {
        this.isHidden = isHidden;
    }

    @Generated
    public void setModelInterface(Map<String, String> modelInterface) {
        this.modelInterface = modelInterface;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MLRegisterModelMetaInput)) {
            return false;
        }
        MLRegisterModelMetaInput other = (MLRegisterModelMetaInput)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$isEnabled = this.getIsEnabled();
        Boolean other$isEnabled = other.getIsEnabled();
        if (this$isEnabled == null ? other$isEnabled != null : !((Object)this$isEnabled).equals(other$isEnabled)) {
            return false;
        }
        Long this$modelContentSizeInBytes = this.getModelContentSizeInBytes();
        Long other$modelContentSizeInBytes = other.getModelContentSizeInBytes();
        if (this$modelContentSizeInBytes == null ? other$modelContentSizeInBytes != null : !((Object)this$modelContentSizeInBytes).equals(other$modelContentSizeInBytes)) {
            return false;
        }
        Integer this$totalChunks = this.getTotalChunks();
        Integer other$totalChunks = other.getTotalChunks();
        if (this$totalChunks == null ? other$totalChunks != null : !((Object)this$totalChunks).equals(other$totalChunks)) {
            return false;
        }
        Boolean this$isAddAllBackendRoles = this.getIsAddAllBackendRoles();
        Boolean other$isAddAllBackendRoles = other.getIsAddAllBackendRoles();
        if (this$isAddAllBackendRoles == null ? other$isAddAllBackendRoles != null : !((Object)this$isAddAllBackendRoles).equals(other$isAddAllBackendRoles)) {
            return false;
        }
        Boolean this$doesVersionCreateModelGroup = this.getDoesVersionCreateModelGroup();
        Boolean other$doesVersionCreateModelGroup = other.getDoesVersionCreateModelGroup();
        if (this$doesVersionCreateModelGroup == null ? other$doesVersionCreateModelGroup != null : !((Object)this$doesVersionCreateModelGroup).equals(other$doesVersionCreateModelGroup)) {
            return false;
        }
        Boolean this$isHidden = this.getIsHidden();
        Boolean other$isHidden = other.getIsHidden();
        if (this$isHidden == null ? other$isHidden != null : !((Object)this$isHidden).equals(other$isHidden)) {
            return false;
        }
        FunctionName this$functionName = this.getFunctionName();
        FunctionName other$functionName = other.getFunctionName();
        if (this$functionName == null ? other$functionName != null : !((Object)((Object)this$functionName)).equals((Object)other$functionName)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$modelGroupId = this.getModelGroupId();
        String other$modelGroupId = other.getModelGroupId();
        if (this$modelGroupId == null ? other$modelGroupId != null : !this$modelGroupId.equals(other$modelGroupId)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        MLRateLimiter this$rateLimiter = this.getRateLimiter();
        MLRateLimiter other$rateLimiter = other.getRateLimiter();
        if (this$rateLimiter == null ? other$rateLimiter != null : !this$rateLimiter.equals(other$rateLimiter)) {
            return false;
        }
        MLModelFormat this$modelFormat = this.getModelFormat();
        MLModelFormat other$modelFormat = other.getModelFormat();
        if (this$modelFormat == null ? other$modelFormat != null : !((Object)((Object)this$modelFormat)).equals((Object)other$modelFormat)) {
            return false;
        }
        MLModelState this$modelState = this.getModelState();
        MLModelState other$modelState = other.getModelState();
        if (this$modelState == null ? other$modelState != null : !((Object)((Object)this$modelState)).equals((Object)other$modelState)) {
            return false;
        }
        String this$modelContentHashValue = this.getModelContentHashValue();
        String other$modelContentHashValue = other.getModelContentHashValue();
        if (this$modelContentHashValue == null ? other$modelContentHashValue != null : !this$modelContentHashValue.equals(other$modelContentHashValue)) {
            return false;
        }
        MLModelConfig this$modelConfig = this.getModelConfig();
        MLModelConfig other$modelConfig = other.getModelConfig();
        if (this$modelConfig == null ? other$modelConfig != null : !this$modelConfig.equals(other$modelConfig)) {
            return false;
        }
        MLDeploySetting this$deploySetting = this.getDeploySetting();
        MLDeploySetting other$deploySetting = other.getDeploySetting();
        if (this$deploySetting == null ? other$deploySetting != null : !this$deploySetting.equals(other$deploySetting)) {
            return false;
        }
        List<String> this$backendRoles = this.getBackendRoles();
        List<String> other$backendRoles = other.getBackendRoles();
        if (this$backendRoles == null ? other$backendRoles != null : !((Object)this$backendRoles).equals(other$backendRoles)) {
            return false;
        }
        AccessMode this$accessMode = this.getAccessMode();
        AccessMode other$accessMode = other.getAccessMode();
        if (this$accessMode == null ? other$accessMode != null : !((Object)((Object)this$accessMode)).equals((Object)other$accessMode)) {
            return false;
        }
        Map<String, String> this$modelInterface = this.getModelInterface();
        Map<String, String> other$modelInterface = other.getModelInterface();
        return !(this$modelInterface == null ? other$modelInterface != null : !((Object)this$modelInterface).equals(other$modelInterface));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof MLRegisterModelMetaInput;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $isEnabled = this.getIsEnabled();
        result = result * 59 + ($isEnabled == null ? 43 : ((Object)$isEnabled).hashCode());
        Long $modelContentSizeInBytes = this.getModelContentSizeInBytes();
        result = result * 59 + ($modelContentSizeInBytes == null ? 43 : ((Object)$modelContentSizeInBytes).hashCode());
        Integer $totalChunks = this.getTotalChunks();
        result = result * 59 + ($totalChunks == null ? 43 : ((Object)$totalChunks).hashCode());
        Boolean $isAddAllBackendRoles = this.getIsAddAllBackendRoles();
        result = result * 59 + ($isAddAllBackendRoles == null ? 43 : ((Object)$isAddAllBackendRoles).hashCode());
        Boolean $doesVersionCreateModelGroup = this.getDoesVersionCreateModelGroup();
        result = result * 59 + ($doesVersionCreateModelGroup == null ? 43 : ((Object)$doesVersionCreateModelGroup).hashCode());
        Boolean $isHidden = this.getIsHidden();
        result = result * 59 + ($isHidden == null ? 43 : ((Object)$isHidden).hashCode());
        FunctionName $functionName = this.getFunctionName();
        result = result * 59 + ($functionName == null ? 43 : ((Object)((Object)$functionName)).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $modelGroupId = this.getModelGroupId();
        result = result * 59 + ($modelGroupId == null ? 43 : $modelGroupId.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        MLRateLimiter $rateLimiter = this.getRateLimiter();
        result = result * 59 + ($rateLimiter == null ? 43 : $rateLimiter.hashCode());
        MLModelFormat $modelFormat = this.getModelFormat();
        result = result * 59 + ($modelFormat == null ? 43 : ((Object)((Object)$modelFormat)).hashCode());
        MLModelState $modelState = this.getModelState();
        result = result * 59 + ($modelState == null ? 43 : ((Object)((Object)$modelState)).hashCode());
        String $modelContentHashValue = this.getModelContentHashValue();
        result = result * 59 + ($modelContentHashValue == null ? 43 : $modelContentHashValue.hashCode());
        MLModelConfig $modelConfig = this.getModelConfig();
        result = result * 59 + ($modelConfig == null ? 43 : $modelConfig.hashCode());
        MLDeploySetting $deploySetting = this.getDeploySetting();
        result = result * 59 + ($deploySetting == null ? 43 : $deploySetting.hashCode());
        List<String> $backendRoles = this.getBackendRoles();
        result = result * 59 + ($backendRoles == null ? 43 : ((Object)$backendRoles).hashCode());
        AccessMode $accessMode = this.getAccessMode();
        result = result * 59 + ($accessMode == null ? 43 : ((Object)((Object)$accessMode)).hashCode());
        Map<String, String> $modelInterface = this.getModelInterface();
        result = result * 59 + ($modelInterface == null ? 43 : ((Object)$modelInterface).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "MLRegisterModelMetaInput(functionName=" + String.valueOf((Object)this.getFunctionName()) + ", name=" + this.getName() + ", modelGroupId=" + this.getModelGroupId() + ", description=" + this.getDescription() + ", version=" + this.getVersion() + ", isEnabled=" + this.getIsEnabled() + ", rateLimiter=" + String.valueOf(this.getRateLimiter()) + ", modelFormat=" + String.valueOf((Object)this.getModelFormat()) + ", modelState=" + String.valueOf((Object)this.getModelState()) + ", modelContentSizeInBytes=" + this.getModelContentSizeInBytes() + ", modelContentHashValue=" + this.getModelContentHashValue() + ", modelConfig=" + String.valueOf(this.getModelConfig()) + ", deploySetting=" + String.valueOf(this.getDeploySetting()) + ", totalChunks=" + this.getTotalChunks() + ", backendRoles=" + String.valueOf(this.getBackendRoles()) + ", accessMode=" + String.valueOf((Object)this.getAccessMode()) + ", isAddAllBackendRoles=" + this.getIsAddAllBackendRoles() + ", doesVersionCreateModelGroup=" + this.getDoesVersionCreateModelGroup() + ", isHidden=" + this.getIsHidden() + ", modelInterface=" + String.valueOf(this.getModelInterface()) + ")";
    }

    @Generated
    public static class MLRegisterModelMetaInputBuilder {
        @Generated
        private String name;
        @Generated
        private FunctionName functionName;
        @Generated
        private String modelGroupId;
        @Generated
        private String version;
        @Generated
        private String description;
        @Generated
        private Boolean isEnabled;
        @Generated
        private MLRateLimiter rateLimiter;
        @Generated
        private MLModelFormat modelFormat;
        @Generated
        private MLModelState modelState;
        @Generated
        private Long modelContentSizeInBytes;
        @Generated
        private String modelContentHashValue;
        @Generated
        private MLModelConfig modelConfig;
        @Generated
        private MLDeploySetting deploySetting;
        @Generated
        private Integer totalChunks;
        @Generated
        private List<String> backendRoles;
        @Generated
        private AccessMode accessMode;
        @Generated
        private Boolean isAddAllBackendRoles;
        @Generated
        private Boolean doesVersionCreateModelGroup;
        @Generated
        private Boolean isHidden;
        @Generated
        private Map<String, String> modelInterface;

        @Generated
        MLRegisterModelMetaInputBuilder() {
        }

        @Generated
        public MLRegisterModelMetaInputBuilder name(String name) {
            this.name = name;
            return this;
        }

        @Generated
        public MLRegisterModelMetaInputBuilder functionName(FunctionName functionName) {
            this.functionName = functionName;
            return this;
        }

        @Generated
        public MLRegisterModelMetaInputBuilder modelGroupId(String modelGroupId) {
            this.modelGroupId = modelGroupId;
            return this;
        }

        @Generated
        public MLRegisterModelMetaInputBuilder version(String version) {
            this.version = version;
            return this;
        }

        @Generated
        public MLRegisterModelMetaInputBuilder description(String description) {
            this.description = description;
            return this;
        }

        @Generated
        public MLRegisterModelMetaInputBuilder isEnabled(Boolean isEnabled) {
            this.isEnabled = isEnabled;
            return this;
        }

        @Generated
        public MLRegisterModelMetaInputBuilder rateLimiter(MLRateLimiter rateLimiter) {
            this.rateLimiter = rateLimiter;
            return this;
        }

        @Generated
        public MLRegisterModelMetaInputBuilder modelFormat(MLModelFormat modelFormat) {
            this.modelFormat = modelFormat;
            return this;
        }

        @Generated
        public MLRegisterModelMetaInputBuilder modelState(MLModelState modelState) {
            this.modelState = modelState;
            return this;
        }

        @Generated
        public MLRegisterModelMetaInputBuilder modelContentSizeInBytes(Long modelContentSizeInBytes) {
            this.modelContentSizeInBytes = modelContentSizeInBytes;
            return this;
        }

        @Generated
        public MLRegisterModelMetaInputBuilder modelContentHashValue(String modelContentHashValue) {
            this.modelContentHashValue = modelContentHashValue;
            return this;
        }

        @Generated
        public MLRegisterModelMetaInputBuilder modelConfig(MLModelConfig modelConfig) {
            this.modelConfig = modelConfig;
            return this;
        }

        @Generated
        public MLRegisterModelMetaInputBuilder deploySetting(MLDeploySetting deploySetting) {
            this.deploySetting = deploySetting;
            return this;
        }

        @Generated
        public MLRegisterModelMetaInputBuilder totalChunks(Integer totalChunks) {
            this.totalChunks = totalChunks;
            return this;
        }

        @Generated
        public MLRegisterModelMetaInputBuilder backendRoles(List<String> backendRoles) {
            this.backendRoles = backendRoles;
            return this;
        }

        @Generated
        public MLRegisterModelMetaInputBuilder accessMode(AccessMode accessMode) {
            this.accessMode = accessMode;
            return this;
        }

        @Generated
        public MLRegisterModelMetaInputBuilder isAddAllBackendRoles(Boolean isAddAllBackendRoles) {
            this.isAddAllBackendRoles = isAddAllBackendRoles;
            return this;
        }

        @Generated
        public MLRegisterModelMetaInputBuilder doesVersionCreateModelGroup(Boolean doesVersionCreateModelGroup) {
            this.doesVersionCreateModelGroup = doesVersionCreateModelGroup;
            return this;
        }

        @Generated
        public MLRegisterModelMetaInputBuilder isHidden(Boolean isHidden) {
            this.isHidden = isHidden;
            return this;
        }

        @Generated
        public MLRegisterModelMetaInputBuilder modelInterface(Map<String, String> modelInterface) {
            this.modelInterface = modelInterface;
            return this;
        }

        @Generated
        public MLRegisterModelMetaInput build() {
            return new MLRegisterModelMetaInput(this.name, this.functionName, this.modelGroupId, this.version, this.description, this.isEnabled, this.rateLimiter, this.modelFormat, this.modelState, this.modelContentSizeInBytes, this.modelContentHashValue, this.modelConfig, this.deploySetting, this.totalChunks, this.backendRoles, this.accessMode, this.isAddAllBackendRoles, this.doesVersionCreateModelGroup, this.isHidden, this.modelInterface);
        }

        @Generated
        public String toString() {
            return "MLRegisterModelMetaInput.MLRegisterModelMetaInputBuilder(name=" + this.name + ", functionName=" + String.valueOf((Object)this.functionName) + ", modelGroupId=" + this.modelGroupId + ", version=" + this.version + ", description=" + this.description + ", isEnabled=" + this.isEnabled + ", rateLimiter=" + String.valueOf(this.rateLimiter) + ", modelFormat=" + String.valueOf((Object)this.modelFormat) + ", modelState=" + String.valueOf((Object)this.modelState) + ", modelContentSizeInBytes=" + this.modelContentSizeInBytes + ", modelContentHashValue=" + this.modelContentHashValue + ", modelConfig=" + String.valueOf(this.modelConfig) + ", deploySetting=" + String.valueOf(this.deploySetting) + ", totalChunks=" + this.totalChunks + ", backendRoles=" + String.valueOf(this.backendRoles) + ", accessMode=" + String.valueOf((Object)this.accessMode) + ", isAddAllBackendRoles=" + this.isAddAllBackendRoles + ", doesVersionCreateModelGroup=" + this.doesVersionCreateModelGroup + ", isHidden=" + this.isHidden + ", modelInterface=" + String.valueOf(this.modelInterface) + ")";
        }
    }
}

