/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.spark.parameter;

import lombok.Generated;
import org.apache.commons.text.StringEscapeUtils;
import org.opensearch.sql.datasource.model.DataSourceMetadata;
import org.opensearch.sql.spark.asyncquery.model.AsyncQueryRequestContext;
import org.opensearch.sql.spark.config.SparkSubmitParameterModifier;
import org.opensearch.sql.spark.dispatcher.model.DispatchQueryRequest;
import org.opensearch.sql.spark.execution.statestore.OpenSearchStateStoreUtil;
import org.opensearch.sql.spark.parameter.SparkParameterComposerCollection;
import org.opensearch.sql.spark.parameter.SparkSubmitParameters;

public class SparkSubmitParametersBuilder {
    private final SparkParameterComposerCollection sparkParameterComposerCollection;
    private final SparkSubmitParameters sparkSubmitParameters;

    public SparkSubmitParametersBuilder(SparkParameterComposerCollection sparkParameterComposerCollection) {
        this.sparkParameterComposerCollection = sparkParameterComposerCollection;
        this.sparkSubmitParameters = new SparkSubmitParameters();
        this.setDefaultConfigs();
    }

    private void setDefaultConfigs() {
        this.setConfigItem("spark.hadoop.fs.s3.customAWSCredentialsProvider", "com.amazonaws.emr.AssumeRoleAWSCredentialsProvider");
        this.setConfigItem("spark.hadoop.aws.catalog.credentials.provider.factory.class", "com.amazonaws.glue.catalog.metastore.STSAssumeRoleSessionCredentialsProviderFactory");
        this.setConfigItem("spark.jars.packages", "org.opensearch:opensearch-spark-standalone_2.12:0.3.0-SNAPSHOT,org.opensearch:opensearch-spark-sql-application_2.12:0.3.0-SNAPSHOT,org.opensearch:opensearch-spark-ppl_2.12:0.3.0-SNAPSHOT");
        this.setConfigItem("spark.jars.repositories", "https://aws.oss.sonatype.org/content/repositories/snapshots");
        this.setConfigItem("spark.emr-serverless.driverEnv.JAVA_HOME", "/usr/lib/jvm/java-17-amazon-corretto.x86_64/");
        this.setConfigItem("spark.executorEnv.JAVA_HOME", "/usr/lib/jvm/java-17-amazon-corretto.x86_64/");
        this.setConfigItem("spark.emr-serverless.driverEnv.FLINT_CLUSTER_NAME", "opensearch-cluster");
        this.setConfigItem("spark.executorEnv.FLINT_CLUSTER_NAME", "opensearch-cluster");
        this.setConfigItem("spark.datasource.flint.host", "localhost");
        this.setConfigItem("spark.datasource.flint.port", "9200");
        this.setConfigItem("spark.datasource.flint.scheme", "http");
        this.setConfigItem("spark.datasource.flint.auth", "noauth");
        this.setConfigItem("spark.datasource.flint.customAWSCredentialsProvider", "com.amazonaws.emr.AssumeRoleAWSCredentialsProvider");
        this.setConfigItem("spark.sql.extensions", "org.opensearch.flint.spark.FlintSparkExtensions,org.opensearch.flint.spark.FlintPPLSparkExtensions");
        this.setConfigItem("spark.hadoop.hive.metastore.client.factory.class", "com.amazonaws.glue.catalog.metastore.AWSGlueDataCatalogHiveClientFactory");
    }

    private void setConfigItem(String key, String value) {
        this.sparkSubmitParameters.setConfigItem(key, value);
    }

    public SparkSubmitParametersBuilder className(String className) {
        this.sparkSubmitParameters.setClassName(className);
        return this;
    }

    public SparkSubmitParametersBuilder clusterName(String clusterName) {
        this.setConfigItem("spark.emr-serverless.driverEnv.FLINT_CLUSTER_NAME", clusterName);
        this.setConfigItem("spark.executorEnv.FLINT_CLUSTER_NAME", clusterName);
        return this;
    }

    public SparkSubmitParametersBuilder query(String query) {
        String escapedQuery = StringEscapeUtils.escapeJava((String)query);
        String wrappedQuery = "\"" + escapedQuery + "\"";
        this.setConfigItem("spark.flint.job.query", wrappedQuery);
        return this;
    }

    public SparkSubmitParametersBuilder dataSource(DataSourceMetadata metadata, DispatchQueryRequest dispatchQueryRequest, AsyncQueryRequestContext context) {
        if (this.sparkParameterComposerCollection.isComposerRegistered(metadata.getConnector())) {
            this.sparkParameterComposerCollection.composeByDataSource(metadata, this.sparkSubmitParameters, dispatchQueryRequest, context);
            return this;
        }
        throw new UnsupportedOperationException(String.format("UnSupported datasource type for async queries:: %s", metadata.getConnector()));
    }

    public SparkSubmitParametersBuilder structuredStreaming(Boolean isStructuredStreaming) {
        if (isStructuredStreaming.booleanValue()) {
            this.setConfigItem("spark.flint.job.type", "streaming");
        }
        return this;
    }

    public SparkSubmitParametersBuilder extraParameters(String params) {
        this.sparkSubmitParameters.setExtraParameters(params);
        return this;
    }

    public SparkSubmitParametersBuilder sessionExecution(String sessionId, String datasourceName) {
        this.setConfigItem("spark.flint.job.requestIndex", OpenSearchStateStoreUtil.getIndexName(datasourceName));
        this.setConfigItem("spark.flint.job.sessionId", sessionId);
        return this;
    }

    public SparkSubmitParametersBuilder acceptModifier(SparkSubmitParameterModifier modifier) {
        if (modifier != null) {
            modifier.modifyParameters(this);
        }
        return this;
    }

    public SparkSubmitParametersBuilder acceptComposers(DispatchQueryRequest dispatchQueryRequest, AsyncQueryRequestContext context) {
        this.sparkParameterComposerCollection.compose(this.sparkSubmitParameters, dispatchQueryRequest, context);
        return this;
    }

    public String toString() {
        return this.sparkSubmitParameters.toString();
    }

    @Generated
    public SparkSubmitParameters getSparkSubmitParameters() {
        return this.sparkSubmitParameters;
    }
}

