# This file has been autogenerated by the pywayland scanner

# Copyright © 2017 Red Hat Inc.
#
# Permission is hereby granted, free of charge, to any person obtaining a
# copy of this software and associated documentation files (the "Software"),
# to deal in the Software without restriction, including without limitation
# the rights to use, copy, modify, merge, publish, distribute, sublicense,
# and/or sell copies of the Software, and to permit persons to whom the
# Software is furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice (including the next
# paragraph) shall be included in all copies or substantial portions of the
# Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
# THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
# FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
# DEALINGS IN THE SOFTWARE.

from __future__ import annotations

from pywayland.protocol_core import (
    Argument,
    ArgumentType,
    Global,
    Interface,
    Proxy,
    Resource,
)

from ..wayland import WlSeat
from ..wayland import WlSurface
from .zwp_xwayland_keyboard_grab_v1 import ZwpXwaylandKeyboardGrabV1


class ZwpXwaylandKeyboardGrabManagerV1(Interface):
    """Context object for keyboard grab manager

    A global interface used for grabbing the keyboard.
    """

    name = "zwp_xwayland_keyboard_grab_manager_v1"
    version = 1


class ZwpXwaylandKeyboardGrabManagerV1Proxy(Proxy[ZwpXwaylandKeyboardGrabManagerV1]):
    interface = ZwpXwaylandKeyboardGrabManagerV1

    @ZwpXwaylandKeyboardGrabManagerV1.request()
    def destroy(self) -> None:
        """Destroy the keyboard grab manager

        Destroy the keyboard grab manager.
        """
        self._marshal(0)
        self._destroy()

    @ZwpXwaylandKeyboardGrabManagerV1.request(
        Argument(ArgumentType.NewId, interface=ZwpXwaylandKeyboardGrabV1),
        Argument(ArgumentType.Object, interface=WlSurface),
        Argument(ArgumentType.Object, interface=WlSeat),
    )
    def grab_keyboard(self, surface: WlSurface, seat: WlSeat) -> Proxy[ZwpXwaylandKeyboardGrabV1]:
        """Grab the keyboard to a surface

        The grab_keyboard request asks for a grab of the keyboard, forcing the
        keyboard focus for the given seat upon the given surface.

        The protocol provides no guarantee that the grab is ever satisfied, and
        does not require the compositor to send an error if the grab cannot
        ever be satisfied. It is thus possible to request a keyboard grab that
        will never be effective.

        The protocol:

        * does not guarantee that the grab itself is applied for a surface, the
          grab request may be silently ignored by the compositor,

        * does not guarantee that any events are sent to this client even if
          the grab is applied to a surface,

        * does not guarantee that events sent to this client are exhaustive, a
          compositor may filter some events for its own consumption,

        * does not guarantee that events sent to this client are continuous, a
          compositor may change and reroute keyboard events while the grab is
          nominally active.

        :param surface:
            surface to report keyboard events to
        :type surface:
            :class:`~pywayland.protocol.wayland.WlSurface`
        :param seat:
            the seat for which the keyboard should be grabbed
        :type seat:
            :class:`~pywayland.protocol.wayland.WlSeat`
        :returns:
            :class:`~pywayland.protocol.xwayland_keyboard_grab_unstable_v1.ZwpXwaylandKeyboardGrabV1`
        """
        id = self._marshal_constructor(1, ZwpXwaylandKeyboardGrabV1, surface, seat)
        return id


class ZwpXwaylandKeyboardGrabManagerV1Resource(Resource):
    interface = ZwpXwaylandKeyboardGrabManagerV1


class ZwpXwaylandKeyboardGrabManagerV1Global(Global):
    interface = ZwpXwaylandKeyboardGrabManagerV1


ZwpXwaylandKeyboardGrabManagerV1._gen_c()
ZwpXwaylandKeyboardGrabManagerV1.proxy_class = ZwpXwaylandKeyboardGrabManagerV1Proxy
ZwpXwaylandKeyboardGrabManagerV1.resource_class = ZwpXwaylandKeyboardGrabManagerV1Resource
ZwpXwaylandKeyboardGrabManagerV1.global_class = ZwpXwaylandKeyboardGrabManagerV1Global
