"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const fromZigbee_1 = __importDefault(require("../converters/fromZigbee"));
const toZigbee_1 = __importDefault(require("../converters/toZigbee"));
const exposes = __importStar(require("../lib/exposes"));
const reporting = __importStar(require("../lib/reporting"));
const tuya = __importStar(require("../lib/tuya"));
const e = exposes.presets;
const ea = exposes.access;
const definitions = [
    {
        fingerprint: [{ modelID: 'TS0219', manufacturerName: '_TZ3000_vdfwjopk' }],
        model: 'SA100',
        vendor: 'Cleverio',
        description: 'Smart siren',
        fromZigbee: [fromZigbee_1.default.ts0216_siren, fromZigbee_1.default.ias_alarm_only_alarm_1, fromZigbee_1.default.power_source],
        toZigbee: [toZigbee_1.default.warning, toZigbee_1.default.ts0216_volume],
        exposes: [
            e.warning(),
            e.binary('alarm', ea.STATE, true, false),
            e.numeric('volume', ea.ALL).withValueMin(0).withValueMax(100).withDescription('Volume of siren'),
        ],
        meta: { disableDefaultResponse: true },
        configure: async (device, coordinatorEndpoint) => {
            const endpoint = device.getEndpoint(1);
            const bindClusters = ['genPowerCfg'];
            await reporting.bind(endpoint, coordinatorEndpoint, bindClusters);
        },
    },
    {
        fingerprint: [{ modelID: 'TS0041A', manufacturerName: '_TYZB01_4qw4rl1u' }],
        model: 'SB100',
        vendor: 'Cleverio',
        description: 'Wireless switch with 1 button',
        exposes: [e.battery(), e.action(['single', 'double', 'hold'])],
        fromZigbee: [tuya.fz.on_off_action, fromZigbee_1.default.battery],
        toZigbee: [],
        configure: tuya.configureMagicPacket,
    },
    {
        fingerprint: [{ modelID: 'SM0201', manufacturerName: '_TYZB01_lzrhtcxu' }],
        model: 'SS300',
        vendor: 'Cleverio',
        description: 'Temperature/humdity sensor',
        exposes: [e.battery().withAccess(ea.STATE_GET), e.temperature(), e.humidity()],
        fromZigbee: [fromZigbee_1.default.temperature, fromZigbee_1.default.humidity, fromZigbee_1.default.battery],
        toZigbee: [toZigbee_1.default.battery_percentage_remaining],
    },
];
exports.default = definitions;
module.exports = definitions;
//# sourceMappingURL=cleverio.js.map