import { Adapter, TsType } from '../..';
import { Backup } from '../../../models';
import * as ZSpec from '../../../zspec';
import * as Zcl from '../../../zspec/zcl';
import * as Zdo from '../../../zspec/zdo';
import * as ZdoTypes from '../../../zspec/zdo/definition/tstypes';
import { ZclPayload } from '../../events';
export declare class ZBOSSAdapter extends Adapter {
    private queue;
    private readonly driver;
    private waitress;
    constructor(networkOptions: TsType.NetworkOptions, serialPortOptions: TsType.SerialPortOptions, backupPath: string, adapterOptions: TsType.AdapterOptions);
    private processMessage;
    static isValidPath(path: string): Promise<boolean>;
    static autoDetectPath(): Promise<string | null>;
    start(): Promise<TsType.StartResult>;
    stop(): Promise<void>;
    getCoordinatorIEEE(): Promise<string>;
    getCoordinatorVersion(): Promise<TsType.CoordinatorVersion>;
    reset(type: 'soft' | 'hard'): Promise<void>;
    supportsBackup(): Promise<boolean>;
    backup(ieeeAddressesInDatabase: string[]): Promise<Backup>;
    getNetworkParameters(): Promise<TsType.NetworkParameters>;
    setTransmitPower(value: number): Promise<void>;
    addInstallCode(ieeeAddress: string, key: Buffer): Promise<void>;
    permitJoin(seconds: number, networkAddress?: number): Promise<void>;
    sendZdo(ieeeAddress: string, networkAddress: number, clusterId: Zdo.ClusterId, payload: Buffer, disableResponse: true): Promise<void>;
    sendZdo<K extends keyof ZdoTypes.RequestToResponseMap>(ieeeAddress: string, networkAddress: number, clusterId: K, payload: Buffer, disableResponse: false): Promise<ZdoTypes.RequestToResponseMap[K]>;
    sendZclFrameToEndpoint(ieeeAddr: string, networkAddress: number, endpoint: number, zclFrame: Zcl.Frame, timeout: number, disableResponse: boolean, disableRecovery: boolean, sourceEndpoint?: number): Promise<ZclPayload | void>;
    private sendZclFrameToEndpointInternal;
    sendZclFrameToGroup(groupID: number, zclFrame: Zcl.Frame, sourceEndpoint?: number): Promise<void>;
    sendZclFrameToAll(endpoint: number, zclFrame: Zcl.Frame, sourceEndpoint: number, destination: ZSpec.BroadcastAddress): Promise<void>;
    setChannelInterPAN(channel: number): Promise<void>;
    sendZclFrameInterPANToIeeeAddr(zclFrame: Zcl.Frame, ieeeAddress: string): Promise<void>;
    sendZclFrameInterPANBroadcast(zclFrame: Zcl.Frame, timeout: number): Promise<ZclPayload>;
    restoreChannelInterPAN(): Promise<void>;
    waitFor(networkAddress: number, endpoint: number, transactionSequenceNumber: number, clusterID: number, commandIdentifier: number, timeout: number): {
        promise: Promise<ZclPayload>;
        cancel: () => void;
        start: () => {
            promise: Promise<ZclPayload>;
        };
    };
    private waitressTimeoutFormatter;
    private waitressValidator;
}
//# sourceMappingURL=zbossAdapter.d.ts.map