/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.cluster.routing.allocation.decider;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.opensearch.cluster.metadata.IndexMetadata;
import org.opensearch.cluster.routing.RoutingNode;
import org.opensearch.cluster.routing.ShardRouting;
import org.opensearch.cluster.routing.allocation.RoutingAllocation;
import org.opensearch.cluster.routing.allocation.decider.AllocationDecider;
import org.opensearch.cluster.routing.allocation.decider.Decision;
import org.opensearch.common.settings.ClusterSettings;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.Settings;
import org.opensearch.core.common.Strings;

public class AwarenessAllocationDecider
extends AllocationDecider {
    public static final String NAME = "awareness";
    public static final Setting<List<String>> CLUSTER_ROUTING_ALLOCATION_AWARENESS_ATTRIBUTE_SETTING = Setting.listSetting("cluster.routing.allocation.awareness.attributes", Collections.emptyList(), Function.identity(), Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<Settings> CLUSTER_ROUTING_ALLOCATION_AWARENESS_FORCE_GROUP_SETTING = Setting.groupSetting("cluster.routing.allocation.awareness.force.", Setting.Property.Dynamic, Setting.Property.NodeScope);
    private volatile List<String> awarenessAttributes;
    private volatile Map<String, List<String>> forcedAwarenessAttributes;

    public AwarenessAllocationDecider(Settings settings, ClusterSettings clusterSettings) {
        this.awarenessAttributes = CLUSTER_ROUTING_ALLOCATION_AWARENESS_ATTRIBUTE_SETTING.get(settings);
        clusterSettings.addSettingsUpdateConsumer(CLUSTER_ROUTING_ALLOCATION_AWARENESS_ATTRIBUTE_SETTING, this::setAwarenessAttributes);
        this.setForcedAwarenessAttributes(CLUSTER_ROUTING_ALLOCATION_AWARENESS_FORCE_GROUP_SETTING.get(settings));
        clusterSettings.addSettingsUpdateConsumer(CLUSTER_ROUTING_ALLOCATION_AWARENESS_FORCE_GROUP_SETTING, this::setForcedAwarenessAttributes);
    }

    private void setForcedAwarenessAttributes(Settings forceSettings) {
        HashMap<String, List<String>> forcedAwarenessAttributes = new HashMap<String, List<String>>();
        Map<String, Settings> forceGroups = forceSettings.getAsGroups();
        for (Map.Entry<String, Settings> entry : forceGroups.entrySet()) {
            List<String> aValues = entry.getValue().getAsList("values");
            if (aValues.size() <= 0) continue;
            forcedAwarenessAttributes.put(entry.getKey(), aValues);
        }
        this.forcedAwarenessAttributes = forcedAwarenessAttributes;
    }

    private void setAwarenessAttributes(List<String> awarenessAttributes) {
        this.awarenessAttributes = awarenessAttributes;
    }

    @Override
    public Decision canAllocate(ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation) {
        return this.underCapacity(shardRouting, node, allocation, true);
    }

    @Override
    public Decision canRemain(ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation) {
        return this.underCapacity(shardRouting, node, allocation, false);
    }

    private Decision underCapacity(ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation, boolean moveToNode) {
        if (this.awarenessAttributes.isEmpty()) {
            return allocation.decision(Decision.YES, NAME, "allocation awareness is not enabled, set cluster setting [%s] to enable it", CLUSTER_ROUTING_ALLOCATION_AWARENESS_ATTRIBUTE_SETTING.getKey());
        }
        IndexMetadata indexMetadata = allocation.metadata().getIndexSafe(shardRouting.index());
        int shardCount = indexMetadata.getNumberOfReplicas() + 1;
        for (String awarenessAttribute : this.awarenessAttributes) {
            int maximumNodeCount;
            if (!this.isAwarenessAttributeAssociatedWithNode(node, awarenessAttribute)) {
                return allocation.decision(Decision.NO, NAME, "node does not contain the awareness attribute [%s]; required attributes cluster setting [%s=%s]", awarenessAttribute, CLUSTER_ROUTING_ALLOCATION_AWARENESS_ATTRIBUTE_SETTING.getKey(), allocation.debugDecision() ? Strings.collectionToCommaDelimitedString(this.awarenessAttributes) : null);
            }
            int currentNodeCount = this.getCurrentNodeCountForAttribute(shardRouting, node, allocation, moveToNode, awarenessAttribute);
            Set<String> nodesPerAttribute = allocation.routingNodes().nodesPerAttributesCounts(awarenessAttribute);
            int numberOfAttributes = nodesPerAttribute.size();
            List<String> fullValues = this.forcedAwarenessAttributes.get(awarenessAttribute);
            if (fullValues != null) {
                HashSet<String> attributesSet = new HashSet<String>(fullValues);
                for (String stringObjectCursor : nodesPerAttribute) {
                    attributesSet.add(stringObjectCursor);
                }
                numberOfAttributes = attributesSet.size();
            }
            if (currentNodeCount <= (maximumNodeCount = (shardCount + numberOfAttributes - 1) / numberOfAttributes)) continue;
            return allocation.decision(Decision.NO, NAME, "there are too many copies of the shard allocated to nodes with attribute [%s], there are [%d] total configured shard copies for this shard id and [%d] total attribute values, expected the allocated shard count per attribute [%d] to be less than or equal to the upper bound of the required number of shards per attribute [%d]", awarenessAttribute, shardCount, numberOfAttributes, currentNodeCount, maximumNodeCount);
        }
        return allocation.decision(Decision.YES, NAME, "node meets all awareness attribute requirements", new Object[0]);
    }

    private int getCurrentNodeCountForAttribute(ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation, boolean moveToNode, String awarenessAttribute) {
        String shardAttributeForNode = this.getAttributeValueForNode(node, awarenessAttribute);
        int currentNodeCount = 0;
        List<ShardRouting> assignedShards = allocation.routingNodes().assignedShards(shardRouting.shardId());
        for (ShardRouting assignedShard : assignedShards) {
            RoutingNode routingNode;
            if (!assignedShard.started() && !assignedShard.initializing() || !this.getAttributeValueForNode(routingNode = allocation.routingNodes().node(assignedShard.currentNodeId()), awarenessAttribute).equals(shardAttributeForNode)) continue;
            ++currentNodeCount;
        }
        if (moveToNode) {
            if (shardRouting.assignedToNode()) {
                String nodeId;
                String string = nodeId = shardRouting.relocating() ? shardRouting.relocatingNodeId() : shardRouting.currentNodeId();
                if (!node.nodeId().equals(nodeId)) {
                    if (this.getAttributeValueForNode(allocation.routingNodes().node(nodeId), awarenessAttribute).equals(shardAttributeForNode) && currentNodeCount > 0) {
                        --currentNodeCount;
                    }
                    ++currentNodeCount;
                }
            } else {
                ++currentNodeCount;
            }
        }
        return currentNodeCount;
    }

    private boolean isAwarenessAttributeAssociatedWithNode(RoutingNode node, String awarenessAttribute) {
        return node.node().getAttributes().containsKey(awarenessAttribute);
    }

    private String getAttributeValueForNode(RoutingNode node, String awarenessAttribute) {
        return node.node().getAttributes().get(awarenessAttribute);
    }
}

