/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.common.blobstore.transfer.stream;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.store.IndexInput;
import org.opensearch.common.blobstore.transfer.stream.OffsetRangeInputStream;
import org.opensearch.common.concurrent.RefCountedReleasable;
import org.opensearch.common.lucene.store.InputStreamIndexInput;
import org.opensearch.common.util.concurrent.RunOnce;

public class OffsetRangeIndexInputStream
extends OffsetRangeInputStream {
    private static final Logger logger = LogManager.getLogger(OffsetRangeIndexInputStream.class);
    private final InputStreamIndexInput inputStreamIndexInput;
    private final IndexInput indexInput;
    private AtomicBoolean readBlock;
    private final OffsetRangeRefCount offsetRangeRefCount;
    private final RunOnce closeOnce;

    public OffsetRangeIndexInputStream(IndexInput indexInput, long size, long position) throws IOException {
        indexInput.seek(position);
        this.indexInput = indexInput;
        this.inputStreamIndexInput = new InputStreamIndexInput(indexInput, size);
        ClosingStreams closingStreams = new ClosingStreams(this.inputStreamIndexInput, indexInput);
        this.offsetRangeRefCount = new OffsetRangeRefCount(closingStreams);
        this.closeOnce = new RunOnce(() -> ((OffsetRangeRefCount)this.offsetRangeRefCount).decRef());
    }

    @Override
    public void setReadBlock(AtomicBoolean readBlock) {
        this.readBlock = readBlock;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        this.ensureReadable();
        try (OffsetRangeRefCount ignored = this.getStreamReference();){
            int n = this.inputStreamIndexInput.read(b, off, len);
            return n;
        }
    }

    private OffsetRangeRefCount getStreamReference() {
        boolean successIncrement = this.offsetRangeRefCount.tryIncRef();
        if (!successIncrement) {
            throw this.alreadyClosed("OffsetRangeIndexInputStream is already unreferenced.");
        }
        return this.offsetRangeRefCount;
    }

    private void ensureReadable() {
        if (this.readBlock != null && this.readBlock.get()) {
            logger.debug("Read attempted on a stream which was read blocked!");
            throw this.alreadyClosed("Read blocked stream.");
        }
    }

    AlreadyClosedException alreadyClosed(String msg) {
        return new AlreadyClosedException(msg + this);
    }

    @Override
    public int read() throws IOException {
        this.ensureReadable();
        try (OffsetRangeRefCount ignored = this.getStreamReference();){
            int n = this.inputStreamIndexInput.read();
            return n;
        }
    }

    @Override
    public boolean markSupported() {
        return this.inputStreamIndexInput.markSupported();
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.inputStreamIndexInput.mark(readlimit);
    }

    @Override
    public synchronized void reset() throws IOException {
        this.inputStreamIndexInput.reset();
    }

    @Override
    public long getFilePointer() throws IOException {
        return this.indexInput.getFilePointer();
    }

    public String toString() {
        return "OffsetRangeIndexInputStream{indexInput=" + this.indexInput + ", readBlock=" + this.readBlock + "}";
    }

    @Override
    public void close() throws IOException {
        this.closeOnce.run();
    }

    private static class ClosingStreams {
        private final InputStreamIndexInput inputStreamIndexInput;
        private final IndexInput indexInput;

        public ClosingStreams(InputStreamIndexInput inputStreamIndexInput, IndexInput indexInput) {
            this.inputStreamIndexInput = inputStreamIndexInput;
            this.indexInput = indexInput;
        }
    }

    private static class OffsetRangeRefCount
    extends RefCountedReleasable<ClosingStreams> {
        private static final Logger logger = LogManager.getLogger(OffsetRangeRefCount.class);

        public OffsetRangeRefCount(ClosingStreams ref) {
            super("OffsetRangeRefCount", ref, () -> {
                try {
                    ref.inputStreamIndexInput.close();
                }
                catch (IOException ex) {
                    logger.error("Failed to close indexStreamIndexInput", (Throwable)ex);
                }
                try {
                    ref.indexInput.close();
                }
                catch (IOException ex) {
                    logger.error("Failed to close indexInput", (Throwable)ex);
                }
            });
        }
    }
}

