/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.codec.fuzzy;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.FieldsConsumer;
import org.apache.lucene.codecs.FieldsProducer;
import org.apache.lucene.codecs.NormsProducer;
import org.apache.lucene.codecs.PostingsFormat;
import org.apache.lucene.index.BaseTermsEnum;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.ImpactsEnum;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.automaton.CompiledAutomaton;
import org.opensearch.common.CheckedSupplier;
import org.opensearch.common.util.io.IOUtils;
import org.opensearch.index.codec.fuzzy.FuzzySet;
import org.opensearch.index.codec.fuzzy.FuzzySetFactory;

public final class FuzzyFilterPostingsFormat
extends PostingsFormat {
    private static final Logger logger = LogManager.getLogger(FuzzyFilterPostingsFormat.class);
    public static final String FUZZY_FILTER_CODEC_NAME = "FuzzyFilterCodec99";
    public static final int VERSION_START = 0;
    public static final int VERSION_CURRENT = 0;
    public static final String FUZZY_FILTER_FILE_EXTENSION = "fzd";
    private final PostingsFormat delegatePostingsFormat;
    private final FuzzySetFactory fuzzySetFactory;

    public FuzzyFilterPostingsFormat(PostingsFormat delegatePostingsFormat, FuzzySetFactory fuzzySetFactory) {
        super(FUZZY_FILTER_CODEC_NAME);
        this.delegatePostingsFormat = delegatePostingsFormat;
        this.fuzzySetFactory = fuzzySetFactory;
    }

    public FuzzyFilterPostingsFormat() {
        this(null, null);
    }

    public FieldsConsumer fieldsConsumer(SegmentWriteState state) throws IOException {
        if (this.delegatePostingsFormat == null) {
            throw new UnsupportedOperationException("Error - " + ((Object)((Object)this)).getClass().getName() + " has been constructed without a choice of PostingsFormat");
        }
        FieldsConsumer fieldsConsumer = this.delegatePostingsFormat.fieldsConsumer(state);
        return new FuzzyFilteredFieldsConsumer(fieldsConsumer, state);
    }

    public FieldsProducer fieldsProducer(SegmentReadState state) throws IOException {
        return new FuzzyFilteredFieldsProducer(state);
    }

    public String toString() {
        return "FuzzyFilterPostingsFormat(" + this.delegatePostingsFormat + ")";
    }

    class FuzzyFilteredFieldsConsumer
    extends FieldsConsumer {
        private FieldsConsumer delegateFieldsConsumer;
        private Map<FieldInfo, FuzzySet> fuzzySets = new HashMap<FieldInfo, FuzzySet>();
        private SegmentWriteState state;
        private List<Closeable> closeables = new ArrayList<Closeable>();
        private boolean closed;

        public FuzzyFilteredFieldsConsumer(FieldsConsumer fieldsConsumer, SegmentWriteState state) {
            this.delegateFieldsConsumer = fieldsConsumer;
            this.state = state;
        }

        public void write(Fields fields, NormsProducer norms) throws IOException {
            this.delegateFieldsConsumer.write(fields, norms);
            for (String field : fields) {
                Terms terms = fields.terms(field);
                if (terms == null) continue;
                FieldInfo fieldInfo = this.state.fieldInfos.fieldInfo(field);
                FuzzySet fuzzySet = FuzzyFilterPostingsFormat.this.fuzzySetFactory.createFuzzySet(this.state.segmentInfo.maxDoc(), fieldInfo.name, (CheckedSupplier<Iterator<BytesRef>, IOException>)((CheckedSupplier)() -> this.iterator(terms)));
                if (fuzzySet == null) break;
                assert (!this.fuzzySets.containsKey(fieldInfo));
                this.closeables.add(fuzzySet);
                this.fuzzySets.put(fieldInfo, fuzzySet);
            }
        }

        private Iterator<BytesRef> iterator(Terms terms) throws IOException {
            final TermsEnum termIterator = terms.iterator();
            return new Iterator<BytesRef>(){
                private BytesRef currentTerm;
                private PostingsEnum postingsEnum;

                @Override
                public boolean hasNext() {
                    try {
                        do {
                            this.currentTerm = termIterator.next();
                            if (this.currentTerm == null) {
                                return false;
                            }
                            this.postingsEnum = termIterator.postings(this.postingsEnum, 0);
                        } while (this.postingsEnum.nextDoc() == Integer.MAX_VALUE);
                        return true;
                    }
                    catch (IOException ex) {
                        throw new IllegalStateException("Cannot read terms: " + termIterator.attributes());
                    }
                }

                @Override
                public BytesRef next() {
                    return this.currentTerm;
                }
            };
        }

        public void close() throws IOException {
            if (this.closed) {
                return;
            }
            this.closed = true;
            this.delegateFieldsConsumer.close();
            ArrayList<Map.Entry<FieldInfo, FuzzySet>> nonSaturatedSets = new ArrayList<Map.Entry<FieldInfo, FuzzySet>>();
            for (Map.Entry<FieldInfo, FuzzySet> entry : this.fuzzySets.entrySet()) {
                FuzzySet fuzzySet = entry.getValue();
                if (fuzzySet.isSaturated()) continue;
                nonSaturatedSets.add(entry);
            }
            String fuzzyFilterFileName = IndexFileNames.segmentFileName((String)this.state.segmentInfo.name, (String)this.state.segmentSuffix, (String)FuzzyFilterPostingsFormat.FUZZY_FILTER_FILE_EXTENSION);
            try (IndexOutput fuzzyFilterFileOutput = this.state.directory.createOutput(fuzzyFilterFileName, this.state.context);){
                logger.trace("Writing fuzzy filter postings with version: {} for segment: {}", (Object)0, (Object)this.state.segmentInfo.toString());
                CodecUtil.writeIndexHeader((DataOutput)fuzzyFilterFileOutput, (String)FuzzyFilterPostingsFormat.FUZZY_FILTER_CODEC_NAME, (int)0, (byte[])this.state.segmentInfo.getId(), (String)this.state.segmentSuffix);
                fuzzyFilterFileOutput.writeString(FuzzyFilterPostingsFormat.this.delegatePostingsFormat.getName());
                fuzzyFilterFileOutput.writeInt(nonSaturatedSets.size());
                for (Map.Entry entry : nonSaturatedSets) {
                    FieldInfo fieldInfo = (FieldInfo)entry.getKey();
                    FuzzySet fuzzySet = (FuzzySet)entry.getValue();
                    this.saveAppropriatelySizedFuzzySet(fuzzyFilterFileOutput, fuzzySet, fieldInfo);
                }
                CodecUtil.writeFooter((IndexOutput)fuzzyFilterFileOutput);
            }
            this.fuzzySets.clear();
            IOUtils.closeWhileHandlingException(this.closeables);
        }

        private void saveAppropriatelySizedFuzzySet(IndexOutput fileOutput, FuzzySet fuzzySet, FieldInfo fieldInfo) throws IOException {
            fileOutput.writeInt(fieldInfo.number);
            fileOutput.writeString(fuzzySet.setType().getSetName());
            fuzzySet.writeTo((DataOutput)fileOutput);
        }
    }

    static class FuzzyFilteredFieldsProducer
    extends FieldsProducer {
        private FieldsProducer delegateFieldsProducer;
        HashMap<String, FuzzySet> fuzzySetsByFieldName = new HashMap();
        private List<Closeable> closeables = new ArrayList<Closeable>();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public FuzzyFilteredFieldsProducer(SegmentReadState state) throws IOException {
            String fuzzyFilterFileName = IndexFileNames.segmentFileName((String)state.segmentInfo.name, (String)state.segmentSuffix, (String)FuzzyFilterPostingsFormat.FUZZY_FILTER_FILE_EXTENSION);
            IndexInput filterIn = null;
            boolean success = false;
            try {
                filterIn = state.directory.openInput(fuzzyFilterFileName, state.context);
                CodecUtil.checkIndexHeader((DataInput)filterIn, (String)FuzzyFilterPostingsFormat.FUZZY_FILTER_CODEC_NAME, (int)0, (int)0, (byte[])state.segmentInfo.getId(), (String)state.segmentSuffix);
                PostingsFormat delegatePostingsFormat = PostingsFormat.forName((String)filterIn.readString());
                this.delegateFieldsProducer = delegatePostingsFormat.fieldsProducer(state);
                int numFilters = filterIn.readInt();
                for (int i = 0; i < numFilters; ++i) {
                    int fieldNum = filterIn.readInt();
                    FuzzySet set = FuzzySetFactory.deserializeFuzzySet(filterIn);
                    this.closeables.add(set);
                    FieldInfo fieldInfo = state.fieldInfos.fieldInfo(fieldNum);
                    this.fuzzySetsByFieldName.put(fieldInfo.name, set);
                }
                CodecUtil.retrieveChecksum((IndexInput)filterIn);
                CodecUtil.checksumEntireFile((IndexInput)filterIn);
                success = true;
                this.closeables.add((Closeable)filterIn);
                if (success) return;
            }
            catch (Throwable throwable) {
                if (success) throw throwable;
                IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{filterIn, this.delegateFieldsProducer});
                throw throwable;
            }
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{filterIn, this.delegateFieldsProducer});
        }

        public Iterator<String> iterator() {
            return this.delegateFieldsProducer.iterator();
        }

        public void close() throws IOException {
            IOUtils.closeWhileHandlingException(this.closeables);
            this.delegateFieldsProducer.close();
        }

        public Terms terms(String field) throws IOException {
            FuzzySet filter = this.fuzzySetsByFieldName.get(field);
            if (filter == null) {
                return this.delegateFieldsProducer.terms(field);
            }
            Terms result = this.delegateFieldsProducer.terms(field);
            if (result == null) {
                return null;
            }
            return new FuzzyFilteredTerms(result, filter);
        }

        public int size() {
            return this.delegateFieldsProducer.size();
        }

        public void checkIntegrity() throws IOException {
            this.delegateFieldsProducer.checkIntegrity();
        }

        public String toString() {
            return ((Object)((Object)this)).getClass().getSimpleName() + "(fields=" + this.fuzzySetsByFieldName.size() + ",delegate=" + this.delegateFieldsProducer + ")";
        }

        static class FuzzyFilteredTerms
        extends Terms {
            private Terms delegateTerms;
            private FuzzySet filter;

            public FuzzyFilteredTerms(Terms terms, FuzzySet filter) {
                this.delegateTerms = terms;
                this.filter = filter;
            }

            public TermsEnum intersect(CompiledAutomaton compiled, BytesRef startTerm) throws IOException {
                return this.delegateTerms.intersect(compiled, startTerm);
            }

            public TermsEnum iterator() throws IOException {
                return new FilterAppliedTermsEnum(this.delegateTerms, this.filter);
            }

            public long size() throws IOException {
                return this.delegateTerms.size();
            }

            public long getSumTotalTermFreq() throws IOException {
                return this.delegateTerms.getSumTotalTermFreq();
            }

            public long getSumDocFreq() throws IOException {
                return this.delegateTerms.getSumDocFreq();
            }

            public int getDocCount() throws IOException {
                return this.delegateTerms.getDocCount();
            }

            public boolean hasFreqs() {
                return this.delegateTerms.hasFreqs();
            }

            public boolean hasOffsets() {
                return this.delegateTerms.hasOffsets();
            }

            public boolean hasPositions() {
                return this.delegateTerms.hasPositions();
            }

            public boolean hasPayloads() {
                return this.delegateTerms.hasPayloads();
            }

            public BytesRef getMin() throws IOException {
                return this.delegateTerms.getMin();
            }

            public BytesRef getMax() throws IOException {
                return this.delegateTerms.getMax();
            }
        }

        static final class FilterAppliedTermsEnum
        extends BaseTermsEnum {
            private Terms delegateTerms;
            private TermsEnum delegateTermsEnum;
            private final FuzzySet filter;

            public FilterAppliedTermsEnum(Terms delegateTerms, FuzzySet filter) throws IOException {
                this.delegateTerms = delegateTerms;
                this.filter = filter;
            }

            void reset(Terms delegateTerms) throws IOException {
                this.delegateTerms = delegateTerms;
                this.delegateTermsEnum = null;
            }

            private TermsEnum delegate() throws IOException {
                if (this.delegateTermsEnum == null) {
                    this.delegateTermsEnum = this.delegateTerms.iterator();
                }
                return this.delegateTermsEnum;
            }

            public BytesRef next() throws IOException {
                return this.delegate().next();
            }

            public boolean seekExact(BytesRef text) throws IOException {
                if (this.filter.contains(text) == FuzzySet.Result.NO) {
                    return false;
                }
                return this.delegate().seekExact(text);
            }

            public TermsEnum.SeekStatus seekCeil(BytesRef text) throws IOException {
                return this.delegate().seekCeil(text);
            }

            public void seekExact(long ord) throws IOException {
                this.delegate().seekExact(ord);
            }

            public BytesRef term() throws IOException {
                return this.delegate().term();
            }

            public long ord() throws IOException {
                return this.delegate().ord();
            }

            public int docFreq() throws IOException {
                return this.delegate().docFreq();
            }

            public long totalTermFreq() throws IOException {
                return this.delegate().totalTermFreq();
            }

            public PostingsEnum postings(PostingsEnum reuse, int flags) throws IOException {
                return this.delegate().postings(reuse, flags);
            }

            public ImpactsEnum impacts(int flags) throws IOException {
                return this.delegate().impacts(flags);
            }

            public String toString() {
                return ((Object)((Object)this)).getClass().getSimpleName() + "(filter=" + this.filter.toString() + ")";
            }
        }
    }
}

