/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.compositeindex.datacube.startree.builder;

import java.io.Closeable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.codecs.DocValuesConsumer;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.store.IndexOutput;
import org.opensearch.common.annotation.ExperimentalApi;
import org.opensearch.common.util.io.IOUtils;
import org.opensearch.index.compositeindex.datacube.Dimension;
import org.opensearch.index.compositeindex.datacube.Metric;
import org.opensearch.index.compositeindex.datacube.MetricStat;
import org.opensearch.index.compositeindex.datacube.startree.StarTreeDocument;
import org.opensearch.index.compositeindex.datacube.startree.StarTreeField;
import org.opensearch.index.compositeindex.datacube.startree.builder.BaseStarTreeBuilder;
import org.opensearch.index.compositeindex.datacube.startree.builder.SegmentDocsFileManager;
import org.opensearch.index.compositeindex.datacube.startree.builder.StarTreeDocsFileManager;
import org.opensearch.index.compositeindex.datacube.startree.index.StarTreeValues;
import org.opensearch.index.compositeindex.datacube.startree.utils.SequentialDocValuesIterator;
import org.opensearch.index.compositeindex.datacube.startree.utils.StarTreeDocumentsSorter;
import org.opensearch.index.compositeindex.datacube.startree.utils.StarTreeUtils;
import org.opensearch.index.mapper.MapperService;

@ExperimentalApi
public class OffHeapStarTreeBuilder
extends BaseStarTreeBuilder {
    private static final Logger logger = LogManager.getLogger(OffHeapStarTreeBuilder.class);
    private final StarTreeDocsFileManager starTreeDocumentFileManager;
    private final SegmentDocsFileManager segmentDocumentFileManager;

    protected OffHeapStarTreeBuilder(IndexOutput metaOut, IndexOutput dataOut, StarTreeField starTreeField, SegmentWriteState state, MapperService mapperService) throws IOException {
        super(metaOut, dataOut, starTreeField, state, mapperService);
        this.segmentDocumentFileManager = new SegmentDocsFileManager(state, starTreeField, this.metricAggregatorInfos);
        try {
            this.starTreeDocumentFileManager = new StarTreeDocsFileManager(state, starTreeField, this.metricAggregatorInfos);
        }
        catch (IOException e) {
            IOUtils.closeWhileHandlingException((Closeable)this.segmentDocumentFileManager);
            throw e;
        }
    }

    @Override
    public void appendStarTreeDocument(StarTreeDocument starTreeDocument) throws IOException {
        this.starTreeDocumentFileManager.writeStarTreeDocument(starTreeDocument, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void build(List<StarTreeValues> starTreeValuesSubs, AtomicInteger fieldNumberAcrossStarTrees, DocValuesConsumer starTreeDocValuesConsumer) throws IOException {
        boolean success = false;
        try {
            this.build(this.mergeStarTrees(starTreeValuesSubs), fieldNumberAcrossStarTrees, starTreeDocValuesConsumer);
            success = true;
        }
        finally {
            this.starTreeDocumentFileManager.deleteFiles(success);
            this.segmentDocumentFileManager.deleteFiles(success);
        }
    }

    @Override
    public Iterator<StarTreeDocument> sortAndAggregateSegmentDocuments(SequentialDocValuesIterator[] dimensionReaders, List<SequentialDocValuesIterator> metricReaders) throws IOException {
        int i;
        int[] sortedDocIds = new int[this.totalSegmentDocs];
        for (i = 0; i < this.totalSegmentDocs; ++i) {
            sortedDocIds[i] = i;
        }
        try {
            for (i = 0; i < this.totalSegmentDocs; ++i) {
                StarTreeDocument document = this.getSegmentStarTreeDocument(i, dimensionReaders, metricReaders);
                this.segmentDocumentFileManager.writeStarTreeDocument(document, false);
            }
        }
        catch (IOException ex) {
            this.segmentDocumentFileManager.close();
            throw ex;
        }
        return this.sortAndReduceDocuments(sortedDocIds, this.totalSegmentDocs, false);
    }

    @Override
    Iterator<StarTreeDocument> mergeStarTrees(List<StarTreeValues> starTreeValuesSubs) throws IOException {
        int[] docIds;
        int numDocs = 0;
        try {
            for (StarTreeValues starTreeValues : starTreeValuesSubs) {
                List<Dimension> dimensionsSplitOrder = starTreeValues.getStarTreeField().getDimensionsOrder();
                SequentialDocValuesIterator[] dimensionReaders = new SequentialDocValuesIterator[starTreeValues.getStarTreeField().getDimensionsOrder().size()];
                for (int i = 0; i < dimensionsSplitOrder.size(); ++i) {
                    String dimension = dimensionsSplitOrder.get(i).getField();
                    dimensionReaders[i] = new SequentialDocValuesIterator(starTreeValues.getDimensionDocIdSetIterator(dimension));
                }
                ArrayList<SequentialDocValuesIterator> metricReaders = new ArrayList<SequentialDocValuesIterator>();
                for (Metric metric : starTreeValues.getStarTreeField().getMetrics()) {
                    for (MetricStat metricStat : metric.getBaseMetrics()) {
                        String metricFullName = StarTreeUtils.fullyQualifiedFieldNameForStarTreeMetricsDocValues(starTreeValues.getStarTreeField().getName(), metric.getField(), metricStat.getTypeName());
                        metricReaders.add(new SequentialDocValuesIterator(starTreeValues.getMetricDocIdSetIterator(metricFullName)));
                    }
                }
                int numSegmentDocs = Integer.parseInt(starTreeValues.getAttributes().getOrDefault("segmentDocsCount", String.valueOf(Integer.MAX_VALUE)));
                for (int currentDocId = 0; currentDocId < numSegmentDocs; ++currentDocId) {
                    StarTreeDocument starTreeDocument = this.getStarTreeDocument(currentDocId, dimensionReaders, metricReaders);
                    this.segmentDocumentFileManager.writeStarTreeDocument(starTreeDocument, true);
                    ++numDocs;
                }
            }
            docIds = new int[numDocs];
            for (int i = 0; i < numDocs; ++i) {
                docIds[i] = i;
            }
        }
        catch (IOException ex) {
            this.segmentDocumentFileManager.close();
            throw ex;
        }
        if (numDocs == 0) {
            return Collections.emptyIterator();
        }
        return this.sortAndReduceDocuments(docIds, numDocs, true);
    }

    private Iterator<StarTreeDocument> sortAndReduceDocuments(final int[] sortedDocIds, final int numDocs, final boolean isMerge) throws IOException {
        try {
            if (sortedDocIds == null || sortedDocIds.length == 0) {
                logger.debug("Sorted doc ids array is null");
                return Collections.emptyIterator();
            }
            try {
                StarTreeDocumentsSorter.sort(sortedDocIds, -1, numDocs, index -> {
                    try {
                        return this.segmentDocumentFileManager.readDimensions(sortedDocIds[index]);
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                });
            }
            catch (UncheckedIOException ex) {
                if (ex.getCause() != null) {
                    throw ex.getCause();
                }
                throw ex;
            }
            final StarTreeDocument currentDocument = this.segmentDocumentFileManager.readStarTreeDocument(sortedDocIds[0], isMerge);
            return new Iterator<StarTreeDocument>(){
                StarTreeDocument tempCurrentDocument;
                boolean hasNext;
                int docId;
                {
                    this.tempCurrentDocument = currentDocument;
                    this.hasNext = true;
                    this.docId = 1;
                }

                @Override
                public boolean hasNext() {
                    return this.hasNext;
                }

                @Override
                public StarTreeDocument next() {
                    StarTreeDocument next = OffHeapStarTreeBuilder.this.reduceSegmentStarTreeDocuments(null, this.tempCurrentDocument, isMerge);
                    while (this.docId < numDocs) {
                        StarTreeDocument doc;
                        try {
                            doc = OffHeapStarTreeBuilder.this.segmentDocumentFileManager.readStarTreeDocument(sortedDocIds[this.docId++], isMerge);
                        }
                        catch (IOException e) {
                            throw new RuntimeException("Reducing documents failed ", e);
                        }
                        if (!Arrays.equals((Object[])doc.dimensions, (Object[])next.dimensions)) {
                            this.tempCurrentDocument = doc;
                            return next;
                        }
                        next = OffHeapStarTreeBuilder.this.reduceSegmentStarTreeDocuments(next, doc, isMerge);
                    }
                    this.hasNext = false;
                    try {
                        OffHeapStarTreeBuilder.this.segmentDocumentFileManager.close();
                    }
                    catch (IOException ex) {
                        logger.error("Closing segment documents file failed", (Throwable)ex);
                    }
                    return next;
                }
            };
        }
        catch (IOException ex) {
            IOUtils.closeWhileHandlingException((Closeable)this.segmentDocumentFileManager);
            throw ex;
        }
    }

    @Override
    public StarTreeDocument getStarTreeDocument(int docId) throws IOException {
        return this.starTreeDocumentFileManager.readStarTreeDocument(docId, true);
    }

    @Override
    public List<StarTreeDocument> getStarTreeDocuments() throws IOException {
        ArrayList<StarTreeDocument> starTreeDocuments = new ArrayList<StarTreeDocument>();
        for (int i = 0; i < this.numStarTreeDocs; ++i) {
            starTreeDocuments.add(this.getStarTreeDocument(i));
        }
        return starTreeDocuments;
    }

    @Override
    public Long getDimensionValue(int docId, int dimensionId) throws IOException {
        return this.starTreeDocumentFileManager.getDimensionValue(docId, dimensionId);
    }

    @Override
    public Iterator<StarTreeDocument> generateStarTreeDocumentsForStarNode(int startDocId, int endDocId, final int dimensionId) throws IOException {
        final int numDocs = endDocId - startDocId;
        final int[] sortedDocIds = new int[numDocs];
        for (int i = 0; i < numDocs; ++i) {
            sortedDocIds[i] = startDocId + i;
        }
        StarTreeDocumentsSorter.sort(sortedDocIds, dimensionId, numDocs, index -> {
            try {
                return this.starTreeDocumentFileManager.readDimensions(sortedDocIds[index]);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
        return new Iterator<StarTreeDocument>(){
            boolean hasNext = true;
            StarTreeDocument currentDocument = OffHeapStarTreeBuilder.this.getStarTreeDocument(sortedDocIds[0]);
            int docId = 1;

            private boolean hasSameDimensions(StarTreeDocument document1, StarTreeDocument document2) {
                for (int i = dimensionId + 1; i < OffHeapStarTreeBuilder.this.starTreeField.getDimensionsOrder().size(); ++i) {
                    if (Objects.equals(document1.dimensions[i], document2.dimensions[i])) continue;
                    return false;
                }
                return true;
            }

            @Override
            public boolean hasNext() {
                return this.hasNext;
            }

            @Override
            public StarTreeDocument next() {
                StarTreeDocument next = OffHeapStarTreeBuilder.this.reduceStarTreeDocuments(null, this.currentDocument);
                next.dimensions[dimensionId] = BaseStarTreeBuilder.STAR_IN_DOC_VALUES_INDEX;
                while (this.docId < numDocs) {
                    StarTreeDocument document;
                    try {
                        document = OffHeapStarTreeBuilder.this.getStarTreeDocument(sortedDocIds[this.docId++]);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                    if (!this.hasSameDimensions(document, this.currentDocument)) {
                        this.currentDocument = document;
                        return next;
                    }
                    next = OffHeapStarTreeBuilder.this.reduceStarTreeDocuments(next, document);
                }
                this.hasNext = false;
                return next;
            }
        };
    }

    @Override
    public void close() throws IOException {
        IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{this.starTreeDocumentFileManager, this.segmentDocumentFileManager});
        super.close();
    }
}

