/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.modeler;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.net.URL;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.management.DynamicMBean;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.modeler.ManagedBean;
import org.apache.tomcat.util.modeler.NoDescriptorRegistry;
import org.apache.tomcat.util.modeler.RegistryMBean;
import org.apache.tomcat.util.modeler.modules.ModelerSource;
import org.apache.tomcat.util.res.StringManager;

public class Registry
implements RegistryMBean,
MBeanRegistration {
    private static final Log log = LogFactory.getLog(Registry.class);
    private static final StringManager sm = StringManager.getManager(Registry.class);
    private static Registry registry = null;
    private volatile MBeanServer server = null;
    private final Object serverLock = new Object();
    private Map<String, ManagedBean> descriptors = new HashMap<String, ManagedBean>();
    private Map<String, ManagedBean> descriptorsByClass = new HashMap<String, ManagedBean>();
    private Map<String, URL> searchedPaths = new HashMap<String, URL>();
    private Object guard;
    private final Hashtable<String, Hashtable<String, Integer>> idDomains = new Hashtable();
    private final Hashtable<String, int[]> ids = new Hashtable();

    protected Registry() {
    }

    public static synchronized Registry getRegistry(Object object, Object object2) {
        if (registry == null) {
            registry = new Registry();
            Registry.registry.guard = object2;
        }
        if (Registry.registry.guard != null && Registry.registry.guard != object2) {
            return null;
        }
        return registry;
    }

    public static synchronized void disableRegistry() {
        if (registry == null) {
            registry = new NoDescriptorRegistry();
        } else if (!(registry instanceof NoDescriptorRegistry)) {
            log.warn((Object)sm.getString("registry.noDisable"));
        }
    }

    @Override
    public void stop() {
        this.descriptorsByClass = new HashMap<String, ManagedBean>();
        this.descriptors = new HashMap<String, ManagedBean>();
        this.searchedPaths = new HashMap<String, URL>();
    }

    @Override
    public void registerComponent(Object object, String string, String string2) throws Exception {
        this.registerComponent(object, new ObjectName(string), string2);
    }

    @Override
    public void unregisterComponent(String string) {
        try {
            this.unregisterComponent(new ObjectName(string));
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            log.info((Object)sm.getString("registry.objectNameCreateError"), (Throwable)malformedObjectNameException);
        }
    }

    @Override
    public void invoke(List<ObjectName> list, String string, boolean bl) throws Exception {
        if (list == null) {
            return;
        }
        for (ObjectName objectName : list) {
            try {
                if (objectName == null || this.getMethodInfo(objectName, string) == null) continue;
                this.getMBeanServer().invoke(objectName, string, new Object[0], new String[0]);
            }
            catch (Exception exception) {
                if (bl) {
                    throw exception;
                }
                log.info((Object)sm.getString("registry.initError"), (Throwable)exception);
            }
        }
    }

    @Override
    public synchronized int getId(String string2, String string3) {
        Integer n;
        if (string2 == null) {
            string2 = "";
        }
        Hashtable hashtable = this.idDomains.computeIfAbsent(string2, string -> new Hashtable());
        if (string3 == null) {
            string3 = "";
        }
        if ((n = (Integer)hashtable.get(string3)) != null) {
            return n;
        }
        int[] nArray = this.ids.computeIfAbsent(string2, string -> new int[1]);
        int n2 = nArray[0];
        nArray[0] = n2 + 1;
        int n3 = n2;
        hashtable.put(string3, n3);
        return n3;
    }

    public void addManagedBean(ManagedBean managedBean) {
        this.descriptors.put(managedBean.getName(), managedBean);
        if (managedBean.getType() != null) {
            this.descriptorsByClass.put(managedBean.getType(), managedBean);
        }
    }

    public ManagedBean findManagedBean(String string) {
        ManagedBean managedBean = this.descriptors.get(string);
        if (managedBean == null) {
            managedBean = this.descriptorsByClass.get(string);
        }
        return managedBean;
    }

    public String getType(ObjectName objectName, String string) {
        MBeanAttributeInfo[] mBeanAttributeInfoArray;
        String string2 = null;
        MBeanInfo mBeanInfo = null;
        try {
            mBeanInfo = this.getMBeanServer().getMBeanInfo(objectName);
        }
        catch (Exception exception) {
            log.info((Object)sm.getString("registry.noMetadata", new Object[]{objectName}));
            return null;
        }
        for (MBeanAttributeInfo mBeanAttributeInfo : mBeanAttributeInfoArray = mBeanInfo.getAttributes()) {
            if (!string.equals(mBeanAttributeInfo.getName())) continue;
            string2 = mBeanAttributeInfo.getType();
            return string2;
        }
        return null;
    }

    public MBeanOperationInfo getMethodInfo(ObjectName objectName, String string) {
        MBeanOperationInfo[] mBeanOperationInfoArray;
        MBeanInfo mBeanInfo = null;
        try {
            mBeanInfo = this.getMBeanServer().getMBeanInfo(objectName);
        }
        catch (Exception exception) {
            log.info((Object)sm.getString("registry.noMetadata", new Object[]{objectName}));
            return null;
        }
        for (MBeanOperationInfo mBeanOperationInfo : mBeanOperationInfoArray = mBeanInfo.getOperations()) {
            if (!string.equals(mBeanOperationInfo.getName())) continue;
            return mBeanOperationInfo;
        }
        return null;
    }

    public MBeanOperationInfo getMethodInfo(ObjectName objectName, String string, int n) throws InstanceNotFoundException {
        MBeanOperationInfo[] mBeanOperationInfoArray;
        MBeanInfo mBeanInfo = null;
        try {
            mBeanInfo = this.getMBeanServer().getMBeanInfo(objectName);
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            throw instanceNotFoundException;
        }
        catch (Exception exception) {
            log.warn((Object)sm.getString("registry.noMetadata", new Object[]{objectName}), (Throwable)exception);
            return null;
        }
        for (MBeanOperationInfo mBeanOperationInfo : mBeanOperationInfoArray = mBeanInfo.getOperations()) {
            if (!string.equals(mBeanOperationInfo.getName()) || n != mBeanOperationInfo.getSignature().length) continue;
            return mBeanOperationInfo;
        }
        return null;
    }

    public void unregisterComponent(ObjectName objectName) {
        try {
            if (objectName != null && this.getMBeanServer().isRegistered(objectName)) {
                this.getMBeanServer().unregisterMBean(objectName);
            }
        }
        catch (Throwable throwable) {
            log.error((Object)sm.getString("registry.unregisterError"), throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MBeanServer getMBeanServer() {
        if (this.server == null) {
            Object object = this.serverLock;
            synchronized (object) {
                if (this.server == null) {
                    if (MBeanServerFactory.findMBeanServer(null).size() > 0) {
                        this.server = MBeanServerFactory.findMBeanServer(null).get(0);
                        if (log.isDebugEnabled()) {
                            log.debug((Object)sm.getString("registry.existingServer"));
                        }
                    } else {
                        this.server = ManagementFactory.getPlatformMBeanServer();
                        if (log.isDebugEnabled()) {
                            log.debug((Object)sm.getString("registry.createdServer"));
                        }
                    }
                }
            }
        }
        return this.server;
    }

    public ManagedBean findManagedBean(Object object, Class<?> clazz, String string) throws Exception {
        ManagedBean managedBean;
        if (object != null && clazz == null) {
            clazz = object.getClass();
        }
        if (string == null) {
            string = clazz.getName();
        }
        if ((managedBean = this.findManagedBean(string)) == null) {
            if (log.isTraceEnabled()) {
                log.trace((Object)"Looking for descriptor ");
            }
            this.findDescriptor(clazz, string);
            managedBean = this.findManagedBean(string);
        }
        if (managedBean == null) {
            if (log.isTraceEnabled()) {
                log.trace((Object)"Introspecting ");
            }
            this.load("MbeansDescriptorsIntrospectionSource", clazz, string);
            managedBean = this.findManagedBean(string);
            if (managedBean == null) {
                log.warn((Object)sm.getString("registry.noTypeMetadata", new Object[]{string}));
                return null;
            }
            managedBean.setName(string);
            this.addManagedBean(managedBean);
        }
        return managedBean;
    }

    public Object convertValue(String string, String string2) {
        Object object = string2;
        if (string == null || "java.lang.String".equals(string)) {
            object = string2;
        } else if ("javax.management.ObjectName".equals(string) || "ObjectName".equals(string)) {
            try {
                object = new ObjectName(string2);
            }
            catch (MalformedObjectNameException malformedObjectNameException) {
                return null;
            }
        } else if ("java.lang.Integer".equals(string) || "int".equals(string)) {
            object = Integer.valueOf(string2);
        } else if ("java.lang.Long".equals(string) || "long".equals(string)) {
            object = Long.valueOf(string2);
        } else if ("java.lang.Boolean".equals(string) || "boolean".equals(string)) {
            object = Boolean.valueOf(string2);
        }
        return object;
    }

    public List<ObjectName> load(String string, Object object, String string2) throws Exception {
        Object object2;
        if (log.isTraceEnabled()) {
            log.trace((Object)("load " + object));
        }
        String string3 = null;
        String string4 = null;
        Object object3 = null;
        if (object instanceof URL) {
            object2 = (URL)object;
            string3 = ((URL)object2).toString();
            string4 = string2;
            object3 = ((URL)object2).openStream();
            if (string == null && string3.endsWith(".xml")) {
                string = "MbeansDescriptorsDigesterSource";
            }
        } else if (object instanceof File) {
            string3 = ((File)object).getAbsolutePath();
            object3 = new FileInputStream((File)object);
            string4 = string2;
            if (string == null && string3.endsWith(".xml")) {
                string = "MbeansDescriptorsDigesterSource";
            }
        } else if (object instanceof InputStream) {
            string4 = string2;
            object3 = object;
        } else if (object instanceof Class) {
            string3 = ((Class)object).getName();
            string4 = string2;
            object3 = object;
            if (string == null) {
                string = "MbeansDescriptorsIntrospectionSource";
            }
        } else {
            throw new IllegalArgumentException(sm.getString("registry.invalidSource"));
        }
        if (string == null) {
            string = "MbeansDescriptorsDigesterSource";
        }
        object2 = this.getModelerSource(string);
        List<ObjectName> list = ((ModelerSource)object2).loadDescriptors(this, string4, object3);
        return list;
    }

    public void registerComponent(Object object, ObjectName objectName, String string) throws Exception {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Managed= " + objectName));
        }
        if (object == null) {
            log.error((Object)sm.getString("registry.nullBean", new Object[]{objectName}));
            return;
        }
        try {
            if (string == null) {
                string = object.getClass().getName();
            }
            ManagedBean managedBean = this.findManagedBean(null, object.getClass(), string);
            DynamicMBean dynamicMBean = managedBean.createMBean(object);
            if (this.getMBeanServer().isRegistered(objectName)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)sm.getString("registry.unregisterExisting", new Object[]{objectName}));
                }
                this.getMBeanServer().unregisterMBean(objectName);
            }
            this.getMBeanServer().registerMBean(dynamicMBean, objectName);
        }
        catch (Exception exception) {
            log.error((Object)sm.getString("registry.registerError", new Object[]{objectName}), (Throwable)exception);
            throw exception;
        }
    }

    public void loadDescriptors(String string, ClassLoader classLoader) {
        String string2 = string.replace('.', '/');
        if (log.isTraceEnabled()) {
            log.trace((Object)("Finding descriptor " + string2));
        }
        if (this.searchedPaths.get(string) != null) {
            return;
        }
        String string3 = string2 + "/mbeans-descriptors.xml";
        URL uRL = classLoader.getResource(string3);
        if (uRL == null) {
            return;
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("Found " + uRL));
        }
        this.searchedPaths.put(string, uRL);
        try {
            this.load("MbeansDescriptorsDigesterSource", uRL, null);
        }
        catch (Exception exception) {
            log.error((Object)sm.getString("registry.loadError", new Object[]{uRL}));
        }
    }

    private void findDescriptor(Class<?> clazz, String string) {
        String string2;
        if (string == null) {
            string = clazz.getName();
        }
        ClassLoader classLoader = null;
        if (clazz != null) {
            classLoader = clazz.getClassLoader();
        }
        if (classLoader == null) {
            classLoader = Thread.currentThread().getContextClassLoader();
        }
        if (classLoader == null) {
            classLoader = this.getClass().getClassLoader();
        }
        String string3 = string2 = string;
        while (string3.indexOf(46) > 0) {
            int n = string3.lastIndexOf(46);
            if (n <= 0) {
                return;
            }
            if (this.searchedPaths.get(string3 = string3.substring(0, n)) != null) {
                return;
            }
            this.loadDescriptors(string3, classLoader);
        }
    }

    private ModelerSource getModelerSource(String string) throws Exception {
        if (string == null) {
            string = "MbeansDescriptorsDigesterSource";
        }
        if (!string.contains(".")) {
            string = "org.apache.tomcat.util.modeler.modules." + string;
        }
        Class<?> clazz = Class.forName(string);
        ModelerSource modelerSource = (ModelerSource)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        return modelerSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ObjectName preRegister(MBeanServer mBeanServer, ObjectName objectName) throws Exception {
        Object object = this.serverLock;
        synchronized (object) {
            this.server = mBeanServer;
        }
        return objectName;
    }

    @Override
    public void postRegister(Boolean bl) {
    }

    @Override
    public void preDeregister() throws Exception {
    }

    @Override
    public void postDeregister() {
    }
}

