/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.symmetry;

import java.util.Map;
import javajs.util.Lst;
import javajs.util.PT;
import org.jmol.symmetry.SpaceGroup;
import org.jmol.symmetry.Symmetry;
import org.jmol.util.SimpleUnitCell;

public abstract class SpecialGroup
extends SpaceGroup {
    protected Symmetry embeddingSymmetry;

    SpecialGroup(Symmetry sym, Map<String, Object> info, int type) {
        super(-1, null, true);
        this.embeddingSymmetry = sym;
        this.groupType = type;
        if (info == null) {
            return;
        }
        this.initSpecial(info);
    }

    private void initSpecial(Map<String, Object> info) {
        Lst ops = (Lst)info.get("gp");
        for (int i = 0; i < ops.size(); ++i) {
            this.addOperation((String)ops.get(i), 0, false);
        }
        this.itaTransform = (String)info.get("trm");
        this.itaNumber = "" + info.get("sg");
        this.itaIndex = "" + info.get("set");
        this.specialPrefix = SpecialGroup.getGroupTypePrefix(this.groupType);
        this.setHMSymbol((String)info.get("hm"));
        this.setITATableNames(null, this.itaNumber, this.itaIndex, this.itaTransform);
    }

    static class FriezeGroup
    extends SpecialGroup {
        protected FriezeGroup(Symmetry sym, Map<String, Object> info) {
            super(sym, info, 600);
            this.nDim = 2;
            this.periodicity = 1;
        }

        @Override
        public boolean createCompatibleUnitCell(float[] params, float[] newParams, boolean allowSame) {
            if (newParams == null) {
                newParams = params;
            }
            float a = params[0];
            float b = params[0];
            float c = -1.0f;
            float alpha = 90.0f;
            float beta = 90.0f;
            float gamma = 90.0f;
            boolean isNew = a != params[0] || b != params[1] || c != params[2] || alpha != params[3] || beta != params[4] || gamma != params[5];
            newParams[0] = a;
            newParams[1] = b;
            newParams[2] = c;
            newParams[3] = alpha;
            newParams[4] = beta;
            newParams[5] = gamma;
            return isNew;
        }
    }

    static class RodGroup
    extends SpecialGroup {
        protected RodGroup(Symmetry sym, Map<String, Object> info) {
            super(sym, info, 500);
            this.nDim = 3;
            this.periodicity = 4;
        }

        @Override
        public boolean createCompatibleUnitCell(float[] params, float[] newParams, boolean allowSame) {
            if (newParams == null) {
                newParams = params;
            }
            float a = params[0];
            float b = params[1];
            float c = params[2];
            float alpha = params[3];
            float beta = params[4];
            float gamma = params[5];
            int n = this.itaNumber == null ? 0 : PT.parseInt(this.itaNumber);
            boolean toHex = false;
            boolean isHex = false;
            toHex = n != 0 && this.isHexagonalSG(n, null);
            boolean bl = isHex = toHex && this.isHexagonalSG(-1, params);
            if (toHex && isHex) {
                allowSame = true;
            }
            if (n > (allowSame ? 2 : 0)) {
                boolean absame = b > 0.0f && SimpleUnitCell.approx0(a - b);
                boolean bcsame = c > 0.0f && SimpleUnitCell.approx0(b - c);
                boolean acsame = c > 0.0f && SimpleUnitCell.approx0(c - a);
                boolean albesame = SimpleUnitCell.approx0(alpha - beta);
                boolean begasame = SimpleUnitCell.approx0(beta - gamma);
                boolean algasame = SimpleUnitCell.approx0(gamma - alpha);
                if (!allowSame) {
                    float d;
                    if (b > 0.0f && a > b) {
                        d = a;
                        a = b;
                        b = d;
                    }
                    boolean bl2 = bcsame = c > 0.0f && SimpleUnitCell.approx0(b - c);
                    if (bcsame) {
                        c = b * 1.5f;
                    }
                    if (absame = SimpleUnitCell.approx0(a - b)) {
                        b = a * 1.2f;
                    }
                    if (acsame = SimpleUnitCell.approx0(c - a)) {
                        c = a * 1.1f;
                    }
                    if (SimpleUnitCell.approx0(alpha - 90.0f)) {
                        alpha = 80.0f;
                    }
                    if (SimpleUnitCell.approx0(beta - 90.0f)) {
                        beta = 100.0f;
                    }
                    if (SimpleUnitCell.approx0(gamma - 90.0f)) {
                        gamma = 110.0f;
                    }
                    if (alpha > beta) {
                        d = alpha;
                        alpha = beta;
                        beta = d;
                    }
                    albesame = SimpleUnitCell.approx0(alpha - beta);
                    begasame = SimpleUnitCell.approx0(beta - gamma);
                    algasame = SimpleUnitCell.approx0(gamma - alpha);
                    if (albesame) {
                        beta = alpha * 1.2f;
                    }
                    if (begasame) {
                        gamma = beta * 1.3f;
                    }
                    if (algasame) {
                        gamma = alpha * 1.4f;
                    }
                }
                if (toHex) {
                    b = a;
                    beta = 90.0f;
                    alpha = 90.0f;
                    gamma = 120.0f;
                } else if (n >= 23) {
                    b = a;
                    if (acsame && !allowSame) {
                        c = a * 1.5f;
                    }
                    gamma = 90.0f;
                    beta = 90.0f;
                    alpha = 90.0f;
                } else if (n >= 13) {
                    gamma = 90.0f;
                    beta = 90.0f;
                    alpha = 90.0f;
                } else if (n >= 8) {
                    beta = 90.0f;
                    alpha = 90.0f;
                } else if (n >= 3) {
                    gamma = 90.0f;
                    beta = 90.0f;
                }
            }
            boolean isNew = a != params[0] || b != params[1] || c != params[2] || alpha != params[3] || beta != params[4] || gamma != params[5];
            newParams[0] = a;
            newParams[1] = b;
            newParams[2] = c;
            newParams[3] = alpha;
            newParams[4] = beta;
            newParams[5] = gamma;
            return isNew;
        }

        @Override
        public boolean isHexagonalSG(int n, float[] params) {
            return n < 1 ? SimpleUnitCell.isHexagonal(params) : n >= 42;
        }
    }

    static class LayerGroup
    extends SpecialGroup {
        protected LayerGroup(Symmetry sym, Map<String, Object> info) {
            super(sym, info, 400);
            this.nDim = 3;
            this.periodicity = 3;
        }

        @Override
        public boolean createCompatibleUnitCell(float[] params, float[] newParams, boolean allowSame) {
            if (newParams == null) {
                newParams = params;
            }
            float a = params[0];
            float b = params[1];
            float c = params[2];
            float alpha = params[3];
            float beta = params[4];
            float gamma = params[5];
            int n = this.itaNumber == null ? 0 : PT.parseInt(this.itaNumber);
            boolean toHex = false;
            boolean isHex = false;
            toHex = n != 0 && this.isHexagonalSG(n, null);
            boolean bl = isHex = toHex && this.isHexagonalSG(-1, params);
            if (toHex && isHex) {
                allowSame = true;
            }
            if (n > (allowSame ? 2 : 0)) {
                boolean absame = b > 0.0f && SimpleUnitCell.approx0(a - b);
                boolean bcsame = c > 0.0f && SimpleUnitCell.approx0(b - c);
                boolean acsame = c > 0.0f && SimpleUnitCell.approx0(c - a);
                boolean albesame = SimpleUnitCell.approx0(alpha - beta);
                boolean begasame = SimpleUnitCell.approx0(beta - gamma);
                boolean algasame = SimpleUnitCell.approx0(gamma - alpha);
                if (!allowSame) {
                    float d;
                    if (b > 0.0f && a > b) {
                        d = a;
                        a = b;
                        b = d;
                    }
                    boolean bl2 = bcsame = c > 0.0f && SimpleUnitCell.approx0(b - c);
                    if (bcsame) {
                        c = b * 1.5f;
                    }
                    if (absame = SimpleUnitCell.approx0(a - b)) {
                        b = a * 1.2f;
                    }
                    if (acsame = SimpleUnitCell.approx0(c - a)) {
                        c = a * 1.1f;
                    }
                    if (SimpleUnitCell.approx0(alpha - 90.0f)) {
                        alpha = 80.0f;
                    }
                    if (SimpleUnitCell.approx0(beta - 90.0f)) {
                        beta = 100.0f;
                    }
                    if (SimpleUnitCell.approx0(gamma - 90.0f)) {
                        gamma = 110.0f;
                    }
                    if (alpha > beta) {
                        d = alpha;
                        alpha = beta;
                        beta = d;
                    }
                    albesame = SimpleUnitCell.approx0(alpha - beta);
                    begasame = SimpleUnitCell.approx0(beta - gamma);
                    algasame = SimpleUnitCell.approx0(gamma - alpha);
                    if (albesame) {
                        beta = alpha * 1.2f;
                    }
                    if (begasame) {
                        gamma = beta * 1.3f;
                    }
                    if (algasame) {
                        gamma = alpha * 1.4f;
                    }
                }
                if (toHex) {
                    b = a;
                    beta = 90.0f;
                    alpha = 90.0f;
                    gamma = 120.0f;
                } else if (n >= 49) {
                    b = a;
                    if (acsame && !allowSame) {
                        c = a * 1.5f;
                    }
                    gamma = 90.0f;
                    beta = 90.0f;
                    alpha = 90.0f;
                } else if (n >= 19) {
                    gamma = 90.0f;
                    beta = 90.0f;
                    alpha = 90.0f;
                } else if (n >= 8) {
                    gamma = 90.0f;
                    beta = 90.0f;
                } else if (n >= 3) {
                    beta = 90.0f;
                    alpha = 90.0f;
                }
            }
            boolean isNew = a != params[0] || b != params[1] || c != params[2] || alpha != params[3] || beta != params[4] || gamma != params[5];
            newParams[0] = a;
            newParams[1] = b;
            newParams[2] = c;
            newParams[3] = alpha;
            newParams[4] = beta;
            newParams[5] = gamma;
            return isNew;
        }

        @Override
        public boolean isHexagonalSG(int n, float[] params) {
            return n < 1 ? SimpleUnitCell.isHexagonal(params) : n >= 65;
        }
    }

    static class PlaneGroup
    extends SpecialGroup {
        protected PlaneGroup(Symmetry sym, Map<String, Object> info) {
            super(sym, info, 300);
            this.nDim = 2;
            this.periodicity = 3;
        }

        @Override
        public boolean createCompatibleUnitCell(float[] params, float[] newParams, boolean allowSame) {
            if (newParams == null) {
                newParams = params;
            }
            float a = params[0];
            float b = params[1];
            float c = -1.0f;
            float alpha = 90.0f;
            float beta = 90.0f;
            float gamma = params[5];
            int n = this.itaNumber == null ? 0 : PT.parseInt(this.itaNumber);
            boolean toHex = false;
            boolean isHex = false;
            toHex = n != 0 && this.isHexagonalSG(n, null);
            boolean bl = isHex = toHex && this.isHexagonalSG(-1, params);
            if (toHex && isHex) {
                allowSame = true;
            }
            if (n > (allowSame ? 2 : 0)) {
                boolean absame = SimpleUnitCell.approx0(a - b);
                if (!allowSame) {
                    if (a > b) {
                        float d = a;
                        a = b;
                        b = d;
                    }
                    if (absame = SimpleUnitCell.approx0(a - b)) {
                        b = a * 1.2f;
                    }
                    if (SimpleUnitCell.approx0(gamma - 90.0f)) {
                        gamma = 110.0f;
                    }
                }
                if (toHex) {
                    b = a;
                    beta = 90.0f;
                    alpha = 90.0f;
                    gamma = 120.0f;
                } else if (n >= 10) {
                    b = a;
                    gamma = 90.0f;
                } else if (n >= 3) {
                    gamma = 90.0f;
                }
            }
            boolean isNew = a != params[0] || b != params[1] || c != params[2] || alpha != params[3] || beta != params[4] || gamma != params[5];
            newParams[0] = a;
            newParams[1] = b;
            newParams[2] = c;
            newParams[3] = alpha;
            newParams[4] = beta;
            newParams[5] = gamma;
            return isNew;
        }

        @Override
        public boolean isHexagonalSG(int n, float[] params) {
            return n < 1 ? SimpleUnitCell.isHexagonal(params) : n >= 13;
        }
    }
}

