/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index.query.rescore;

import lombok.Generated;

public final class RescoreContext {
    public static final float DEFAULT_OVERSAMPLE_FACTOR = 1.0f;
    public static final float MAX_OVERSAMPLE_FACTOR = 100.0f;
    public static final float MIN_OVERSAMPLE_FACTOR = 0.0f;
    public static final int MAX_FIRST_PASS_RESULTS = 10000;
    public static final int MIN_FIRST_PASS_RESULTS = 100;
    private float oversampleFactor;

    public static RescoreContext getDefault() {
        return RescoreContext.builder().build();
    }

    public int getFirstPassK(int finalK) {
        return Math.min(10000, Math.max(100, (int)Math.ceil((float)finalK * this.oversampleFactor)));
    }

    @Generated
    private static float $default$oversampleFactor() {
        return 1.0f;
    }

    @Generated
    public static RescoreContextBuilder builder() {
        return new RescoreContextBuilder();
    }

    @Generated
    public float getOversampleFactor() {
        return this.oversampleFactor;
    }

    @Generated
    public RescoreContext(float oversampleFactor) {
        this.oversampleFactor = oversampleFactor;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RescoreContext)) {
            return false;
        }
        RescoreContext other = (RescoreContext)o;
        return Float.compare(this.getOversampleFactor(), other.getOversampleFactor()) == 0;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Float.floatToIntBits(this.getOversampleFactor());
        return result;
    }

    @Generated
    public static class RescoreContextBuilder {
        @Generated
        private boolean oversampleFactor$set;
        @Generated
        private float oversampleFactor$value;

        @Generated
        RescoreContextBuilder() {
        }

        @Generated
        public RescoreContextBuilder oversampleFactor(float oversampleFactor) {
            this.oversampleFactor$value = oversampleFactor;
            this.oversampleFactor$set = true;
            return this;
        }

        @Generated
        public RescoreContext build() {
            float oversampleFactor$value = this.oversampleFactor$value;
            if (!this.oversampleFactor$set) {
                oversampleFactor$value = RescoreContext.$default$oversampleFactor();
            }
            return new RescoreContext(oversampleFactor$value);
        }

        @Generated
        public String toString() {
            return "RescoreContext.RescoreContextBuilder(oversampleFactor$value=" + this.oversampleFactor$value + ")";
        }
    }
}

