/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.plugin.transport;

import java.io.IOException;
import lombok.Generated;
import org.opensearch.action.ActionRequestValidationException;
import org.opensearch.action.ValidateActions;
import org.opensearch.action.support.master.AcknowledgedRequest;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;

public class UpdateModelGraveyardRequest
extends AcknowledgedRequest<UpdateModelGraveyardRequest> {
    private final String modelId;
    private final boolean isRemoveRequest;

    public UpdateModelGraveyardRequest(StreamInput in) throws IOException {
        super(in);
        this.modelId = in.readString();
        this.isRemoveRequest = in.readBoolean();
    }

    public UpdateModelGraveyardRequest(String modelId, boolean isRemoveRequest) {
        this.modelId = modelId;
        this.isRemoveRequest = isRemoveRequest;
    }

    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.modelId.isEmpty()) {
            validationException = ValidateActions.addValidationError((String)"Missing model ID", validationException);
        }
        return validationException;
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.modelId);
        out.writeBoolean(this.isRemoveRequest);
    }

    @Generated
    public String getModelId() {
        return this.modelId;
    }

    @Generated
    public boolean isRemoveRequest() {
        return this.isRemoveRequest;
    }
}

