/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.opensearch.request.system;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.opensearch.sql.data.model.ExprTupleValue;
import org.opensearch.sql.data.model.ExprValue;
import org.opensearch.sql.data.model.ExprValueUtils;
import org.opensearch.sql.opensearch.client.OpenSearchClient;
import org.opensearch.sql.opensearch.request.system.OpenSearchSystemRequest;

public class OpenSearchCatIndicesRequest
implements OpenSearchSystemRequest {
    private static final String DEFAULT_TABLE_CAT = "opensearch";
    private static final String DEFAULT_TABLE_TAPE = "BASE TABLE";
    private final OpenSearchClient client;

    @Override
    public List<ExprValue> search() {
        ArrayList<ExprValue> results = new ArrayList<ExprValue>();
        Map<String, String> meta = this.client.meta();
        for (String index : this.client.indices()) {
            results.add((ExprValue)this.row(index, this.clusterName(meta)));
        }
        return results;
    }

    private ExprTupleValue row(String indexName, String clusterName) {
        LinkedHashMap<String, ExprValue> valueMap = new LinkedHashMap<String, ExprValue>();
        valueMap.put("TABLE_CAT", ExprValueUtils.stringValue((String)clusterName));
        valueMap.put("TABLE_NAME", ExprValueUtils.stringValue((String)indexName));
        valueMap.put("TABLE_TYPE", ExprValueUtils.stringValue((String)DEFAULT_TABLE_TAPE));
        return new ExprTupleValue(valueMap);
    }

    private String clusterName(Map<String, String> meta) {
        return meta.getOrDefault("CLUSTER_NAME", DEFAULT_TABLE_CAT);
    }

    public String toString() {
        return "OpenSearchCatIndicesRequest{}";
    }

    @Generated
    public OpenSearchCatIndicesRequest(OpenSearchClient client) {
        this.client = client;
    }
}

