info = {
    "name": "el",
    "date_order": "DMY",
    "january": [
        "ιαν",
        "ιανουάριος",
        "ιανουαρίου"
    ],
    "february": [
        "φεβ",
        "φεβρουάριος",
        "φεβρουαρίου"
    ],
    "march": [
        "μάρ",
        "μάρτιος",
        "μαρ",
        "μαρτίου"
    ],
    "april": [
        "απρ",
        "απρίλιος",
        "απριλίου"
    ],
    "may": [
        "μάι",
        "μάιος",
        "μαΐ",
        "μαΐου"
    ],
    "june": [
        "ιουν",
        "ιουνίου",
        "ιούν",
        "ιούνιος"
    ],
    "july": [
        "ιουλ",
        "ιουλίου",
        "ιούλ",
        "ιούλιος"
    ],
    "august": [
        "αυγ",
        "αυγούστου",
        "αύγ",
        "αύγουστος"
    ],
    "september": [
        "σεπ",
        "σεπτέμβριος",
        "σεπτεμβρίου"
    ],
    "october": [
        "οκτ",
        "οκτωβρίου",
        "οκτώβριος"
    ],
    "november": [
        "νοέ",
        "νοέμβριος",
        "νοε",
        "νοεμβρίου"
    ],
    "december": [
        "δεκ",
        "δεκέμβριος",
        "δεκεμβρίου"
    ],
    "monday": [
        "δευ",
        "δευτέρα"
    ],
    "tuesday": [
        "τρί",
        "τρίτη"
    ],
    "wednesday": [
        "τετ",
        "τετάρτη"
    ],
    "thursday": [
        "πέμ",
        "πέμπτη"
    ],
    "friday": [
        "παρ",
        "παρασκευή"
    ],
    "saturday": [
        "σάβ",
        "σάββατο"
    ],
    "sunday": [
        "κυρ",
        "κυριακή"
    ],
    "am": [
        "πμ"
    ],
    "pm": [
        "μμ"
    ],
    "year": [
        "έτ",
        "έτος"
    ],
    "month": [
        "μήν",
        "μήνας"
    ],
    "week": [
        "εβδ",
        "εβδομάδα"
    ],
    "day": [
        "ημέρα"
    ],
    "hour": [
        "ώ",
        "ώρ",
        "ώρα"
    ],
    "minute": [
        "λ",
        "λεπ",
        "λεπτό"
    ],
    "second": [
        "δ",
        "δευτ",
        "δευτερόλεπτο"
    ],
    "relative-type": {
        "0 day ago": [
            "σήμερα"
        ],
        "0 hour ago": [
            "αυτήν την ώρα"
        ],
        "0 minute ago": [
            "αυτό το λεπτό"
        ],
        "0 month ago": [
            "τρέχων μήνας"
        ],
        "0 second ago": [
            "τώρα"
        ],
        "0 week ago": [
            "αυτήν την εβδομάδα"
        ],
        "0 year ago": [
            "φέτος"
        ],
        "1 day ago": [
            "χθες"
        ],
        "1 month ago": [
            "προηγούμενος μήνας"
        ],
        "1 week ago": [
            "προηγούμενη εβδομάδα"
        ],
        "1 year ago": [
            "πέρσι"
        ],
        "in 1 day": [
            "αύριο"
        ],
        "in 1 month": [
            "επόμενος μήνας"
        ],
        "in 1 week": [
            "επόμενη εβδομάδα"
        ],
        "in 1 year": [
            "επόμενο έτος"
        ]
    },
    "relative-type-regex": {
        "\\1 day ago": [
            "(\\d+) ημ πριν",
            "πριν από (\\d+) ημέρα",
            "πριν από (\\d+) ημέρες"
        ],
        "\\1 hour ago": [
            "(\\d+) ώ πριν",
            "πριν από (\\d+) ώρ",
            "πριν από (\\d+) ώρα",
            "πριν από (\\d+) ώρες"
        ],
        "\\1 minute ago": [
            "(\\d+) λ πριν",
            "πριν από (\\d+) λεπ",
            "πριν από (\\d+) λεπτά",
            "πριν από (\\d+) λεπτό"
        ],
        "\\1 month ago": [
            "(\\d+) μ πριν",
            "πριν από (\\d+) μήνα",
            "πριν από (\\d+) μήνες"
        ],
        "\\1 second ago": [
            "(\\d+) δ πριν",
            "πριν από (\\d+) δευτ",
            "πριν από (\\d+) δευτερόλεπτα",
            "πριν από (\\d+) δευτερόλεπτο"
        ],
        "\\1 week ago": [
            "(\\d+) εβδ πριν",
            "πριν από (\\d+) εβδ",
            "πριν από (\\d+) εβδομάδα",
            "πριν από (\\d+) εβδομάδες"
        ],
        "\\1 year ago": [
            "(\\d+) έτη πριν",
            "(\\d+) έτος πριν",
            "πριν από (\\d+) έτη",
            "πριν από (\\d+) έτος"
        ],
        "in \\1 day": [
            "σε (\\d+) ημ",
            "σε (\\d+) ημέρα",
            "σε (\\d+) ημέρες"
        ],
        "in \\1 hour": [
            "σε (\\d+) ώ",
            "σε (\\d+) ώρ",
            "σε (\\d+) ώρα",
            "σε (\\d+) ώρες"
        ],
        "in \\1 minute": [
            "σε (\\d+) λ",
            "σε (\\d+) λεπ",
            "σε (\\d+) λεπτά",
            "σε (\\d+) λεπτό"
        ],
        "in \\1 month": [
            "σε (\\d+) μ",
            "σε (\\d+) μήνα",
            "σε (\\d+) μήνες"
        ],
        "in \\1 second": [
            "σε (\\d+) δ",
            "σε (\\d+) δευτ",
            "σε (\\d+) δευτερόλεπτα",
            "σε (\\d+) δευτερόλεπτο"
        ],
        "in \\1 week": [
            "σε (\\d+) εβδ",
            "σε (\\d+) εβδομάδα",
            "σε (\\d+) εβδομάδες"
        ],
        "in \\1 year": [
            "σε (\\d+) έτη",
            "σε (\\d+) έτος"
        ]
    },
    "locale_specific": {
        "el-CY": {
            "name": "el-CY"
        }
    },
    "skip": [
        " ",
        "'",
        ",",
        "-",
        ".",
        "/",
        ";",
        "@",
        "[",
        "]",
        "|",
        "，"
    ]
}
