{
    This file is part of the Free Pascal run time library.
    Copyright (c) 2005-06 by Thomas Schatzl,
    member of the Free Pascal development team.

    Syscall numbers for 2.6.23

    This file contains the system call numbers.
    See the file COPYING.FPC, included in this distribution,
    for details about the copyright.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

 **********************************************************************}

const
  syscall_nr_exit = 1;
  syscall_nr_fork = 2;
  syscall_nr_read = 3;
  syscall_nr_write = 4;
  syscall_nr_open = 5;
  syscall_nr_close = 6;
  syscall_nr_waitpid = 7;
  syscall_nr_creat = 8;
  syscall_nr_link = 9;
  syscall_nr_unlink = 10;
  syscall_nr_execve = 11;
  syscall_nr_chdir = 12;
  syscall_nr_time = 13;
  syscall_nr_mknod = 14;
  syscall_nr_chmod = 15;
  syscall_nr_lchown = 16;
  syscall_nr_break = 17;
  syscall_nr_oldstat = 18;
  syscall_nr_lseek = 19;
  syscall_nr_getpid = 20;
  syscall_nr_mount = 21;
  syscall_nr_umount = 22;
  syscall_nr_setuid = 23;
  syscall_nr_getuid = 24;
  syscall_nr_stime = 25;
  syscall_nr_ptrace = 26;
  syscall_nr_alarm = 27;
  syscall_nr_oldfstat = 28;
  syscall_nr_pause = 29;
  syscall_nr_utime = 30;
  syscall_nr_stty = 31;
  syscall_nr_gtty = 32;
  syscall_nr_access = 33;
  syscall_nr_nice = 34;
  syscall_nr_ftime = 35;
  syscall_nr_sync = 36;
  syscall_nr_kill = 37;
  syscall_nr_rename = 38;
  syscall_nr_mkdir = 39;
  syscall_nr_rmdir = 40;
  syscall_nr_dup = 41;
  syscall_nr_pipe = 42;
  syscall_nr_times = 43;
  syscall_nr_prof = 44;
  syscall_nr_brk = 45;
  syscall_nr_setgid = 46;
  syscall_nr_getgid = 47;
  syscall_nr_signal = 48;
  syscall_nr_geteuid = 49;
  syscall_nr_getegid = 50;
  syscall_nr_acct = 51;
  syscall_nr_umount2 = 52;
  syscall_nr_lock = 53;
  syscall_nr_ioctl = 54;
  syscall_nr_fcntl = 55;
  syscall_nr_mpx = 56;
  syscall_nr_setpgid = 57;
  syscall_nr_ulimit = 58;
  syscall_nr_oldolduname = 59;
  syscall_nr_umask = 60;
  syscall_nr_chroot = 61;
  syscall_nr_ustat = 62;
  syscall_nr_dup2 = 63;
  syscall_nr_getppid = 64;
  syscall_nr_getpgrp = 65;
  syscall_nr_setsid = 66;
  syscall_nr_sigaction = 67;
  syscall_nr_sgetmask = 68;
  syscall_nr_ssetmask = 69;
  syscall_nr_setreuid = 70;
  syscall_nr_setregid = 71;
  syscall_nr_sigsuspend = 72;
  syscall_nr_sigpending = 73;
  syscall_nr_sethostname = 74;
  syscall_nr_setrlimit = 75;
  syscall_nr_getrlimit = 76;
  syscall_nr_getrusage = 77;
  syscall_nr_gettimeofday = 78;
  syscall_nr_settimeofday = 79;
  syscall_nr_getgroups = 80;
  syscall_nr_setgroups = 81;
  syscall_nr_select = 82;
  syscall_nr_symlink = 83;
  syscall_nr_oldlstat = 84;
  syscall_nr_readlink = 85;
  syscall_nr_uselib = 86;
  syscall_nr_swapon = 87;
  syscall_nr_reboot = 88;
  syscall_nr_readdir = 89;
  syscall_nr_mmap = 90;
  syscall_nr_munmap = 91;
  syscall_nr_truncate = 92;
  syscall_nr_ftruncate = 93;
  syscall_nr_fchmod = 94;
  syscall_nr_fchown = 95;
  syscall_nr_getpriority = 96;
  syscall_nr_setpriority = 97;
  syscall_nr_profil = 98;
  syscall_nr_statfs = 99;
  syscall_nr_fstatfs = 100;
  syscall_nr_ioperm = 101;
  syscall_nr_socketcall = 102;
  syscall_nr_syslog = 103;
  syscall_nr_setitimer = 104;
  syscall_nr_getitimer = 105;
  syscall_nr_stat = 106;
  syscall_nr_lstat = 107;
  syscall_nr_fstat = 108;
  syscall_nr_olduname = 109;
  syscall_nr_iopl = 110;
  syscall_nr_vhangup = 111;
  syscall_nr_idle = 112;
  syscall_nr_vm86 = 113;
  syscall_nr_wait4 = 114;
  syscall_nr_swapoff = 115;
  syscall_nr_sysinfo = 116;
  syscall_nr_ipc = 117;
  syscall_nr_fsync = 118;
  syscall_nr_sigreturn = 119;
  syscall_nr_clone = 120;
  syscall_nr_setdomainname = 121;
  syscall_nr_uname = 122;
  syscall_nr_modify_ldt = 123;
  syscall_nr_adjtimex = 124;
  syscall_nr_mprotect = 125;
  syscall_nr_sigprocmask = 126;
  syscall_nr_create_module = 127;
  syscall_nr_init_module = 128;
  syscall_nr_delete_module = 129;
  syscall_nr_get_kernel_syms = 130;
  syscall_nr_quotactl = 131;
  syscall_nr_getpgid = 132;
  syscall_nr_fchdir = 133;
  syscall_nr_bdflush = 134;
  syscall_nr_sysfs = 135;
  syscall_nr_personality = 136;
  { Syscall for Andrew File System  }
  syscall_nr_afs_syscall = 137;
  syscall_nr_setfsuid = 138;
  syscall_nr_setfsgid = 139;
  syscall_nr__llseek = 140;
  syscall_nr_getdents = 141;
  syscall_nr__newselect = 142;
  syscall_nr_flock = 143;
  syscall_nr_msync = 144;
  syscall_nr_readv = 145;
  syscall_nr_writev = 146;
  syscall_nr_getsid = 147;
  syscall_nr_fdatasync = 148;
  syscall_nr__sysctl = 149;
  syscall_nr_mlock = 150;
  syscall_nr_munlock = 151;
  syscall_nr_mlockall = 152;
  syscall_nr_munlockall = 153;
  syscall_nr_sched_setparam = 154;
  syscall_nr_sched_getparam = 155;
  syscall_nr_sched_setscheduler = 156;
  syscall_nr_sched_getscheduler = 157;
  syscall_nr_sched_yield = 158;
  syscall_nr_sched_get_priority_max = 159;
  syscall_nr_sched_get_priority_min = 160;
  syscall_nr_sched_rr_get_interval = 161;
  syscall_nr_nanosleep = 162;
  syscall_nr_mremap = 163;
  syscall_nr_setresuid = 164;
  syscall_nr_getresuid = 165;
  syscall_nr_query_module = 166;
  syscall_nr_poll = 167;
  syscall_nr_nfsservctl = 168;
  syscall_nr_setresgid = 169;
  syscall_nr_getresgid = 170;
  syscall_nr_prctl = 171;
  syscall_nr_rt_sigreturn = 172;
  syscall_nr_rt_sigaction = 173;
  syscall_nr_rt_sigprocmask = 174;
  syscall_nr_rt_sigpending = 175;
  syscall_nr_rt_sigtimedwait = 176;
  syscall_nr_rt_sigqueueinfo = 177;
  syscall_nr_rt_sigsuspend = 178;
  syscall_nr_pread64 = 179;
  syscall_nr_pwrite64 = 180;
  syscall_nr_chown = 181;
  syscall_nr_getcwd = 182;
  syscall_nr_capget = 183;
  syscall_nr_capset = 184;
  syscall_nr_sigaltstack = 185;
  syscall_nr_sendfile = 186;
  { some people actually want streams  }
  syscall_nr_getpmsg = 187;
  { some people actually want streams  }
  syscall_nr_putpmsg = 188;
  syscall_nr_vfork = 189;
  { SuS compliant getrlimit  }
  syscall_nr_ugetrlimit = 190;
  syscall_nr_readahead = 191;
{$ifdef cpu32}
  syscall_nr_mmap2 = 192;
  syscall_nr_truncate64 = 193;
  syscall_nr_ftruncate64 = 194;
  syscall_nr_stat64 = 195;
  syscall_nr_lstat64 = 196;
  syscall_nr_fstat64 = 197;
{$endif}
  syscall_nr_pciconfig_read = 198;
  syscall_nr_pciconfig_write = 199;
  syscall_nr_pciconfig_iobase = 200;
  syscall_nr_multiplexer = 201;
  syscall_nr_getdents64 = 202;
  syscall_nr_pivot_root = 203;
{$ifdef cpu32}
  syscall_nr_fcntl64 = 204;
{$endif}
  syscall_nr_madvise = 205;
  syscall_nr_mincore = 206;
  syscall_nr_gettid = 207;
  syscall_nr_tkill = 208;
  syscall_nr_setxattr = 209;
  syscall_nr_lsetxattr = 210;
  syscall_nr_fsetxattr = 211;
  syscall_nr_getxattr = 212;
  syscall_nr_lgetxattr = 213;
  syscall_nr_fgetxattr = 214;
  syscall_nr_listxattr = 215;
  syscall_nr_llistxattr = 216;
  syscall_nr_flistxattr = 217;
  syscall_nr_removexattr = 218;
  syscall_nr_lremovexattr = 219;
  syscall_nr_fremovexattr = 220;
  syscall_nr_futex = 221;
  syscall_nr_sched_setaffinity = 222;
  syscall_nr_sched_getaffinity = 223;
  { 224 currently unused  }
  syscall_nr_tuxcall = 225;
{$ifdef cpu32}
  syscall_nr_sendfile64 = 226;
{$endif}
  syscall_nr_io_setup = 227;
  syscall_nr_io_destroy = 228;
  syscall_nr_io_getevents = 229;
  syscall_nr_io_submit = 230;
  syscall_nr_io_cancel = 231;
  syscall_nr_set_tid_address = 232;
  syscall_nr_fadvise64 = 233;
  syscall_nr_exit_group = 234;
  syscall_nr_lookup_dcookie = 235;
  syscall_nr_epoll_create = 236;
  syscall_nr_epoll_ctl = 237;
  syscall_nr_epoll_wait = 238;
  syscall_nr_remap_file_pages = 239;
  syscall_nr_timer_create = 240;
  syscall_nr_timer_settime = 241;
  syscall_nr_timer_gettime = 242;
  syscall_nr_timer_getoverrun = 243;
  syscall_nr_timer_delete = 244;
  syscall_nr_clock_settime = 245;
  syscall_nr_clock_gettime = 246;
  syscall_nr_clock_getres = 247;
  syscall_nr_clock_nanosleep = 248;
  syscall_nr_swapcontext = 249;
  syscall_nr_tgkill = 250;
  syscall_nr_utimes = 251;
  syscall_nr_statfs64 = 252;
  syscall_nr_fstatfs64 = 253;
{$ifdef cpu32}
  syscall_nr_fadvise64_64 = 254;
{$endif}
  syscall_nr_rtas = 255;
  syscall_nr_mq_open = 262;
  syscall_nr_mq_unlink = 263;
  syscall_nr_mq_timedsend = 264;
  syscall_nr_mq_timedreceive = 265;
  syscall_nr_mq_notify = 266;
  syscall_nr_mq_getsetattr = 267;
  syscall_nr_kexec_load = 268;
  syscall_nr_add_key = 269;
  syscall_nr_request_key = 270;
  syscall_nr_keyctl = 271;
  syscall_nr_waitid = 272;
  syscall_nr_ioprio_set = 273;
  syscall_nr_ioprio_get = 274;
  syscall_nr_inotify_init = 275;
  syscall_nr_inotify_add_watch = 276;
  syscall_nr_inotify_rm_watch = 277;
  syscall_nr_spu_run          = 278;
  syscall_nr_spu_create       = 278;
  syscall_nr_pselect6         = 289;
  syscall_nr_ppoll            = 281;
  syscall_nr_unshare          = 282;
  syscall_nr_splice           = 283;
  syscall_nr_tee              = 284;
  syscall_nr_vmsplice         = 285;
  syscall_nr_openat           = 286;
  syscall_nr_mkdirat          = 287;
  syscall_nr_mknodat          = 288;
  syscall_nr_fchownat         = 289;
  syscall_nr_futimesat        = 290;
  syscall_nr_sys_fstatat64    = 291;
  syscall_nr_unlinkat         = 292;
  syscall_nr_renameat         = 293;
  syscall_nr_linkat           = 294;
  syscall_nr_symlinkat        = 295;
  syscall_nr_readlinkat       = 296;
  syscall_nr_fchmodat         = 297;
  syscall_nr_faccessat        = 298;
  syscall_nr_get_robust_list  = 299;
  syscall_nr_set_robust_list  = 300;
  syscall_nr_move_pages       = 301;
  syscall_nr_getcpu           = 302;
  syscall_nr_epoll_pwait      = 303;
  syscall_nr_utimensat        = 304;
  syscall_nr_fallocate        = 305;
  syscall_nr_signalfd         = 306;
  syscall_nr_timerfd          = 307;
  syscall_nr_eventfd          = 308;
  syscall_nr_sync_file_range2 = 309;
