/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.common.conversation;

import java.io.IOException;
import java.time.Instant;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import org.opensearch.Version;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.ml.common.CommonValue;
import org.opensearch.search.SearchHit;

public class ConversationMeta
implements Writeable,
ToXContentObject {
    public static final Version MINIMAL_SUPPORTED_VERSION_FOR_ADDITIONAL_INFO = CommonValue.VERSION_2_17_0;
    private String id;
    private Instant createdTime;
    private Instant updatedTime;
    private String name;
    private String user;
    private Map<String, String> additionalInfos;

    public static ConversationMeta fromSearchHit(SearchHit hit) {
        String id = hit.getId();
        return ConversationMeta.fromMap(id, hit.getSourceAsMap());
    }

    public static ConversationMeta fromMap(String id, Map<String, Object> docFields) {
        Instant created = Instant.parse((String)docFields.get("create_time"));
        Instant updated = Instant.parse((String)docFields.get("updated_time"));
        String name = (String)docFields.get("name");
        String user = (String)docFields.get("user");
        Map additionalInfos = (Map)docFields.get("additional_info");
        return new ConversationMeta(id, created, updated, name, user, additionalInfos);
    }

    public static ConversationMeta fromStream(StreamInput in) throws IOException {
        String id = in.readString();
        Instant created = in.readInstant();
        Instant updated = in.readInstant();
        String name = in.readString();
        String user = in.readOptionalString();
        Map additionalInfos = null;
        if (in.getVersion().onOrAfter(MINIMAL_SUPPORTED_VERSION_FOR_ADDITIONAL_INFO) && in.readBoolean()) {
            additionalInfos = in.readMap(StreamInput::readString, StreamInput::readString);
        }
        return new ConversationMeta(id, created, updated, name, user, additionalInfos);
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.id);
        out.writeInstant(this.createdTime);
        out.writeInstant(this.updatedTime);
        out.writeString(this.name);
        out.writeOptionalString(this.user);
        if (out.getVersion().onOrAfter(MINIMAL_SUPPORTED_VERSION_FOR_ADDITIONAL_INFO)) {
            if (this.additionalInfos == null) {
                out.writeBoolean(false);
            } else {
                out.writeBoolean(true);
                out.writeMap(this.additionalInfos, StreamOutput::writeString, StreamOutput::writeString);
            }
        }
    }

    public String toString() {
        return "{id=" + this.id + ", name=" + this.name + ", created=" + this.createdTime.toString() + ", updated=" + this.updatedTime.toString() + ", user=" + this.user + "}";
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("memory_id", this.id);
        builder.field("create_time", (Object)this.createdTime);
        builder.field("updated_time", (Object)this.updatedTime);
        builder.field("name", this.name);
        if (this.user != null) {
            builder.field("user", this.user);
        }
        if (this.additionalInfos != null) {
            builder.field("additional_info", this.additionalInfos);
        }
        builder.endObject();
        return builder;
    }

    public boolean equals(Object other) {
        if (!(other instanceof ConversationMeta)) {
            return false;
        }
        ConversationMeta otherConversation = (ConversationMeta)other;
        return Objects.equals(this.id, otherConversation.id) && Objects.equals(this.user, otherConversation.user) && Objects.equals(this.createdTime, otherConversation.createdTime) && Objects.equals(this.updatedTime, otherConversation.updatedTime) && Objects.equals(this.name, otherConversation.name);
    }

    @Generated
    public ConversationMeta(String id, Instant createdTime, Instant updatedTime, String name, String user, Map<String, String> additionalInfos) {
        this.id = id;
        this.createdTime = createdTime;
        this.updatedTime = updatedTime;
        this.name = name;
        this.user = user;
        this.additionalInfos = additionalInfos;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public Instant getCreatedTime() {
        return this.createdTime;
    }

    @Generated
    public Instant getUpdatedTime() {
        return this.updatedTime;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getUser() {
        return this.user;
    }

    @Generated
    public Map<String, String> getAdditionalInfos() {
        return this.additionalInfos;
    }
}

