/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function.compress;

import java.awt.Component;
import java.awt.event.ActionListener;
import tim.prune.data.DataPoint;
import tim.prune.data.Track;
import tim.prune.function.compress.SingleParameterAlgorithm;
import tim.prune.function.compress.TrackDetails;
import tim.prune.function.compress.XYpoint;

public class DouglasPeuckerAlgorithm
extends SingleParameterAlgorithm {
    public DouglasPeuckerAlgorithm(Track track, TrackDetails trackDetails, ActionListener actionListener) {
        super(track, trackDetails, actionListener);
    }

    @Override
    protected int compress(boolean[] blArray) {
        double d = this.getParameter();
        if (d > 1.0) {
            d = 1.0 / d;
        }
        if (d <= 0.0 || d >= 1.0) {
            return 0;
        }
        double d2 = this._trackDetails.getTrackSpan() * d;
        int n = this._track.getNumPoints();
        int n2 = DouglasPeuckerAlgorithm.countFlags(blArray);
        int[] nArray = new int[n];
        int n3 = -1;
        int n4 = -1;
        int n5 = 0;
        while (n5 < n) {
            DataPoint dataPoint = this._track.getPoint(n5);
            if (dataPoint.getSegmentStart() && n3 > -1 && n4 > n3) {
                nArray[n4] = 1;
                this.compressSegment(nArray, n3, n4, d2);
                n4 = -1;
                n3 = -1;
            }
            if (blArray[n5]) {
                nArray[n5] = -1;
            } else if (dataPoint.isWaypoint() || dataPoint.hasMedia() || dataPoint.getSegmentStart()) {
                nArray[n5] = 1;
            }
            if (!blArray[n5] && !dataPoint.isWaypoint()) {
                if (n3 < 0) {
                    n3 = n5;
                } else {
                    n4 = n5;
                }
            }
            ++n5;
        }
        if (n3 >= 0 && n4 > n3) {
            nArray[n4] = 1;
            this.compressSegment(nArray, n3, n4, d2);
        }
        n5 = 1;
        while (n5 < n) {
            if (nArray[n5] < 1) {
                blArray[n5] = true;
            }
            ++n5;
        }
        return DouglasPeuckerAlgorithm.countFlags(blArray) - n2;
    }

    private static int countFlags(boolean[] blArray) {
        int n = 0;
        int n2 = 0;
        while (n2 < blArray.length) {
            if (blArray[n2]) {
                ++n;
            }
            ++n2;
        }
        return n;
    }

    private void compressSegment(int[] nArray, int n, int n2, double d) {
        int n3 = n2 - n + 1;
        if (n3 < 3) {
            return;
        }
        XYpoint xYpoint = new XYpoint(this._track.getX(n), this._track.getY(n));
        XYpoint xYpoint2 = new XYpoint(this._track.getX(n2), this._track.getY(n2));
        XYpoint xYpoint3 = xYpoint.vectorTo(xYpoint2);
        double d2 = xYpoint3.len2();
        double d3 = xYpoint3.len();
        XYpoint xYpoint4 = new XYpoint(xYpoint3.y / d3, -xYpoint3.x / d3);
        if (d3 <= 0.0) {
            int n4 = this.getFurthestPointIndex(n, n2);
            if (n4 > n) {
                this.compressSegment(nArray, n, n4, d);
                this.compressSegment(nArray, n4, n2, d);
            }
            return;
        }
        double d4 = -1.0;
        double d5 = -1.0;
        int n5 = -1;
        int n6 = n + 1;
        while (n6 < n2) {
            XYpoint xYpoint5;
            XYpoint xYpoint6;
            double d6;
            if (nArray[n6] == 0 && (d5 = (d6 = xYpoint3.dot(xYpoint6 = xYpoint.vectorTo(xYpoint5 = new XYpoint(this._track.getX(n6), this._track.getY(n6)))) / d2) < 0.0 ? xYpoint6.len() : (d6 > 1.0 ? xYpoint2.vectorTo(xYpoint5).len() : Math.abs(xYpoint4.dot(xYpoint6)))) > d4) {
                d4 = d5;
                n5 = n6;
            }
            ++n6;
        }
        if (d4 > d) {
            nArray[n5] = 1;
            this.compressSegment(nArray, n, n5, d);
            this.compressSegment(nArray, n5, n2, d);
        }
    }

    @Override
    protected Component getSpecificGuiComponents() {
        return this.getSpecificGuiComponents("dialog.compress.douglaspeucker.paramdesc", "2000");
    }

    @Override
    protected String getTitleTextKey() {
        return "dialog.compress.douglaspeucker.title";
    }

    private int getFurthestPointIndex(int n, int n2) {
        int n3 = -1;
        if (n >= 0 && n2 > n) {
            DataPoint dataPoint = this._track.getPoint(n);
            double d = 0.0;
            int n4 = n + 1;
            while (n4 < n2) {
                double d2;
                DataPoint dataPoint2 = this._track.getPoint(n4);
                if (!dataPoint2.isWaypoint() && (d2 = DataPoint.calculateRadiansBetween(dataPoint, dataPoint2)) > d) {
                    n3 = n4;
                    d = d2;
                }
                ++n4;
            }
        }
        return n3;
    }
}

