/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.objectdiagram.command;

import net.sourceforge.plantuml.abel.Entity;
import net.sourceforge.plantuml.abel.LeafType;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.CommandMultilines2;
import net.sourceforge.plantuml.command.MultilinesStrategy;
import net.sourceforge.plantuml.command.Trim;
import net.sourceforge.plantuml.klimt.color.ColorParser;
import net.sourceforge.plantuml.klimt.color.ColorType;
import net.sourceforge.plantuml.klimt.color.NoSuchColorException;
import net.sourceforge.plantuml.klimt.creole.CreoleMode;
import net.sourceforge.plantuml.klimt.creole.Display;
import net.sourceforge.plantuml.klimt.font.FontParam;
import net.sourceforge.plantuml.objectdiagram.AbstractClassOrObjectDiagram;
import net.sourceforge.plantuml.plasma.Quark;
import net.sourceforge.plantuml.regex.IRegex;
import net.sourceforge.plantuml.regex.RegexConcat;
import net.sourceforge.plantuml.regex.RegexLeaf;
import net.sourceforge.plantuml.regex.RegexResult;
import net.sourceforge.plantuml.skin.VisibilityModifier;
import net.sourceforge.plantuml.stereo.Stereotype;
import net.sourceforge.plantuml.stereo.StereotypePattern;
import net.sourceforge.plantuml.text.StringLocated;
import net.sourceforge.plantuml.url.UrlBuilder;
import net.sourceforge.plantuml.utils.BlocLines;

public class CommandCreateEntityObjectMultilines
extends CommandMultilines2<AbstractClassOrObjectDiagram> {
    public CommandCreateEntityObjectMultilines() {
        super(CommandCreateEntityObjectMultilines.getRegexConcat(), MultilinesStrategy.REMOVE_STARTING_QUOTE, Trim.BOTH);
    }

    private static IRegex getRegexConcat() {
        return RegexConcat.build(CommandCreateEntityObjectMultilines.class.getName(), RegexLeaf.start(), new RegexLeaf("TYPE", "object"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("NAME", "(?:[%g]([^%g]+)[%g][%s]+as[%s]+)?([%pLN_.]+)"), StereotypePattern.optional("STEREO"), UrlBuilder.OPTIONAL, RegexLeaf.spaceZeroOrMore(), ColorParser.exp1(), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("\\{"), RegexLeaf.end());
    }

    @Override
    public String getPatternEnd() {
        return "^[%s]*\\}[%s]*$";
    }

    @Override
    protected CommandExecutionResult executeNow(AbstractClassOrObjectDiagram diagram, BlocLines lines) throws NoSuchColorException {
        lines = lines.trim().removeEmptyLines();
        RegexResult line0 = this.getStartingPattern().matcher(lines.getFirst().getTrimmed().getString());
        Entity entity = this.executeArg0(diagram, line0);
        if (entity == null) {
            return CommandExecutionResult.error("No such entity");
        }
        lines = lines.subExtract(1, 1);
        for (StringLocated s2 : lines) {
            assert (s2.getString().length() > 0);
            if (VisibilityModifier.isVisibilityCharacter(s2.getString())) {
                diagram.setVisibilityModifierPresent(true);
            }
            entity.getBodier().addFieldOrMethod(s2.getString());
        }
        return CommandExecutionResult.ok();
    }

    private Entity executeArg0(AbstractClassOrObjectDiagram diagram, RegexResult line0) throws NoSuchColorException {
        String s2;
        Entity entity;
        String name = line0.get("NAME", 1);
        Quark<Entity> quark = diagram.quarkInContext(true, diagram.cleanId(name));
        String displayString = line0.get("NAME", 0);
        String stereotype = line0.get("STEREO", 0);
        Display display = Display.getWithNewlines(displayString);
        if (Display.isNull(display)) {
            display = Display.getWithNewlines(name).withCreoleMode(CreoleMode.SIMPLE_LINE);
        }
        if ((entity = quark.getData()) == null) {
            entity = diagram.reallyCreateLeaf(quark, display, LeafType.OBJECT, null);
        }
        if (stereotype != null) {
            entity.setStereotype(Stereotype.build(stereotype, diagram.getSkinParam().getCircledCharacterRadius(), diagram.getSkinParam().getFont(null, false, FontParam.CIRCLED_CHARACTER), diagram.getSkinParam().getIHtmlColorSet()));
        }
        entity.setSpecificColorTOBEREMOVED(ColorType.BACK, (s2 = line0.get("COLOR", 0)) == null ? null : diagram.getSkinParam().getIHtmlColorSet().getColor(s2));
        return entity;
    }
}

