/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.descriptor.web;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.tomcat.util.descriptor.web.ResourceBase;

public class ContextHandler
extends ResourceBase {
    private static final long serialVersionUID = 1L;
    private String handlerclass = null;
    private final HashMap<String, String> soapHeaders = new HashMap();
    private final ArrayList<String> soapRoles = new ArrayList();
    private final ArrayList<String> portNames = new ArrayList();

    public String getHandlerclass() {
        return this.handlerclass;
    }

    public void setHandlerclass(String string) {
        this.handlerclass = string;
    }

    public Iterator<String> getLocalparts() {
        return this.soapHeaders.keySet().iterator();
    }

    public String getNamespaceuri(String string) {
        return this.soapHeaders.get(string);
    }

    public void addSoapHeaders(String string, String string2) {
        this.soapHeaders.put(string, string2);
    }

    public void setProperty(String string, String string2) {
        this.setProperty(string, (Object)string2);
    }

    public String getSoapRole(int n) {
        return this.soapRoles.get(n);
    }

    public int getSoapRolesSize() {
        return this.soapRoles.size();
    }

    public void addSoapRole(String string) {
        this.soapRoles.add(string);
    }

    public String getPortName(int n) {
        return this.portNames.get(n);
    }

    public int getPortNamesSize() {
        return this.portNames.size();
    }

    public void addPortName(String string) {
        this.portNames.add(string);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("ContextHandler[");
        stringBuilder.append("name=");
        stringBuilder.append(this.getName());
        if (this.handlerclass != null) {
            stringBuilder.append(", class=");
            stringBuilder.append(this.handlerclass);
        }
        if (this.soapHeaders != null) {
            stringBuilder.append(", soap-headers=");
            stringBuilder.append(this.soapHeaders);
        }
        if (this.getSoapRolesSize() > 0) {
            stringBuilder.append(", soap-roles=");
            stringBuilder.append(this.soapRoles);
        }
        if (this.getPortNamesSize() > 0) {
            stringBuilder.append(", port-name=");
            stringBuilder.append(this.portNames);
        }
        if (this.listProperties() != null) {
            stringBuilder.append(", init-param=");
            stringBuilder.append(this.listProperties());
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    @Override
    public int hashCode() {
        int n = super.hashCode();
        n = 31 * n + (this.handlerclass == null ? 0 : this.handlerclass.hashCode());
        n = 31 * n + (this.portNames == null ? 0 : this.portNames.hashCode());
        n = 31 * n + (this.soapHeaders == null ? 0 : this.soapHeaders.hashCode());
        n = 31 * n + (this.soapRoles == null ? 0 : this.soapRoles.hashCode());
        return n;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ContextHandler contextHandler = (ContextHandler)object;
        if (this.handlerclass == null ? contextHandler.handlerclass != null : !this.handlerclass.equals(contextHandler.handlerclass)) {
            return false;
        }
        if (this.portNames == null ? contextHandler.portNames != null : !this.portNames.equals(contextHandler.portNames)) {
            return false;
        }
        if (this.soapHeaders == null ? contextHandler.soapHeaders != null : !this.soapHeaders.equals(contextHandler.soapHeaders)) {
            return false;
        }
        return !(this.soapRoles == null ? contextHandler.soapRoles != null : !this.soapRoles.equals(contextHandler.soapRoles));
    }
}

