/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.sendopts;

import java.util.HashSet;
import java.util.Set;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.netbeans.modules.sendopts.DefaultProcessor;
import org.netbeans.spi.sendopts.Arg;
import org.netbeans.spi.sendopts.Description;
import org.netbeans.spi.sendopts.OptionProcessor;
import org.openide.filesystems.annotations.LayerBuilder;
import org.openide.filesystems.annotations.LayerGeneratingProcessor;
import org.openide.filesystems.annotations.LayerGenerationException;

final class OptionAnnotationProcessorImpl
extends LayerGeneratingProcessor {
    OptionAnnotationProcessorImpl() {
    }

    public Set<String> getSupportedAnnotationTypes() {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add(Arg.class.getName());
        return hashSet;
    }

    protected boolean handleProcess(Set<? extends TypeElement> set, RoundEnvironment roundEnvironment) throws LayerGenerationException {
        PrimitiveType primitiveType = this.processingEnv.getTypeUtils().getPrimitiveType(TypeKind.BOOLEAN);
        TypeMirror typeMirror = this.processingEnv.getElementUtils().getTypeElement("java.lang.String").asType();
        ArrayType arrayType = this.processingEnv.getTypeUtils().getArrayType(typeMirror);
        HashSet hashSet = new HashSet();
        for (Element element : roundEnvironment.getElementsAnnotatedWith(Arg.class)) {
            if (element.getModifiers().contains((Object)Modifier.STATIC)) {
                throw new LayerGenerationException("@Arg can be applied only to non-static fields", element);
            }
            if (!element.getModifiers().contains((Object)Modifier.PUBLIC)) {
                throw new LayerGenerationException("@Arg can be applied only to public fields", element);
            }
            if (element.getModifiers().contains((Object)Modifier.FINAL)) {
                throw new LayerGenerationException("@Arg can be applied only to non-final fields", element);
            }
            Arg arg = element.getAnnotation(Arg.class);
            if (arg.longName().isEmpty() && arg.shortName() == '\uffff') {
                throw new LayerGenerationException("At least one of longName or shortName attributes needs to be non-empty", element);
            }
            if (arg.implicit() && !element.asType().equals(arrayType)) {
                throw new LayerGenerationException("implicit @Arg can only be applied to String[] fields", element);
            }
            hashSet.add(TypeElement.class.cast(element.getEnclosingElement()));
        }
        for (TypeElement typeElement : hashSet) {
            int n = 1;
            String string = this.processingEnv.getElementUtils().getBinaryName(typeElement).toString().replace('.', '-');
            LayerBuilder.File file = this.layer(new Element[]{typeElement}).file("Services/OptionProcessors/" + string + ".instance");
            file.methodvalue("instanceCreate", DefaultProcessor.class.getName(), "create");
            file.stringvalue("instanceOf", OptionProcessor.class.getName());
            file.stringvalue("class", this.processingEnv.getElementUtils().getBinaryName(typeElement).toString());
            for (Element element : typeElement.getEnclosedElements()) {
                Arg arg = element.getAnnotation(Arg.class);
                if (arg == null) continue;
                Description description = element.getAnnotation(Description.class);
                if (arg.shortName() != '\uffff') {
                    file.charvalue(n + ".shortName", arg.shortName());
                }
                if (!arg.longName().isEmpty()) {
                    file.stringvalue(n + ".longName", arg.longName());
                }
                if (primitiveType == element.asType()) {
                    file.stringvalue(n + ".type", "withoutArgument");
                } else if (typeMirror == element.asType()) {
                    if (arg.defaultValue().equals("\u0000")) {
                        file.stringvalue(n + ".type", "requiredArgument");
                    } else {
                        file.stringvalue(n + ".type", "optionalArgument");
                    }
                } else {
                    if (!arrayType.equals(element.asType())) {
                        throw new LayerGenerationException("Field type has to be either boolean, String or String[]!", element);
                    }
                    file.stringvalue(n + ".type", "additionalArguments");
                }
                if (arg.implicit()) {
                    file.boolvalue(n + ".implicit", true);
                }
                if (description != null) {
                    this.writeBundle(file, n + ".displayName", description.displayName(), element);
                    this.writeBundle(file, n + ".shortDescription", description.shortDescription(), element);
                }
                ++n;
            }
            file.write();
        }
        return true;
    }

    private void writeBundle(LayerBuilder.File file, String string, String string2, Element element) throws LayerGenerationException {
        if (string2.isEmpty()) {
            return;
        }
        this.layer(new Element[]{element}).file("dummy/file").bundlevalue(string, string2);
        if (string2.startsWith("#")) {
            Element element2;
            for (element2 = element; element2 != null && element2.getKind() != ElementKind.PACKAGE; element2 = element2.getEnclosingElement()) {
            }
            if (element2 == null) {
                throw new LayerGenerationException("No reference element to determine package in '" + string2 + "'", element);
            }
            string2 = ((PackageElement)element2).getQualifiedName() + ".Bundle" + string2;
        }
        file.stringvalue(string, string2);
    }
}

