/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.presentations.mindmapmode;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.presentations.mindmapmode.CollectionChangeListener;
import org.freeplane.features.presentations.mindmapmode.CollectionChangedEvent;
import org.freeplane.features.presentations.mindmapmode.NamedElement;
import org.freeplane.features.presentations.mindmapmode.NamedElementFactory;
import org.freeplane.features.presentations.mindmapmode.Stringifyed;

public class NamedElementCollection<T extends NamedElement<T>>
implements Iterable<T> {
    private final DefaultComboBoxModel<Stringifyed<T>> elements;
    private int currentIndex;
    private ArrayList<CollectionChangeListener<T>> collectionChangeListeners;
    private boolean moveInProgress;
    private NamedElementFactory<T> factory;

    public NamedElementCollection(NamedElementFactory<T> factory) {
        this.factory = factory;
        this.elements = new DefaultComboBoxModel();
        this.elements.addListDataListener(new ListDataListener(){

            @Override
            public void intervalRemoved(ListDataEvent e) {
            }

            @Override
            public void intervalAdded(ListDataEvent e) {
            }

            @Override
            public void contentsChanged(ListDataEvent e) {
                int newIndex;
                int index = e.getIndex0();
                if (index == -1 && e.getIndex1() == index && !NamedElementCollection.this.moveInProgress && (newIndex = NamedElementCollection.this.elements.getIndexOf(NamedElementCollection.this.elements.getSelectedItem())) != -1) {
                    NamedElementCollection.this.currentIndex = newIndex;
                    NamedElementCollection.this.fireCollectionChangeEvent(CollectionChangedEvent.EventType.SELECTION_INDEX_CHANGED);
                    NamedElementCollection.this.fireCollectionChangeEvent(CollectionChangedEvent.EventType.SELECTION_CHANGED);
                }
            }
        });
        this.currentIndex = -1;
        this.collectionChangeListeners = new ArrayList();
    }

    public ComboBoxModel<Stringifyed<T>> getElements() {
        return this.elements;
    }

    public void add(String name) {
        T currentElement = this.getCurrentElement();
        T newInstance = currentElement != null ? this.factory.create(currentElement, name) : this.factory.create(name);
        this.add(newInstance);
    }

    public void add(T element) {
        int newElementIndex = this.currentIndex + 1;
        Stringifyed<T> anObject = new Stringifyed<T>(element);
        this.elements.insertElementAt(anObject, newElementIndex);
        this.elements.setSelectedItem(anObject);
        this.selectCurrentElement(newElementIndex);
        this.fireCollectionChangeEvent(CollectionChangedEvent.EventType.COLLECTION_SIZE_CHANGED);
    }

    public void removeCurrentElement() {
        if (this.currentIndex >= 0) {
            this.elements.removeElementAt(this.currentIndex);
            this.selectCurrentElement(Math.min(this.currentIndex, this.elements.getSize() - 1));
            this.fireCollectionChangeEvent(CollectionChangedEvent.EventType.COLLECTION_SIZE_CHANGED);
        }
    }

    public void selectCurrentElement(int index) {
        if (this.currentIndex != index) {
            Stringifyed<T> newSelecteditem;
            this.currentIndex = index;
            Stringifyed<T> stringifyed = newSelecteditem = index == -1 ? null : this.elements.getElementAt(index);
            if (newSelecteditem != this.elements.getSelectedItem()) {
                this.elements.setSelectedItem(newSelecteditem);
            } else {
                this.fireCollectionChangeEvent(CollectionChangedEvent.EventType.SELECTION_INDEX_CHANGED);
                this.fireCollectionChangeEvent(CollectionChangedEvent.EventType.SELECTION_CHANGED);
            }
        }
    }

    private void fireCollectionChangeEvent(CollectionChangedEvent.EventType eventType) {
        for (CollectionChangeListener selectionChangeListener : this.collectionChangeListeners) {
            selectionChangeListener.onCollectionChange(eventType.of(this));
        }
    }

    public int getSize() {
        return this.elements.getSize();
    }

    public T getCurrentElement() {
        return this.currentIndex >= 0 ? (T)this.elements.getElementAt((int)this.currentIndex).element : null;
    }

    public void moveCurrentElementUp() {
        this.moveCurrentElementTo(this.currentIndex - 1);
    }

    public void moveCurrentElementDown() {
        this.moveCurrentElementTo(this.currentIndex + 1);
    }

    public void moveCurrentElementTo(int newElementIndex) {
        if (this.canMoveCurrentElementTo(newElementIndex)) {
            Stringifyed<T> currentElement = this.elements.getElementAt(this.currentIndex);
            this.moveInProgress = true;
            try {
                this.elements.removeElementAt(this.currentIndex);
                this.elements.insertElementAt(currentElement, newElementIndex);
                this.currentIndex = newElementIndex;
                this.elements.setSelectedItem(currentElement);
            }
            finally {
                this.moveInProgress = false;
            }
            this.fireCollectionChangeEvent(CollectionChangedEvent.EventType.SELECTION_INDEX_CHANGED);
        }
    }

    public boolean canMoveCurrentElementTo(int newElementIndex) {
        return newElementIndex >= 0 && newElementIndex < this.getSize() && newElementIndex != this.currentIndex;
    }

    public void addCollectionChangeListener(CollectionChangeListener<T> selectionChangeListener) {
        this.collectionChangeListeners.add(selectionChangeListener);
    }

    public void removeCollectionChangeListener(CollectionChangeListener<T> selectionChangeListener) {
        this.collectionChangeListeners.remove(selectionChangeListener);
    }

    public int getCurrentElementIndex() {
        return this.currentIndex;
    }

    public T getElement(int i) {
        return this.elements.getElementAt((int)i).element;
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            private int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < NamedElementCollection.this.getSize();
            }

            @Override
            public T next() {
                if (this.hasNext()) {
                    return NamedElementCollection.this.getElement(this.index++);
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("remove");
            }
        };
    }

    public void copyCurrentElement() {
        T currentElement = this.getCurrentElement();
        String newName = TextUtils.format((String)"copy_name", (Object[])new Object[]{currentElement.getName()});
        Object newInstance = currentElement.saveAs(newName);
        this.add(newInstance);
    }
}

