/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.prometheus.storage;

import java.io.IOException;
import java.security.AccessController;
import java.util.Iterator;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.JSONObject;
import org.opensearch.sql.data.model.ExprValue;
import org.opensearch.sql.prometheus.client.PrometheusClient;
import org.opensearch.sql.prometheus.request.PrometheusQueryRequest;
import org.opensearch.sql.prometheus.response.PrometheusResponse;
import org.opensearch.sql.prometheus.storage.model.PrometheusResponseFieldNames;
import org.opensearch.sql.storage.TableScanOperator;

public class PrometheusMetricScan
extends TableScanOperator {
    private final PrometheusClient prometheusClient;
    private PrometheusQueryRequest request;
    private Iterator<ExprValue> iterator;
    private PrometheusResponseFieldNames prometheusResponseFieldNames;
    private static final Logger LOG = LogManager.getLogger();

    public PrometheusMetricScan(PrometheusClient prometheusClient) {
        this.prometheusClient = prometheusClient;
        this.request = new PrometheusQueryRequest();
        this.prometheusResponseFieldNames = new PrometheusResponseFieldNames();
    }

    public void open() {
        super.open();
        this.iterator = AccessController.doPrivileged(() -> {
            try {
                JSONObject responseObject = this.prometheusClient.queryRange(this.request.getPromQl(), this.request.getStartTime(), this.request.getEndTime(), this.request.getStep());
                return new PrometheusResponse(responseObject, this.prometheusResponseFieldNames).iterator();
            }
            catch (IOException e) {
                LOG.error(e.getMessage());
                throw new RuntimeException("Error fetching data from prometheus server. " + e.getMessage());
            }
        });
    }

    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    public ExprValue next() {
        return this.iterator.next();
    }

    public String explain() {
        return this.getRequest().toString();
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PrometheusMetricScan)) {
            return false;
        }
        PrometheusMetricScan other = (PrometheusMetricScan)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        PrometheusQueryRequest this$request = this.getRequest();
        PrometheusQueryRequest other$request = other.getRequest();
        return !(this$request == null ? other$request != null : !((Object)this$request).equals(other$request));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PrometheusMetricScan;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        PrometheusQueryRequest $request = this.getRequest();
        result = result * 59 + ($request == null ? 43 : ((Object)$request).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "PrometheusMetricScan(request=" + this.getRequest() + ")";
    }

    @Generated
    public PrometheusQueryRequest getRequest() {
        return this.request;
    }

    @Generated
    public void setRequest(PrometheusQueryRequest request) {
        this.request = request;
    }

    @Generated
    public void setPrometheusResponseFieldNames(PrometheusResponseFieldNames prometheusResponseFieldNames) {
        this.prometheusResponseFieldNames = prometheusResponseFieldNames;
    }
}

