/*
 * Decompiled with CFR 0.152.
 */
package org.coode.mdock;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.plaf.TabbedPaneUI;
import org.coode.mdock.Node;
import org.coode.mdock.NodeComponent;
import org.coode.mdock.NodeVisitor;
import org.coode.mdock.UIComponentFactory;

public class ComponentNode
extends Node {
    private final JTabbedPane tabbedPane;
    private final List<JComponent> components;
    private final Map<JComponent, String> component2LabelMap;
    private final JComponent baseComponent = new JPanel(new BorderLayout()){

        @Override
        public void remove(Component comp) {
            ComponentNode.this.remove((JComponent)comp);
        }

        @Override
        public void remove(int index) {
            super.remove(index);
        }

        @Override
        public void removeAll() {
            super.removeAll();
        }
    };

    public ComponentNode() {
        this.components = new ArrayList<JComponent>();
        this.component2LabelMap = new HashMap<JComponent, String>();
        TabbedPaneUI tabbedPaneUI = UIComponentFactory.getInstance().createComponentNodeTabbedPaneUI();
        this.tabbedPane = new JTabbedPane(){

            @Override
            public void remove(Component component) {
                ComponentNode.this.remove((JComponent)component);
            }
        };
        this.tabbedPane.setUI(tabbedPaneUI);
        this.baseComponent.setBorder(UIComponentFactory.getInstance().createComponentNodeBorder());
    }

    public void add(JComponent component, String label) {
        this.components.add(component);
        this.component2LabelMap.put(component, label);
        if (this.components.size() == 1) {
            this.baseComponent.add(component);
        } else if (this.components.size() > 1) {
            this.baseComponent.removeAll();
            for (JComponent c : this.components) {
                this.tabbedPane.add(this.component2LabelMap.get(c), c);
            }
            this.baseComponent.add(this.tabbedPane);
        }
        if (component instanceof NodeComponent) {
            ((NodeComponent)((Object)component)).addedToNode(this);
        }
    }

    public String getLabel(JComponent component) {
        String label = this.component2LabelMap.get(component);
        if (label != null) {
            return label;
        }
        return "";
    }

    public void remove(JComponent component) {
        this.component2LabelMap.remove(component);
        this.components.remove(component);
        this.baseComponent.removeAll();
        this.tabbedPane.removeAll();
        if (this.components.size() == 1) {
            this.baseComponent.add(this.components.get(0));
        } else if (this.components.size() > 1) {
            for (JComponent c : this.components) {
                this.tabbedPane.add(this.component2LabelMap.get(c), c);
            }
            this.baseComponent.add(this.tabbedPane);
        }
        this.removeFromParentIfEmpty();
        this.notifyStateChange();
    }

    private void removeFromParentIfEmpty() {
        if (this.getComponentCount() == 0) {
            this.baseComponent.getParent().remove(this.baseComponent);
            this.remove();
        }
    }

    public JComponent getComponent() {
        return this.baseComponent;
    }

    public int getComponentCount() {
        return this.components.size();
    }

    @Override
    public boolean isVisible() {
        return this.getComponentCount() != 0;
    }

    @Override
    public double getGloballyNormalisedXLocation(Node child) {
        if (this.getParent() == null) {
            return 1.0;
        }
        return this.getParent().getGloballyNormalisedYLocation();
    }

    @Override
    public double getGloballyNormalisedYLocation(Node child) {
        return 0.0;
    }

    @Override
    protected void stateChanged() {
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    public List<JComponent> getComponents() {
        return Collections.unmodifiableList(this.components);
    }
}

