/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.merge;

import com.google.common.base.Preconditions;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.protege.editor.core.ProtegeManager;
import org.protege.editor.core.ui.util.InputVerificationStatusChangedListener;
import org.protege.editor.core.ui.util.JOptionPaneEx;
import org.protege.editor.core.ui.util.VerifiedInputEditor;
import org.protege.editor.core.ui.workspace.Workspace;
import org.protege.editor.core.ui.workspace.WorkspaceFrame;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.ui.find.EntityFinderField;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLObject;

public class MergeEntitiesPanel
extends JPanel
implements VerifiedInputEditor {
    @Nonnull
    private Optional<OWLEntity> selectedEntity = Optional.empty();
    private final EntityFinderField entityFinderField;
    private InputVerificationStatusChangedListener listener = newState -> {};

    public MergeEntitiesPanel(OWLEditorKit editorKit) {
        this.entityFinderField = new EntityFinderField(this, editorKit);
        this.entityFinderField.setEntityFoundHandler(entity -> {
            this.selectedEntity = Optional.of(entity);
            this.entityFinderField.setText(editorKit.getModelManager().getRendering((OWLObject)entity));
            this.listener.verifiedStatusChanged(true);
        });
        this.entityFinderField.setSearchStartedHandler(() -> this.listener.verifiedStatusChanged(false));
        this.setLayout(new BorderLayout(7, 7));
        this.add((Component)new JLabel("<html><body>Please specify the <b>target entity</b> in the field below.<br>This is the entity that the selected entity will be merged into.</body></html>"), "North");
        this.add((Component)((Object)this.entityFinderField), "South");
    }

    public void addStatusChangedListener(InputVerificationStatusChangedListener listener) {
        this.listener = (InputVerificationStatusChangedListener)Preconditions.checkNotNull((Object)listener);
    }

    public void removeStatusChangedListener(InputVerificationStatusChangedListener listener) {
        this.listener = newState -> {};
    }

    private EntityFinderField getEntityFinderField() {
        return this.entityFinderField;
    }

    public Optional<OWLEntity> getTargetEntity() {
        return this.selectedEntity;
    }

    public static Optional<OWLEntity> showDialog(OWLEditorKit editorKit) {
        WorkspaceFrame parent = ProtegeManager.getInstance().getFrame((Workspace)editorKit.getWorkspace());
        MergeEntitiesPanel mergeEntitiesPanel = new MergeEntitiesPanel(editorKit);
        JOptionPaneEx.showValidatingConfirmDialog((Component)parent, (String)"Specify target entity", (JComponent)mergeEntitiesPanel, (int)-1, (int)2, (JComponent)((Object)mergeEntitiesPanel.getEntityFinderField()));
        return mergeEntitiesPanel.getTargetEntity();
    }
}

