/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index.engine;

import org.opensearch.knn.index.engine.KNNEngine;
import org.opensearch.knn.index.engine.KNNMethodConfigContext;
import org.opensearch.knn.index.engine.KNNMethodContext;
import org.opensearch.knn.index.mapper.CompressionLevel;
import org.opensearch.knn.index.mapper.Mode;

public final class EngineResolver {
    public static final EngineResolver INSTANCE = new EngineResolver();

    private EngineResolver() {
    }

    public KNNEngine resolveEngine(KNNMethodConfigContext knnMethodConfigContext, KNNMethodContext knnMethodContext, boolean requiresTraining) {
        if (knnMethodContext != null && knnMethodContext.isEngineConfigured()) {
            return knnMethodContext.getKnnEngine();
        }
        if (requiresTraining) {
            return KNNEngine.FAISS;
        }
        Mode mode = knnMethodConfigContext.getMode();
        CompressionLevel compressionLevel = knnMethodConfigContext.getCompressionLevel();
        if (!Mode.isConfigured(mode) && !CompressionLevel.isConfigured(compressionLevel)) {
            return KNNEngine.DEFAULT;
        }
        if (!CompressionLevel.isConfigured(compressionLevel) || compressionLevel == CompressionLevel.x1) {
            return mode == Mode.ON_DISK ? KNNEngine.FAISS : KNNEngine.DEFAULT;
        }
        if (compressionLevel == CompressionLevel.x4) {
            return KNNEngine.LUCENE;
        }
        return KNNEngine.FAISS;
    }
}

