'''OpenGL extension EXT.texture_compression_astc_decode_mode

This module customises the behaviour of the 
OpenGL.raw.GLES2.EXT.texture_compression_astc_decode_mode to provide a more 
Python-friendly API

Overview (from the spec)
	
	Adaptive Scalable Texture Compression (ASTC) is a texture compression
	technology that is exposed by existing extensions and specifications.
	
	The existing specifications require that low dynamic range (LDR)
	textures are decompressed to FP16 values per component. In many cases,
	decompressing LDR textures to a lower precision intermediate result gives
	acceptable image quality. Source material for LDR textures is typically
	authored as 8-bit UNORM values, so decoding to FP16 values adds little
	value. On the other hand, reducing precision of the decoded result
	reduces the size of the decompressed data, potentially improving texture
	cache performance and saving power.
	
	The goal of this extension is to enable this efficiency gain on existing
	ASTC texture data. This is achieved by giving the application the ability
	to select the decoding precision.
	
	Two decoding options are provided by
	GL_EXT_texture_compression_astc_decode_mode
	 - Decode to FP16: This is the default, and matches the required behavior
	   in existing APIs.
	 - Decode to UNORM8: This is provided as an option in LDR mode.
	
	If GL_EXT_texture_compression_astc_decode_mode_rgb9e5 is supported, then
	a third decoding option is provided:
	 - Decode to RGB9_E5: This is provided as an option in both LDR and HDR
	   mode. In this mode, negative values cannot be represented and are
	   clamped to zero. The alpha component is ignored, and the results
	   are as if alpha was 1.0.

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/EXT/texture_compression_astc_decode_mode.txt
'''
from OpenGL import platform, constant, arrays
from OpenGL import extensions, wrapper
import ctypes
from OpenGL.raw.GLES2 import _types, _glgets
from OpenGL.raw.GLES2.EXT.texture_compression_astc_decode_mode import *
from OpenGL.raw.GLES2.EXT.texture_compression_astc_decode_mode import _EXTENSION_NAME

def glInitTextureCompressionAstcDecodeModeEXT():
    '''Return boolean indicating whether this extension is available'''
    from OpenGL import extensions
    return extensions.hasGLExtension( _EXTENSION_NAME )


### END AUTOGENERATED SECTION