/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.internal.parser.v0;

import java.io.IOException;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.unit.IRange;
import org.openjdk.jmc.common.unit.QuantityRange;
import org.openjdk.jmc.flightrecorder.CouldNotLoadRecordingException;
import org.openjdk.jmc.flightrecorder.internal.ChunkInfo;
import org.openjdk.jmc.flightrecorder.internal.IChunkLoader;
import org.openjdk.jmc.flightrecorder.internal.parser.Chunk;
import org.openjdk.jmc.flightrecorder.internal.parser.LoaderContext;
import org.openjdk.jmc.flightrecorder.internal.parser.v0.ChunkMetadata;
import org.openjdk.jmc.flightrecorder.internal.parser.v0.ChunkStructure;
import org.openjdk.jmc.flightrecorder.internal.parser.v0.EventParserManager;
import org.openjdk.jmc.flightrecorder.internal.parser.v0.NumberReaders;
import org.openjdk.jmc.flightrecorder.internal.parser.v0.Offset;
import org.openjdk.jmc.flightrecorder.internal.parser.v0.ReaderFactory;

public class ChunkLoaderV0
implements IChunkLoader {
    private final ChunkStructure structure;
    private final byte[] data;
    private final LoaderContext context;
    private final ChunkMetadata metadata;

    private ChunkLoaderV0(ChunkStructure structure, byte[] data, LoaderContext context) throws CouldNotLoadRecordingException {
        this.structure = structure;
        this.data = data;
        this.context = context;
        this.metadata = new ChunkMetadata(data, structure.getMetadataOffset());
        context.addChunkRange((IRange<IQuantity>)QuantityRange.createWithEnd((IQuantity)this.metadata.getStartTime(), (IQuantity)this.metadata.getEndTime()));
    }

    @Override
    public byte[] call() throws Exception {
        this.context.incChunkCount();
        ReaderFactory readerFactory = new ReaderFactory(this.metadata, this.data, this.context, this.structure);
        EventParserManager eventParser = new EventParserManager(readerFactory, this.context, this.metadata.getProducers());
        int nextEventIndex = this.structure.getBodyStartOffset();
        while (nextEventIndex < this.structure.getMetadataOffset()) {
            Offset offset = new Offset(this.data, nextEventIndex);
            nextEventIndex = offset.getEnd();
            int eventTypeId = NumberReaders.readInt(this.data, offset);
            if (eventTypeId == 0 || eventTypeId == 1) continue;
            eventParser.loadEvent(this.data, offset, eventTypeId);
        }
        return this.data;
    }

    public static IChunkLoader create(Chunk input, LoaderContext context) throws IOException, CouldNotLoadRecordingException {
        ChunkStructure structure = new ChunkStructure(input);
        byte[] buffer = input.fill(structure.getChunkSize());
        return new ChunkLoaderV0(structure, buffer, context);
    }

    public static ChunkInfo getInfo(Chunk input, long position) throws IOException, CouldNotLoadRecordingException {
        ChunkStructure structure = new ChunkStructure(input);
        byte[] buffer = input.fill(structure.getChunkSize());
        ChunkMetadata metadata = new ChunkMetadata(buffer, structure.getMetadataOffset());
        return new ChunkInfo(position, structure.getChunkSize(), (IRange<IQuantity>)QuantityRange.createWithEnd((IQuantity)metadata.getStartTime(), (IQuantity)metadata.getEndTime()));
    }

    @Override
    public long getTimestamp() {
        return this.metadata.getStartTime().longValue();
    }
}

