/*
 * Copyright (c) 2012, 2024, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_eu extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] GMT = new String[] {
               "Greenwichko meridianoaren ordua",
               "GMT",
               "",
               "GMT",
               "",
               "GMT",
            };
        final String[] Acre = new String[] {
               "Acreko ordu estandarra",
               "",
               "Acreko udako ordua",
               "",
               "Acreko ordua",
               "",
            };
        final String[] Apia = new String[] {
               "Apiako ordu estandarra",
               "",
               "Apiako udako ordua",
               "",
               "Apiako ordua",
               "",
            };
        final String[] Cook = new String[] {
               "Cook uharteetako ordu estandarra",
               "",
               "Cook uharteetako uda erdialdeko ordua",
               "",
               "Cook uharteetako ordua",
               "",
            };
        final String[] Cuba = new String[] {
               "Kubako ordu estandarra",
               "CST",
               "Kubako udako ordua",
               "CDT",
               "Kubako ordua",
               "CT",
            };
        final String[] Fiji = new String[] {
               "Fijiko ordu estandarra",
               "",
               "Fijiko udako ordua",
               "",
               "Fijiko ordua",
               "",
            };
        final String[] Gulf = new String[] {
               "Golkoko ordu estandarra",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hovd = new String[] {
               "Khovdeko ordu estandarra",
               "",
               "Khovdeko udako ordua",
               "",
               "Khovdeko ordua",
               "",
            };
        final String[] Iran = new String[] {
               "Irango ordu estandarra",
               "",
               "Irango udako ordua",
               "",
               "Irango ordua",
               "",
            };
        final String[] Niue = new String[] {
               "Niueko ordua",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Omsk = new String[] {
               "Omskeko ordu estandarra",
               "",
               "Omskeko udako ordua",
               "",
               "Omskeko ordua",
               "",
            };
        final String[] Peru = new String[] {
               "Peruko ordu estandarra",
               "",
               "Peruko udako ordua",
               "",
               "Peruko ordua",
               "",
            };
        final String[] Truk = new String[] {
               "Chuukeko ordua",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wake = new String[] {
               "Wake uharteko ordua",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chile = new String[] {
               "Txileko ordu estandarra",
               "",
               "Txileko udako ordua",
               "",
               "Txileko ordua",
               "",
            };
        final String[] China = new String[] {
               "Txinako ordu estandarra",
               "CST",
               "Txinako udako ordua",
               "CDT",
               "Txinako ordua",
               "CT",
            };
        final String[] Cocos = new String[] {
               "Cocos uharteetako ordua",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Davis = new String[] {
               "Daviseko ordua",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] India = new String[] {
               "Indiako ordua",
               "IST",
               "",
               "IST",
               "",
               "IST",
            };
        final String[] Japan = new String[] {
               "Japoniako ordu estandarra",
               "JST",
               "Japoniako udako ordua",
               "JDT",
               "Japoniako ordua",
               "JT",
            };
        final String[] Korea = new String[] {
               "Koreako ordu estandarra",
               "KST",
               "Koreako udako ordua",
               "KST",
               "Koreako ordua",
               "KST",
            };
        final String[] Nauru = new String[] {
               "Nauruko ordua",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Nepal = new String[] {
               "Nepalgo ordua",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Palau = new String[] {
               "Palauko ordua",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samoa = new String[] {
               "Samoako ordu estandarra",
               "SST",
               "Samoako udako ordua",
               "SST",
               "Samoako ordua",
               "SST",
            };
        final String[] Syowa = new String[] {
               "Syowako ordua",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tonga = new String[] {
               "Tongako ordu estandarra",
               "",
               "Tongako udako ordua",
               "",
               "Tongako ordua",
               "",
            };
        final String[] Yukon = new String[] {
               "Yukongo ordua",
               "MST",
               "",
               "MST",
               "",
               "MST",
            };
        final String[] Alaska = new String[] {
               "Alaskako ordu estandarra",
               "AKST",
               "Alaskako udako ordua",
               "AKDT",
               "Alaskako ordua",
               "AKT",
            };
        final String[] Amazon = new String[] {
               "Amazoniako ordu estandarra",
               "",
               "Amazoniako udako ordua",
               "",
               "Amazoniako ordua",
               "",
            };
        final String[] Anadyr = new String[] {
               "Anadyrreko ordu estandarra",
               "",
               "Anadyrreko udako ordua",
               "",
               "Anadyrreko ordua",
               "",
            };
        final String[] Azores = new String[] {
               "Azoreetako ordu estandarra",
               "",
               "Azoreetako udako ordua",
               "",
               "Azoreetako ordua",
               "",
            };
        final String[] Bhutan = new String[] {
               "Bhutango ordua",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Brunei = new String[] {
               "Brunei Darussalamgo ordua",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Easter = new String[] {
               "Pazko uharteko ordu estandarra",
               "",
               "Pazko uharteko udako ordua",
               "",
               "Pazko uharteko ordua",
               "",
            };
        final String[] Guyana = new String[] {
               "Guyanako ordua",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Israel = new String[] {
               "Israelgo ordu estandarra",
               "IST",
               "Israelgo udako ordua",
               "IDT",
               "Israelgo ordua",
               "IT",
            };
        final String[] Kosrae = new String[] {
               "Kosraeko ordua",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mawson = new String[] {
               "Mawsoneko ordua",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Moscow = new String[] {
               "Moskuko ordu estandarra",
               "MSK",
               "Moskuko udako ordua",
               "MSK",
               "Moskuko ordua",
               "MSK",
            };
        final String[] Ponape = new String[] {
               "Ponapeko ordua",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samara = new String[] {
               "Samarako ordu estandarra",
               "",
               "Samarako udako ordua",
               "",
               "Samarako ordua",
               "",
            };
        final String[] Tahiti = new String[] {
               "Tahitiko ordua",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Taipei = new String[] {
               "Taipeiko ordu estandarra",
               "CST",
               "Taipeiko udako ordua",
               "CDT",
               "Taipeiko ordua",
               "CT",
            };
        final String[] Tuvalu = new String[] {
               "Tuvaluko ordua",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Vostok = new String[] {
               "Vostokeko ordua",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wallis = new String[] {
               "Wallis eta Futunako ordutegia",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Arabian = new String[] {
               "Arabiako ordu estandarra",
               "",
               "Arabiako udako ordua",
               "",
               "Arabiako ordua",
               "",
            };
        final String[] Armenia = new String[] {
               "Armeniako ordu estandarra",
               "",
               "Armeniako udako ordua",
               "",
               "Armeniako ordua",
               "",
            };
        final String[] Bolivia = new String[] {
               "Boliviako ordua",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chatham = new String[] {
               "Chathamgo ordu estandarra",
               "",
               "Chathamgo udako ordua",
               "",
               "Chathamgo ordua",
               "",
            };
        final String[] ETC_UTC = new String[] {
               "ordu unibertsal koordinatua",
               "UTC",
               "",
               "",
               "",
               "",
            };
        final String[] Ecuador = new String[] {
               "Ekuadorreko ordua",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gambier = new String[] {
               "Gambierretako ordua",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Georgia = new String[] {
               "Georgiako ordu estandarra",
               "",
               "Georgiako udako ordua",
               "",
               "Georgiako ordua",
               "",
            };
        final String[] Irkutsk = new String[] {
               "Irkutskeko ordu estandarra",
               "",
               "Irkutskeko udako ordua",
               "",
               "Irkutskeko ordua",
               "",
            };
        final String[] Magadan = new String[] {
               "Magadango ordu estandarra",
               "",
               "Magadango udako ordua",
               "",
               "Magadango ordua",
               "",
            };
        final String[] Myanmar = new String[] {
               "Myanmarreko ordua",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Norfolk = new String[] {
               "Norfolk uharteetako ordu estandarra",
               "",
               "Norfolk uharteetako udako ordua",
               "",
               "Norfolk uharteetako ordua",
               "",
            };
        final String[] Noronha = new String[] {
               "Fernando de Noronhako ordu estandarra",
               "",
               "Fernando de Noronhako udako ordua",
               "",
               "Fernando de Noronhako ordua",
               "",
            };
        final String[] Reunion = new String[] {
               "Reunioneko ordua",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Rothera = new String[] {
               "Rotherako ordua",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Solomon = new String[] {
               "Salomon Uharteetako ordua",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tokelau = new String[] {
               "Tokelauko ordua",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uruguay = new String[] {
               "Uruguaiko ordu estandarra",
               "",
               "Uruguaiko udako ordua",
               "",
               "Uruguaiko ordua",
               "",
            };
        final String[] Vanuatu = new String[] {
               "Vanuatuko ordu estandarra",
               "",
               "Vanuatuko udako ordua",
               "",
               "Vanuatuko ordua",
               "",
            };
        final String[] Yakutsk = new String[] {
               "Jakutskeko ordu estandarra",
               "",
               "Jakutskeko udako ordua",
               "",
               "Jakutskeko ordua",
               "",
            };
        final String[] Atlantic = new String[] {
               "Ipar Amerikako Atlantikoko ordu estandarra",
               "AST",
               "Ipar Amerikako Atlantikoko udako ordua",
               "ADT",
               "Ipar Amerikako Atlantikoko ordua",
               "AT",
            };
        final String[] Brasilia = new String[] {
               "Brasiliako ordu estandarra",
               "",
               "Brasiliako udako ordua",
               "",
               "Brasiliako ordua",
               "",
            };
        final String[] Chamorro = new String[] {
               "Chamorroko ordu estandarra",
               "ChST",
               "",
               "ChST",
               "",
               "ChST",
            };
        final String[] Colombia = new String[] {
               "Kolonbiako ordu estandarra",
               "",
               "Kolonbiako udako ordua",
               "",
               "Kolonbiako ordua",
               "",
            };
        final String[] Falkland = new String[] {
               "Falkland uharteetako ordu estandarra",
               "",
               "Falkland uharteetako udako ordua",
               "",
               "Falkland uharteetako ordua",
               "",
            };
        final String[] Malaysia = new String[] {
               "Malaysiako ordua",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Maldives = new String[] {
               "Maldivetako ordua",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mongolia = new String[] {
               "Ulan Batorreko ordu estandarra",
               "",
               "Ulan Batorreko udako ordua",
               "",
               "Ulan Batorreko ordua",
               "",
            };
        final String[] Pakistan = new String[] {
               "Pakistango ordu estandarra",
               "PKT",
               "Pakistango udako ordua",
               "PKST",
               "Pakistango ordua",
               "PKT",
            };
        final String[] Paraguay = new String[] {
               "Paraguaiko ordu estandarra",
               "",
               "Paraguaiko udako ordua",
               "",
               "Paraguaiko ordua",
               "",
            };
        final String[] Pitcairn = new String[] {
               "Pitcairneko ordua",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Sakhalin = new String[] {
               "Sakhalingo ordu estandarra",
               "",
               "Sakhalingo udako ordua",
               "",
               "Sakhalingo ordua",
               "",
            };
        final String[] Suriname = new String[] {
               "Surinamgo ordua",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Argentina = new String[] {
               "Argentinako ordu estandarra",
               "",
               "Argentinako udako ordua",
               "",
               "Argentinako ordua",
               "",
            };
        final String[] Christmas = new String[] {
               "Christmas uharteko ordua",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Galapagos = new String[] {
               "Galapagoetako ordua",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hong_Kong = new String[] {
               "Hong Kongo ordu estandarra",
               "HKT",
               "Hong Kongo udako ordua",
               "HKST",
               "Hong Kongo ordua",
               "HKT",
            };
        final String[] Indochina = new String[] {
               "Indotxinako ordua",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kamchatka = new String[] {
               "Petropavlovsk-Kamchatskiko ordu estandarra",
               "",
               "Petropavlovsk-Kamchatskiko udako ordua",
               "",
               "Petropavlovsk-Kamchatskiko ordua",
               "",
            };
        final String[] Kyrgystan = new String[] {
               "Kirgizistango ordua",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Lord_Howe = new String[] {
               "Lord Howeko ordu estandarra",
               "",
               "Lord Howeko udako ordua",
               "",
               "Lord Howeko ordua",
               "",
            };
        final String[] Marquesas = new String[] {
               "Markesetako ordua",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mauritius = new String[] {
               "Maurizioko ordu estandarra",
               "",
               "Maurizioko udako ordua",
               "",
               "Maurizioko ordua",
               "",
            };
        final String[] Singapore = new String[] {
               "Singapurreko ordu estandarra",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Venezuela = new String[] {
               "Venezuelako ordua",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Volgograd = new String[] {
               "Volgogradeko ordu estandarra",
               "MSK",
               "Volgogradeko udako ordua",
               "MSK",
               "Volgogradeko ordua",
               "MSK",
            };
        final String[] Azerbaijan = new String[] {
               "Azerbaijango ordu estandarra",
               "",
               "Azerbaijango udako ordua",
               "",
               "Azerbaijango ordua",
               "",
            };
        final String[] Bangladesh = new String[] {
               "Bangladesheko ordu estandarra",
               "",
               "Bangladesheko udako ordua",
               "",
               "Bangladesheko ordua",
               "",
            };
        final String[] Cape_Verde = new String[] {
               "Cabo Verdeko ordu estandarra",
               "",
               "Cabo Verdeko udako ordua",
               "",
               "Cabo Verdeko ordua",
               "",
            };
        final String[] East_Timor = new String[] {
               "Ekialdeko Timorreko ordua",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Seychelles = new String[] {
               "Seychelle uharteetako ordua",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tajikistan = new String[] {
               "Tadjikistango ordua",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uzbekistan = new String[] {
               "Uzbekistango ordu estandarra",
               "",
               "Uzbekistango udako ordua",
               "",
               "Uzbekistango ordua",
               "",
            };
        final String[] Afghanistan = new String[] {
               "Afganistango ordua",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Krasnoyarsk = new String[] {
               "Krasnoiarskeko ordu estandarra",
               "",
               "Krasnoiarskeko udako ordua",
               "",
               "Krasnoiarskeko ordua",
               "",
            };
        final String[] New_Zealand = new String[] {
               "Zeelanda Berriko ordu estandarra",
               "NZST",
               "Zeelanda Berriko udako ordua",
               "NZDT",
               "Zeelanda Berriko ordua",
               "NZT",
            };
        final String[] Novosibirsk = new String[] {
               "Novosibirskeko ordu estandarra",
               "",
               "Novosibirskeko udako ordua",
               "",
               "Novosibirskeko ordua",
               "",
            };
        final String[] Philippines = new String[] {
               "Filipinetako ordu estandarra",
               "PST",
               "Filipinetako udako ordua",
               "PDT",
               "Filipinetako ordua",
               "PT",
            };
        final String[] Vladivostok = new String[] {
               "Vladivostokeko ordu estandarra",
               "",
               "Vladivostokeko udako ordua",
               "",
               "Vladivostokeko ordua",
               "",
            };
        final String[] Indian_Ocean = new String[] {
               "Indiako ozeanoko ordua",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Line_Islands = new String[] {
               "Line uharteetako ordua",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Newfoundland = new String[] {
               "Ternuako ordu estandarra",
               "NST",
               "Ternuako udako ordua",
               "NDT",
               "Ternuako ordua",
               "NT",
            };
        final String[] Turkmenistan = new String[] {
               "Turkmenistango ordu estandarra",
               "",
               "Turkmenistango udako ordua",
               "",
               "Turkmenistango ordua",
               "",
            };
        final String[] French_Guiana = new String[] {
               "Guyana Frantseseko ordua",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] New_Caledonia = new String[] {
               "Kaledonia Berriko ordu estandarra",
               "",
               "Kaledonia Berriko udako ordua",
               "",
               "Kaledonia Berriko ordua",
               "",
            };
        final String[] South_Georgia = new String[] {
               "Hegoaldeko Georgietako ordua",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Yekaterinburg = new String[] {
               "Jekaterinburgeko ordu estandarra",
               "",
               "Jekaterinburgeko udako ordua",
               "",
               "Jekaterinburgeko ordua",
               "",
            };
        final String[] Africa_Central = new String[] {
               "Afrikako erdialdeko ordua",
               "CAT",
               "",
               "CAT",
               "",
               "CAT",
            };
        final String[] Africa_Eastern = new String[] {
               "Afrikako ekialdeko ordua",
               "EAT",
               "",
               "EAT",
               "",
               "EAT",
            };
        final String[] Africa_Western = new String[] {
               "Afrikako mendebaldeko ordu estandarra",
               "WAT",
               "Afrikako mendebaldeko udako ordua",
               "WAT",
               "Afrikako mendebaldeko ordua",
               "WAT",
            };
        final String[] DumontDUrville = new String[] {
               "Dumont-d\u2019Urvilleko ordua",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Europe_Central = new String[] {
               "Europako erdialdeko ordu estandarra",
               "CET",
               "Europako erdialdeko udako ordua",
               "CEST",
               "Europako erdialdeko ordua",
               "CET",
            };
        final String[] Europe_Eastern = new String[] {
               "Europako ekialdeko ordu estandarra",
               "EET",
               "Europako ekialdeko udako ordua",
               "EEST",
               "Europako ekialdeko ordua",
               "EET",
            };
        final String[] Europe_Western = new String[] {
               "Europako mendebaldeko ordu estandarra",
               "WET",
               "Europako mendebaldeko udako ordua",
               "WEST",
               "Europako mendebaldeko ordua",
               "WET",
            };
        final String[] Mexico_Pacific = new String[] {
               "Mexikoko Pazifikoko ordu estandarra",
               "MST",
               "Mexikoko Pazifikoko udako ordua",
               "MDT",
               "Mexikoko Pazifikoko ordua",
               "MT",
            };
        final String[] Africa_Southern = new String[] {
               "Afrikako hegoaldeko ordua",
               "SAST",
               "",
               "SAST",
               "",
               "SAST",
            };
        final String[] America_Central = new String[] {
               "Ipar Amerikako erdialdeko ordu estandarra",
               "CST",
               "Ipar Amerikako erdialdeko udako ordua",
               "CDT",
               "Ipar Amerikako erdialdeko ordua",
               "CT",
            };
        final String[] America_Eastern = new String[] {
               "Ipar Amerikako ekialdeko ordu estandarra",
               "EST",
               "Ipar Amerikako ekialdeko udako ordua",
               "EDT",
               "Ipar Amerikako ekialdeko ordua",
               "ET",
            };
        final String[] America_Pacific = new String[] {
               "Ipar Amerikako Pazifikoko ordu estandarra",
               "PST",
               "Ipar Amerikako Pazifikoko udako ordua",
               "PDT",
               "Ipar Amerikako Pazifikoko ordua",
               "PT",
            };
        final String[] French_Southern = new String[] {
               "Frantziaren lurralde austral eta antartikoetako ordutegia",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gilbert_Islands = new String[] {
               "Gilbert uharteetako ordua",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "Hawaii-Aleutiar uharteetako ordu estandarra",
               "HAST",
               "Hawaii-Aleutiar uharteetako udako ordua",
               "HADT",
               "Hawaii-Aleutiar uharteetako ordua",
               "HAT",
            };
        final String[] Phoenix_Islands = new String[] {
               "Phoenix uharteetako ordua",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Pierre_Miquelon = new String[] {
               "Saint-Pierre eta Mikeluneko ordu estandarra",
               "",
               "Saint-Pierre eta Mikeluneko udako ordua",
               "",
               "Saint-Pierre eta Mikeluneko ordua",
               "",
            };
        final String[] America_Mountain = new String[] {
               "Ipar Amerikako mendialdeko ordu estandarra",
               "MST",
               "Ipar Amerikako mendialdeko udako ordua",
               "MDT",
               "Ipar Amerikako mendialdeko ordua",
               "MT",
            };
        final String[] Marshall_Islands = new String[] {
               "Marshall Uharteetako ordua",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Papua_New_Guinea = new String[] {
               "Papua Ginea Berriko ordua",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_Central = new String[] {
               "Australiako erdialdeko ordu estandarra",
               "ACST",
               "Australiako erdialdeko udako ordua",
               "ACDT",
               "Australiako erdialdeko ordua",
               "ACT",
            };
        final String[] Australia_Eastern = new String[] {
               "Australiako ekialdeko ordu estandarra",
               "AEST",
               "Australiako ekialdeko udako ordua",
               "AEDT",
               "Australiako ekialdeko ordua",
               "AET",
            };
        final String[] Australia_Western = new String[] {
               "Australiako mendebaldeko ordu estandarra",
               "AWST",
               "Australiako mendebaldeko udako ordua",
               "AWDT",
               "Australiako mendebaldeko ordua",
               "AWT",
            };
        final String[] Indonesia_Central = new String[] {
               "Indonesiako erdialdeko ordua",
               "WITA",
               "",
               "WITA",
               "",
               "WITA",
            };
        final String[] Indonesia_Eastern = new String[] {
               "Indonesiako ekialdeko ordua",
               "WIT",
               "",
               "WIT",
               "",
               "WIT",
            };
        final String[] Indonesia_Western = new String[] {
               "Indonesiako mendebaldeko ordua",
               "WIB",
               "",
               "WIB",
               "",
               "WIB",
            };
        final String[] Kazakhstan_Western = new String[] {
               "Kazakhstango mendebaldeko ordua",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_CentralWestern = new String[] {
               "Australiako erdi-mendebaldeko ordu estandarra",
               "",
               "Australiako erdi-mendebaldeko udako ordua",
               "",
               "Australiako erdi-mendebaldeko ordua",
               "",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu",
                new String[] {
                    "Hawaii-Aleutiar uharteetako ordu estandarra",
                    "HST",
                    "Hawaii-Aleutiar uharteetako udako ordua",
                    "HDT",
                    "Hawaii-Aleutiar uharteetako ordua",
                    "HST",
                }
            },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "UTC", ETC_UTC },
            { "GB",
                new String[] {
                    "Greenwichko meridianoaren ordua",
                    "GMT",
                    "Londresko udako ordua",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "NZ", New_Zealand },
            { "ACT", Australia_Central },
            { "AET", Australia_Eastern },
            { "AGT", Argentina },
            { "ART", Europe_Eastern },
            { "AST", Alaska },
            { "BET", Brasilia },
            { "BST", Bangladesh },
            { "CAT", Africa_Central },
            { "CNT", Newfoundland },
            { "CST", America_Central },
            { "CTT", China },
            { "EAT", Africa_Eastern },
            { "ECT", Europe_Central },
            { "IET", America_Eastern },
            { "IST", India },
            { "JST", Japan },
            { "MIT", Apia },
            { "NET", Armenia },
            { "NST", New_Zealand },
            { "PLT", Pakistan },
            { "PNT", America_Mountain },
            { "PRC", China },
            { "PRT", Atlantic },
            { "PST", America_Pacific },
            { "ROK", Korea },
            { "SST", Solomon },
            { "UCT",
                new String[] {
                    "ordu unibertsal koordinatua",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "VST", Indochina },
            { "Cuba", Cuba },
            { "Eire",
                new String[] {
                    "Greenwichko meridianoaren ordua",
                    "GMT",
                    "Irlandako ordu estandarra",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "GMT0", GMT },
            { "Iran", Iran },
            { "W-SU", Moscow },
            { "Zulu",
                new String[] {
                    "ordu unibertsal koordinatua",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Egypt", Europe_Eastern },
            { "Japan", Japan },
            { "Libya", Europe_Eastern },
            { "Israel", Israel },
            { "Navajo", America_Mountain },
            { "Poland", Europe_Central },
            { "CST6CDT", America_Central },
            { "EST5EDT", America_Eastern },
            { "Etc/GMT", GMT },
            { "Etc/UCT",
                new String[] {
                    "ordu unibertsal koordinatua",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Etc/UTC", ETC_UTC },
            { "GB-Eire",
                new String[] {
                    "Greenwichko meridianoaren ordua",
                    "GMT",
                    "Londresko udako ordua",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Iceland", GMT },
            { "Jamaica", America_Eastern },
            { "MST7MDT", America_Mountain },
            { "NZ-CHAT", Chatham },
            { "PST8PDT", America_Pacific },
            { "Etc/GMT0", GMT },
            { "Etc/Zulu",
                new String[] {
                    "ordu unibertsal koordinatua",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Hongkong", Hong_Kong },
            { "Portugal", Europe_Western },
            { "US/Samoa", Samoa },
            { "Asia/Aden", Arabian },
            { "Asia/Baku", Azerbaijan },
            { "Asia/Dili", East_Timor },
            { "Asia/Gaza", Europe_Eastern },
            { "Asia/Hovd", Hovd },
            { "Asia/Omsk", Omsk },
            { "Asia/Oral", Kazakhstan_Western },
            { "Etc/GMT+0", GMT },
            { "Etc/GMT-0", GMT },
            { "Greenwich", GMT },
            { "Kwajalein", Marshall_Islands },
            { "Singapore", Singapore },
            { "US/Alaska", Alaska },
            { "US/Hawaii",
                new String[] {
                    "Hawaii-Aleutiar uharteetako ordu estandarra",
                    "HST",
                    "Hawaii-Aleutiar uharteetako udako ordua",
                    "HDT",
                    "Hawaii-Aleutiar uharteetako ordua",
                    "HST",
                }
            },
            { "Universal",
                new String[] {
                    "ordu unibertsal koordinatua",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Asia/Aqtau", Kazakhstan_Western },
            { "Asia/Chita", Yakutsk },
            { "Asia/Dacca", Bangladesh },
            { "Asia/Dhaka", Bangladesh },
            { "Asia/Dubai", Gulf },
            { "Asia/Kabul", Afghanistan },
            { "Asia/Macao", China },
            { "Asia/Macau", China },
            { "Asia/Qatar", Arabian },
            { "Asia/Seoul", Korea },
            { "US/Arizona", America_Mountain },
            { "US/Central", America_Central },
            { "US/Eastern", America_Eastern },
            { "US/Pacific", America_Pacific },
            { "Africa/Juba", Africa_Central },
            { "Africa/Lome", GMT },
            { "Asia/Almaty", Kazakhstan_Western },
            { "Asia/Anadyr", Anadyr },
            { "Asia/Aqtobe", Kazakhstan_Western },
            { "Asia/Atyrau", Kazakhstan_Western },
            { "Asia/Beirut", Europe_Eastern },
            { "Asia/Brunei", Brunei },
            { "Asia/Harbin", China },
            { "Asia/Hebron", Europe_Eastern },
            { "Asia/Kuwait", Arabian },
            { "Asia/Manila", Philippines },
            { "Asia/Muscat", Gulf },
            { "Asia/Riyadh", Arabian },
            { "Asia/Saigon", Indochina },
            { "Asia/Taipei", Taipei },
            { "Asia/Tehran", Iran },
            { "Asia/Thimbu", Bhutan },
            { "Asia/Yangon", Cocos },
            { "Brazil/Acre", Acre },
            { "Brazil/East", Brasilia },
            { "Brazil/West", Amazon },
            { "Europe/Kiev", Europe_Eastern },
            { "Europe/Kyiv", Europe_Eastern },
            { "Europe/Oslo", Europe_Central },
            { "Europe/Riga", Europe_Eastern },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mahe", Seychelles },
            { "Pacific/Yap", Papua_New_Guinea },
            { "US/Aleutian", Hawaii_Aleutian },
            { "US/Michigan", America_Eastern },
            { "US/Mountain", America_Mountain },
            { "Africa/Accra", GMT },
            { "Africa/Cairo", Europe_Eastern },
            { "Africa/Ceuta", Europe_Central },
            { "Africa/Dakar", GMT },
            { "Africa/Lagos", Africa_Western },
            { "Africa/Tunis", Europe_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "America/Atka", Hawaii_Aleutian },
            { "America/Lima", Peru },
            { "America/Nome", Alaska },
            { "Asia/Baghdad", Arabian },
            { "Asia/Bahrain", Arabian },
            { "Asia/Bangkok", Indochina },
            { "Asia/Bishkek", Kyrgystan },
            { "Asia/Colombo", India },
            { "Asia/Irkutsk", Irkutsk },
            { "Asia/Jakarta", Indonesia_Western },
            { "Asia/Karachi", Pakistan },
            { "Asia/Kolkata", India },
            { "Asia/Kuching", Brunei },
            { "Asia/Magadan", Magadan },
            { "Asia/Nicosia", Europe_Eastern },
            { "Asia/Rangoon", Myanmar },
            { "Asia/Tbilisi", Georgia },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Yakutsk", Yakutsk },
            { "Asia/Yerevan", Armenia },
            { "Canada/Yukon", Yukon },
            { "Europe/Malta", Europe_Central },
            { "Europe/Minsk", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Europe/Vaduz", Europe_Central },
            { "Indian/Cocos", Cocos },
            { "Pacific/Apia", Apia },
            { "Pacific/Fiji", Fiji },
            { "Pacific/Guam", Chamorro },
            { "Pacific/Niue", Niue },
            { "Pacific/Truk", Truk },
            { "Pacific/Wake", Wake },
            { "SystemV/AST4", Atlantic },
            { "SystemV/CST6", America_Central },
            { "SystemV/EST5", America_Eastern },
            { "SystemV/MST7", America_Mountain },
            { "SystemV/PST8", Pitcairn },
            { "SystemV/YST9", Gambier },
            { "Africa/Asmara", Africa_Eastern },
            { "Africa/Asmera", Africa_Eastern },
            { "Africa/Bamako", GMT },
            { "Africa/Bangui", Africa_Western },
            { "Africa/Banjul", GMT },
            { "Africa/Bissau", GMT },
            { "Africa/Douala", Africa_Western },
            { "Africa/Harare", Africa_Central },
            { "Africa/Kigali", Africa_Central },
            { "Africa/Luanda", Africa_Western },
            { "Africa/Lusaka", Africa_Central },
            { "Africa/Malabo", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "Africa/Maseru", Africa_Southern },
            { "Africa/Niamey", Africa_Western },
            { "America/Aruba", Atlantic },
            { "America/Bahia", Brasilia },
            { "America/Belem", Brasilia },
            { "America/Boise", America_Mountain },
            { "America/Jujuy", Argentina },
            { "America/Thule", Atlantic },
            { "Asia/Ashgabat", Turkmenistan },
            { "Asia/Calcutta", India },
            { "Asia/Dushanbe", Tajikistan },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "Asia/Katmandu", Nepal },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Makassar", Indonesia_Central },
            { "Asia/Qostanay", Kazakhstan_Western },
            { "Asia/Sakhalin", Sakhalin },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Tel_Aviv", Israel },
            { "Asia/Ust-Nera", Vladivostok },
            { "Australia/ACT", Australia_Eastern },
            { "Australia/LHI", Lord_Howe },
            { "Australia/NSW", Australia_Eastern },
            { "Etc/Greenwich", GMT },
            { "Etc/Universal",
                new String[] {
                    "ordu unibertsal koordinatua",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Dublin",
                new String[] {
                    "Greenwichko meridianoaren ordua",
                    "GMT",
                    "Irlandako ordu estandarra",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Jersey",
                new String[] {
                    "Greenwichko meridianoaren ordua",
                    "GMT",
                    "Londresko udako ordua",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Lisbon", Europe_Western },
            { "Europe/London",
                new String[] {
                    "Greenwichko meridianoaren ordua",
                    "GMT",
                    "Londresko udako ordua",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Madrid", Europe_Central },
            { "Europe/Monaco", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Prague", Europe_Central },
            { "Europe/Samara", Samara },
            { "Europe/Skopje", Europe_Central },
            { "Europe/Tirane", Europe_Central },
            { "Europe/Vienna", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Europe/Zagreb", Europe_Central },
            { "Europe/Zurich", Europe_Central },
            { "Indian/Chagos", Indian_Ocean },
            { "Indian/Comoro", Africa_Eastern },
            { "Pacific/Chuuk", Papua_New_Guinea },
            { "Pacific/Efate", Vanuatu },
            { "Pacific/Nauru", Nauru },
            { "Pacific/Palau", Palau },
            { "Pacific/Samoa", Samoa },
            { "SystemV/HST10",
                new String[] {
                    "Hawaii-Aleutiar uharteetako ordu estandarra",
                    "HST",
                    "Hawaii-Aleutiar uharteetako udako ordua",
                    "HDT",
                    "Hawaii-Aleutiar uharteetako ordua",
                    "HST",
                }
            },
            { "Africa/Abidjan", GMT },
            { "Africa/Algiers", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Kampala", Africa_Eastern },
            { "Africa/Mbabane", Africa_Southern },
            { "Africa/Nairobi", Africa_Eastern },
            { "Africa/Tripoli", Europe_Eastern },
            { "America/Belize", America_Central },
            { "America/Bogota", Colombia },
            { "America/Cancun", America_Eastern },
            { "America/Cayman", America_Eastern },
            { "America/Cuiaba", Amazon },
            { "America/Dawson", Yukon },
            { "America/Guyana", Guyana },
            { "America/Havana", Cuba },
            { "America/Inuvik", America_Mountain },
            { "America/Juneau", Alaska },
            { "America/La_Paz", Bolivia },
            { "America/Maceio", Brasilia },
            { "America/Manaus", Amazon },
            { "America/Merida", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Panama", America_Eastern },
            { "America/Recife", Brasilia },
            { "America/Regina", America_Central },
            { "America/Virgin", Atlantic },
            { "Asia/Ashkhabad", Turkmenistan },
            { "Asia/Chongqing", China },
            { "Asia/Chungking", China },
            { "Asia/Hong_Kong", Hong_Kong },
            { "Asia/Kamchatka", Kamchatka },
            { "Asia/Kathmandu", Nepal },
            { "Asia/Pontianak", Indonesia_Western },
            { "Asia/Pyongyang", Korea },
            { "Asia/Qyzylorda", Kazakhstan_Western },
            { "Asia/Samarkand", Uzbekistan },
            { "Asia/Singapore", Singapore },
            { "Asia/Vientiane", Indochina },
            { "Atlantic/Faroe", Europe_Western },
            { "Australia/West", Australia_Western },
            { "Canada/Central", America_Central },
            { "Canada/Eastern", America_Eastern },
            { "Canada/Pacific", America_Pacific },
            { "Europe/Andorra", Europe_Central },
            { "Europe/Belfast",
                new String[] {
                    "Greenwichko meridianoaren ordua",
                    "GMT",
                    "Londresko udako ordua",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Nicosia", Europe_Eastern },
            { "Europe/Tallinn", Europe_Eastern },
            { "Europe/Vatican", Europe_Central },
            { "Europe/Vilnius", Europe_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Indian/Reunion", Reunion },
            { "Mexico/BajaSur", Mexico_Pacific },
            { "Mexico/General", America_Central },
            { "Pacific/Easter", Easter },
            { "Pacific/Kanton", Phoenix_Islands },
            { "Pacific/Kosrae", Kosrae },
            { "Pacific/Majuro", Marshall_Islands },
            { "Pacific/Midway", Samoa },
            { "Pacific/Noumea", New_Caledonia },
            { "Pacific/Ponape", Solomon },
            { "Pacific/Saipan", Chamorro },
            { "Pacific/Tahiti", Tahiti },
            { "Pacific/Tarawa", Marshall_Islands },
            { "Pacific/Wallis", Gilbert_Islands },
            { "Africa/Blantyre", Africa_Central },
            { "Africa/Djibouti", Africa_Eastern },
            { "Africa/Freetown", GMT },
            { "Africa/Gaborone", Africa_Central },
            { "Africa/Khartoum", Africa_Central },
            { "Africa/Kinshasa", Africa_Western },
            { "Africa/Monrovia", GMT },
            { "Africa/Ndjamena", Africa_Western },
            { "Africa/Sao_Tome", GMT },
            { "Africa/Timbuktu", GMT },
            { "Africa/Windhoek", Africa_Central },
            { "America/Antigua", Atlantic },
            { "America/Caracas", Venezuela },
            { "America/Cayenne", French_Guiana },
            { "America/Cordoba", Argentina },
            { "America/Creston", America_Mountain },
            { "America/Curacao", Atlantic },
            { "America/Detroit", America_Eastern },
            { "America/Grenada", Atlantic },
            { "America/Iqaluit", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "America/Knox_IN", America_Central },
            { "America/Managua", America_Central },
            { "America/Marigot", Atlantic },
            { "America/Mendoza", Argentina },
            { "America/Moncton", Atlantic },
            { "America/Nipigon", America_Eastern },
            { "America/Noronha", Noronha },
            { "America/Ojinaga", America_Central },
            { "America/Tijuana", America_Pacific },
            { "America/Toronto", America_Eastern },
            { "America/Tortola", Atlantic },
            { "America/Yakutat", Alaska },
            { "Asia/Choibalsan", Mongolia },
            { "Asia/Phnom_Penh", Indochina },
            { "Asia/Ulan_Bator", Mongolia },
            { "Atlantic/Azores", Azores },
            { "Atlantic/Canary", Europe_Western },
            { "Atlantic/Faeroe", Europe_Western },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Australia/North", Australia_Central },
            { "Australia/Perth", Australia_Western },
            { "Australia/South", Australia_Central },
            { "Canada/Atlantic", Atlantic },
            { "Canada/Mountain", America_Mountain },
            { "Europe/Belgrade", Europe_Central },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Europe/Busingen", Europe_Central },
            { "Europe/Chisinau", Europe_Eastern },
            { "Europe/Guernsey",
                new String[] {
                    "Greenwichko meridianoaren ordua",
                    "GMT",
                    "Londresko udako ordua",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Helsinki", Europe_Eastern },
            { "Europe/Sarajevo", Europe_Central },
            { "Europe/Tiraspol", Europe_Eastern },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "Indian/Maldives", French_Southern },
            { "Pacific/Chatham", Chatham },
            { "Pacific/Fakaofo", Tokelau },
            { "Pacific/Gambier", Gambier },
            { "Pacific/Norfolk", Norfolk },
            { "Pacific/Pohnpei", Solomon },
            { "SystemV/AST4ADT", Atlantic },
            { "SystemV/CST6CDT", America_Central },
            { "SystemV/EST5EDT", America_Eastern },
            { "SystemV/MST7MDT", America_Mountain },
            { "SystemV/PST8PDT", America_Pacific },
            { "SystemV/YST9YDT", Alaska },
            { "Africa/Bujumbura", Africa_Central },
            { "Africa/Mogadishu", Africa_Eastern },
            { "America/Anguilla", Atlantic },
            { "America/Asuncion", Paraguay },
            { "America/Atikokan", America_Eastern },
            { "America/Barbados", Atlantic },
            { "America/Dominica", Atlantic },
            { "America/Edmonton", America_Mountain },
            { "America/Eirunepe", Acre },
            { "America/Ensenada", America_Pacific },
            { "America/Mazatlan", Mexico_Pacific },
            { "America/Miquelon", Pierre_Miquelon },
            { "America/Montreal", America_Eastern },
            { "America/Resolute", America_Central },
            { "America/Santarem", Brasilia },
            { "America/Santiago", Chile },
            { "America/Shiprock", America_Mountain },
            { "America/St_Kitts", Atlantic },
            { "America/St_Lucia", Atlantic },
            { "America/Winnipeg", America_Central },
            { "Antarctica/Casey", Australia_Western },
            { "Antarctica/Davis", Davis },
            { "Antarctica/Syowa", Syowa },
            { "Antarctica/Troll", GMT },
            { "Asia/Ho_Chi_Minh", Indochina },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "Asia/Novosibirsk", Novosibirsk },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Vladivostok", Vladivostok },
            { "Atlantic/Bermuda", Atlantic },
            { "Atlantic/Madeira", Europe_Western },
            { "Atlantic/Stanley", Falkland },
            { "Australia/Currie", Australia_Eastern },
            { "Australia/Darwin", Australia_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Australia/Sydney", Australia_Eastern },
            { "Brazil/DeNoronha", Noronha },
            { "Europe/Amsterdam", Europe_Central },
            { "Europe/Gibraltar", Europe_Central },
            { "Europe/Ljubljana", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "Europe/Podgorica", Europe_Central },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Volgograd", Volgograd },
            { "Indian/Christmas", Christmas },
            { "Indian/Kerguelen", French_Southern },
            { "Indian/Mauritius", Mauritius },
            { "Mexico/BajaNorte", America_Pacific },
            { "Pacific/Auckland", New_Zealand },
            { "Pacific/Funafuti", Tuvalu },
            { "Pacific/Johnston",
                new String[] {
                    "Hawaii-Aleutiar uharteetako ordu estandarra",
                    "HST",
                    "Hawaii-Aleutiar uharteetako udako ordua",
                    "HDT",
                    "Hawaii-Aleutiar uharteetako ordua",
                    "HST",
                }
            },
            { "Pacific/Pitcairn", Pitcairn },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Lubumbashi", Africa_Central },
            { "Africa/Nouakchott", GMT },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/Araguaina", Brasilia },
            { "America/Boa_Vista", Amazon },
            { "America/Catamarca", Argentina },
            { "America/Chihuahua", America_Central },
            { "America/Fortaleza", Brasilia },
            { "America/Glace_Bay", Atlantic },
            { "America/Goose_Bay", Atlantic },
            { "America/Guatemala", America_Central },
            { "America/Guayaquil", Ecuador },
            { "America/Matamoros", America_Central },
            { "America/Menominee", America_Central },
            { "America/Monterrey", America_Central },
            { "America/Sao_Paulo", Brasilia },
            { "America/St_Thomas", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Antarctica/Mawson", Mawson },
            { "Antarctica/Vostok", Vostok },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "Chile/Continental", Chile },
            { "Europe/Bratislava", Europe_Central },
            { "Europe/Copenhagen", Europe_Central },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/San_Marino", Europe_Central },
            { "Europe/Simferopol", Moscow },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "Pacific/Galapagos", Galapagos },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "Pacific/Marquesas", Marquesas },
            { "Pacific/Pago_Pago", Samoa },
            { "Pacific/Rarotonga", Cook },
            { "Pacific/Tongatapu", Tonga },
            { "US/Indiana-Starke", America_Central },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Costa_Rica", America_Central },
            { "America/Grand_Turk", America_Eastern },
            { "America/Guadeloupe", Atlantic },
            { "America/Hermosillo", Mexico_Pacific },
            { "America/Kralendijk", Atlantic },
            { "America/Louisville", America_Eastern },
            { "America/Martinique", Atlantic },
            { "America/Metlakatla", Alaska },
            { "America/Montevideo", Uruguay },
            { "America/Montserrat", Atlantic },
            { "America/Paramaribo", Suriname },
            { "America/Porto_Acre", Acre },
            { "America/Rio_Branco", Acre },
            { "America/St_Vincent", Atlantic },
            { "America/Whitehorse", Yukon },
            { "Antarctica/McMurdo", New_Zealand },
            { "Antarctica/Rothera", Rothera },
            { "Asia/Ujung_Pandang", Indonesia_Central },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "Atlantic/Jan_Mayen", Europe_Central },
            { "Atlantic/Reykjavik", GMT },
            { "Atlantic/St_Helena", GMT },
            { "Australia/Adelaide", Australia_Central },
            { "Australia/Brisbane", Australia_Eastern },
            { "Australia/Canberra", Australia_Eastern },
            { "Australia/Lindeman", Australia_Eastern },
            { "Australia/Tasmania", Australia_Eastern },
            { "Australia/Victoria", Australia_Eastern },
            { "Chile/EasterIsland", Easter },
            { "Europe/Isle_of_Man",
                new String[] {
                    "Greenwichko meridianoaren ordua",
                    "GMT",
                    "Londresko udako ordua",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "Pacific/Kiritimati", Line_Islands },
            { "Africa/Johannesburg", Africa_Southern },
            { "America/El_Salvador", America_Central },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "America/Pangnirtung", America_Eastern },
            { "America/Porto_Velho", Amazon },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rainy_River", America_Central },
            { "America/Tegucigalpa", America_Central },
            { "America/Thunder_Bay", America_Eastern },
            { "America/Yellowknife", America_Mountain },
            { "Arctic/Longyearbyen", Europe_Central },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Australia/Melbourne", Australia_Eastern },
            { "Canada/Newfoundland", Newfoundland },
            { "Canada/Saskatchewan", America_Central },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Pacific/Guadalcanal", Solomon },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "America/Blanc-Sablon", Atlantic },
            { "America/Buenos_Aires", Argentina },
            { "America/Campo_Grande", Amazon },
            { "America/Danmarkshavn", GMT },
            { "America/Dawson_Creek", America_Mountain },
            { "America/Indiana/Knox", America_Central },
            { "America/Rankin_Inlet", America_Central },
            { "America/Santa_Isabel", America_Pacific },
            { "Antarctica/Macquarie", Australia_Eastern },
            { "Australia/Queensland", Australia_Eastern },
            { "Australia/Yancowinna", Australia_Central },
            { "Pacific/Port_Moresby", DumontDUrville },
            { "America/Cambridge_Bay", America_Mountain },
            { "America/Ciudad_Juarez", America_Mountain },
            { "America/Coral_Harbour", America_Eastern },
            { "America/Indiana/Vevay", America_Eastern },
            { "America/Lower_Princes", Atlantic },
            { "America/Port_of_Spain", Atlantic },
            { "America/Santo_Domingo", Atlantic },
            { "America/St_Barthelemy", Atlantic },
            { "America/Swift_Current", America_Central },
            { "Antarctica/South_Pole", New_Zealand },
            { "Australia/Broken_Hill", Australia_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Port-au-Prince", America_Eastern },
            { "Atlantic/South_Georgia", South_Georgia },
            { "America/Argentina/Jujuy", Argentina },
            { "America/Argentina/Salta", Argentina },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Argentina/Cordoba", Argentina },
            { "America/Argentina/Mendoza", Argentina },
            { "America/Argentina/Tucuman", Argentina },
            { "America/Argentina/Ushuaia", Argentina },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "timezone.excity.Asia/Hovd", "Khovd" },
            { "America/Argentina/La_Rioja", Argentina },
            { "America/Argentina/San_Juan", Argentina },
            { "America/Argentina/San_Luis", Argentina },
            { "America/Indiana/Petersburg", America_Eastern },
            { "timezone.excity.Asia/Aqtau", "Aktau" },
            { "timezone.excity.Asia/Chita", "Txita" },
            { "timezone.excity.Asia/Macau", "Macau" },
            { "timezone.excity.Asia/Seoul", "Seul" },
            { "timezone.excity.Asia/Tokyo", "Tokio" },
            { "America/Argentina/Catamarca", Argentina },
            { "America/Kentucky/Louisville", America_Eastern },
            { "America/Kentucky/Monticello", America_Eastern },
            { "America/North_Dakota/Beulah", America_Central },
            { "America/North_Dakota/Center", America_Central },
            { "timezone.excity.Asia/Aqtobe", "Aktobe" },
            { "timezone.excity.Asia/Muscat", "Maskat" },
            { "timezone.excity.Asia/Riyadh", "Riad" },
            { "timezone.excity.Asia/Tehran", "Teheran" },
            { "timezone.excity.Asia/Urumqi", "\u00dcr\u00fcmqi" },
            { "timezone.excity.Etc/Unknown", "Hiri ezezaguna" },
            { "timezone.excity.Europe/Kiev", "Kiev" },
            { "timezone.excity.Europe/Rome", "Erroma" },
            { "timezone.excity.Indian/Mahe", "Mah\u00e9" },
            { "America/Indiana/Indianapolis", America_Eastern },
            { "timezone.excity.Africa/Accra", "Akkra" },
            { "timezone.excity.Africa/Cairo", "Kairo" },
            { "timezone.excity.Asia/Baghdad", "Bagdad" },
            { "timezone.excity.Asia/Bishkek", "Bixkek" },
            { "timezone.excity.Asia/Colombo", "Kolombo" },
            { "timezone.excity.Asia/Karachi", "Karatxi" },
            { "timezone.excity.Asia/Nicosia", "Nikosia" },
            { "timezone.excity.Asia/Yakutsk", "Jakutsk" },
            { "timezone.excity.Asia/Yerevan", "Erevan" },
            { "timezone.excity.Africa/Bangui", "Bangi" },
            { "timezone.excity.Africa/Douala", "Duala" },
            { "timezone.excity.Africa/Niamey", "Niamei" },
            { "timezone.excity.America/Thule", "Qaanaaq" },
            { "timezone.excity.Asia/Ashgabat", "Asgabat" },
            { "timezone.excity.Asia/Calcutta", "Kalkuta" },
            { "timezone.excity.Asia/Damascus", "Damasko" },
            { "timezone.excity.Asia/Dushanbe", "Duxanbe" },
            { "timezone.excity.Asia/Katmandu", "Katmandu" },
            { "timezone.excity.Asia/Khandyga", "Khandiga" },
            { "timezone.excity.Asia/Qostanay", "Kostanay" },
            { "timezone.excity.Asia/Tashkent", "Taxkent" },
            { "timezone.excity.Europe/Athens", "Atenas" },
            { "timezone.excity.Europe/Lisbon", "Lisboa" },
            { "timezone.excity.Europe/London", "Londres" },
            { "timezone.excity.Europe/Madrid", "Madril" },
            { "timezone.excity.Europe/Monaco", "Monako" },
            { "timezone.excity.Europe/Moscow", "Mosku" },
            { "timezone.excity.Europe/Prague", "Praga" },
            { "timezone.excity.Europe/Tirane", "Tirana" },
            { "timezone.excity.Europe/Vienna", "Viena" },
            { "timezone.excity.Europe/Warsaw", "Varsovia" },
            { "timezone.excity.Europe/Zurich", "Z\u00fcrich" },
            { "timezone.excity.Pacific/Efate", "\u00c9fat\u00e9" },
            { "America/Argentina/Buenos_Aires", Argentina },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "America/North_Dakota/New_Salem", America_Central },
            { "timezone.excity.Africa/Algiers", "Aljer" },
            { "timezone.excity.Africa/Conakry", "Konakry" },
            { "timezone.excity.America/Cayman", "Kaiman" },
            { "timezone.excity.America/Cuiaba", "Cuiab\u00e1" },
            { "timezone.excity.America/Havana", "Habana" },
            { "timezone.excity.America/Maceio", "Macei\u00f3" },
            { "timezone.excity.Asia/Kamchatka", "Kamtxatka" },
            { "timezone.excity.Asia/Pyongyang", "Piongiang" },
            { "timezone.excity.Asia/Qyzylorda", "Kyzylorda" },
            { "timezone.excity.Asia/Samarkand", "Samarkanda" },
            { "timezone.excity.Asia/Singapore", "Singapur" },
            { "timezone.excity.Asia/Vientiane", "Vientian" },
            { "timezone.excity.Europe/Vatican", "Vatikano Hiria" },
            { "timezone.excity.Pacific/Easter", "Pazko uhartea" },
            { "timezone.excity.Pacific/Noumea", "Noum\u00e9a" },
            { "timezone.excity.Africa/Djibouti", "Djibuti" },
            { "timezone.excity.Africa/El_Aaiun", "Aaiun" },
            { "timezone.excity.Africa/Khartoum", "Khartum" },
            { "timezone.excity.Africa/Ndjamena", "N\u2019djamena" },
            { "timezone.excity.America/Cordoba", "C\u00f3rdoba" },
            { "timezone.excity.America/Jamaica", "Jamaika" },
            { "timezone.excity.Asia/Choibalsan", "Txoibalsan" },
            { "timezone.excity.Atlantic/Azores", "Azoreak" },
            { "timezone.excity.Atlantic/Canary", "Kanariak" },
            { "timezone.excity.Europe/Belgrade", "Belgrad" },
            { "timezone.excity.Europe/Brussels", "Brusela" },
            { "timezone.excity.Europe/Busingen", "B\u00fcsingen" },
            { "timezone.excity.Europe/Guernsey", "Guernesey" },
            { "timezone.excity.Indian/Maldives", "Maldivak" },
            { "timezone.excity.Africa/Mogadishu", "Muqdisho" },
            { "timezone.excity.America/Anguilla", "Aingira" },
            { "timezone.excity.America/Dominica", "Dominika" },
            { "timezone.excity.America/Eirunepe", "Eirunep\u00e9" },
            { "timezone.excity.America/Mazatlan", "Mazatl\u00e1n" },
            { "timezone.excity.America/Miquelon", "Mikelune" },
            { "timezone.excity.America/Santarem", "Santar\u00e9m" },
            { "timezone.excity.America/St_Johns", "Saint John\u2019s" },
            { "timezone.excity.America/St_Kitts", "Saint Kitts" },
            { "timezone.excity.America/St_Lucia", "Santa Luzia" },
            { "timezone.excity.Asia/Krasnoyarsk", "Krasnoiarsk" },
            { "timezone.excity.Asia/Ulaanbaatar", "Ulan Bator" },
            { "timezone.excity.Europe/Bucharest", "Bukarest" },
            { "timezone.excity.Europe/Ulyanovsk", "Ulianovsk" },
            { "timezone.excity.Indian/Mauritius", "Maurizio" },
            { "timezone.excity.Pacific/Honolulu", "Honolulu" },
            { "timezone.excity.Africa/Nouakchott", "Nuakxot" },
            { "timezone.excity.Africa/Porto-Novo", "Porto Novo" },
            { "timezone.excity.America/Araguaina", "Aragua\u00edna" },
            { "timezone.excity.America/Sao_Paulo", "S\u00e3o Paulo" },
            { "timezone.excity.America/St_Thomas", "Saint-Thomas" },
            { "timezone.excity.Europe/Copenhagen", "Kopenhage" },
            { "timezone.excity.Europe/Luxembourg", "Luxenburgo" },
            { "timezone.excity.Pacific/Enderbury", "Enderbury" },
            { "timezone.excity.Pacific/Galapagos", "Galapagoak" },
            { "timezone.excity.Pacific/Marquesas", "Markesak" },
            { "timezone.excity.Africa/Addis_Ababa", "Addis Abeba" },
            { "timezone.excity.Africa/Ouagadougou", "Uagadugu" },
            { "timezone.excity.America/Guadeloupe", "Guadalupe" },
            { "timezone.excity.America/Martinique", "Martinika" },
            { "timezone.excity.America/St_Vincent", "Saint Vincent" },
            { "timezone.excity.Asia/Srednekolymsk", "Srednekolimsk" },
            { "timezone.excity.Asia/Yekaterinburg", "Jekaterinburg" },
            { "timezone.excity.Atlantic/St_Helena", "Santa Helena" },
            { "timezone.excity.Europe/Isle_of_Man", "Man uhartea" },
            { "timezone.excity.America/Mexico_City", "Mexiko Hiria" },
            { "timezone.excity.Atlantic/Cape_Verde", "Cabo Verde" },
            { "timezone.excity.America/Port_of_Spain", "Port-of-Spain" },
            { "timezone.excity.America/St_Barthelemy", "Saint-Barth\u00e9lemy" },
            { "timezone.excity.Atlantic/South_Georgia", "Hegoaldeko Georgiak" },
            { "timezone.excity.America/Argentina/Tucuman", "Tucum\u00e1n" },
            { "timezone.excity.America/North_Dakota/Beulah", "Beulah, Ipar Dakota" },
            { "timezone.excity.America/North_Dakota/Center", "Center, Ipar Dakota" },
            { "timezone.excity.America/North_Dakota/New_Salem", "New Salem, Ipar Dakota" },
        };
        return data;
    }
}
