info = {
    "name": "nl",
    "date_order": "DMY",
    "january": [
        "jan",
        "januari"
    ],
    "february": [
        "feb",
        "februari"
    ],
    "march": [
        "maart",
        "mrt"
    ],
    "april": [
        "apr",
        "april"
    ],
    "may": [
        "mei"
    ],
    "june": [
        "jun",
        "juni"
    ],
    "july": [
        "jul",
        "juli"
    ],
    "august": [
        "aug",
        "augustus"
    ],
    "september": [
        "sep",
        "september"
    ],
    "october": [
        "okt",
        "oktober"
    ],
    "november": [
        "nov",
        "november"
    ],
    "december": [
        "dec",
        "december"
    ],
    "monday": [
        "ma",
        "maandag"
    ],
    "tuesday": [
        "di",
        "dinsdag"
    ],
    "wednesday": [
        "wo",
        "woensdag"
    ],
    "thursday": [
        "do",
        "donderdag"
    ],
    "friday": [
        "vr",
        "vrijdag"
    ],
    "saturday": [
        "za",
        "zaterdag"
    ],
    "sunday": [
        "zo",
        "zondag"
    ],
    "am": [
        "am"
    ],
    "pm": [
        "pm"
    ],
    "year": [
        "jaar",
        "jr"
    ],
    "month": [
        "maand",
        "mnd",
        "maanden"
    ],
    "week": [
        "week",
        "wk",
        "weken"
    ],
    "day": [
        "dag",
        "dagen"
    ],
    "hour": [
        "uur"
    ],
    "minute": [
        "min",
        "minuut",
        "minuten"
    ],
    "second": [
        "s",
        "sec",
        "seconde",
        "seconden"
    ],
    "relative-type": {
        "0 day ago": [
            "vandaag"
        ],
        "0 hour ago": [
            "binnen een uur"
        ],
        "0 minute ago": [
            "binnen een minuut"
        ],
        "0 month ago": [
            "deze maand"
        ],
        "0 second ago": [
            "nu"
        ],
        "0 week ago": [
            "deze week"
        ],
        "0 year ago": [
            "dit jaar"
        ],
        "1 day ago": [
            "gisteren"
        ],
        "1 month ago": [
            "vorige maand"
        ],
        "1 week ago": [
            "vorige week"
        ],
        "1 year ago": [
            "vorig jaar",
            "vorige jaar"
        ],
        "in 1 day": [
            "morgen"
        ],
        "in 1 month": [
            "volgende maand"
        ],
        "in 1 week": [
            "volgende week"
        ],
        "in 1 year": [
            "volgend jaar"
        ],
        "2 day ago": [
            "eergisteren"
        ],
        "in 2 day": [
            "overmorgen"
        ]
    },
    "relative-type-regex": {
        "\\1 day ago": [
            "(\\d+) dag geleden",
            "(\\d+) dagen geleden",
            "(\\d+) dgn geleden"
        ],
        "\\1 hour ago": [
            "(\\d+) uur geleden"
        ],
        "\\1 minute ago": [
            "(\\d+) min geleden",
            "(\\d+) minuten geleden",
            "(\\d+) minuut geleden"
        ],
        "\\1 month ago": [
            "(\\d+) maand geleden",
            "(\\d+) maanden geleden"
        ],
        "\\1 second ago": [
            "(\\d+) sec geleden",
            "(\\d+) seconde geleden",
            "(\\d+) seconden geleden"
        ],
        "\\1 week ago": [
            "(\\d+) week geleden",
            "(\\d+) weken geleden"
        ],
        "\\1 year ago": [
            "(\\d+) jaar geleden"
        ],
        "in \\1 day": [
            "over (\\d+) dag",
            "over (\\d+) dagen",
            "over (\\d+) dgn"
        ],
        "in \\1 hour": [
            "over (\\d+) uur"
        ],
        "in \\1 minute": [
            "over (\\d+) min",
            "over (\\d+) minuten",
            "over (\\d+) minuut"
        ],
        "in \\1 month": [
            "over (\\d+) maand",
            "over (\\d+) maanden"
        ],
        "in \\1 second": [
            "over (\\d+) sec",
            "over (\\d+) seconde",
            "over (\\d+) seconden"
        ],
        "in \\1 week": [
            "over (\\d+) week",
            "over (\\d+) weken"
        ],
        "in \\1 year": [
            "over (\\d+) jaar"
        ]
    },
    "locale_specific": {
        "nl-AW": {
            "name": "nl-AW"
        },
        "nl-BE": {
            "name": "nl-BE"
        },
        "nl-BQ": {
            "name": "nl-BQ"
        },
        "nl-CW": {
            "name": "nl-CW"
        },
        "nl-SR": {
            "name": "nl-SR"
        },
        "nl-SX": {
            "name": "nl-SX"
        }
    },
    "skip": [
        "om",
        " ",
        "'",
        ",",
        "-",
        ".",
        "/",
        ";",
        "@",
        "[",
        "]",
        "|",
        "，"
    ],
    "sentence_splitter_group": 1,
    "ago": [
        "geleden"
    ],
    "in": [
        "in"
    ]
}
