/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.comp.Calc.NLPSolver;

import com.sun.star.comp.Calc.NLPSolver.BaseNLPSolver;
import com.sun.star.comp.Calc.NLPSolver.PropertyInfo;
import com.sun.star.comp.Calc.NLPSolver.dialogs.DummyEvolutionarySolverStatusDialog;
import com.sun.star.comp.Calc.NLPSolver.dialogs.EvolutionarySolverStatusUno;
import com.sun.star.comp.Calc.NLPSolver.dialogs.IEvolutionarySolverStatusDialog;
import com.sun.star.uno.XComponentContext;
import java.util.ArrayList;
import net.adaptivebox.global.RandomGenerator;
import net.adaptivebox.goodness.ACRComparator;
import net.adaptivebox.goodness.BCHComparator;
import net.adaptivebox.goodness.IGoodnessCompareEngine;
import net.adaptivebox.knowledge.Library;
import net.adaptivebox.knowledge.SearchPoint;
import net.adaptivebox.problem.ProblemEncoder;

public abstract class BaseEvolutionarySolver
extends BaseNLPSolver {
    protected CalcProblemEncoder m_problemEncoder;
    protected Library m_library;
    protected IGoodnessCompareEngine m_envCompareEngine;
    protected IGoodnessCompareEngine m_specCompareEngine;
    protected SearchPoint m_totalBestPoint;
    protected int m_toleratedCount;
    protected double m_toleratedMin;
    protected double m_toleratedMax;
    private final ArrayList<Variable> m_variables = new ArrayList();
    protected PropertyInfo<Integer> m_swarmSize = new PropertyInfo<Integer>("SwarmSize", 70, "Size of Swarm");
    protected PropertyInfo<Integer> m_librarySize = new PropertyInfo<Integer>("LibrarySize", 210, "Size of Library");
    protected PropertyInfo<Integer> m_learningCycles = new PropertyInfo<Integer>("LearningCycles", 2000, "Learning Cycles");
    private final PropertyInfo<Boolean> m_guessVariableRange = new PropertyInfo<Boolean>("GuessVariableRange", true, "Variable Bounds Guessing");
    private final PropertyInfo<Double> m_variableRangeThreshold = new PropertyInfo<Double>("VariableRangeThreshold", 3.0, "Variable Bounds Threshold (when guessing)");
    private final PropertyInfo<Boolean> m_useACRComperator = new PropertyInfo<Boolean>("UseACRComparator", false, "Use ACR Comparator (instead of BCH)");
    private final PropertyInfo<Boolean> m_useRandomStartingPoint = new PropertyInfo<Boolean>("UseRandomStartingPoint", false, "Use Random starting point");
    private final PropertyInfo<Boolean> m_useStrongerPRNG = new PropertyInfo<Boolean>("UseStrongerPRNG", false, "Use a stronger random generator (slower)");
    protected PropertyInfo<Integer> m_required = new PropertyInfo<Integer>("StagnationLimit", 70, "Stagnation Limit");
    protected PropertyInfo<Double> m_tolerance = new PropertyInfo<Double>("Tolerance", 1.0E-6, "Stagnation Tolerance");
    private final PropertyInfo<Boolean> m_enhancedSolverStatus = new PropertyInfo<Boolean>("EnhancedSolverStatus", true, "Show enhanced solver status");
    protected IEvolutionarySolverStatusDialog m_solverStatusDialog;

    public BaseEvolutionarySolver(XComponentContext xComponentContext, String string) {
        super(xComponentContext, string);
        this.registerProperty(this.m_swarmSize);
        this.registerProperty(this.m_learningCycles);
        this.registerProperty(this.m_guessVariableRange);
        this.registerProperty(this.m_variableRangeThreshold);
        this.registerProperty(this.m_useACRComperator);
        this.registerProperty(this.m_useRandomStartingPoint);
        this.registerProperty(this.m_useStrongerPRNG);
        this.registerProperty(this.m_required);
        this.registerProperty(this.m_tolerance);
        this.registerProperty(this.m_enhancedSolverStatus);
    }

    private void prepareVariables(double[][] dArray) {
        this.m_variables.clear();
        for (int i = 0; i < this.m_variableCount; ++i) {
            Variable variable = new Variable(this.m_variableMap[i], i);
            variable.MinValue = dArray[i][0];
            variable.MaxValue = dArray[i][1];
            variable.Granularity = dArray[i][2];
            this.m_variables.add(variable);
        }
    }

    @Override
    protected void initializeSolve() {
        super.initializeSolve();
        if (this.m_variableCount == 0) {
            return;
        }
        this.m_solverStatusDialog = this.m_enhancedSolverStatus.getValue() != false ? new EvolutionarySolverStatusUno(this.m_xContext) : new DummyEvolutionarySolverStatusDialog();
        double[][] dArray = new double[this.m_variableCount][3];
        for (int i = 0; i < this.m_variableCount; ++i) {
            if (this.m_guessVariableRange.getValue().booleanValue()) {
                double d;
                double d2;
                double d3 = this.m_variableCells[i].getValue();
                if (d3 == 0.0) {
                    d3 = 1000.0;
                }
                if (((Boolean)this.m_assumeNonNegative.getValue()).booleanValue()) {
                    d2 = 0.0;
                    d = d3 + d3 * 2.0 * this.m_variableRangeThreshold.getValue();
                } else {
                    d2 = d3 + d3 * this.m_variableRangeThreshold.getValue();
                    d = d3 - d3 * this.m_variableRangeThreshold.getValue();
                }
                dArray[i][0] = Math.min(d2, d);
                dArray[i][1] = Math.max(d2, d);
            } else {
                dArray[i][0] = (Boolean)this.m_assumeNonNegative.getValue() != false ? 0.0 : -1.0E308;
                dArray[i][1] = 1.0E308;
            }
            dArray[i][2] = 0.0;
        }
        ArrayList<BaseNLPSolver.ExtSolverConstraint> arrayList = new ArrayList<BaseNLPSolver.ExtSolverConstraint>();
        for (int i = 0; i < this.m_constraintCount; ++i) {
            Double d = this.m_extConstraints[i].Right != null ? null : Double.valueOf(this.m_extConstraints[i].Data);
            boolean bl = false;
            if (this.m_extConstraints[i].Right == null) {
                block11: for (int j = 0; j < this.m_variableCount && !bl; ++j) {
                    if (this.m_constraints[i].Left.Sheet != ((BaseNLPSolver)this).m_variables[j].Sheet || this.m_constraints[i].Left.Column != ((BaseNLPSolver)this).m_variables[j].Column || this.m_constraints[i].Left.Row != ((BaseNLPSolver)this).m_variables[j].Row) continue;
                    bl = true;
                    switch (this.m_extConstraints[i].Operator.getValue()) {
                        case 1: {
                            if (d == null) continue block11;
                            dArray[j][0] = d;
                            dArray[j][1] = d;
                            continue block11;
                        }
                        case 2: {
                            if (d == null) continue block11;
                            dArray[j][0] = d;
                            continue block11;
                        }
                        case 0: {
                            if (d == null) continue block11;
                            dArray[j][1] = d;
                            continue block11;
                        }
                        case 3: {
                            dArray[j][2] = 1.0;
                            continue block11;
                        }
                        case 4: {
                            dArray[j][0] = 0.0;
                            dArray[j][1] = 1.0;
                            dArray[j][2] = 1.0;
                            continue block11;
                        }
                        default: {
                            bl = false;
                        }
                    }
                }
            }
            if (bl) continue;
            arrayList.add(this.m_extConstraints[i]);
        }
        this.prepareVariables(dArray);
        try {
            this.m_problemEncoder = new CalcProblemEncoder(this.m_variables, arrayList);
        }
        catch (Exception exception) {
            this.m_problemEncoder = null;
            return;
        }
        this.m_library = new Library(this.m_librarySize.getValue(), this.m_problemEncoder);
        if (this.m_useRandomStartingPoint.getValue().booleanValue()) {
            this.m_totalBestPoint = this.m_problemEncoder.getEncodedSearchPoint();
        } else {
            this.m_totalBestPoint = this.m_problemEncoder.getFreshSearchPoint();
            double[] dArray2 = new double[this.m_variables.size()];
            for (int i = 0; i < this.m_variables.size(); ++i) {
                dArray2[i] = this.m_currentParameters[this.m_variables.get(i).OriginalVariable];
            }
            this.m_totalBestPoint.importLocation(dArray2);
            this.m_problemEncoder.evaluate(this.m_totalBestPoint);
        }
        this.m_library.getSelectedPoint(0).importPoint(this.m_totalBestPoint);
        this.m_solverStatusDialog.setBestSolution(this.m_totalBestPoint.getObjectiveValue(), this.checkConstraints());
        this.m_envCompareEngine = new BCHComparator();
        this.m_specCompareEngine = this.m_useACRComperator.getValue() != false ? new ACRComparator(this.m_library, this.m_learningCycles.getValue()) : new BCHComparator();
        RandomGenerator.useStrongerGenerator(this.m_useStrongerPRNG.getValue());
    }

    protected void applySolution() {
        double[] dArray = this.m_totalBestPoint.getLocation();
        this.m_problemEncoder.getDesignSpace().getMappingPoint(dArray);
        for (int i = 0; i < this.m_variableCount; ++i) {
            this.m_variableCells[i].setValue(dArray[i]);
            this.m_currentParameters[i] = dArray[i];
        }
        this.m_functionValue = this.m_objectiveCell.getValue();
    }

    @Override
    protected void finalizeSolve() {
        this.applySolution();
        this.m_success = this.m_objectiveCell.getError() == 0 && this.checkConstraints();
        this.m_solverStatusDialog.setVisible(false);
        this.m_solverStatusDialog.dispose();
        super.finalizeSolve();
    }

    private boolean checkConstraints() {
        boolean bl = true;
        for (int i = 0; i < this.m_constraintCount && bl; ++i) {
            if (this.m_extConstraints[i].Left.getError() == 0) {
                double d = this.m_extConstraints[i].getLeftValue();
                double d2 = this.m_extConstraints[i].Data;
                switch (this.m_extConstraints[i].Operator.getValue()) {
                    case 1: {
                        bl = d == d2;
                        break;
                    }
                    case 2: {
                        bl = d >= d2;
                        break;
                    }
                    case 0: {
                        bl = d <= d2;
                        break;
                    }
                    case 3: {
                        bl = Math.rint(d) == d;
                        break;
                    }
                    case 4: {
                        bl = d == 0.0 || d == 1.0;
                    }
                }
                continue;
            }
            bl = false;
        }
        return bl;
    }

    private static class Variable {
        private final BaseNLPSolver.CellMap CellMap;
        private final int OriginalVariable;
        private double MinValue;
        private double MaxValue;
        private double Granularity;

        private Variable(BaseNLPSolver.CellMap cellMap, int n) {
            this.CellMap = cellMap;
            this.OriginalVariable = n;
            this.MinValue = -1.0E308;
            this.MaxValue = 1.0E308;
            this.Granularity = 0.0;
        }
    }

    private class CalcProblemEncoder
    extends ProblemEncoder {
        private final ArrayList<Variable> m_variables;
        private final ArrayList<BaseNLPSolver.ExtSolverConstraint> m_constraints;

        private CalcProblemEncoder(ArrayList<Variable> arrayList, ArrayList<BaseNLPSolver.ExtSolverConstraint> arrayList2) throws Exception {
            Object object;
            int n;
            super(arrayList.size(), 1 + arrayList2.size());
            this.m_variables = arrayList;
            this.m_constraints = arrayList2;
            double d = BaseEvolutionarySolver.this.m_maximize ? 1.0E308 : -1.0E308;
            this.setDefaultYAt(0, d, d);
            block7: for (n = 0; n < arrayList2.size(); ++n) {
                object = arrayList2.get(n);
                switch (((BaseNLPSolver.ExtSolverConstraint)object).Operator.getValue()) {
                    case 1: {
                        this.setDefaultYAt(n + 1, ((BaseNLPSolver.ExtSolverConstraint)object).Data, ((BaseNLPSolver.ExtSolverConstraint)object).Data);
                        continue block7;
                    }
                    case 2: {
                        this.setDefaultYAt(n + 1, ((BaseNLPSolver.ExtSolverConstraint)object).Data, 1.0E308);
                        continue block7;
                    }
                    case 0: {
                        this.setDefaultYAt(n + 1, -1.0E308, ((BaseNLPSolver.ExtSolverConstraint)object).Data);
                        continue block7;
                    }
                    case 3: {
                        this.setDefaultYAt(n + 1, -1.0E308, 1.0E308);
                        continue block7;
                    }
                    case 4: {
                        this.setDefaultYAt(n + 1, 0.0, 1.0);
                    }
                }
            }
            for (n = 0; n < this.m_variables.size(); ++n) {
                object = this.m_variables.get(n);
                this.setDefaultXAt(n, ((Variable)object).MinValue, ((Variable)object).MaxValue, ((Variable)object).Granularity);
            }
        }

        @Override
        protected double calcTargetAt(int n, double[] dArray) {
            if (n == 0) {
                int n2;
                for (n2 = 0; n2 < this.m_variables.size(); ++n2) {
                    BaseNLPSolver.CellMap cellMap = this.m_variables.get(n2).CellMap;
                    BaseEvolutionarySolver.this.m_variableData[cellMap.Range][cellMap.Row][cellMap.Col] = dArray[n2];
                }
                for (n2 = 0; n2 < BaseEvolutionarySolver.this.m_cellRangeCount; ++n2) {
                    BaseEvolutionarySolver.this.m_cellRangeData[n2].setData(BaseEvolutionarySolver.this.m_variableData[n2]);
                }
                if (BaseEvolutionarySolver.this.m_objectiveCell.getError() != 0) {
                    return BaseEvolutionarySolver.this.m_maximize ? -1.0E308 : 1.0E308;
                }
                double d = BaseEvolutionarySolver.this.m_objectiveCell.getValue();
                if (d >= BaseEvolutionarySolver.this.m_toleratedMin && d <= BaseEvolutionarySolver.this.m_toleratedMax && BaseEvolutionarySolver.this.checkConstraints()) {
                    ++BaseEvolutionarySolver.this.m_toleratedCount;
                }
                return d;
            }
            return this.m_constraints.get(n - 1).getLeftValue();
        }
    }
}

