/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index.codec.util;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.stream.IntStream;
import org.apache.lucene.util.BytesRef;
import org.opensearch.knn.index.codec.util.KNNVectorSerializer;

public class KNNVectorAsCollectionOfFloatsSerializer
implements KNNVectorSerializer {
    private static final int BYTES_IN_FLOAT = 4;

    @Override
    public byte[] floatToByteArray(float[] input) {
        ByteBuffer bb = ByteBuffer.allocate(input.length * 4).order(ByteOrder.BIG_ENDIAN);
        IntStream.range(0, input.length).forEach(index -> bb.putFloat(input[index]));
        byte[] bytes = new byte[bb.flip().limit()];
        bb.get(bytes);
        return bytes;
    }

    @Override
    public float[] byteToFloatArray(BytesRef bytesRef) {
        if (bytesRef == null || bytesRef.length % 4 != 0) {
            throw new IllegalArgumentException("Byte stream cannot be deserialized to array of floats");
        }
        int sizeOfFloatArray = bytesRef.length / 4;
        float[] vector = new float[sizeOfFloatArray];
        ByteBuffer.wrap(bytesRef.bytes, bytesRef.offset, bytesRef.length).asFloatBuffer().get(vector);
        return vector;
    }
}

