# Generated by get_iana_data.py @ 2024-06-07T21:30:17.411566+00:00

from typing import NamedTuple


class ZoneData(NamedTuple):
    key: str
    full_name: str
    short_name: str
    country_code: str
    country_name: str


def get_zone_data(key: str) -> ZoneData:
    return ZoneData(*ZONE_DATA[key])


ZONE_DATA = {
    'Africa/Abidjan': ('Africa/Abidjan', 'Africa/Abidjan', 'Abidjan', 'CI', "Côte d'Ivoire"),
    'Africa/Accra': ('Africa/Accra', 'Africa/Accra', 'Accra', 'GH', 'Ghana'),
    'Africa/Addis_Ababa': ('Africa/Addis_Ababa', 'Africa/Addis Ababa', 'Addis Ababa', 'ET', 'Ethiopia'),
    'Africa/Algiers': ('Africa/Algiers', 'Africa/Algiers', 'Algiers', 'DZ', 'Algeria'),
    'Africa/Asmara': ('Africa/Asmara', 'Africa/Asmara', 'Asmara', 'ER', 'Eritrea'),
    'Africa/Bamako': ('Africa/Bamako', 'Africa/Bamako', 'Bamako', 'ML', 'Mali'),
    'Africa/Bangui': ('Africa/Bangui', 'Africa/Bangui', 'Bangui', 'CF', 'Central African Rep.'),
    'Africa/Banjul': ('Africa/Banjul', 'Africa/Banjul', 'Banjul', 'GM', 'Gambia'),
    'Africa/Bissau': ('Africa/Bissau', 'Africa/Bissau', 'Bissau', 'GW', 'Guinea-Bissau'),
    'Africa/Blantyre': ('Africa/Blantyre', 'Africa/Blantyre', 'Blantyre', 'MW', 'Malawi'),
    'Africa/Brazzaville': ('Africa/Brazzaville', 'Africa/Brazzaville', 'Brazzaville', 'CG', 'Congo (Rep.)'),
    'Africa/Bujumbura': ('Africa/Bujumbura', 'Africa/Bujumbura', 'Bujumbura', 'BI', 'Burundi'),
    'Africa/Cairo': ('Africa/Cairo', 'Africa/Cairo', 'Cairo', 'EG', 'Egypt'),
    'Africa/Casablanca': ('Africa/Casablanca', 'Africa/Casablanca', 'Casablanca', 'MA', 'Morocco'),
    'Africa/Ceuta': ('Africa/Ceuta', 'Africa/Ceuta', 'Ceuta', 'ES', 'Spain'),
    'Africa/Conakry': ('Africa/Conakry', 'Africa/Conakry', 'Conakry', 'GN', 'Guinea'),
    'Africa/Dakar': ('Africa/Dakar', 'Africa/Dakar', 'Dakar', 'SN', 'Senegal'),
    'Africa/Dar_es_Salaam': ('Africa/Dar_es_Salaam', 'Africa/Dar es Salaam', 'Dar es Salaam', 'TZ', 'Tanzania'),
    'Africa/Djibouti': ('Africa/Djibouti', 'Africa/Djibouti', 'Djibouti', 'DJ', 'Djibouti'),
    'Africa/Douala': ('Africa/Douala', 'Africa/Douala', 'Douala', 'CM', 'Cameroon'),
    'Africa/El_Aaiun': ('Africa/El_Aaiun', 'Africa/El Aaiun', 'El Aaiun', 'EH', 'Western Sahara'),
    'Africa/Freetown': ('Africa/Freetown', 'Africa/Freetown', 'Freetown', 'SL', 'Sierra Leone'),
    'Africa/Gaborone': ('Africa/Gaborone', 'Africa/Gaborone', 'Gaborone', 'BW', 'Botswana'),
    'Africa/Harare': ('Africa/Harare', 'Africa/Harare', 'Harare', 'ZW', 'Zimbabwe'),
    'Africa/Johannesburg': ('Africa/Johannesburg', 'Africa/Johannesburg', 'Johannesburg', 'ZA', 'South Africa'),
    'Africa/Juba': ('Africa/Juba', 'Africa/Juba', 'Juba', 'SS', 'South Sudan'),
    'Africa/Kampala': ('Africa/Kampala', 'Africa/Kampala', 'Kampala', 'UG', 'Uganda'),
    'Africa/Khartoum': ('Africa/Khartoum', 'Africa/Khartoum', 'Khartoum', 'SD', 'Sudan'),
    'Africa/Kigali': ('Africa/Kigali', 'Africa/Kigali', 'Kigali', 'RW', 'Rwanda'),
    'Africa/Kinshasa': ('Africa/Kinshasa', 'Africa/Kinshasa', 'Kinshasa', 'CD', 'Congo (Dem. Rep.)'),
    'Africa/Lagos': ('Africa/Lagos', 'Africa/Lagos', 'Lagos', 'NG', 'Nigeria'),
    'Africa/Libreville': ('Africa/Libreville', 'Africa/Libreville', 'Libreville', 'GA', 'Gabon'),
    'Africa/Lome': ('Africa/Lome', 'Africa/Lome', 'Lome', 'TG', 'Togo'),
    'Africa/Luanda': ('Africa/Luanda', 'Africa/Luanda', 'Luanda', 'AO', 'Angola'),
    'Africa/Lubumbashi': ('Africa/Lubumbashi', 'Africa/Lubumbashi', 'Lubumbashi', 'CD', 'Congo (Dem. Rep.)'),
    'Africa/Lusaka': ('Africa/Lusaka', 'Africa/Lusaka', 'Lusaka', 'ZM', 'Zambia'),
    'Africa/Malabo': ('Africa/Malabo', 'Africa/Malabo', 'Malabo', 'GQ', 'Equatorial Guinea'),
    'Africa/Maputo': ('Africa/Maputo', 'Africa/Maputo', 'Maputo', 'MZ', 'Mozambique'),
    'Africa/Maseru': ('Africa/Maseru', 'Africa/Maseru', 'Maseru', 'LS', 'Lesotho'),
    'Africa/Mbabane': ('Africa/Mbabane', 'Africa/Mbabane', 'Mbabane', 'SZ', 'Eswatini (Swaziland)'),
    'Africa/Mogadishu': ('Africa/Mogadishu', 'Africa/Mogadishu', 'Mogadishu', 'SO', 'Somalia'),
    'Africa/Monrovia': ('Africa/Monrovia', 'Africa/Monrovia', 'Monrovia', 'LR', 'Liberia'),
    'Africa/Nairobi': ('Africa/Nairobi', 'Africa/Nairobi', 'Nairobi', 'KE', 'Kenya'),
    'Africa/Ndjamena': ('Africa/Ndjamena', 'Africa/Ndjamena', 'Ndjamena', 'TD', 'Chad'),
    'Africa/Niamey': ('Africa/Niamey', 'Africa/Niamey', 'Niamey', 'NE', 'Niger'),
    'Africa/Nouakchott': ('Africa/Nouakchott', 'Africa/Nouakchott', 'Nouakchott', 'MR', 'Mauritania'),
    'Africa/Ouagadougou': ('Africa/Ouagadougou', 'Africa/Ouagadougou', 'Ouagadougou', 'BF', 'Burkina Faso'),
    'Africa/Porto-Novo': ('Africa/Porto-Novo', 'Africa/Porto-Novo', 'Porto-Novo', 'BJ', 'Benin'),
    'Africa/Sao_Tome': ('Africa/Sao_Tome', 'Africa/Sao Tome', 'Sao Tome', 'ST', 'Sao Tome & Principe'),
    'Africa/Tripoli': ('Africa/Tripoli', 'Africa/Tripoli', 'Tripoli', 'LY', 'Libya'),
    'Africa/Tunis': ('Africa/Tunis', 'Africa/Tunis', 'Tunis', 'TN', 'Tunisia'),
    'Africa/Windhoek': ('Africa/Windhoek', 'Africa/Windhoek', 'Windhoek', 'NA', 'Namibia'),
    'America/Adak': ('America/Adak', 'America/Adak', 'Adak', 'US', 'United States'),
    'America/Anchorage': ('America/Anchorage', 'America/Anchorage', 'Anchorage', 'US', 'United States'),
    'America/Anguilla': ('America/Anguilla', 'America/Anguilla', 'Anguilla', 'AI', 'Anguilla'),
    'America/Antigua': ('America/Antigua', 'America/Antigua', 'Antigua', 'AG', 'Antigua & Barbuda'),
    'America/Araguaina': ('America/Araguaina', 'America/Araguaina', 'Araguaina', 'BR', 'Brazil'),
    'America/Argentina/Buenos_Aires': ('America/Argentina/Buenos_Aires', 'America/Argentina/Buenos Aires', 'Buenos Aires', 'AR', 'Argentina'),
    'America/Argentina/Catamarca': ('America/Argentina/Catamarca', 'America/Argentina/Catamarca', 'Catamarca', 'AR', 'Argentina'),
    'America/Argentina/Cordoba': ('America/Argentina/Cordoba', 'America/Argentina/Cordoba', 'Cordoba', 'AR', 'Argentina'),
    'America/Argentina/Jujuy': ('America/Argentina/Jujuy', 'America/Argentina/Jujuy', 'Jujuy', 'AR', 'Argentina'),
    'America/Argentina/La_Rioja': ('America/Argentina/La_Rioja', 'America/Argentina/La Rioja', 'La Rioja', 'AR', 'Argentina'),
    'America/Argentina/Mendoza': ('America/Argentina/Mendoza', 'America/Argentina/Mendoza', 'Mendoza', 'AR', 'Argentina'),
    'America/Argentina/Rio_Gallegos': ('America/Argentina/Rio_Gallegos', 'America/Argentina/Rio Gallegos', 'Rio Gallegos', 'AR', 'Argentina'),
    'America/Argentina/Salta': ('America/Argentina/Salta', 'America/Argentina/Salta', 'Salta', 'AR', 'Argentina'),
    'America/Argentina/San_Juan': ('America/Argentina/San_Juan', 'America/Argentina/San Juan', 'San Juan', 'AR', 'Argentina'),
    'America/Argentina/San_Luis': ('America/Argentina/San_Luis', 'America/Argentina/San Luis', 'San Luis', 'AR', 'Argentina'),
    'America/Argentina/Tucuman': ('America/Argentina/Tucuman', 'America/Argentina/Tucuman', 'Tucuman', 'AR', 'Argentina'),
    'America/Argentina/Ushuaia': ('America/Argentina/Ushuaia', 'America/Argentina/Ushuaia', 'Ushuaia', 'AR', 'Argentina'),
    'America/Aruba': ('America/Aruba', 'America/Aruba', 'Aruba', 'AW', 'Aruba'),
    'America/Asuncion': ('America/Asuncion', 'America/Asuncion', 'Asuncion', 'PY', 'Paraguay'),
    'America/Atikokan': ('America/Atikokan', 'America/Atikokan', 'Atikokan', 'CA', 'Canada'),
    'America/Bahia': ('America/Bahia', 'America/Bahia', 'Bahia', 'BR', 'Brazil'),
    'America/Bahia_Banderas': ('America/Bahia_Banderas', 'America/Bahia Banderas', 'Bahia Banderas', 'MX', 'Mexico'),
    'America/Barbados': ('America/Barbados', 'America/Barbados', 'Barbados', 'BB', 'Barbados'),
    'America/Belem': ('America/Belem', 'America/Belem', 'Belem', 'BR', 'Brazil'),
    'America/Belize': ('America/Belize', 'America/Belize', 'Belize', 'BZ', 'Belize'),
    'America/Blanc-Sablon': ('America/Blanc-Sablon', 'America/Blanc-Sablon', 'Blanc-Sablon', 'CA', 'Canada'),
    'America/Boa_Vista': ('America/Boa_Vista', 'America/Boa Vista', 'Boa Vista', 'BR', 'Brazil'),
    'America/Bogota': ('America/Bogota', 'America/Bogota', 'Bogota', 'CO', 'Colombia'),
    'America/Boise': ('America/Boise', 'America/Boise', 'Boise', 'US', 'United States'),
    'America/Cambridge_Bay': ('America/Cambridge_Bay', 'America/Cambridge Bay', 'Cambridge Bay', 'CA', 'Canada'),
    'America/Campo_Grande': ('America/Campo_Grande', 'America/Campo Grande', 'Campo Grande', 'BR', 'Brazil'),
    'America/Cancun': ('America/Cancun', 'America/Cancun', 'Cancun', 'MX', 'Mexico'),
    'America/Caracas': ('America/Caracas', 'America/Caracas', 'Caracas', 'VE', 'Venezuela'),
    'America/Cayenne': ('America/Cayenne', 'America/Cayenne', 'Cayenne', 'GF', 'French Guiana'),
    'America/Cayman': ('America/Cayman', 'America/Cayman', 'Cayman', 'KY', 'Cayman Islands'),
    'America/Chicago': ('America/Chicago', 'America/Chicago', 'Chicago', 'US', 'United States'),
    'America/Chihuahua': ('America/Chihuahua', 'America/Chihuahua', 'Chihuahua', 'MX', 'Mexico'),
    'America/Ciudad_Juarez': ('America/Ciudad_Juarez', 'America/Ciudad Juarez', 'Ciudad Juarez', 'MX', 'Mexico'),
    'America/Costa_Rica': ('America/Costa_Rica', 'America/Costa Rica', 'Costa Rica', 'CR', 'Costa Rica'),
    'America/Creston': ('America/Creston', 'America/Creston', 'Creston', 'CA', 'Canada'),
    'America/Cuiaba': ('America/Cuiaba', 'America/Cuiaba', 'Cuiaba', 'BR', 'Brazil'),
    'America/Curacao': ('America/Curacao', 'America/Curacao', 'Curacao', 'CW', 'Curaçao'),
    'America/Danmarkshavn': ('America/Danmarkshavn', 'America/Danmarkshavn', 'Danmarkshavn', 'GL', 'Greenland'),
    'America/Dawson': ('America/Dawson', 'America/Dawson', 'Dawson', 'CA', 'Canada'),
    'America/Dawson_Creek': ('America/Dawson_Creek', 'America/Dawson Creek', 'Dawson Creek', 'CA', 'Canada'),
    'America/Denver': ('America/Denver', 'America/Denver', 'Denver', 'US', 'United States'),
    'America/Detroit': ('America/Detroit', 'America/Detroit', 'Detroit', 'US', 'United States'),
    'America/Dominica': ('America/Dominica', 'America/Dominica', 'Dominica', 'DM', 'Dominica'),
    'America/Edmonton': ('America/Edmonton', 'America/Edmonton', 'Edmonton', 'CA', 'Canada'),
    'America/Eirunepe': ('America/Eirunepe', 'America/Eirunepe', 'Eirunepe', 'BR', 'Brazil'),
    'America/El_Salvador': ('America/El_Salvador', 'America/El Salvador', 'El Salvador', 'SV', 'El Salvador'),
    'America/Fort_Nelson': ('America/Fort_Nelson', 'America/Fort Nelson', 'Fort Nelson', 'CA', 'Canada'),
    'America/Fortaleza': ('America/Fortaleza', 'America/Fortaleza', 'Fortaleza', 'BR', 'Brazil'),
    'America/Glace_Bay': ('America/Glace_Bay', 'America/Glace Bay', 'Glace Bay', 'CA', 'Canada'),
    'America/Goose_Bay': ('America/Goose_Bay', 'America/Goose Bay', 'Goose Bay', 'CA', 'Canada'),
    'America/Grand_Turk': ('America/Grand_Turk', 'America/Grand Turk', 'Grand Turk', 'TC', 'Turks & Caicos Is'),
    'America/Grenada': ('America/Grenada', 'America/Grenada', 'Grenada', 'GD', 'Grenada'),
    'America/Guadeloupe': ('America/Guadeloupe', 'America/Guadeloupe', 'Guadeloupe', 'GP', 'Guadeloupe'),
    'America/Guatemala': ('America/Guatemala', 'America/Guatemala', 'Guatemala', 'GT', 'Guatemala'),
    'America/Guayaquil': ('America/Guayaquil', 'America/Guayaquil', 'Guayaquil', 'EC', 'Ecuador'),
    'America/Guyana': ('America/Guyana', 'America/Guyana', 'Guyana', 'GY', 'Guyana'),
    'America/Halifax': ('America/Halifax', 'America/Halifax', 'Halifax', 'CA', 'Canada'),
    'America/Havana': ('America/Havana', 'America/Havana', 'Havana', 'CU', 'Cuba'),
    'America/Hermosillo': ('America/Hermosillo', 'America/Hermosillo', 'Hermosillo', 'MX', 'Mexico'),
    'America/Indiana/Indianapolis': ('America/Indiana/Indianapolis', 'America/Indiana/Indianapolis', 'Indianapolis', 'US', 'United States'),
    'America/Indiana/Knox': ('America/Indiana/Knox', 'America/Indiana/Knox', 'Knox', 'US', 'United States'),
    'America/Indiana/Marengo': ('America/Indiana/Marengo', 'America/Indiana/Marengo', 'Marengo', 'US', 'United States'),
    'America/Indiana/Petersburg': ('America/Indiana/Petersburg', 'America/Indiana/Petersburg', 'Petersburg', 'US', 'United States'),
    'America/Indiana/Tell_City': ('America/Indiana/Tell_City', 'America/Indiana/Tell City', 'Tell City', 'US', 'United States'),
    'America/Indiana/Vevay': ('America/Indiana/Vevay', 'America/Indiana/Vevay', 'Vevay', 'US', 'United States'),
    'America/Indiana/Vincennes': ('America/Indiana/Vincennes', 'America/Indiana/Vincennes', 'Vincennes', 'US', 'United States'),
    'America/Indiana/Winamac': ('America/Indiana/Winamac', 'America/Indiana/Winamac', 'Winamac', 'US', 'United States'),
    'America/Inuvik': ('America/Inuvik', 'America/Inuvik', 'Inuvik', 'CA', 'Canada'),
    'America/Iqaluit': ('America/Iqaluit', 'America/Iqaluit', 'Iqaluit', 'CA', 'Canada'),
    'America/Jamaica': ('America/Jamaica', 'America/Jamaica', 'Jamaica', 'JM', 'Jamaica'),
    'America/Juneau': ('America/Juneau', 'America/Juneau', 'Juneau', 'US', 'United States'),
    'America/Kentucky/Louisville': ('America/Kentucky/Louisville', 'America/Kentucky/Louisville', 'Louisville', 'US', 'United States'),
    'America/Kentucky/Monticello': ('America/Kentucky/Monticello', 'America/Kentucky/Monticello', 'Monticello', 'US', 'United States'),
    'America/Kralendijk': ('America/Kralendijk', 'America/Kralendijk', 'Kralendijk', 'BQ', 'Caribbean NL'),
    'America/La_Paz': ('America/La_Paz', 'America/La Paz', 'La Paz', 'BO', 'Bolivia'),
    'America/Lima': ('America/Lima', 'America/Lima', 'Lima', 'PE', 'Peru'),
    'America/Los_Angeles': ('America/Los_Angeles', 'America/Los Angeles', 'Los Angeles', 'US', 'United States'),
    'America/Lower_Princes': ('America/Lower_Princes', 'America/Lower Princes', 'Lower Princes', 'SX', 'St Maarten (Dutch)'),
    'America/Maceio': ('America/Maceio', 'America/Maceio', 'Maceio', 'BR', 'Brazil'),
    'America/Managua': ('America/Managua', 'America/Managua', 'Managua', 'NI', 'Nicaragua'),
    'America/Manaus': ('America/Manaus', 'America/Manaus', 'Manaus', 'BR', 'Brazil'),
    'America/Marigot': ('America/Marigot', 'America/Marigot', 'Marigot', 'MF', 'St Martin (French)'),
    'America/Martinique': ('America/Martinique', 'America/Martinique', 'Martinique', 'MQ', 'Martinique'),
    'America/Matamoros': ('America/Matamoros', 'America/Matamoros', 'Matamoros', 'MX', 'Mexico'),
    'America/Mazatlan': ('America/Mazatlan', 'America/Mazatlan', 'Mazatlan', 'MX', 'Mexico'),
    'America/Menominee': ('America/Menominee', 'America/Menominee', 'Menominee', 'US', 'United States'),
    'America/Merida': ('America/Merida', 'America/Merida', 'Merida', 'MX', 'Mexico'),
    'America/Metlakatla': ('America/Metlakatla', 'America/Metlakatla', 'Metlakatla', 'US', 'United States'),
    'America/Mexico_City': ('America/Mexico_City', 'America/Mexico City', 'Mexico City', 'MX', 'Mexico'),
    'America/Miquelon': ('America/Miquelon', 'America/Miquelon', 'Miquelon', 'PM', 'St Pierre & Miquelon'),
    'America/Moncton': ('America/Moncton', 'America/Moncton', 'Moncton', 'CA', 'Canada'),
    'America/Monterrey': ('America/Monterrey', 'America/Monterrey', 'Monterrey', 'MX', 'Mexico'),
    'America/Montevideo': ('America/Montevideo', 'America/Montevideo', 'Montevideo', 'UY', 'Uruguay'),
    'America/Montserrat': ('America/Montserrat', 'America/Montserrat', 'Montserrat', 'MS', 'Montserrat'),
    'America/Nassau': ('America/Nassau', 'America/Nassau', 'Nassau', 'BS', 'Bahamas'),
    'America/New_York': ('America/New_York', 'America/New York', 'New York', 'US', 'United States'),
    'America/Nome': ('America/Nome', 'America/Nome', 'Nome', 'US', 'United States'),
    'America/Noronha': ('America/Noronha', 'America/Noronha', 'Noronha', 'BR', 'Brazil'),
    'America/North_Dakota/Beulah': ('America/North_Dakota/Beulah', 'America/North Dakota/Beulah', 'Beulah', 'US', 'United States'),
    'America/North_Dakota/Center': ('America/North_Dakota/Center', 'America/North Dakota/Center', 'Center', 'US', 'United States'),
    'America/North_Dakota/New_Salem': ('America/North_Dakota/New_Salem', 'America/North Dakota/New Salem', 'New Salem', 'US', 'United States'),
    'America/Nuuk': ('America/Nuuk', 'America/Nuuk', 'Nuuk', 'GL', 'Greenland'),
    'America/Ojinaga': ('America/Ojinaga', 'America/Ojinaga', 'Ojinaga', 'MX', 'Mexico'),
    'America/Panama': ('America/Panama', 'America/Panama', 'Panama', 'PA', 'Panama'),
    'America/Paramaribo': ('America/Paramaribo', 'America/Paramaribo', 'Paramaribo', 'SR', 'Suriname'),
    'America/Phoenix': ('America/Phoenix', 'America/Phoenix', 'Phoenix', 'US', 'United States'),
    'America/Port-au-Prince': ('America/Port-au-Prince', 'America/Port-au-Prince', 'Port-au-Prince', 'HT', 'Haiti'),
    'America/Port_of_Spain': ('America/Port_of_Spain', 'America/Port of Spain', 'Port of Spain', 'TT', 'Trinidad & Tobago'),
    'America/Porto_Velho': ('America/Porto_Velho', 'America/Porto Velho', 'Porto Velho', 'BR', 'Brazil'),
    'America/Puerto_Rico': ('America/Puerto_Rico', 'America/Puerto Rico', 'Puerto Rico', 'PR', 'Puerto Rico'),
    'America/Punta_Arenas': ('America/Punta_Arenas', 'America/Punta Arenas', 'Punta Arenas', 'CL', 'Chile'),
    'America/Rankin_Inlet': ('America/Rankin_Inlet', 'America/Rankin Inlet', 'Rankin Inlet', 'CA', 'Canada'),
    'America/Recife': ('America/Recife', 'America/Recife', 'Recife', 'BR', 'Brazil'),
    'America/Regina': ('America/Regina', 'America/Regina', 'Regina', 'CA', 'Canada'),
    'America/Resolute': ('America/Resolute', 'America/Resolute', 'Resolute', 'CA', 'Canada'),
    'America/Rio_Branco': ('America/Rio_Branco', 'America/Rio Branco', 'Rio Branco', 'BR', 'Brazil'),
    'America/Santarem': ('America/Santarem', 'America/Santarem', 'Santarem', 'BR', 'Brazil'),
    'America/Santiago': ('America/Santiago', 'America/Santiago', 'Santiago', 'CL', 'Chile'),
    'America/Santo_Domingo': ('America/Santo_Domingo', 'America/Santo Domingo', 'Santo Domingo', 'DO', 'Dominican Republic'),
    'America/Sao_Paulo': ('America/Sao_Paulo', 'America/Sao Paulo', 'Sao Paulo', 'BR', 'Brazil'),
    'America/Scoresbysund': ('America/Scoresbysund', 'America/Scoresbysund', 'Scoresbysund', 'GL', 'Greenland'),
    'America/Sitka': ('America/Sitka', 'America/Sitka', 'Sitka', 'US', 'United States'),
    'America/St_Barthelemy': ('America/St_Barthelemy', 'America/St Barthelemy', 'St Barthelemy', 'BL', 'St Barthelemy'),
    'America/St_Johns': ('America/St_Johns', 'America/St Johns', 'St Johns', 'CA', 'Canada'),
    'America/St_Kitts': ('America/St_Kitts', 'America/St Kitts', 'St Kitts', 'KN', 'St Kitts & Nevis'),
    'America/St_Lucia': ('America/St_Lucia', 'America/St Lucia', 'St Lucia', 'LC', 'St Lucia'),
    'America/St_Thomas': ('America/St_Thomas', 'America/St Thomas', 'St Thomas', 'VI', 'Virgin Islands (US)'),
    'America/St_Vincent': ('America/St_Vincent', 'America/St Vincent', 'St Vincent', 'VC', 'St Vincent'),
    'America/Swift_Current': ('America/Swift_Current', 'America/Swift Current', 'Swift Current', 'CA', 'Canada'),
    'America/Tegucigalpa': ('America/Tegucigalpa', 'America/Tegucigalpa', 'Tegucigalpa', 'HN', 'Honduras'),
    'America/Thule': ('America/Thule', 'America/Thule', 'Thule', 'GL', 'Greenland'),
    'America/Tijuana': ('America/Tijuana', 'America/Tijuana', 'Tijuana', 'MX', 'Mexico'),
    'America/Toronto': ('America/Toronto', 'America/Toronto', 'Toronto', 'CA', 'Canada'),
    'America/Tortola': ('America/Tortola', 'America/Tortola', 'Tortola', 'VG', 'Virgin Islands (UK)'),
    'America/Vancouver': ('America/Vancouver', 'America/Vancouver', 'Vancouver', 'CA', 'Canada'),
    'America/Whitehorse': ('America/Whitehorse', 'America/Whitehorse', 'Whitehorse', 'CA', 'Canada'),
    'America/Winnipeg': ('America/Winnipeg', 'America/Winnipeg', 'Winnipeg', 'CA', 'Canada'),
    'America/Yakutat': ('America/Yakutat', 'America/Yakutat', 'Yakutat', 'US', 'United States'),
    'Antarctica/Casey': ('Antarctica/Casey', 'Antarctica/Casey', 'Casey', 'AQ', 'Antarctica'),
    'Antarctica/Davis': ('Antarctica/Davis', 'Antarctica/Davis', 'Davis', 'AQ', 'Antarctica'),
    'Antarctica/DumontDUrville': ('Antarctica/DumontDUrville', 'Antarctica/DumontDUrville', 'DumontDUrville', 'AQ', 'Antarctica'),
    'Antarctica/Macquarie': ('Antarctica/Macquarie', 'Antarctica/Macquarie', 'Macquarie', 'AU', 'Australia'),
    'Antarctica/Mawson': ('Antarctica/Mawson', 'Antarctica/Mawson', 'Mawson', 'AQ', 'Antarctica'),
    'Antarctica/McMurdo': ('Antarctica/McMurdo', 'Antarctica/McMurdo', 'McMurdo', 'AQ', 'Antarctica'),
    'Antarctica/Palmer': ('Antarctica/Palmer', 'Antarctica/Palmer', 'Palmer', 'AQ', 'Antarctica'),
    'Antarctica/Rothera': ('Antarctica/Rothera', 'Antarctica/Rothera', 'Rothera', 'AQ', 'Antarctica'),
    'Antarctica/Syowa': ('Antarctica/Syowa', 'Antarctica/Syowa', 'Syowa', 'AQ', 'Antarctica'),
    'Antarctica/Troll': ('Antarctica/Troll', 'Antarctica/Troll', 'Troll', 'AQ', 'Antarctica'),
    'Antarctica/Vostok': ('Antarctica/Vostok', 'Antarctica/Vostok', 'Vostok', 'AQ', 'Antarctica'),
    'Arctic/Longyearbyen': ('Arctic/Longyearbyen', 'Arctic/Longyearbyen', 'Longyearbyen', 'SJ', 'Svalbard & Jan Mayen'),
    'Asia/Aden': ('Asia/Aden', 'Asia/Aden', 'Aden', 'YE', 'Yemen'),
    'Asia/Almaty': ('Asia/Almaty', 'Asia/Almaty', 'Almaty', 'KZ', 'Kazakhstan'),
    'Asia/Amman': ('Asia/Amman', 'Asia/Amman', 'Amman', 'JO', 'Jordan'),
    'Asia/Anadyr': ('Asia/Anadyr', 'Asia/Anadyr', 'Anadyr', 'RU', 'Russia'),
    'Asia/Aqtau': ('Asia/Aqtau', 'Asia/Aqtau', 'Aqtau', 'KZ', 'Kazakhstan'),
    'Asia/Aqtobe': ('Asia/Aqtobe', 'Asia/Aqtobe', 'Aqtobe', 'KZ', 'Kazakhstan'),
    'Asia/Ashgabat': ('Asia/Ashgabat', 'Asia/Ashgabat', 'Ashgabat', 'TM', 'Turkmenistan'),
    'Asia/Atyrau': ('Asia/Atyrau', 'Asia/Atyrau', 'Atyrau', 'KZ', 'Kazakhstan'),
    'Asia/Baghdad': ('Asia/Baghdad', 'Asia/Baghdad', 'Baghdad', 'IQ', 'Iraq'),
    'Asia/Bahrain': ('Asia/Bahrain', 'Asia/Bahrain', 'Bahrain', 'BH', 'Bahrain'),
    'Asia/Baku': ('Asia/Baku', 'Asia/Baku', 'Baku', 'AZ', 'Azerbaijan'),
    'Asia/Bangkok': ('Asia/Bangkok', 'Asia/Bangkok', 'Bangkok', 'TH', 'Thailand'),
    'Asia/Barnaul': ('Asia/Barnaul', 'Asia/Barnaul', 'Barnaul', 'RU', 'Russia'),
    'Asia/Beirut': ('Asia/Beirut', 'Asia/Beirut', 'Beirut', 'LB', 'Lebanon'),
    'Asia/Bishkek': ('Asia/Bishkek', 'Asia/Bishkek', 'Bishkek', 'KG', 'Kyrgyzstan'),
    'Asia/Brunei': ('Asia/Brunei', 'Asia/Brunei', 'Brunei', 'BN', 'Brunei'),
    'Asia/Chita': ('Asia/Chita', 'Asia/Chita', 'Chita', 'RU', 'Russia'),
    'Asia/Choibalsan': ('Asia/Choibalsan', 'Asia/Choibalsan', 'Choibalsan', 'MN', 'Mongolia'),
    'Asia/Colombo': ('Asia/Colombo', 'Asia/Colombo', 'Colombo', 'LK', 'Sri Lanka'),
    'Asia/Damascus': ('Asia/Damascus', 'Asia/Damascus', 'Damascus', 'SY', 'Syria'),
    'Asia/Dhaka': ('Asia/Dhaka', 'Asia/Dhaka', 'Dhaka', 'BD', 'Bangladesh'),
    'Asia/Dili': ('Asia/Dili', 'Asia/Dili', 'Dili', 'TL', 'East Timor'),
    'Asia/Dubai': ('Asia/Dubai', 'Asia/Dubai', 'Dubai', 'AE', 'United Arab Emirates'),
    'Asia/Dushanbe': ('Asia/Dushanbe', 'Asia/Dushanbe', 'Dushanbe', 'TJ', 'Tajikistan'),
    'Asia/Famagusta': ('Asia/Famagusta', 'Asia/Famagusta', 'Famagusta', 'CY', 'Cyprus'),
    'Asia/Gaza': ('Asia/Gaza', 'Asia/Gaza', 'Gaza', 'PS', 'Palestine'),
    'Asia/Hebron': ('Asia/Hebron', 'Asia/Hebron', 'Hebron', 'PS', 'Palestine'),
    'Asia/Ho_Chi_Minh': ('Asia/Ho_Chi_Minh', 'Asia/Ho Chi Minh', 'Ho Chi Minh', 'VN', 'Vietnam'),
    'Asia/Hong_Kong': ('Asia/Hong_Kong', 'Asia/Hong Kong', 'Hong Kong', 'HK', 'Hong Kong'),
    'Asia/Hovd': ('Asia/Hovd', 'Asia/Hovd', 'Hovd', 'MN', 'Mongolia'),
    'Asia/Irkutsk': ('Asia/Irkutsk', 'Asia/Irkutsk', 'Irkutsk', 'RU', 'Russia'),
    'Asia/Jakarta': ('Asia/Jakarta', 'Asia/Jakarta', 'Jakarta', 'ID', 'Indonesia'),
    'Asia/Jayapura': ('Asia/Jayapura', 'Asia/Jayapura', 'Jayapura', 'ID', 'Indonesia'),
    'Asia/Jerusalem': ('Asia/Jerusalem', 'Asia/Jerusalem', 'Jerusalem', 'IL', 'Israel'),
    'Asia/Kabul': ('Asia/Kabul', 'Asia/Kabul', 'Kabul', 'AF', 'Afghanistan'),
    'Asia/Kamchatka': ('Asia/Kamchatka', 'Asia/Kamchatka', 'Kamchatka', 'RU', 'Russia'),
    'Asia/Karachi': ('Asia/Karachi', 'Asia/Karachi', 'Karachi', 'PK', 'Pakistan'),
    'Asia/Kathmandu': ('Asia/Kathmandu', 'Asia/Kathmandu', 'Kathmandu', 'NP', 'Nepal'),
    'Asia/Khandyga': ('Asia/Khandyga', 'Asia/Khandyga', 'Khandyga', 'RU', 'Russia'),
    'Asia/Kolkata': ('Asia/Kolkata', 'Asia/Kolkata', 'Kolkata', 'IN', 'India'),
    'Asia/Krasnoyarsk': ('Asia/Krasnoyarsk', 'Asia/Krasnoyarsk', 'Krasnoyarsk', 'RU', 'Russia'),
    'Asia/Kuala_Lumpur': ('Asia/Kuala_Lumpur', 'Asia/Kuala Lumpur', 'Kuala Lumpur', 'MY', 'Malaysia'),
    'Asia/Kuching': ('Asia/Kuching', 'Asia/Kuching', 'Kuching', 'MY', 'Malaysia'),
    'Asia/Kuwait': ('Asia/Kuwait', 'Asia/Kuwait', 'Kuwait', 'KW', 'Kuwait'),
    'Asia/Macau': ('Asia/Macau', 'Asia/Macau', 'Macau', 'MO', 'Macau'),
    'Asia/Magadan': ('Asia/Magadan', 'Asia/Magadan', 'Magadan', 'RU', 'Russia'),
    'Asia/Makassar': ('Asia/Makassar', 'Asia/Makassar', 'Makassar', 'ID', 'Indonesia'),
    'Asia/Manila': ('Asia/Manila', 'Asia/Manila', 'Manila', 'PH', 'Philippines'),
    'Asia/Muscat': ('Asia/Muscat', 'Asia/Muscat', 'Muscat', 'OM', 'Oman'),
    'Asia/Nicosia': ('Asia/Nicosia', 'Asia/Nicosia', 'Nicosia', 'CY', 'Cyprus'),
    'Asia/Novokuznetsk': ('Asia/Novokuznetsk', 'Asia/Novokuznetsk', 'Novokuznetsk', 'RU', 'Russia'),
    'Asia/Novosibirsk': ('Asia/Novosibirsk', 'Asia/Novosibirsk', 'Novosibirsk', 'RU', 'Russia'),
    'Asia/Omsk': ('Asia/Omsk', 'Asia/Omsk', 'Omsk', 'RU', 'Russia'),
    'Asia/Oral': ('Asia/Oral', 'Asia/Oral', 'Oral', 'KZ', 'Kazakhstan'),
    'Asia/Phnom_Penh': ('Asia/Phnom_Penh', 'Asia/Phnom Penh', 'Phnom Penh', 'KH', 'Cambodia'),
    'Asia/Pontianak': ('Asia/Pontianak', 'Asia/Pontianak', 'Pontianak', 'ID', 'Indonesia'),
    'Asia/Pyongyang': ('Asia/Pyongyang', 'Asia/Pyongyang', 'Pyongyang', 'KP', 'Korea (North)'),
    'Asia/Qatar': ('Asia/Qatar', 'Asia/Qatar', 'Qatar', 'QA', 'Qatar'),
    'Asia/Qostanay': ('Asia/Qostanay', 'Asia/Qostanay', 'Qostanay', 'KZ', 'Kazakhstan'),
    'Asia/Qyzylorda': ('Asia/Qyzylorda', 'Asia/Qyzylorda', 'Qyzylorda', 'KZ', 'Kazakhstan'),
    'Asia/Riyadh': ('Asia/Riyadh', 'Asia/Riyadh', 'Riyadh', 'SA', 'Saudi Arabia'),
    'Asia/Sakhalin': ('Asia/Sakhalin', 'Asia/Sakhalin', 'Sakhalin', 'RU', 'Russia'),
    'Asia/Samarkand': ('Asia/Samarkand', 'Asia/Samarkand', 'Samarkand', 'UZ', 'Uzbekistan'),
    'Asia/Seoul': ('Asia/Seoul', 'Asia/Seoul', 'Seoul', 'KR', 'Korea (South)'),
    'Asia/Shanghai': ('Asia/Shanghai', 'Asia/Shanghai', 'Shanghai', 'CN', 'China'),
    'Asia/Singapore': ('Asia/Singapore', 'Asia/Singapore', 'Singapore', 'SG', 'Singapore'),
    'Asia/Srednekolymsk': ('Asia/Srednekolymsk', 'Asia/Srednekolymsk', 'Srednekolymsk', 'RU', 'Russia'),
    'Asia/Taipei': ('Asia/Taipei', 'Asia/Taipei', 'Taipei', 'TW', 'Taiwan'),
    'Asia/Tashkent': ('Asia/Tashkent', 'Asia/Tashkent', 'Tashkent', 'UZ', 'Uzbekistan'),
    'Asia/Tbilisi': ('Asia/Tbilisi', 'Asia/Tbilisi', 'Tbilisi', 'GE', 'Georgia'),
    'Asia/Tehran': ('Asia/Tehran', 'Asia/Tehran', 'Tehran', 'IR', 'Iran'),
    'Asia/Thimphu': ('Asia/Thimphu', 'Asia/Thimphu', 'Thimphu', 'BT', 'Bhutan'),
    'Asia/Tokyo': ('Asia/Tokyo', 'Asia/Tokyo', 'Tokyo', 'JP', 'Japan'),
    'Asia/Tomsk': ('Asia/Tomsk', 'Asia/Tomsk', 'Tomsk', 'RU', 'Russia'),
    'Asia/Ulaanbaatar': ('Asia/Ulaanbaatar', 'Asia/Ulaanbaatar', 'Ulaanbaatar', 'MN', 'Mongolia'),
    'Asia/Urumqi': ('Asia/Urumqi', 'Asia/Urumqi', 'Urumqi', 'CN', 'China'),
    'Asia/Ust-Nera': ('Asia/Ust-Nera', 'Asia/Ust-Nera', 'Ust-Nera', 'RU', 'Russia'),
    'Asia/Vientiane': ('Asia/Vientiane', 'Asia/Vientiane', 'Vientiane', 'LA', 'Laos'),
    'Asia/Vladivostok': ('Asia/Vladivostok', 'Asia/Vladivostok', 'Vladivostok', 'RU', 'Russia'),
    'Asia/Yakutsk': ('Asia/Yakutsk', 'Asia/Yakutsk', 'Yakutsk', 'RU', 'Russia'),
    'Asia/Yangon': ('Asia/Yangon', 'Asia/Yangon', 'Yangon', 'MM', 'Myanmar (Burma)'),
    'Asia/Yekaterinburg': ('Asia/Yekaterinburg', 'Asia/Yekaterinburg', 'Yekaterinburg', 'RU', 'Russia'),
    'Asia/Yerevan': ('Asia/Yerevan', 'Asia/Yerevan', 'Yerevan', 'AM', 'Armenia'),
    'Atlantic/Azores': ('Atlantic/Azores', 'Atlantic/Azores', 'Azores', 'PT', 'Portugal'),
    'Atlantic/Bermuda': ('Atlantic/Bermuda', 'Atlantic/Bermuda', 'Bermuda', 'BM', 'Bermuda'),
    'Atlantic/Canary': ('Atlantic/Canary', 'Atlantic/Canary', 'Canary', 'ES', 'Spain'),
    'Atlantic/Cape_Verde': ('Atlantic/Cape_Verde', 'Atlantic/Cape Verde', 'Cape Verde', 'CV', 'Cape Verde'),
    'Atlantic/Faroe': ('Atlantic/Faroe', 'Atlantic/Faroe', 'Faroe', 'FO', 'Faroe Islands'),
    'Atlantic/Madeira': ('Atlantic/Madeira', 'Atlantic/Madeira', 'Madeira', 'PT', 'Portugal'),
    'Atlantic/Reykjavik': ('Atlantic/Reykjavik', 'Atlantic/Reykjavik', 'Reykjavik', 'IS', 'Iceland'),
    'Atlantic/South_Georgia': ('Atlantic/South_Georgia', 'Atlantic/South Georgia', 'South Georgia', 'GS', 'South Georgia & the South Sandwich Islands'),
    'Atlantic/St_Helena': ('Atlantic/St_Helena', 'Atlantic/St Helena', 'St Helena', 'SH', 'St Helena'),
    'Atlantic/Stanley': ('Atlantic/Stanley', 'Atlantic/Stanley', 'Stanley', 'FK', 'Falkland Islands'),
    'Australia/Adelaide': ('Australia/Adelaide', 'Australia/Adelaide', 'Adelaide', 'AU', 'Australia'),
    'Australia/Brisbane': ('Australia/Brisbane', 'Australia/Brisbane', 'Brisbane', 'AU', 'Australia'),
    'Australia/Broken_Hill': ('Australia/Broken_Hill', 'Australia/Broken Hill', 'Broken Hill', 'AU', 'Australia'),
    'Australia/Darwin': ('Australia/Darwin', 'Australia/Darwin', 'Darwin', 'AU', 'Australia'),
    'Australia/Eucla': ('Australia/Eucla', 'Australia/Eucla', 'Eucla', 'AU', 'Australia'),
    'Australia/Hobart': ('Australia/Hobart', 'Australia/Hobart', 'Hobart', 'AU', 'Australia'),
    'Australia/Lindeman': ('Australia/Lindeman', 'Australia/Lindeman', 'Lindeman', 'AU', 'Australia'),
    'Australia/Lord_Howe': ('Australia/Lord_Howe', 'Australia/Lord Howe', 'Lord Howe', 'AU', 'Australia'),
    'Australia/Melbourne': ('Australia/Melbourne', 'Australia/Melbourne', 'Melbourne', 'AU', 'Australia'),
    'Australia/Perth': ('Australia/Perth', 'Australia/Perth', 'Perth', 'AU', 'Australia'),
    'Australia/Sydney': ('Australia/Sydney', 'Australia/Sydney', 'Sydney', 'AU', 'Australia'),
    'Europe/Amsterdam': ('Europe/Amsterdam', 'Europe/Amsterdam', 'Amsterdam', 'NL', 'Netherlands'),
    'Europe/Andorra': ('Europe/Andorra', 'Europe/Andorra', 'Andorra', 'AD', 'Andorra'),
    'Europe/Astrakhan': ('Europe/Astrakhan', 'Europe/Astrakhan', 'Astrakhan', 'RU', 'Russia'),
    'Europe/Athens': ('Europe/Athens', 'Europe/Athens', 'Athens', 'GR', 'Greece'),
    'Europe/Belgrade': ('Europe/Belgrade', 'Europe/Belgrade', 'Belgrade', 'RS', 'Serbia'),
    'Europe/Berlin': ('Europe/Berlin', 'Europe/Berlin', 'Berlin', 'DE', 'Germany'),
    'Europe/Bratislava': ('Europe/Bratislava', 'Europe/Bratislava', 'Bratislava', 'SK', 'Slovakia'),
    'Europe/Brussels': ('Europe/Brussels', 'Europe/Brussels', 'Brussels', 'BE', 'Belgium'),
    'Europe/Bucharest': ('Europe/Bucharest', 'Europe/Bucharest', 'Bucharest', 'RO', 'Romania'),
    'Europe/Budapest': ('Europe/Budapest', 'Europe/Budapest', 'Budapest', 'HU', 'Hungary'),
    'Europe/Busingen': ('Europe/Busingen', 'Europe/Busingen', 'Busingen', 'DE', 'Germany'),
    'Europe/Chisinau': ('Europe/Chisinau', 'Europe/Chisinau', 'Chisinau', 'MD', 'Moldova'),
    'Europe/Copenhagen': ('Europe/Copenhagen', 'Europe/Copenhagen', 'Copenhagen', 'DK', 'Denmark'),
    'Europe/Dublin': ('Europe/Dublin', 'Europe/Dublin', 'Dublin', 'IE', 'Ireland'),
    'Europe/Gibraltar': ('Europe/Gibraltar', 'Europe/Gibraltar', 'Gibraltar', 'GI', 'Gibraltar'),
    'Europe/Guernsey': ('Europe/Guernsey', 'Europe/Guernsey', 'Guernsey', 'GG', 'Guernsey'),
    'Europe/Helsinki': ('Europe/Helsinki', 'Europe/Helsinki', 'Helsinki', 'FI', 'Finland'),
    'Europe/Isle_of_Man': ('Europe/Isle_of_Man', 'Europe/Isle of Man', 'Isle of Man', 'IM', 'Isle of Man'),
    'Europe/Istanbul': ('Europe/Istanbul', 'Europe/Istanbul', 'Istanbul', 'TR', 'Turkey'),
    'Europe/Jersey': ('Europe/Jersey', 'Europe/Jersey', 'Jersey', 'JE', 'Jersey'),
    'Europe/Kaliningrad': ('Europe/Kaliningrad', 'Europe/Kaliningrad', 'Kaliningrad', 'RU', 'Russia'),
    'Europe/Kirov': ('Europe/Kirov', 'Europe/Kirov', 'Kirov', 'RU', 'Russia'),
    'Europe/Kyiv': ('Europe/Kyiv', 'Europe/Kyiv', 'Kyiv', 'UA', 'Ukraine'),
    'Europe/Lisbon': ('Europe/Lisbon', 'Europe/Lisbon', 'Lisbon', 'PT', 'Portugal'),
    'Europe/Ljubljana': ('Europe/Ljubljana', 'Europe/Ljubljana', 'Ljubljana', 'SI', 'Slovenia'),
    'Europe/London': ('Europe/London', 'Europe/London', 'London', 'GB', 'Britain (UK)'),
    'Europe/Luxembourg': ('Europe/Luxembourg', 'Europe/Luxembourg', 'Luxembourg', 'LU', 'Luxembourg'),
    'Europe/Madrid': ('Europe/Madrid', 'Europe/Madrid', 'Madrid', 'ES', 'Spain'),
    'Europe/Malta': ('Europe/Malta', 'Europe/Malta', 'Malta', 'MT', 'Malta'),
    'Europe/Mariehamn': ('Europe/Mariehamn', 'Europe/Mariehamn', 'Mariehamn', 'AX', 'Åland Islands'),
    'Europe/Minsk': ('Europe/Minsk', 'Europe/Minsk', 'Minsk', 'BY', 'Belarus'),
    'Europe/Monaco': ('Europe/Monaco', 'Europe/Monaco', 'Monaco', 'MC', 'Monaco'),
    'Europe/Moscow': ('Europe/Moscow', 'Europe/Moscow', 'Moscow', 'RU', 'Russia'),
    'Europe/Oslo': ('Europe/Oslo', 'Europe/Oslo', 'Oslo', 'NO', 'Norway'),
    'Europe/Paris': ('Europe/Paris', 'Europe/Paris', 'Paris', 'FR', 'France'),
    'Europe/Podgorica': ('Europe/Podgorica', 'Europe/Podgorica', 'Podgorica', 'ME', 'Montenegro'),
    'Europe/Prague': ('Europe/Prague', 'Europe/Prague', 'Prague', 'CZ', 'Czech Republic'),
    'Europe/Riga': ('Europe/Riga', 'Europe/Riga', 'Riga', 'LV', 'Latvia'),
    'Europe/Rome': ('Europe/Rome', 'Europe/Rome', 'Rome', 'IT', 'Italy'),
    'Europe/Samara': ('Europe/Samara', 'Europe/Samara', 'Samara', 'RU', 'Russia'),
    'Europe/San_Marino': ('Europe/San_Marino', 'Europe/San Marino', 'San Marino', 'SM', 'San Marino'),
    'Europe/Sarajevo': ('Europe/Sarajevo', 'Europe/Sarajevo', 'Sarajevo', 'BA', 'Bosnia & Herzegovina'),
    'Europe/Saratov': ('Europe/Saratov', 'Europe/Saratov', 'Saratov', 'RU', 'Russia'),
    'Europe/Simferopol': ('Europe/Simferopol', 'Europe/Simferopol', 'Simferopol', 'UA', 'Ukraine'),
    'Europe/Skopje': ('Europe/Skopje', 'Europe/Skopje', 'Skopje', 'MK', 'North Macedonia'),
    'Europe/Sofia': ('Europe/Sofia', 'Europe/Sofia', 'Sofia', 'BG', 'Bulgaria'),
    'Europe/Stockholm': ('Europe/Stockholm', 'Europe/Stockholm', 'Stockholm', 'SE', 'Sweden'),
    'Europe/Tallinn': ('Europe/Tallinn', 'Europe/Tallinn', 'Tallinn', 'EE', 'Estonia'),
    'Europe/Tirane': ('Europe/Tirane', 'Europe/Tirane', 'Tirane', 'AL', 'Albania'),
    'Europe/Ulyanovsk': ('Europe/Ulyanovsk', 'Europe/Ulyanovsk', 'Ulyanovsk', 'RU', 'Russia'),
    'Europe/Vaduz': ('Europe/Vaduz', 'Europe/Vaduz', 'Vaduz', 'LI', 'Liechtenstein'),
    'Europe/Vatican': ('Europe/Vatican', 'Europe/Vatican', 'Vatican', 'VA', 'Vatican City'),
    'Europe/Vienna': ('Europe/Vienna', 'Europe/Vienna', 'Vienna', 'AT', 'Austria'),
    'Europe/Vilnius': ('Europe/Vilnius', 'Europe/Vilnius', 'Vilnius', 'LT', 'Lithuania'),
    'Europe/Volgograd': ('Europe/Volgograd', 'Europe/Volgograd', 'Volgograd', 'RU', 'Russia'),
    'Europe/Warsaw': ('Europe/Warsaw', 'Europe/Warsaw', 'Warsaw', 'PL', 'Poland'),
    'Europe/Zagreb': ('Europe/Zagreb', 'Europe/Zagreb', 'Zagreb', 'HR', 'Croatia'),
    'Europe/Zurich': ('Europe/Zurich', 'Europe/Zurich', 'Zurich', 'CH', 'Switzerland'),
    'Indian/Antananarivo': ('Indian/Antananarivo', 'Indian/Antananarivo', 'Antananarivo', 'MG', 'Madagascar'),
    'Indian/Chagos': ('Indian/Chagos', 'Indian/Chagos', 'Chagos', 'IO', 'British Indian Ocean Territory'),
    'Indian/Christmas': ('Indian/Christmas', 'Indian/Christmas', 'Christmas', 'CX', 'Christmas Island'),
    'Indian/Cocos': ('Indian/Cocos', 'Indian/Cocos', 'Cocos', 'CC', 'Cocos (Keeling) Islands'),
    'Indian/Comoro': ('Indian/Comoro', 'Indian/Comoro', 'Comoro', 'KM', 'Comoros'),
    'Indian/Kerguelen': ('Indian/Kerguelen', 'Indian/Kerguelen', 'Kerguelen', 'TF', 'French S. Terr.'),
    'Indian/Mahe': ('Indian/Mahe', 'Indian/Mahe', 'Mahe', 'SC', 'Seychelles'),
    'Indian/Maldives': ('Indian/Maldives', 'Indian/Maldives', 'Maldives', 'MV', 'Maldives'),
    'Indian/Mauritius': ('Indian/Mauritius', 'Indian/Mauritius', 'Mauritius', 'MU', 'Mauritius'),
    'Indian/Mayotte': ('Indian/Mayotte', 'Indian/Mayotte', 'Mayotte', 'YT', 'Mayotte'),
    'Indian/Reunion': ('Indian/Reunion', 'Indian/Reunion', 'Reunion', 'RE', 'Réunion'),
    'Pacific/Apia': ('Pacific/Apia', 'Pacific/Apia', 'Apia', 'WS', 'Samoa (western)'),
    'Pacific/Auckland': ('Pacific/Auckland', 'Pacific/Auckland', 'Auckland', 'NZ', 'New Zealand'),
    'Pacific/Bougainville': ('Pacific/Bougainville', 'Pacific/Bougainville', 'Bougainville', 'PG', 'Papua New Guinea'),
    'Pacific/Chatham': ('Pacific/Chatham', 'Pacific/Chatham', 'Chatham', 'NZ', 'New Zealand'),
    'Pacific/Chuuk': ('Pacific/Chuuk', 'Pacific/Chuuk', 'Chuuk', 'FM', 'Micronesia'),
    'Pacific/Easter': ('Pacific/Easter', 'Pacific/Easter', 'Easter', 'CL', 'Chile'),
    'Pacific/Efate': ('Pacific/Efate', 'Pacific/Efate', 'Efate', 'VU', 'Vanuatu'),
    'Pacific/Fakaofo': ('Pacific/Fakaofo', 'Pacific/Fakaofo', 'Fakaofo', 'TK', 'Tokelau'),
    'Pacific/Fiji': ('Pacific/Fiji', 'Pacific/Fiji', 'Fiji', 'FJ', 'Fiji'),
    'Pacific/Funafuti': ('Pacific/Funafuti', 'Pacific/Funafuti', 'Funafuti', 'TV', 'Tuvalu'),
    'Pacific/Galapagos': ('Pacific/Galapagos', 'Pacific/Galapagos', 'Galapagos', 'EC', 'Ecuador'),
    'Pacific/Gambier': ('Pacific/Gambier', 'Pacific/Gambier', 'Gambier', 'PF', 'French Polynesia'),
    'Pacific/Guadalcanal': ('Pacific/Guadalcanal', 'Pacific/Guadalcanal', 'Guadalcanal', 'SB', 'Solomon Islands'),
    'Pacific/Guam': ('Pacific/Guam', 'Pacific/Guam', 'Guam', 'GU', 'Guam'),
    'Pacific/Honolulu': ('Pacific/Honolulu', 'Pacific/Honolulu', 'Honolulu', 'US', 'United States'),
    'Pacific/Kanton': ('Pacific/Kanton', 'Pacific/Kanton', 'Kanton', 'KI', 'Kiribati'),
    'Pacific/Kiritimati': ('Pacific/Kiritimati', 'Pacific/Kiritimati', 'Kiritimati', 'KI', 'Kiribati'),
    'Pacific/Kosrae': ('Pacific/Kosrae', 'Pacific/Kosrae', 'Kosrae', 'FM', 'Micronesia'),
    'Pacific/Kwajalein': ('Pacific/Kwajalein', 'Pacific/Kwajalein', 'Kwajalein', 'MH', 'Marshall Islands'),
    'Pacific/Majuro': ('Pacific/Majuro', 'Pacific/Majuro', 'Majuro', 'MH', 'Marshall Islands'),
    'Pacific/Marquesas': ('Pacific/Marquesas', 'Pacific/Marquesas', 'Marquesas', 'PF', 'French Polynesia'),
    'Pacific/Midway': ('Pacific/Midway', 'Pacific/Midway', 'Midway', 'UM', 'US minor outlying islands'),
    'Pacific/Nauru': ('Pacific/Nauru', 'Pacific/Nauru', 'Nauru', 'NR', 'Nauru'),
    'Pacific/Niue': ('Pacific/Niue', 'Pacific/Niue', 'Niue', 'NU', 'Niue'),
    'Pacific/Norfolk': ('Pacific/Norfolk', 'Pacific/Norfolk', 'Norfolk', 'NF', 'Norfolk Island'),
    'Pacific/Noumea': ('Pacific/Noumea', 'Pacific/Noumea', 'Noumea', 'NC', 'New Caledonia'),
    'Pacific/Pago_Pago': ('Pacific/Pago_Pago', 'Pacific/Pago Pago', 'Pago Pago', 'AS', 'Samoa (American)'),
    'Pacific/Palau': ('Pacific/Palau', 'Pacific/Palau', 'Palau', 'PW', 'Palau'),
    'Pacific/Pitcairn': ('Pacific/Pitcairn', 'Pacific/Pitcairn', 'Pitcairn', 'PN', 'Pitcairn'),
    'Pacific/Pohnpei': ('Pacific/Pohnpei', 'Pacific/Pohnpei', 'Pohnpei', 'FM', 'Micronesia'),
    'Pacific/Port_Moresby': ('Pacific/Port_Moresby', 'Pacific/Port Moresby', 'Port Moresby', 'PG', 'Papua New Guinea'),
    'Pacific/Rarotonga': ('Pacific/Rarotonga', 'Pacific/Rarotonga', 'Rarotonga', 'CK', 'Cook Islands'),
    'Pacific/Saipan': ('Pacific/Saipan', 'Pacific/Saipan', 'Saipan', 'MP', 'Northern Mariana Islands'),
    'Pacific/Tahiti': ('Pacific/Tahiti', 'Pacific/Tahiti', 'Tahiti', 'PF', 'French Polynesia'),
    'Pacific/Tarawa': ('Pacific/Tarawa', 'Pacific/Tarawa', 'Tarawa', 'KI', 'Kiribati'),
    'Pacific/Tongatapu': ('Pacific/Tongatapu', 'Pacific/Tongatapu', 'Tongatapu', 'TO', 'Tonga'),
    'Pacific/Wake': ('Pacific/Wake', 'Pacific/Wake', 'Wake', 'UM', 'US minor outlying islands'),
    'Pacific/Wallis': ('Pacific/Wallis', 'Pacific/Wallis', 'Wallis', 'WF', 'Wallis & Futuna'),
}


URI_SCHEMES = {
    'aaa',
    'aaas',
    'about',
    'acap',
    'acct',
    'acd',
    'acr',
    'adiumxtra',
    'adt',
    'afp',
    'afs',
    'aim',
    'amss',
    'android',
    'appdata',
    'apt',
    'ar',
    'ark',
    'at',
    'attachment',
    'aw',
    'barion',
    'bb',
    'beshare',
    'bitcoin',
    'bitcoincash',
    'blob',
    'bolo',
    'brid',
    'browserext',
    'cabal',
    'calculator',
    'callto',
    'cap',
    'cast',
    'casts',
    'chrome',
    'chrome-extension',
    'cid',
    'coap',
    'coap+tcp',
    'coap+ws',
    'coaps',
    'coaps+tcp',
    'coaps+ws',
    'com-eventbrite-attendee',
    'content',
    'content-type',
    'crid',
    'cstr',
    'cvs',
    'dab',
    'dat',
    'data',
    'dav',
    'dhttp',
    'diaspora',
    'dict',
    'did',
    'dis',
    'dlna-playcontainer',
    'dlna-playsingle',
    'dns',
    'dntp',
    'doi',
    'dpp',
    'drm',
    'drop',
    'dtmi',
    'dtn',
    'dvb',
    'dvx',
    'dweb',
    'ed2k',
    'eid',
    'elsi',
    'embedded',
    'ens',
    'ethereum',
    'example',
    'facetime',
    'fax',
    'feed',
    'feedready',
    'fido',
    'file',
    'filesystem',
    'finger',
    'first-run-pen-experience',
    'fish',
    'fm',
    'ftp',
    'fuchsia-pkg',
    'geo',
    'gg',
    'git',
    'gitoid',
    'gizmoproject',
    'go',
    'gopher',
    'graph',
    'grd',
    'gtalk',
    'h323',
    'ham',
    'hcap',
    'hcp',
    'hs20',
    'http',
    'https',
    'hxxp',
    'hxxps',
    'hydrazone',
    'hyper',
    'iax',
    'icap',
    'icon',
    'im',
    'imap',
    'info',
    'iotdisco',
    'ipfs',
    'ipn',
    'ipns',
    'ipp',
    'ipps',
    'irc',
    'irc6',
    'ircs',
    'iris',
    'iris.beep',
    'iris.lwz',
    'iris.xpc',
    'iris.xpcs',
    'isostore',
    'itms',
    'jabber',
    'jar',
    'jms',
    'keyparc',
    'lastfm',
    'lbry',
    'ldap',
    'ldaps',
    'leaptofrogans',
    'lid',
    'lorawan',
    'lpa',
    'lvlt',
    'machineprovisioningprogressreporter',
    'magnet',
    'mailserver',
    'mailto',
    'maps',
    'market',
    'matrix',
    'message',
    'microsoft.windows.camera',
    'microsoft.windows.camera.multipicker',
    'microsoft.windows.camera.picker',
    'mid',
    'mms',
    'modem',
    'mongodb',
    'moz',
    'ms-access',
    'ms-appinstaller',
    'ms-browser-extension',
    'ms-calculator',
    'ms-drive-to',
    'ms-enrollment',
    'ms-excel',
    'ms-eyecontrolspeech',
    'ms-gamebarservices',
    'ms-gamingoverlay',
    'ms-getoffice',
    'ms-help',
    'ms-infopath',
    'ms-inputapp',
    'ms-launchremotedesktop',
    'ms-lockscreencomponent-config',
    'ms-media-stream-id',
    'ms-meetnow',
    'ms-mixedrealitycapture',
    'ms-mobileplans',
    'ms-newsandinterests',
    'ms-officeapp',
    'ms-people',
    'ms-project',
    'ms-powerpoint',
    'ms-publisher',
    'ms-recall',
    'ms-remotedesktop',
    'ms-remotedesktop-launch',
    'ms-restoretabcompanion',
    'ms-screenclip',
    'ms-screensketch',
    'ms-search',
    'ms-search-repair',
    'ms-secondary-screen-controller',
    'ms-secondary-screen-setup',
    'ms-settings',
    'ms-settings-airplanemode',
    'ms-settings-bluetooth',
    'ms-settings-camera',
    'ms-settings-cellular',
    'ms-settings-cloudstorage',
    'ms-settings-connectabledevices',
    'ms-settings-displays-topology',
    'ms-settings-emailandaccounts',
    'ms-settings-language',
    'ms-settings-location',
    'ms-settings-lock',
    'ms-settings-nfctransactions',
    'ms-settings-notifications',
    'ms-settings-power',
    'ms-settings-privacy',
    'ms-settings-proximity',
    'ms-settings-screenrotation',
    'ms-settings-wifi',
    'ms-settings-workplace',
    'ms-spd',
    'ms-stickers',
    'ms-sttoverlay',
    'ms-transit-to',
    'ms-useractivityset',
    'ms-virtualtouchpad',
    'ms-visio',
    'ms-walk-to',
    'ms-whiteboard',
    'ms-whiteboard-cmd',
    'ms-word',
    'msnim',
    'msrp',
    'msrps',
    'mss',
    'mt',
    'mtqp',
    'mumble',
    'mupdate',
    'mvn',
    'mvrp',
    'mvrps',
    'news',
    'nfs',
    'ni',
    'nih',
    'nntp',
    'notes',
    'num',
    'ocf',
    'oid',
    'onenote',
    'onenote-cmd',
    'opaquelocktoken',
    'openid',
    'openpgp4fpr',
    'otpauth',
    'p1',
    'pack',
    'palm',
    'paparazzi',
    'payment',
    'payto',
    'pkcs11',
    'platform',
    'pop',
    'pres',
    'prospero',
    'proxy',
    'pwid',
    'psyc',
    'pttp',
    'qb',
    'query',
    'quic-transport',
    'redis',
    'rediss',
    'reload',
    'res',
    'resource',
    'rmi',
    'rsync',
    'rtmfp',
    'rtmp',
    'rtsp',
    'rtsps',
    'rtspu',
    'sarif',
    'secondlife',
    'secret-token',
    'service',
    'session',
    'sftp',
    'sgn',
    'shc',
    'shttp',
    'sieve',
    'simpleledger',
    'simplex',
    'sip',
    'sips',
    'skype',
    'smb',
    'smp',
    'sms',
    'smtp',
    'snews',
    'snmp',
    'soap.beep',
    'soap.beeps',
    'soldat',
    'spiffe',
    'spotify',
    'ssb',
    'ssh',
    'starknet',
    'steam',
    'stun',
    'stuns',
    'submit',
    'svn',
    'swh',
    'swid',
    'swidpath',
    'tag',
    'taler',
    'teamspeak',
    'tel',
    'teliaeid',
    'telnet',
    'tftp',
    'things',
    'thismessage',
    'tip',
    'tn3270',
    'tool',
    'turn',
    'turns',
    'tv',
    'udp',
    'unreal',
    'upt',
    'urn',
    'ut2004',
    'uuid-in-package',
    'v-event',
    'vemmi',
    'ventrilo',
    'ves',
    'videotex',
    'vnc',
    'view-source',
    'vscode',
    'vscode-insiders',
    'vsls',
    'w3',
    'wais',
    'web3',
    'wcr',
    'webcal',
    'web+ap',
    'wifi',
    'wpid',
    'ws',
    'wss',
    'wtai',
    'wyciwyg',
    'xcon',
    'xcon-userid',
    'xfire',
    'xmlrpc.beep',
    'xmlrpc.beeps',
    'xmpp',
    'xftp',
    'xrcp',
    'xri',
    'ymsgr',
    'z39.50',
    'z39.50r',
    'z39.50s',
}
