"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const fromZigbee_1 = __importDefault(require("../converters/fromZigbee"));
const toZigbee_1 = __importDefault(require("../converters/toZigbee"));
const exposes = __importStar(require("../lib/exposes"));
const modernExtend_1 = require("../lib/modernExtend");
const ota = __importStar(require("../lib/ota"));
const reporting = __importStar(require("../lib/reporting"));
const utils = __importStar(require("../lib/utils"));
const e = exposes.presets;
const ea = exposes.access;
const tzLocal = {
    aOneBacklight: {
        key: ['backlight_led'],
        convertSet: async (entity, key, value, meta) => {
            utils.assertString(value, 'backlight_led');
            const state = value.toLowerCase();
            utils.validateValue(state, ['toggle', 'off', 'on']);
            const endpoint = meta.device.getEndpoint(3);
            await endpoint.command('genOnOff', state, {});
            return { state: { backlight_led: state.toUpperCase() } };
        },
    },
    backlight_brightness: {
        key: ['brightness'],
        options: [exposes.options.transition()],
        convertSet: async (entity, key, value, meta) => {
            await entity.command('genLevelCtrl', 'moveToLevel', { level: value, transtime: 0 }, utils.getOptions(meta.mapped, entity));
            return { state: { brightness: value } };
        },
        convertGet: async (entity, key, meta) => {
            await entity.read('genLevelCtrl', ['currentLevel']);
        },
    },
};
const disableBatteryRotaryDimmerReporting = async (endpoint) => {
    // The default is for the device to also report the on/off and
    // brightness at the same time as sending on/off and step commands.
    // Disable the reporting by setting the max interval to 0xFFFF.
    await reporting.brightness(endpoint, { max: 0xffff });
    await reporting.onOff(endpoint, { max: 0xffff });
};
const batteryRotaryDimmer = (...endpointsIds) => ({
    fromZigbee: [fromZigbee_1.default.battery, fromZigbee_1.default.command_on, fromZigbee_1.default.command_off, fromZigbee_1.default.command_step, fromZigbee_1.default.command_step_color_temperature],
    toZigbee: [], // TODO: Needs documented reasoning for asserting this as a type it isn't
    exposes: [
        e.battery(),
        e.action(['on', 'off', 'brightness_step_up', 'brightness_step_down', 'color_temperature_step_up', 'color_temperature_step_down']),
    ],
    configure: (async (device, coordinatorEndpoint) => {
        const endpoints = endpointsIds.map((endpoint) => device.getEndpoint(endpoint));
        // Battery level is only reported on first endpoint
        await reporting.batteryVoltage(endpoints[0]);
        for (const endpoint of endpoints) {
            await reporting.bind(endpoint, coordinatorEndpoint, ['genIdentify', 'genOnOff', 'genLevelCtrl', 'lightingColorCtrl']);
            await disableBatteryRotaryDimmerReporting(endpoint);
        }
    }),
    onEvent: (async (type, data, device) => {
        // The rotary dimmer devices appear to lose the configured reportings when they
        // re-announce themselves which they do roughly every 6 hours.
        if (type === 'deviceAnnounce') {
            for (const endpoint of device.endpoints) {
                // First disable the default reportings (for the dimmer endpoints only)
                if ([1, 2].includes(endpoint.ID)) {
                    await disableBatteryRotaryDimmerReporting(endpoint);
                }
                // Then re-apply the configured reportings
                for (const c of endpoint.configuredReportings) {
                    await endpoint.configureReporting(c.cluster.name, [
                        {
                            attribute: c.attribute.name,
                            minimumReportInterval: c.minimumReportInterval,
                            maximumReportInterval: c.maximumReportInterval,
                            reportableChange: c.reportableChange,
                        },
                    ]);
                }
            }
        }
    }),
});
const definitions = [
    {
        zigbeeModel: ['TWBulb51AU'],
        model: 'AU-A1GSZ9CX',
        vendor: 'Aurora Lighting',
        description: 'AOne GLS lamp 9w tunable dimmable 2200-5000K',
        extend: [(0, modernExtend_1.light)({ colorTemp: { range: [200, 454] } })],
    },
    {
        zigbeeModel: ['RGBCXStrip50AU'],
        model: 'AU-A1ZBSCRGBCX',
        vendor: 'Aurora Lighting',
        description: 'RGBW LED strip controller',
        extend: [(0, modernExtend_1.light)({ colorTemp: { range: [166, 400] }, color: true })],
    },
    {
        zigbeeModel: ['TWGU10Bulb50AU'],
        model: 'AU-A1GUZBCX5',
        vendor: 'Aurora Lighting',
        description: 'AOne 5.4W smart tuneable GU10 lamp',
        extend: [(0, modernExtend_1.light)({ colorTemp: { range: undefined } })],
    },
    {
        zigbeeModel: ['TWMPROZXBulb50AU'],
        model: 'AU-A1ZBMPRO1ZX',
        vendor: 'Aurora Lighting',
        description: 'AOne MPROZX fixed IP65 fire rated smart tuneable LED downlight',
        extend: [(0, modernExtend_1.light)({ colorTemp: { range: [200, 455] }, powerOnBehavior: false })],
    },
    {
        zigbeeModel: ['FWG125Bulb50AU'],
        model: 'AU-A1VG125Z5E/19',
        vendor: 'Aurora Lighting',
        description: 'AOne 4W smart dimmable G125 lamp 1900K',
        extend: [(0, modernExtend_1.light)({ turnsOffAtBrightness1: true })],
    },
    {
        zigbeeModel: ['FWBulb51AU'],
        model: 'AU-A1GSZ9B/27',
        vendor: 'Aurora Lighting',
        description: 'AOne 9W smart GLS B22',
        extend: [(0, modernExtend_1.light)()],
    },
    {
        zigbeeModel: ['FWGU10Bulb50AU', 'FWGU10Bulb01UK'],
        model: 'AU-A1GUZB5/30',
        vendor: 'Aurora Lighting',
        description: 'AOne 4.8W smart dimmable GU10 lamp 3000K',
        extend: [(0, modernExtend_1.light)()],
    },
    {
        zigbeeModel: ['FWA60Bulb50AU'],
        model: 'AU-A1VGSZ5E/19',
        vendor: 'Aurora Lighting',
        description: 'AOne 4W smart dimmable Vintage GLS lamp 1900K',
        extend: [(0, modernExtend_1.light)({ effect: false })],
    },
    {
        zigbeeModel: ['RGBGU10Bulb50AU', 'RGBGU10Bulb50AU2'],
        model: 'AU-A1GUZBRGBW',
        vendor: 'Aurora Lighting',
        description: 'AOne 5.6w smart RGBW tuneable GU10 lamp',
        extend: [(0, modernExtend_1.light)({ colorTemp: { range: undefined }, color: true })],
    },
    {
        zigbeeModel: ['RGBBulb01UK', 'RGBBulb02UK', 'RGBBulb51AU'],
        model: 'AU-A1GSZ9RGBW_HV-GSCXZB269K',
        vendor: 'Aurora Lighting',
        description: 'AOne 9.5W smart RGBW GLS E27/B22',
        extend: [(0, modernExtend_1.light)({ colorTemp: { range: undefined }, color: true })],
    },
    {
        zigbeeModel: ['Remote50AU'],
        model: 'AU-A1ZBRC',
        vendor: 'Aurora Lighting',
        description: 'AOne smart remote',
        fromZigbee: [fromZigbee_1.default.battery, fromZigbee_1.default.command_on, fromZigbee_1.default.command_off, fromZigbee_1.default.command_step, fromZigbee_1.default.command_recall, fromZigbee_1.default.command_store],
        toZigbee: [],
        exposes: [e.battery(), e.action(['on', 'off', 'brightness_step_up', 'brightness_step_down', 'recall_1', 'store_1'])],
        configure: async (device, coordinatorEndpoint) => {
            const endpoint = device.getEndpoint(1);
            await reporting.bind(endpoint, coordinatorEndpoint, ['genOnOff', 'genLevelCtrl', 'genPowerCfg', 'genScenes']);
        },
    },
    {
        zigbeeModel: ['MotionSensor51AU'],
        model: 'AU-A1ZBPIRS',
        vendor: 'Aurora Lighting',
        description: 'AOne PIR sensor',
        fromZigbee: [fromZigbee_1.default.ias_occupancy_alarm_1, fromZigbee_1.default.illuminance],
        toZigbee: [],
        configure: async (device, coordinatorEndpoint) => {
            const endpoint = device.getEndpoint(39);
            await reporting.bind(endpoint, coordinatorEndpoint, ['msIlluminanceMeasurement']);
            await reporting.illuminance(endpoint);
        },
        exposes: [e.occupancy(), e.battery_low(), e.tamper(), e.illuminance(), e.illuminance_lux()],
    },
    {
        zigbeeModel: ['SingleSocket50AU'],
        model: 'AU-A1ZBPIAB',
        vendor: 'Aurora Lighting',
        description: 'Power plug Zigbee EU',
        fromZigbee: [fromZigbee_1.default.identify, fromZigbee_1.default.on_off, fromZigbee_1.default.electrical_measurement],
        exposes: [e.switch(), e.power(), e.voltage(), e.current()],
        toZigbee: [toZigbee_1.default.on_off],
        configure: async (device, coordinatorEndpoint) => {
            const endpoint = device.getEndpoint(1);
            await reporting.bind(endpoint, coordinatorEndpoint, ['genIdentify', 'genOnOff', 'haElectricalMeasurement']);
            await reporting.onOff(endpoint);
        },
    },
    {
        zigbeeModel: ['WindowSensor51AU'],
        model: 'AU-A1ZBDWS',
        vendor: 'Aurora Lighting',
        description: 'Magnetic door & window contact sensor',
        fromZigbee: [fromZigbee_1.default.ias_contact_alarm_1, fromZigbee_1.default.battery],
        toZigbee: [],
        exposes: [e.contact(), e.battery_low(), e.tamper(), e.battery()],
    },
    {
        zigbeeModel: ['WallDimmerMaster'],
        model: 'AU-A1ZB2WDM',
        vendor: 'Aurora Lighting',
        description: 'AOne 250W smart rotary dimmer module',
        exposes: [e.binary('backlight_led', ea.STATE_SET, 'ON', 'OFF').withDescription('Enable or disable the blue backlight LED')],
        toZigbee: [tzLocal.aOneBacklight],
        extend: [(0, modernExtend_1.light)({ configureReporting: true })],
    },
    {
        zigbeeModel: ['DoubleSocket50AU'],
        model: 'AU-A1ZBDSS',
        vendor: 'Aurora Lighting',
        description: 'Double smart socket UK',
        fromZigbee: [fromZigbee_1.default.identify, fromZigbee_1.default.on_off, fromZigbee_1.default.electrical_measurement, fromZigbee_1.default.brightness],
        exposes: [
            e.switch().withEndpoint('left'),
            e.switch().withEndpoint('right'),
            e.power().withEndpoint('left'),
            e.power().withEndpoint('right'),
            e.numeric('brightness', ea.ALL).withValueMin(0).withValueMax(254).withDescription('Brightness of this backlight LED'),
        ],
        toZigbee: [tzLocal.backlight_brightness, toZigbee_1.default.on_off],
        meta: { multiEndpoint: true },
        ota: ota.zigbeeOTA,
        endpoint: (device) => {
            return { left: 1, right: 2 };
        },
        configure: async (device, coordinatorEndpoint) => {
            const endpoint1 = device.getEndpoint(1);
            await reporting.bind(endpoint1, coordinatorEndpoint, ['genIdentify', 'genOnOff', 'haElectricalMeasurement']);
            await reporting.onOff(endpoint1);
            const endpoint2 = device.getEndpoint(2);
            await reporting.bind(endpoint2, coordinatorEndpoint, ['genIdentify', 'genOnOff', 'haElectricalMeasurement']);
            await reporting.onOff(endpoint2);
        },
    },
    {
        zigbeeModel: ['SmartPlug51AU'],
        model: 'AU-A1ZBPIA',
        vendor: 'Aurora Lighting',
        description: 'Aurora smart plug',
        fromZigbee: [fromZigbee_1.default.identify, fromZigbee_1.default.on_off, fromZigbee_1.default.electrical_measurement, fromZigbee_1.default.metering, fromZigbee_1.default.device_temperature],
        exposes: [e.switch(), e.power(), e.voltage(), e.current(), e.device_temperature(), e.energy()],
        toZigbee: [toZigbee_1.default.on_off],
        endpoint: (device) => {
            return { default: 2 };
        },
        configure: async (device, coordinatorEndpoint) => {
            const endpoint = device.getEndpoint(2);
            await reporting.bind(endpoint, coordinatorEndpoint, [
                'genOnOff',
                'genIdentify',
                'haElectricalMeasurement',
                'seMetering',
                'genDeviceTempCfg',
            ]);
            await reporting.onOff(endpoint);
            await reporting.deviceTemperature(endpoint);
            await reporting.readEletricalMeasurementMultiplierDivisors(endpoint);
            // Report 5v voltage change, 5a current, 5 watt power change to reduce the noise
            await reporting.rmsVoltage(endpoint, { change: 500 });
            await reporting.rmsCurrent(endpoint, { change: 500 });
            await reporting.activePower(endpoint, { change: 5 });
            await reporting.readMeteringMultiplierDivisor(endpoint);
            await reporting.instantaneousDemand(endpoint, { change: 500 });
        },
    },
    {
        zigbeeModel: ['1GBatteryDimmer50AU'],
        model: 'AU-A1ZBR1GW',
        vendor: 'Aurora Lighting',
        description: 'AOne one gang wireless battery rotary dimmer',
        meta: { battery: { voltageToPercentage: '3V_2100' } },
        // One gang battery rotary dimmer with endpoint ID 1
        ...batteryRotaryDimmer(1),
    },
    {
        zigbeeModel: ['2GBatteryDimmer50AU'],
        model: 'AU-A1ZBR2GW',
        vendor: 'Aurora Lighting',
        description: 'AOne two gang wireless battery rotary dimmer',
        meta: { multiEndpoint: true, battery: { voltageToPercentage: '3V_2100' } },
        endpoint: (device) => {
            return { right: 1, left: 2 };
        },
        // Two gang battery rotary dimmer with endpoint IDs 1 and 2
        ...batteryRotaryDimmer(1, 2),
    },
    {
        zigbeeModel: ['NPD3032'],
        model: 'AU-A1ZB110',
        vendor: 'Aurora Lighting',
        description: 'AOne 1-10V in-line dimmer',
        extend: [(0, modernExtend_1.identify)(), (0, modernExtend_1.light)({ powerOnBehavior: false })],
    },
];
exports.default = definitions;
module.exports = definitions;
//# sourceMappingURL=aurora_lighting.js.map