"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.setupRoutes = setupRoutes;
var _dsl_facet = require("../services/facets/dsl_facet");
var _ppl_facet = require("../services/facets/ppl_facet");
var _saved_objects = _interopRequireDefault(require("../services/facets/saved_objects"));
var _queryService = require("../services/queryService");
var _app_analytics_router = require("./application_analytics/app_analytics_router");
var _panels_router = require("./custom_panels/panels_router");
var _visualizations_router = require("./custom_panels/visualizations_router");
var _data_connections_router = require("./data_connections/data_connections_router");
var _datasources_router = require("./datasources/datasources_router");
var _dsl = require("./dsl");
var _event_analytics_router = require("./event_analytics/event_analytics_router");
var _getting_started_router = require("./getting_started/getting_started_router");
var _integrations_router = require("./integrations/integrations_router");
var _metrics_rounter = require("./metrics/metrics_rounter");
var _noteRouter = require("./notebooks/noteRouter");
var _paraRouter = require("./notebooks/paraRouter");
var _sqlRouter = require("./notebooks/sqlRouter");
var _vizRouter = require("./notebooks/vizRouter");
var _ppl = require("./ppl");
var _routes = require("./query_assist/routes");
var _trace_analytics_dsl_router = require("./trace_analytics_dsl_router");
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

function setupRoutes({
  router,
  client,
  dataSourceEnabled
}) {
  (0, _panels_router.PanelsRouter)(router);
  (0, _visualizations_router.VisualizationsRouter)(router);
  (0, _ppl.registerPplRoute)({
    router,
    facet: new _ppl_facet.PPLFacet(client)
  });
  (0, _dsl.registerDslRoute)({
    router,
    facet: new _dsl_facet.DSLFacet(client)
  }, dataSourceEnabled);
  (0, _event_analytics_router.registerEventAnalyticsRouter)({
    router,
    savedObjectFacet: new _saved_objects.default(client)
  });
  (0, _app_analytics_router.registerAppAnalyticsRouter)(router);

  // TODO remove trace analytics route when DSL route for autocomplete is added
  (0, _trace_analytics_dsl_router.registerTraceAnalyticsDslRouter)(router, dataSourceEnabled);

  // notebooks routes
  (0, _paraRouter.registerParaRoute)(router);
  (0, _noteRouter.registerNoteRoute)(router);
  (0, _vizRouter.registerVizRoute)(router, dataSourceEnabled);
  const queryService = new _queryService.QueryService(client);
  (0, _sqlRouter.registerSqlRoute)(router, queryService, dataSourceEnabled);
  (0, _metrics_rounter.registerMetricsRoute)(router, dataSourceEnabled);
  (0, _integrations_router.registerIntegrationsRoute)(router);
  (0, _data_connections_router.registerDataConnectionsRoute)(router, dataSourceEnabled);
  (0, _datasources_router.registerDatasourcesRoute)(router, dataSourceEnabled);

  // query assist is part of log explorer, which will be disabled if datasource is enabled
  if (!dataSourceEnabled) {
    (0, _routes.registerQueryAssistRoutes)(router);
  }
  (0, _getting_started_router.registerGettingStartedRoutes)(router);
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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