/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.action.tasks;

import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.client.Client;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.core.action.ActionListener;
import org.opensearch.ml.utils.RestActionUtils;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportService;

public class SearchTaskTransportAction
extends HandledTransportAction<SearchRequest, SearchResponse> {
    @Generated
    private static final Logger log = LogManager.getLogger(SearchTaskTransportAction.class);
    private Client client;

    @Inject
    public SearchTaskTransportAction(TransportService transportService, ActionFilters actionFilters, Client client) {
        super("cluster:admin/opensearch/ml/tasks/search", transportService, actionFilters, SearchRequest::new);
        this.client = client;
    }

    protected void doExecute(Task task, SearchRequest request, ActionListener<SearchResponse> actionListener) {
        try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
            ActionListener wrappedListener = ActionListener.wrap(arg_0 -> actionListener.onResponse(arg_0), e -> RestActionUtils.wrapListenerToHandleSearchIndexNotFound(e, actionListener));
            this.client.search(request, ActionListener.runBefore((ActionListener)wrappedListener, () -> context.restore()));
        }
        catch (Exception e2) {
            log.error(e2.getMessage(), (Throwable)e2);
            actionListener.onFailure(e2);
        }
    }
}

