/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.math.la;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.DoubleUnaryOperator;
import org.tribuo.math.la.DenseMatrix;
import org.tribuo.math.la.DenseVector;
import org.tribuo.math.la.Matrix;
import org.tribuo.math.la.MatrixIterator;
import org.tribuo.math.la.MatrixTuple;
import org.tribuo.math.la.SGDVector;
import org.tribuo.math.la.SparseVector;
import org.tribuo.math.la.Tensor;
import org.tribuo.math.la.VectorTuple;

public class DenseSparseMatrix
implements Matrix {
    private static final long serialVersionUID = 1L;
    private final SparseVector[] values;
    private final int dim1;
    private final int dim2;
    private final int[] shape;

    DenseSparseMatrix(SparseVector[] values) {
        this.values = values;
        this.dim1 = values.length;
        this.dim2 = values[0].size();
        this.shape = new int[]{this.dim1, this.dim2};
    }

    public DenseSparseMatrix(List<SparseVector> values) {
        this.values = new SparseVector[values.size()];
        this.dim1 = values.size();
        this.dim2 = values.get(0).size();
        this.shape = new int[]{this.dim1, this.dim2};
        for (int i = 0; i < values.size(); ++i) {
            if (values.get(i).size() != this.dim2) {
                throw new IllegalArgumentException("Unexpected size, found " + values.get(i).size() + ", expected " + this.dim2);
            }
            this.values[i] = values.get(i);
            if (values.get(i).size() == this.dim2) continue;
            throw new IllegalArgumentException("Vectors are not the same dimension, expected " + this.dim2 + ", found " + values.get(i).size() + " at index " + i);
        }
    }

    public DenseSparseMatrix(DenseSparseMatrix other) {
        this.dim1 = other.dim1;
        this.dim2 = other.dim2;
        this.values = new SparseVector[other.values.length];
        this.shape = new int[]{this.dim1, this.dim2};
        for (int i = 0; i < this.values.length; ++i) {
            this.values[i] = other.values[i].copy();
        }
    }

    public DenseSparseMatrix(int dim1, int dim2) {
        this.dim1 = dim1;
        this.dim2 = dim2;
        this.values = new SparseVector[dim1];
        this.shape = new int[]{dim1, dim2};
        SparseVector emptyVector = new SparseVector(dim2);
        for (int i = 0; i < this.values.length; ++i) {
            this.values[i] = emptyVector;
        }
    }

    public static DenseSparseMatrix createFromSparseVectors(SparseVector[] values) {
        SparseVector[] newValues = new SparseVector[values.length];
        for (int i = 0; i < values.length; ++i) {
            newValues[i] = values[i].copy();
        }
        return new DenseSparseMatrix(newValues);
    }

    @Override
    public int[] getShape() {
        return this.shape;
    }

    @Override
    public Tensor reshape(int[] newShape) {
        throw new UnsupportedOperationException("Reshape not supported on sparse Tensors.");
    }

    @Override
    public DenseSparseMatrix copy() {
        SparseVector[] copies = new SparseVector[this.values.length];
        for (int i = 0; i < this.values.length; ++i) {
            copies[i] = this.values[i].copy();
        }
        return new DenseSparseMatrix(copies);
    }

    @Override
    public double get(int i, int j) {
        return this.values[i].get(j);
    }

    @Override
    public void set(int i, int j, double value) {
        this.values[i].set(j, value);
    }

    @Override
    public int getDimension1Size() {
        return this.dim1;
    }

    @Override
    public int getDimension2Size() {
        return this.dim2;
    }

    @Override
    public DenseVector leftMultiply(SGDVector input) {
        if (input.size() == this.dim2) {
            double[] output = new double[this.dim1];
            for (int i = 0; i < output.length; ++i) {
                output[i] = this.values[i].dot(input);
            }
            return new DenseVector(output);
        }
        throw new IllegalArgumentException("input.size() != dim2");
    }

    @Override
    public DenseVector rightMultiply(SGDVector input) {
        if (input.size() == this.dim1) {
            double[] output = new double[this.dim2];
            for (int j = 0; j < this.values.length; ++j) {
                for (int i = 0; i < output.length; ++i) {
                    output[i] = this.values[j].get(i) * input.get(i);
                }
            }
            return new DenseVector(output);
        }
        throw new IllegalArgumentException("input.size() != dim1");
    }

    @Override
    public void add(int i, int j, double value) {
        this.values[i].add(j, value);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void intersectAndAddInPlace(Tensor other, DoubleUnaryOperator f) {
        if (!(other instanceof Matrix)) throw new IllegalArgumentException("Adding a non-Matrix to a Matrix");
        Matrix otherMat = (Matrix)other;
        if (this.dim1 != otherMat.getDimension1Size() || this.dim2 != otherMat.getDimension2Size()) throw new IllegalArgumentException("Matrices are not the same size, this(" + this.dim1 + "," + this.dim2 + "), other(" + otherMat.getDimension1Size() + "," + otherMat.getDimension2Size() + ")");
        if (!(otherMat instanceof DenseMatrix)) throw new UnsupportedOperationException("Not implemented intersectAndAddInPlace in DenseSparseMatrix for types other than DenseMatrix");
        DenseMatrix otherDenseMat = (DenseMatrix)other;
        for (int i = 0; i < this.dim1; ++i) {
            this.values[i].intersectAndAddInPlace(otherDenseMat.getRow(i), f);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void hadamardProductInPlace(Tensor other, DoubleUnaryOperator f) {
        if (!(other instanceof Matrix)) throw new IllegalArgumentException("Scaling a Matrix by a non-Matrix");
        Matrix otherMat = (Matrix)other;
        if (this.dim1 != otherMat.getDimension1Size() || this.dim2 != otherMat.getDimension2Size()) throw new IllegalArgumentException("Matrices are not the same size, this(" + this.dim1 + "," + this.dim2 + "), other(" + otherMat.getDimension1Size() + "," + otherMat.getDimension2Size() + ")");
        if (!(otherMat instanceof DenseMatrix)) throw new UnsupportedOperationException("Not implemented hadamardProductInPlace in DenseSparseMatrix for types other than DenseMatrix");
        DenseMatrix otherDenseMat = (DenseMatrix)other;
        for (int i = 0; i < this.dim1; ++i) {
            this.values[i].hadamardProductInPlace(otherDenseMat.getRow(i), f);
        }
    }

    @Override
    public void foreachInPlace(DoubleUnaryOperator f) {
        for (int i = 0; i < this.values.length; ++i) {
            this.values[i].foreachInPlace(f);
        }
    }

    @Override
    public int numActiveElements(int row) {
        return this.values[row].numActiveElements();
    }

    @Override
    public SparseVector getRow(int i) {
        return this.values[i];
    }

    public boolean equals(Object other) {
        if (other instanceof Matrix) {
            MatrixIterator ourItr = this.iterator();
            Iterator otherItr = ((Matrix)other).iterator();
            while (ourItr.hasNext() && otherItr.hasNext()) {
                MatrixTuple otherTuple;
                MatrixTuple ourTuple = (MatrixTuple)ourItr.next();
                if (ourTuple.equals(otherTuple = (MatrixTuple)otherItr.next())) continue;
                return false;
            }
            return !ourItr.hasNext() && !otherItr.hasNext();
        }
        return false;
    }

    public int hashCode() {
        int result = Objects.hash(this.dim1, this.dim2);
        result = 31 * result + Arrays.hashCode(this.values);
        return result;
    }

    @Override
    public double twoNorm() {
        double output = 0.0;
        for (int i = 0; i < this.dim1; ++i) {
            double value = this.values[i].twoNorm();
            output += value * value;
        }
        return Math.sqrt(output);
    }

    @Override
    public DenseMatrix matrixMultiply(Matrix other) {
        if (this.dim2 == other.getDimension1Size()) {
            if (other instanceof DenseMatrix) {
                DenseMatrix otherDense = (DenseMatrix)other;
                double[][] output = new double[this.dim1][otherDense.dim2];
                for (int i = 0; i < this.dim1; ++i) {
                    for (int j = 0; j < otherDense.dim2; ++j) {
                        output[i][j] = this.columnRowDot(i, j, otherDense);
                    }
                }
                return new DenseMatrix(output);
            }
            if (other instanceof DenseSparseMatrix) {
                DenseSparseMatrix otherSparse = (DenseSparseMatrix)other;
                int otherDim2 = otherSparse.getDimension2Size();
                double[][] output = new double[this.dim1][otherDim2];
                for (int i = 0; i < this.dim1; ++i) {
                    for (int j = 0; j < otherDim2; ++j) {
                        output[i][j] = this.columnRowDot(i, j, otherSparse);
                    }
                }
                return new DenseMatrix(output);
            }
            throw new IllegalArgumentException("Unknown matrix type " + other.getClass().getName());
        }
        throw new IllegalArgumentException("Invalid matrix dimensions, this.shape=" + Arrays.toString(this.shape) + ", other.shape = " + Arrays.toString(other.getShape()));
    }

    @Override
    public DenseMatrix matrixMultiply(Matrix other, boolean transposeThis, boolean transposeOther) {
        if (transposeThis && transposeOther) {
            return this.matrixMultiplyTransposeBoth(other);
        }
        if (transposeThis) {
            return this.matrixMultiplyTransposeThis(other);
        }
        if (transposeOther) {
            return this.matrixMultiplyTransposeOther(other);
        }
        return this.matrixMultiply(other);
    }

    private DenseMatrix matrixMultiplyTransposeBoth(Matrix other) {
        if (this.dim1 == other.getDimension2Size()) {
            if (other instanceof DenseMatrix) {
                DenseMatrix otherDense = (DenseMatrix)other;
                double[][] output = new double[this.dim2][otherDense.dim1];
                for (int i = 0; i < this.dim2; ++i) {
                    for (int j = 0; j < otherDense.dim1; ++j) {
                        output[i][j] = this.rowColumnDot(i, j, otherDense);
                    }
                }
                return new DenseMatrix(output);
            }
            if (other instanceof DenseSparseMatrix) {
                DenseSparseMatrix otherSparse = (DenseSparseMatrix)other;
                int otherDim1 = otherSparse.getDimension1Size();
                double[][] output = new double[this.dim2][otherDim1];
                for (int i = 0; i < this.dim2; ++i) {
                    for (int j = 0; j < otherDim1; ++j) {
                        output[i][j] = this.rowColumnDot(i, j, otherSparse);
                    }
                }
                return new DenseMatrix(output);
            }
            throw new IllegalArgumentException("Unknown matrix type " + other.getClass().getName());
        }
        throw new IllegalArgumentException("Invalid matrix dimensions, dim1 = " + this.dim1 + ", other.dim2 = " + other.getDimension2Size());
    }

    private DenseMatrix matrixMultiplyTransposeThis(Matrix other) {
        if (this.dim1 == other.getDimension1Size()) {
            if (other instanceof DenseMatrix) {
                DenseMatrix otherDense = (DenseMatrix)other;
                double[][] output = new double[this.dim2][otherDense.dim2];
                for (int i = 0; i < this.dim2; ++i) {
                    for (int j = 0; j < otherDense.dim2; ++j) {
                        output[i][j] = this.columnColumnDot(i, j, otherDense);
                    }
                }
                return new DenseMatrix(output);
            }
            if (other instanceof DenseSparseMatrix) {
                DenseSparseMatrix otherSparse = (DenseSparseMatrix)other;
                int otherDim2 = otherSparse.getDimension2Size();
                double[][] output = new double[this.dim2][otherDim2];
                for (int i = 0; i < this.dim2; ++i) {
                    for (int j = 0; j < otherDim2; ++j) {
                        output[i][j] = this.columnColumnDot(i, j, otherSparse);
                    }
                }
                return new DenseMatrix(output);
            }
            throw new IllegalArgumentException("Unknown matrix type " + other.getClass().getName());
        }
        throw new IllegalArgumentException("Invalid matrix dimensions, dim1 = " + this.dim1 + ", other.dim1 = " + other.getDimension1Size());
    }

    private DenseMatrix matrixMultiplyTransposeOther(Matrix other) {
        if (this.dim2 == other.getDimension2Size()) {
            if (other instanceof DenseMatrix) {
                DenseMatrix otherDense = (DenseMatrix)other;
                double[][] output = new double[this.dim1][otherDense.dim1];
                for (int i = 0; i < this.dim1; ++i) {
                    for (int j = 0; j < otherDense.dim1; ++j) {
                        output[i][j] = this.rowRowDot(i, j, otherDense);
                    }
                }
                return new DenseMatrix(output);
            }
            if (other instanceof DenseSparseMatrix) {
                DenseSparseMatrix otherSparse = (DenseSparseMatrix)other;
                int otherDim1 = otherSparse.getDimension1Size();
                double[][] output = new double[this.dim1][otherDim1];
                for (int i = 0; i < this.dim1; ++i) {
                    for (int j = 0; j < otherDim1; ++j) {
                        output[i][j] = this.rowRowDot(i, j, otherSparse);
                    }
                }
                return new DenseMatrix(output);
            }
            throw new IllegalArgumentException("Unknown matrix type " + other.getClass().getName());
        }
        throw new IllegalArgumentException("Invalid matrix dimensions, dim2 = " + this.dim2 + ", other.dim2 = " + other.getDimension2Size());
    }

    private double columnRowDot(int rowIndex, int otherColIndex, Matrix other) {
        double sum = 0.0;
        for (VectorTuple tuple : this.values[rowIndex]) {
            sum += tuple.value * other.get(tuple.index, otherColIndex);
        }
        return sum;
    }

    private double rowColumnDot(int colIndex, int otherRowIndex, Matrix other) {
        double sum = 0.0;
        for (int i = 0; i < this.dim1; ++i) {
            sum += this.get(i, colIndex) * other.get(otherRowIndex, i);
        }
        return sum;
    }

    private double columnColumnDot(int colIndex, int otherColIndex, Matrix other) {
        double sum = 0.0;
        for (int i = 0; i < this.dim1; ++i) {
            sum += this.get(i, colIndex) * other.get(i, otherColIndex);
        }
        return sum;
    }

    private double rowRowDot(int rowIndex, int otherRowIndex, Matrix other) {
        double sum = 0.0;
        for (VectorTuple tuple : this.values[rowIndex]) {
            sum += tuple.value * other.get(otherRowIndex, tuple.index);
        }
        return sum;
    }

    @Override
    public DenseVector rowSum() {
        double[] rowSum = new double[this.dim1];
        for (int i = 0; i < this.dim1; ++i) {
            rowSum[i] = this.values[i].sum();
        }
        return new DenseVector(rowSum);
    }

    @Override
    public void rowScaleInPlace(DenseVector scalingCoefficients) {
        for (int i = 0; i < this.dim1; ++i) {
            this.values[i].scaleInPlace(scalingCoefficients.get(i));
        }
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("DenseSparseMatrix(\n");
        for (int i = 0; i < this.values.length; ++i) {
            buffer.append("\t");
            buffer.append(this.values[i].toString());
            buffer.append(";\n");
        }
        buffer.append(")");
        return buffer.toString();
    }

    public MatrixIterator iterator() {
        return new DenseSparseMatrixIterator(this);
    }

    private static class DenseSparseMatrixIterator
    implements MatrixIterator {
        private final DenseSparseMatrix matrix;
        private final MatrixTuple tuple;
        private int i;
        private Iterator<VectorTuple> itr;
        private VectorTuple vecTuple;

        public DenseSparseMatrixIterator(DenseSparseMatrix matrix) {
            this.matrix = matrix;
            this.tuple = new MatrixTuple();
            this.i = 0;
            this.itr = matrix.values[0].iterator();
        }

        public String toString() {
            return "DenseSparseMatrixIterator(position=" + this.i + ",tuple=" + this.tuple.toString() + ")";
        }

        @Override
        public MatrixTuple getReference() {
            return this.tuple;
        }

        @Override
        public boolean hasNext() {
            if (this.itr.hasNext()) {
                return true;
            }
            while (this.i < this.matrix.dim1 && !this.itr.hasNext()) {
                ++this.i;
                if (this.i >= this.matrix.dim1) continue;
                this.itr = this.matrix.values[this.i].iterator();
            }
            return this.i < this.matrix.dim1 && this.itr.hasNext();
        }

        @Override
        public MatrixTuple next() {
            this.vecTuple = this.itr.next();
            this.tuple.i = this.i;
            this.tuple.j = this.vecTuple.index;
            this.tuple.value = this.vecTuple.value;
            return this.tuple;
        }
    }
}

