/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.common.tree;

import com.oracle.labs.mlrg.olcut.config.PropertyException;
import java.util.logging.Logger;
import org.tribuo.Output;
import org.tribuo.common.tree.DecisionTreeTrainer;
import org.tribuo.ensemble.BaggingTrainer;
import org.tribuo.ensemble.EnsembleCombiner;

public class ExtraTreesTrainer<T extends Output<T>>
extends BaggingTrainer<T> {
    private static final Logger logger = Logger.getLogger(ExtraTreesTrainer.class.getName());

    private ExtraTreesTrainer() {
    }

    public ExtraTreesTrainer(DecisionTreeTrainer<T> trainer, EnsembleCombiner<T> combiner, int numMembers) {
        super(trainer, combiner, numMembers);
        this.postConfig();
    }

    public ExtraTreesTrainer(DecisionTreeTrainer<T> trainer, EnsembleCombiner<T> combiner, int numMembers, long seed) {
        super(trainer, combiner, numMembers, seed);
        this.postConfig();
    }

    public void postConfig() {
        super.postConfig();
        if (!(this.innerTrainer instanceof DecisionTreeTrainer)) {
            throw new PropertyException("", "innerTrainer", "ExtraTreesTrainer requires a decision tree innerTrainer");
        }
        DecisionTreeTrainer t = (DecisionTreeTrainer)this.innerTrainer;
        if (!t.getUseRandomSplitPoints()) {
            throw new PropertyException("", "innerTrainer", "ExtraTreesTrainer requires that the decision tree innerTrainer have random split points turned on.");
        }
    }

    protected String ensembleName() {
        return "extra-trees-ensemble";
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("ExtraTreesTrainer(");
        buffer.append("innerTrainer=");
        buffer.append(this.innerTrainer.toString());
        buffer.append(",combiner=");
        buffer.append(this.combiner.toString());
        buffer.append(",numMembers=");
        buffer.append(this.numMembers);
        buffer.append(",seed=");
        buffer.append(this.seed);
        buffer.append(")");
        return buffer.toString();
    }
}

